/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.generic;

import com.ibm.xltxe.rnm1.xtq.bcel.generic.ClassGenException;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ConstantPoolGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ConstantPushInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Instruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Type;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.TypedInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Visitor;

public class FCONST
extends Instruction
implements ConstantPushInstruction,
TypedInstruction {
    private float value;

    FCONST() {
    }

    public FCONST(float f2) {
        super((short)11, (short)1);
        if ((double)f2 == 0.0) {
            this.opcode = (short)11;
        } else if ((double)f2 == 1.0) {
            this.opcode = (short)12;
        } else if ((double)f2 == 2.0) {
            this.opcode = (short)13;
        } else {
            throw new ClassGenException("FCONST can be used only for 0.0, 1.0 and 2.0: " + f2);
        }
        this.value = f2;
    }

    @Override
    public Number getValue() {
        return new Float(this.value);
    }

    @Override
    public Type getType(ConstantPoolGen cp) {
        return Type.FLOAT;
    }

    @Override
    public void accept(Visitor v) {
        v.visitPushInstruction(this);
        v.visitStackProducer(this);
        v.visitTypedInstruction(this);
        v.visitConstantPushInstruction(this);
        v.visitFCONST(this);
    }
}

