/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.generic;

import com.ibm.xltxe.rnm1.xtq.bcel.generic.ClassGenException;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ConstantPoolGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LocalVariableInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Type;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Visitor;
import com.ibm.xltxe.rnm1.xtq.bcel.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public class IINC
extends LocalVariableInstruction {
    private boolean wide;
    private int c;

    IINC() {
    }

    public IINC(int n2, int c) {
        this.opcode = (short)132;
        this.length = (short)3;
        this.setIndex(n2);
        this.setIncrement(c);
    }

    @Override
    public void dump(DataOutputStream out) throws IOException {
        if (this.wide) {
            out.writeByte(196);
        }
        out.writeByte(this.opcode);
        if (this.wide) {
            out.writeShort(this.n);
            out.writeShort(this.c);
        } else {
            out.writeByte(this.n);
            out.writeByte(this.c);
        }
    }

    private final void setWide() {
        this.wide = this.n > 65535 || Math.abs(this.c) > 127;
        this.length = this.wide ? (short)6 : (short)3;
    }

    @Override
    protected void initFromFile(ByteSequence bytes2, boolean wide) throws IOException {
        this.wide = wide;
        if (wide) {
            this.length = (short)6;
            this.n = bytes2.readUnsignedShort();
            this.c = bytes2.readShort();
        } else {
            this.length = (short)3;
            this.n = bytes2.readUnsignedByte();
            this.c = bytes2.readByte();
        }
    }

    @Override
    public String toString(boolean verbose) {
        return super.toString(verbose) + " " + this.c;
    }

    @Override
    public final void setIndex(int n2) {
        if (n2 < 0) {
            throw new ClassGenException("Negative index value: " + n2);
        }
        this.n = n2;
        this.setWide();
    }

    public final int getIncrement() {
        return this.c;
    }

    public final void setIncrement(int c) {
        this.c = c;
        this.setWide();
    }

    @Override
    public Type getType(ConstantPoolGen cp) {
        return Type.INT;
    }

    @Override
    public void accept(Visitor v) {
        v.visitLocalVariableInstruction(this);
        v.visitIINC(this);
    }
}

