/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.generic;

import com.ibm.xltxe.rnm1.xtq.bcel.Constants;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantPool;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ClassGenException;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ConstantPoolGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IINC;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionComparator;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionConstants;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LocalVariableInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.RET;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Visitor;
import com.ibm.xltxe.rnm1.xtq.bcel.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;

public abstract class Instruction
implements Cloneable,
Serializable {
    protected short length = 1;
    protected short opcode = (short)-1;
    private static InstructionComparator cmp = InstructionComparator.DEFAULT;

    Instruction() {
    }

    public Instruction(short opcode, short length2) {
        this.length = length2;
        this.opcode = opcode;
    }

    public void dump(DataOutputStream out) throws IOException {
        out.writeByte(this.opcode);
    }

    public String getName() {
        return Constants.OPCODE_NAMES[this.opcode];
    }

    public String toString(boolean verbose) {
        if (verbose) {
            return this.getName() + "[" + this.opcode + "](" + this.length + ")";
        }
        return this.getName();
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(ConstantPool cp) {
        return this.toString(false);
    }

    public Instruction copy() {
        Instruction i = null;
        if (InstructionConstants.INSTRUCTIONS[this.getOpcode()] != null) {
            i = this;
        } else {
            try {
                i = (Instruction)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        return i;
    }

    protected void initFromFile(ByteSequence bytes2, boolean wide) throws IOException {
    }

    public static final Instruction readInstruction(ByteSequence bytes2) throws IOException {
        Class<?> clazz;
        boolean wide = false;
        short opcode = (short)bytes2.readUnsignedByte();
        Instruction obj = null;
        if (opcode == 196) {
            wide = true;
            opcode = (short)bytes2.readUnsignedByte();
        }
        if (InstructionConstants.INSTRUCTIONS[opcode] != null) {
            return InstructionConstants.INSTRUCTIONS[opcode];
        }
        try {
            clazz = Class.forName(Instruction.className(opcode));
        }
        catch (ClassNotFoundException cnfe) {
            throw new ClassGenException("Illegal opcode detected.");
        }
        try {
            obj = (Instruction)clazz.newInstance();
            if (wide && !(obj instanceof LocalVariableInstruction) && !(obj instanceof IINC) && !(obj instanceof RET)) {
                throw new Exception("Illegal opcode after wide: " + opcode);
            }
            obj.setOpcode(opcode);
            obj.initFromFile(bytes2, wide);
        }
        catch (Exception e) {
            throw new ClassGenException(e.toString());
        }
        return obj;
    }

    private static final String className(short opcode) {
        String name2 = Constants.OPCODE_NAMES[opcode].toUpperCase();
        try {
            int len = name2.length();
            char ch1 = name2.charAt(len - 2);
            char ch2 = name2.charAt(len - 1);
            if (ch1 == '_' && ch2 >= '0' && ch2 <= '5') {
                name2 = name2.substring(0, len - 2);
            }
            if (name2.equals("ICONST_M1")) {
                name2 = "ICONST";
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        return "com.ibm.xltxe.rnm1.xtq.bcel.generic." + name2;
    }

    public int consumeStack(ConstantPoolGen cpg) {
        return Constants.CONSUME_STACK[this.opcode];
    }

    public int produceStack(ConstantPoolGen cpg) {
        return Constants.PRODUCE_STACK[this.opcode];
    }

    public short getOpcode() {
        return this.opcode;
    }

    public int getLength() {
        return this.length;
    }

    private void setOpcode(short opcode) {
        this.opcode = opcode;
    }

    void dispose() {
    }

    public abstract void accept(Visitor var1);

    public static InstructionComparator getComparator() {
        return cmp;
    }

    public static void setComparator(InstructionComparator c) {
        cmp = c;
    }

    public boolean equals(Object that) {
        return that instanceof Instruction ? cmp.equals(this, (Instruction)that) : false;
    }
}

