/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.generic;

import com.ibm.xltxe.rnm1.xtq.bcel.generic.ALOAD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ANEWARRAY;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ASTORE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ArithmeticInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ArrayInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ArrayType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.BasicType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.BranchInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.CHECKCAST;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ClassGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ClassGenException;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ConstantPoolGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.DLOAD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.DSTORE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.FLOAD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.FSTORE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.FieldInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.GETFIELD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.GETSTATIC;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.GOTO;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.GOTO_W;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IFEQ;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IFGE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IFGT;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IFLE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IFLT;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IFNE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IFNONNULL;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IFNULL;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IF_ACMPEQ;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IF_ACMPNE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IF_ICMPEQ;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IF_ICMPGE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IF_ICMPGT;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IF_ICMPLE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IF_ICMPLT;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IF_ICMPNE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ILOAD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.INSTANCEOF;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.INVOKEINTERFACE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.INVOKESPECIAL;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.INVOKESTATIC;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.INVOKEVIRTUAL;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ISTORE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Instruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionConstants;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionHandle;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionList;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InvokeInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.JSR;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.JSR_W;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LLOAD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LSTORE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LocalVariableInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.MULTIANEWARRAY;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.NEW;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.NEWARRAY;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ObjectType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.PUSH;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.PUTFIELD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.PUTSTATIC;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ReferenceType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ReturnInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.StackInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Type;
import java.io.Serializable;

public class InstructionFactory
implements InstructionConstants,
Serializable {
    protected ClassGen cg;
    protected ConstantPoolGen cp;
    private static MethodObject[] append_mos = new MethodObject[]{new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.STRING}, 1), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.OBJECT}, 1), null, null, new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.BOOLEAN}, 1), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.CHAR}, 1), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.FLOAT}, 1), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.DOUBLE}, 1), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.INT}, 1), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.INT}, 1), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.INT}, 1), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.LONG}, 1)};

    public InstructionFactory(ClassGen cg, ConstantPoolGen cp) {
        this.cg = cg;
        this.cp = cp;
    }

    public InstructionFactory(ClassGen cg) {
        this(cg, cg.getConstantPool());
    }

    public InstructionFactory(ConstantPoolGen cp) {
        this(null, cp);
    }

    public InvokeInstruction createInvoke(String class_name, String name2, Type ret_type, Type[] arg_types, short kind2) {
        int nargs = 0;
        String signature = Type.getMethodSignature(ret_type, arg_types);
        for (int i = 0; i < arg_types.length; ++i) {
            nargs += arg_types[i].getSize();
        }
        int index2 = kind2 == 185 ? this.cp.addInterfaceMethodref(class_name, name2, signature) : this.cp.addMethodref(class_name, name2, signature);
        switch (kind2) {
            case 183: {
                return new INVOKESPECIAL(index2);
            }
            case 182: {
                return new INVOKEVIRTUAL(index2);
            }
            case 184: {
                return new INVOKESTATIC(index2);
            }
            case 185: {
                return new INVOKEINTERFACE(index2, nargs + 1);
            }
        }
        throw new RuntimeException("Oops: Unknown invoke kind:" + kind2);
    }

    public InstructionList createPrintln(String s) {
        InstructionList il = new InstructionList();
        int out = this.cp.addFieldref("java.lang.System", "out", "Ljava/io/PrintStream;");
        int println = this.cp.addMethodref("java.io.PrintStream", "println", "(Ljava/lang/String;)V");
        il.append(new GETSTATIC(out));
        il.append(new PUSH(this.cp, s));
        il.append(new INVOKEVIRTUAL(println));
        return il;
    }

    public Instruction createConstant(Object value2) {
        PUSH push;
        if (value2 instanceof Number) {
            push = new PUSH(this.cp, (Number)value2);
        } else if (value2 instanceof String) {
            push = new PUSH(this.cp, (String)value2);
        } else if (value2 instanceof Boolean) {
            push = new PUSH(this.cp, (Boolean)value2);
        } else if (value2 instanceof Character) {
            push = new PUSH(this.cp, (Character)value2);
        } else {
            throw new ClassGenException("Illegal type: " + value2.getClass());
        }
        return push.getInstruction();
    }

    private InvokeInstruction createInvoke(MethodObject m, short kind2) {
        return this.createInvoke(m.class_name, m.name, m.result_type, m.arg_types, kind2);
    }

    private static final boolean isString(Type type2) {
        return type2 instanceof ObjectType && ((ObjectType)type2).getClassName().equals("java.lang.String");
    }

    public Instruction createAppend(Type type2) {
        byte t = type2.getType();
        if (InstructionFactory.isString(type2)) {
            return this.createInvoke(append_mos[0], (short)182);
        }
        switch (t) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return this.createInvoke(append_mos[t], (short)182);
            }
            case 13: 
            case 14: {
                return this.createInvoke(append_mos[1], (short)182);
            }
        }
        throw new RuntimeException("Oops: No append for this type? " + type2);
    }

    public FieldInstruction createFieldAccess(String class_name, String name2, Type type2, short kind2) {
        String signature = type2.getSignature();
        int index2 = this.cp.addFieldref(class_name, name2, signature);
        switch (kind2) {
            case 180: {
                return new GETFIELD(index2);
            }
            case 181: {
                return new PUTFIELD(index2);
            }
            case 178: {
                return new GETSTATIC(index2);
            }
            case 179: {
                return new PUTSTATIC(index2);
            }
        }
        throw new RuntimeException("Oops: Unknown getfield kind:" + kind2);
    }

    public static Instruction createThis() {
        return new ALOAD(0);
    }

    public static ReturnInstruction createReturn(Type type2) {
        switch (type2.getType()) {
            case 13: 
            case 14: {
                return ARETURN;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return IRETURN;
            }
            case 6: {
                return FRETURN;
            }
            case 7: {
                return DRETURN;
            }
            case 11: {
                return LRETURN;
            }
            case 12: {
                return RETURN;
            }
        }
        throw new RuntimeException("Invalid type: " + type2);
    }

    private static final ArithmeticInstruction createBinaryIntOp(char first, String op2) {
        switch (first) {
            case '-': {
                return ISUB;
            }
            case '+': {
                return IADD;
            }
            case '%': {
                return IREM;
            }
            case '*': {
                return IMUL;
            }
            case '/': {
                return IDIV;
            }
            case '&': {
                return IAND;
            }
            case '|': {
                return IOR;
            }
            case '^': {
                return IXOR;
            }
            case '<': {
                return ISHL;
            }
            case '>': {
                return op2.equals(">>>") ? IUSHR : ISHR;
            }
        }
        throw new RuntimeException("Invalid operand " + op2);
    }

    private static final ArithmeticInstruction createBinaryLongOp(char first, String op2) {
        switch (first) {
            case '-': {
                return LSUB;
            }
            case '+': {
                return LADD;
            }
            case '%': {
                return LREM;
            }
            case '*': {
                return LMUL;
            }
            case '/': {
                return LDIV;
            }
            case '&': {
                return LAND;
            }
            case '|': {
                return LOR;
            }
            case '^': {
                return LXOR;
            }
            case '<': {
                return LSHL;
            }
            case '>': {
                return op2.equals(">>>") ? LUSHR : LSHR;
            }
        }
        throw new RuntimeException("Invalid operand " + op2);
    }

    private static final ArithmeticInstruction createBinaryFloatOp(char op2) {
        switch (op2) {
            case '-': {
                return FSUB;
            }
            case '+': {
                return FADD;
            }
            case '*': {
                return FMUL;
            }
            case '/': {
                return FDIV;
            }
        }
        throw new RuntimeException("Invalid operand " + op2);
    }

    private static final ArithmeticInstruction createBinaryDoubleOp(char op2) {
        switch (op2) {
            case '-': {
                return DSUB;
            }
            case '+': {
                return DADD;
            }
            case '*': {
                return DMUL;
            }
            case '/': {
                return DDIV;
            }
        }
        throw new RuntimeException("Invalid operand " + op2);
    }

    public static ArithmeticInstruction createBinaryOperation(String op2, Type type2) {
        char first = op2.toCharArray()[0];
        switch (type2.getType()) {
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return InstructionFactory.createBinaryIntOp(first, op2);
            }
            case 11: {
                return InstructionFactory.createBinaryLongOp(first, op2);
            }
            case 6: {
                return InstructionFactory.createBinaryFloatOp(first);
            }
            case 7: {
                return InstructionFactory.createBinaryDoubleOp(first);
            }
        }
        throw new RuntimeException("Invalid type " + type2);
    }

    public static StackInstruction createPop(int size) {
        return size == 2 ? POP2 : POP;
    }

    public static StackInstruction createDup(int size) {
        return size == 2 ? DUP2 : DUP;
    }

    public static StackInstruction createDup_2(int size) {
        return size == 2 ? DUP2_X2 : DUP_X2;
    }

    public static StackInstruction createDup_1(int size) {
        return size == 2 ? DUP2_X1 : DUP_X1;
    }

    public static LocalVariableInstruction createStore(Type type2, int index2) {
        switch (type2.getType()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return new ISTORE(index2);
            }
            case 6: {
                return new FSTORE(index2);
            }
            case 7: {
                return new DSTORE(index2);
            }
            case 11: {
                return new LSTORE(index2);
            }
            case 13: 
            case 14: {
                return new ASTORE(index2);
            }
        }
        throw new RuntimeException("Invalid type " + type2);
    }

    public static LocalVariableInstruction createLoad(Type type2, int index2) {
        switch (type2.getType()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return new ILOAD(index2);
            }
            case 6: {
                return new FLOAD(index2);
            }
            case 7: {
                return new DLOAD(index2);
            }
            case 11: {
                return new LLOAD(index2);
            }
            case 13: 
            case 14: {
                return new ALOAD(index2);
            }
        }
        throw new RuntimeException("Invalid type " + type2);
    }

    public static ArrayInstruction createArrayLoad(Type type2) {
        switch (type2.getType()) {
            case 4: 
            case 8: {
                return BALOAD;
            }
            case 5: {
                return CALOAD;
            }
            case 9: {
                return SALOAD;
            }
            case 10: {
                return IALOAD;
            }
            case 6: {
                return FALOAD;
            }
            case 7: {
                return DALOAD;
            }
            case 11: {
                return LALOAD;
            }
            case 13: 
            case 14: {
                return AALOAD;
            }
        }
        throw new RuntimeException("Invalid type " + type2);
    }

    public static ArrayInstruction createArrayStore(Type type2) {
        switch (type2.getType()) {
            case 4: 
            case 8: {
                return BASTORE;
            }
            case 5: {
                return CASTORE;
            }
            case 9: {
                return SASTORE;
            }
            case 10: {
                return IASTORE;
            }
            case 6: {
                return FASTORE;
            }
            case 7: {
                return DASTORE;
            }
            case 11: {
                return LASTORE;
            }
            case 13: 
            case 14: {
                return AASTORE;
            }
        }
        throw new RuntimeException("Invalid type " + type2);
    }

    public Instruction createCast(Type src_type, Type dest_type) {
        if (src_type instanceof BasicType && dest_type instanceof BasicType) {
            byte dest = dest_type.getType();
            int src = src_type.getType();
            if (dest == 11 && (src == 5 || src == 8 || src == 9)) {
                src = 10;
            }
            String[] short_names = new String[]{"C", "F", "D", "B", "S", "I", "L"};
            String name2 = "com.ibm.xltxe.rnm1.xtq.bcel.generic." + short_names[src - 5] + "2" + short_names[dest - 5];
            Instruction i = null;
            try {
                i = (Instruction)Class.forName(name2).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not find instruction: " + name2);
            }
            return i;
        }
        if (src_type instanceof ReferenceType && dest_type instanceof ReferenceType) {
            if (dest_type instanceof ArrayType) {
                return new CHECKCAST(this.cp.addArrayClass((ArrayType)dest_type));
            }
            return new CHECKCAST(this.cp.addClass(((ObjectType)dest_type).getClassName()));
        }
        throw new RuntimeException("Can not cast " + src_type + " to " + dest_type);
    }

    public GETFIELD createGetField(String class_name, String name2, Type t) {
        return new GETFIELD(this.cp.addFieldref(class_name, name2, t.getSignature()));
    }

    public GETSTATIC createGetStatic(String class_name, String name2, Type t) {
        return new GETSTATIC(this.cp.addFieldref(class_name, name2, t.getSignature()));
    }

    public PUTFIELD createPutField(String class_name, String name2, Type t) {
        return new PUTFIELD(this.cp.addFieldref(class_name, name2, t.getSignature()));
    }

    public PUTSTATIC createPutStatic(String class_name, String name2, Type t) {
        return new PUTSTATIC(this.cp.addFieldref(class_name, name2, t.getSignature()));
    }

    public CHECKCAST createCheckCast(ReferenceType t) {
        if (t instanceof ArrayType) {
            return new CHECKCAST(this.cp.addArrayClass((ArrayType)t));
        }
        return new CHECKCAST(this.cp.addClass((ObjectType)t));
    }

    public INSTANCEOF createInstanceOf(ReferenceType t) {
        if (t instanceof ArrayType) {
            return new INSTANCEOF(this.cp.addArrayClass((ArrayType)t));
        }
        return new INSTANCEOF(this.cp.addClass((ObjectType)t));
    }

    public NEW createNew(ObjectType t) {
        return new NEW(this.cp.addClass(t));
    }

    public NEW createNew(String s) {
        return this.createNew(new ObjectType(s));
    }

    public Instruction createNewArray(Type t, short dim) {
        if (dim == 1) {
            if (t instanceof ObjectType) {
                return new ANEWARRAY(this.cp.addClass((ObjectType)t));
            }
            if (t instanceof ArrayType) {
                return new ANEWARRAY(this.cp.addArrayClass((ArrayType)t));
            }
            return new NEWARRAY(((BasicType)t).getType());
        }
        ArrayType at = t instanceof ArrayType ? (ArrayType)t : new ArrayType(t, (int)dim);
        return new MULTIANEWARRAY(this.cp.addArrayClass(at), dim);
    }

    public static Instruction createNull(Type type2) {
        switch (type2.getType()) {
            case 13: 
            case 14: {
                return ACONST_NULL;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return ICONST_0;
            }
            case 6: {
                return FCONST_0;
            }
            case 7: {
                return DCONST_0;
            }
            case 11: {
                return LCONST_0;
            }
            case 12: {
                return NOP;
            }
        }
        throw new RuntimeException("Invalid type: " + type2);
    }

    public static BranchInstruction createBranchInstruction(short opcode, InstructionHandle target) {
        switch (opcode) {
            case 153: {
                return new IFEQ(target);
            }
            case 154: {
                return new IFNE(target);
            }
            case 155: {
                return new IFLT(target);
            }
            case 156: {
                return new IFGE(target);
            }
            case 157: {
                return new IFGT(target);
            }
            case 158: {
                return new IFLE(target);
            }
            case 159: {
                return new IF_ICMPEQ(target);
            }
            case 160: {
                return new IF_ICMPNE(target);
            }
            case 161: {
                return new IF_ICMPLT(target);
            }
            case 162: {
                return new IF_ICMPGE(target);
            }
            case 163: {
                return new IF_ICMPGT(target);
            }
            case 164: {
                return new IF_ICMPLE(target);
            }
            case 165: {
                return new IF_ACMPEQ(target);
            }
            case 166: {
                return new IF_ACMPNE(target);
            }
            case 167: {
                return new GOTO(target);
            }
            case 168: {
                return new JSR(target);
            }
            case 198: {
                return new IFNULL(target);
            }
            case 199: {
                return new IFNONNULL(target);
            }
            case 200: {
                return new GOTO_W(target);
            }
            case 201: {
                return new JSR_W(target);
            }
        }
        throw new RuntimeException("Invalid opcode: " + opcode);
    }

    public void setClassGen(ClassGen c) {
        this.cg = c;
    }

    public ClassGen getClassGen() {
        return this.cg;
    }

    public void setConstantPool(ConstantPoolGen c) {
        this.cp = c;
    }

    public ConstantPoolGen getConstantPool() {
        return this.cp;
    }

    private static class MethodObject {
        Type[] arg_types;
        Type result_type;
        String[] arg_names;
        String class_name;
        String name;
        int access;

        MethodObject(String c, String n2, Type r, Type[] a, int acc) {
            this.class_name = c;
            this.name = n2;
            this.result_type = r;
            this.arg_types = a;
            this.access = acc;
        }
    }
}

