/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.generic;

import com.ibm.xltxe.rnm1.xtq.bcel.classfile.LocalVariable;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.BranchInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ClassGenException;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ConstantPoolGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionHandle;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionTargeter;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.NamedAndTyped;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Type;
import java.io.Serializable;

public class LocalVariableGen
implements InstructionTargeter,
NamedAndTyped,
Cloneable,
Serializable {
    private int index;
    private String name;
    private Type type;
    private InstructionHandle start;
    private InstructionHandle end;

    public LocalVariableGen(int index2, String name2, Type type2, InstructionHandle start, InstructionHandle end) {
        if (index2 < 0 || index2 > 65535) {
            throw new ClassGenException("Invalid index index: " + index2);
        }
        this.name = name2;
        this.type = type2;
        this.index = index2;
        this.setStart(start);
        this.setEnd(end);
    }

    public LocalVariable getLocalVariable(ConstantPoolGen cp) {
        int start_pc = this.start.getPosition();
        int length2 = this.end.getPosition() - start_pc;
        if (length2 > 0) {
            length2 += this.end.getInstruction().getLength();
        }
        int name_index = cp.addUtf8(this.name);
        int signature_index = cp.addUtf8(this.type.getSignature());
        return new LocalVariable(start_pc, length2, name_index, signature_index, this.index, cp.getConstantPool());
    }

    public void setIndex(int index2) {
        this.index = index2;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public void setName(String name2) {
        this.name = name2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setType(Type type2) {
        this.type = type2;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public InstructionHandle getStart() {
        return this.start;
    }

    public InstructionHandle getEnd() {
        return this.end;
    }

    public void setStart(InstructionHandle start) {
        BranchInstruction.notifyTarget(this.start, start, this);
        this.start = start;
    }

    public void setEnd(InstructionHandle end) {
        BranchInstruction.notifyTarget(this.end, end, this);
        this.end = end;
    }

    @Override
    public void updateTarget(InstructionHandle old_ih, InstructionHandle new_ih) {
        boolean targeted = false;
        if (this.start == old_ih) {
            targeted = true;
            this.setStart(new_ih);
        }
        if (this.end == old_ih) {
            targeted = true;
            this.setEnd(new_ih);
        }
        if (!targeted) {
            throw new ClassGenException("Not targeting " + old_ih + ", but {" + this.start + ", " + this.end + "}");
        }
    }

    @Override
    public boolean containsTarget(InstructionHandle ih) {
        return this.start == ih || this.end == ih;
    }

    public boolean equals(Object o) {
        if (!(o instanceof LocalVariableGen)) {
            return false;
        }
        LocalVariableGen l = (LocalVariableGen)o;
        return l.index == this.index && l.start == this.start && l.end == this.end;
    }

    public int hashCode() {
        return this.index;
    }

    public String toString() {
        return "LocalVariableGen(" + this.name + ", " + this.type + ", " + this.start + ", " + this.end + ")";
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

