/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.generic;

import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Attribute;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Code;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.CodeException;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ExceptionTable;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.LineNumber;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.LineNumberTable;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.LocalVariable;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.LocalVariableTable;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Method;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Utility;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.BranchInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ClassGenException;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.CodeExceptionGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ConstantPoolGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.FieldGenOrMethodGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IINC;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IfInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IndexedInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Instruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionHandle;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionList;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionTargeter;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LineNumberGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LocalVariableGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LocalVariableInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.MethodObserver;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.NOP;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ObjectType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.RET;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Select;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.TargetLostException;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Type;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.TypedInstruction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;

public class MethodGen
extends FieldGenOrMethodGen {
    private String class_name;
    private Type[] arg_types;
    private String[] arg_names;
    private int max_locals;
    private int max_stack;
    private InstructionList il;
    private boolean strip_localVarTable;
    private boolean strip_lineTable;
    private HashSet<LocalVariableGen> local_variables = new HashSet();
    private ArrayList line_number_vec = new ArrayList();
    private ArrayList exception_vec = new ArrayList();
    private ArrayList throws_vec = new ArrayList();
    private ArrayList code_attrs_vec = new ArrayList();
    private ArrayList observers;

    public MethodGen(int access_flags, Type return_type, Type[] arg_types, String[] arg_names, String method_name, String class_name, InstructionList il, ConstantPoolGen cp) {
        this.setAccessFlags(access_flags);
        this.setType(return_type);
        this.setArgumentTypes(arg_types);
        this.setArgumentNames(arg_names);
        this.setName(method_name);
        this.setClassName(class_name);
        this.setInstructionList(il);
        this.setConstantPool(cp);
        boolean abstract_ = this.isAbstract() || this.isNative();
        InstructionHandle start = null;
        InstructionHandle end = null;
        if (!abstract_) {
            start = il.getStart();
            end = il.getEnd();
            if (!this.isStatic() && class_name != null) {
                this.addLocalVariable("this", new ObjectType(class_name), start, end);
            }
        }
        if (arg_types != null) {
            int i;
            int size = arg_types.length;
            for (i = 0; i < size; ++i) {
                if (Type.VOID != arg_types[i]) continue;
                throw new ClassGenException("'void' is an illegal argument type for a method");
            }
            if (arg_names != null) {
                if (size != arg_names.length) {
                    throw new ClassGenException("Mismatch in argument array lengths: " + size + " vs. " + arg_names.length);
                }
            } else {
                arg_names = new String[size];
                for (i = 0; i < size; ++i) {
                    arg_names[i] = "arg" + i;
                }
                this.setArgumentNames(arg_names);
            }
            if (!abstract_) {
                for (i = 0; i < size; ++i) {
                    this.addLocalVariable(arg_names[i], arg_types[i], start, end);
                }
            }
        }
    }

    public MethodGen(Method m, String class_name, ConstantPoolGen cp) {
        this(m.getAccessFlags(), Type.getReturnType(m.getSignature()), Type.getArgumentTypes(m.getSignature()), null, m.getName(), class_name, (m.getAccessFlags() & 0x500) == 0 ? new InstructionList(m.getCode().getCode()) : null, cp);
        Attribute[] attributes2 = m.getAttributes();
        for (int i = 0; i < attributes2.length; ++i) {
            Attribute a = attributes2[i];
            if (a instanceof Code) {
                InstructionHandle end;
                Code c = (Code)a;
                this.setMaxStack(c.getMaxStack());
                this.setMaxLocals(c.getMaxLocals());
                CodeException[] ces = c.getExceptionTable();
                if (ces != null) {
                    for (int j = 0; j < ces.length; ++j) {
                        CodeException ce = ces[j];
                        int type2 = ce.getCatchType();
                        ObjectType c_type = null;
                        if (type2 > 0) {
                            String cen = m.getConstantPool().getConstantString(type2, (byte)7);
                            c_type = new ObjectType(cen);
                        }
                        int end_pc = ce.getEndPC();
                        int length2 = m.getCode().getCode().length;
                        if (length2 == end_pc) {
                            end = this.il.getEnd();
                        } else {
                            end = this.il.findHandle(end_pc);
                            end = end.getPrev();
                        }
                        this.addExceptionHandler(this.il.findHandle(ce.getStartPC()), end, this.il.findHandle(ce.getHandlerPC()), c_type);
                    }
                }
                Attribute[] c_attributes = c.getAttributes();
                for (int j = 0; j < c_attributes.length; ++j) {
                    Cloneable l;
                    int k;
                    a = c_attributes[j];
                    if (a instanceof LineNumberTable) {
                        LineNumber[] ln = ((LineNumberTable)a).getLineNumberTable();
                        for (k = 0; k < ln.length; ++k) {
                            l = ln[k];
                            this.addLineNumber(this.il.findHandle(((LineNumber)l).getStartPC()), ((LineNumber)l).getLineNumber());
                        }
                        continue;
                    }
                    if (a instanceof LocalVariableTable) {
                        LocalVariable[] lv = ((LocalVariableTable)a).getLocalVariableTable();
                        this.removeLocalVariables();
                        for (k = 0; k < lv.length; ++k) {
                            l = lv[k];
                            InstructionHandle start = this.il.findHandle(((LocalVariable)l).getStartPC());
                            end = this.il.findHandle(((LocalVariable)l).getStartPC() + ((LocalVariable)l).getLength());
                            if (null == start) {
                                start = this.il.getStart();
                            }
                            if (null == end) {
                                end = this.il.getEnd();
                            }
                            this.addLocalVariable(((LocalVariable)l).getName(), Type.getType(((LocalVariable)l).getSignature()), ((LocalVariable)l).getIndex(), start, end);
                        }
                        continue;
                    }
                    this.addCodeAttribute(a);
                }
                continue;
            }
            if (a instanceof ExceptionTable) {
                String[] names = ((ExceptionTable)a).getExceptionNames();
                for (int j = 0; j < names.length; ++j) {
                    this.addException(names[j]);
                }
                continue;
            }
            this.addAttribute(a);
        }
    }

    public LocalVariableGen addLocalVariable(String name2, Type type2, int slot, InstructionHandle start, InstructionHandle end) {
        byte t = type2.getType();
        if (t != 16) {
            LocalVariableGen l;
            int add2 = type2.getSize();
            if (slot + add2 > this.max_locals) {
                this.max_locals = slot + add2;
            }
            if (!this.local_variables.add(l = new LocalVariableGen(slot, name2, type2, start, end))) {
                this.local_variables.remove(l);
                this.local_variables.add(l);
            }
            return l;
        }
        throw new IllegalArgumentException("Can not use " + type2 + " as type for local variable");
    }

    public LocalVariableGen addLocalVariable(String name2, Type type2, InstructionHandle start, InstructionHandle end) {
        return this.addLocalVariable(name2, type2, this.max_locals, start, end);
    }

    public void removeLocalVariable(LocalVariableGen l) {
        this.local_variables.remove(l);
    }

    public void removeLocalVariables() {
        this.local_variables.clear();
    }

    private static final void sort(LocalVariableGen[] vars, int l, int r) {
        int i = l;
        int j = r;
        int m = vars[(l + r) / 2].getIndex();
        while (true) {
            if (vars[i].getIndex() < m) {
                ++i;
                continue;
            }
            while (m < vars[j].getIndex()) {
                --j;
            }
            if (i <= j) {
                LocalVariableGen h = vars[i];
                vars[i] = vars[j];
                vars[j] = h;
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (l < j) {
            MethodGen.sort(vars, l, j);
        }
        if (i < r) {
            MethodGen.sort(vars, i, r);
        }
    }

    public LocalVariableGen[] getLocalVariables() {
        int size = this.local_variables.size();
        LocalVariableGen[] lg = new LocalVariableGen[size];
        this.local_variables.toArray(lg);
        for (int i = 0; i < size; ++i) {
            if (lg[i].getStart() == null) {
                lg[i].setStart(this.il.getStart());
            }
            if (lg[i].getEnd() != null) continue;
            lg[i].setEnd(this.il.getEnd());
        }
        if (size > 1) {
            MethodGen.sort(lg, 0, size - 1);
        }
        return lg;
    }

    public LocalVariableTable getLocalVariableTable(ConstantPoolGen cp) {
        LocalVariableGen[] lg = this.getLocalVariables();
        int size = lg.length;
        LocalVariable[] lv = new LocalVariable[size];
        for (int i = 0; i < size; ++i) {
            lv[i] = lg[i].getLocalVariable(cp);
        }
        return new LocalVariableTable(cp.addUtf8("LocalVariableTable"), 2 + lv.length * 10, lv, cp.getConstantPool());
    }

    public LineNumberGen addLineNumber(InstructionHandle ih, int src_line) {
        LineNumberGen l = new LineNumberGen(ih, src_line);
        this.line_number_vec.add(l);
        return l;
    }

    public void removeLineNumber(LineNumberGen l) {
        this.line_number_vec.remove(l);
    }

    public void removeLineNumbers() {
        this.line_number_vec.clear();
    }

    public LineNumberGen[] getLineNumbers() {
        LineNumberGen[] lg = new LineNumberGen[this.line_number_vec.size()];
        this.line_number_vec.toArray(lg);
        return lg;
    }

    public LineNumberTable getLineNumberTable(ConstantPoolGen cp) {
        int size = this.line_number_vec.size();
        LineNumber[] ln = new LineNumber[size];
        try {
            for (int i = 0; i < size; ++i) {
                ln[i] = ((LineNumberGen)this.line_number_vec.get(i)).getLineNumber();
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        return new LineNumberTable(cp.addUtf8("LineNumberTable"), 2 + ln.length * 4, ln, cp.getConstantPool());
    }

    public CodeExceptionGen addExceptionHandler(InstructionHandle start_pc, InstructionHandle end_pc, InstructionHandle handler_pc, ObjectType catch_type) {
        if (start_pc == null || end_pc == null || handler_pc == null) {
            throw new ClassGenException("Exception handler target is null instruction");
        }
        CodeExceptionGen c = new CodeExceptionGen(start_pc, end_pc, handler_pc, catch_type);
        this.exception_vec.add(c);
        return c;
    }

    public void removeExceptionHandler(CodeExceptionGen c) {
        this.exception_vec.remove(c);
    }

    public void removeExceptionHandlers() {
        this.exception_vec.clear();
    }

    public CodeExceptionGen[] getExceptionHandlers() {
        CodeExceptionGen[] cg = new CodeExceptionGen[this.exception_vec.size()];
        this.exception_vec.toArray(cg);
        return cg;
    }

    private CodeException[] getCodeExceptions() {
        int size = this.exception_vec.size();
        CodeException[] c_exc = new CodeException[size];
        try {
            for (int i = 0; i < size; ++i) {
                CodeExceptionGen c = (CodeExceptionGen)this.exception_vec.get(i);
                c_exc[i] = c.getCodeException(this.cp);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return c_exc;
    }

    public void addException(String class_name) {
        this.throws_vec.add(class_name);
    }

    public void removeException(String c) {
        this.throws_vec.remove(c);
    }

    public void removeExceptions() {
        this.throws_vec.clear();
    }

    public String[] getExceptions() {
        String[] e = new String[this.throws_vec.size()];
        this.throws_vec.toArray(e);
        return e;
    }

    private ExceptionTable getExceptionTable(ConstantPoolGen cp) {
        int size = this.throws_vec.size();
        int[] ex = new int[size];
        try {
            for (int i = 0; i < size; ++i) {
                ex[i] = cp.addClass((String)this.throws_vec.get(i));
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        return new ExceptionTable(cp.addUtf8("Exceptions"), 2 + 2 * size, ex, cp.getConstantPool());
    }

    public void addCodeAttribute(Attribute a) {
        this.code_attrs_vec.add(a);
    }

    public void removeCodeAttribute(Attribute a) {
        this.code_attrs_vec.remove(a);
    }

    public void removeCodeAttributes() {
        this.code_attrs_vec.clear();
    }

    public Attribute[] getCodeAttributes() {
        Attribute[] attributes2 = new Attribute[this.code_attrs_vec.size()];
        this.code_attrs_vec.toArray(attributes2);
        return attributes2;
    }

    public Method getMethod() {
        String signature = this.getSignature();
        int name_index = this.cp.addUtf8(this.name);
        int signature_index = this.cp.addUtf8(signature);
        byte[] byte_code = null;
        if (this.il != null) {
            byte_code = this.il.getByteCode();
        }
        LineNumberTable lnt = null;
        LocalVariableTable lvt = null;
        if (this.local_variables.size() > 0 && !this.strip_localVarTable) {
            lvt = this.getLocalVariableTable(this.cp);
            this.addCodeAttribute(lvt);
        }
        if (this.line_number_vec.size() > 0 && !this.strip_lineTable) {
            lnt = this.getLineNumberTable(this.cp);
            this.addCodeAttribute(lnt);
        }
        Attribute[] code_attrs = this.getCodeAttributes();
        int attrs_len = 0;
        for (int i = 0; i < code_attrs.length; ++i) {
            attrs_len += code_attrs[i].getLength() + 6;
        }
        CodeException[] c_exc = this.getCodeExceptions();
        int exc_len = c_exc.length * 8;
        Code code = null;
        if (this.il != null && !this.isAbstract()) {
            Attribute[] attributes2 = this.getAttributes();
            for (int i = 0; i < attributes2.length; ++i) {
                Attribute a = attributes2[i];
                if (!(a instanceof Code)) continue;
                this.removeAttribute(a);
            }
            code = new Code(this.cp.addUtf8("Code"), 8 + byte_code.length + 2 + exc_len + 2 + attrs_len, this.max_stack, this.max_locals, byte_code, c_exc, code_attrs, this.cp.getConstantPool());
            this.addAttribute(code);
        }
        ExceptionTable et = null;
        if (this.throws_vec.size() > 0) {
            et = this.getExceptionTable(this.cp);
            this.addAttribute(et);
        }
        Method m = new Method(this.access_flags, name_index, signature_index, this.getAttributes(), this.cp.getConstantPool());
        if (lvt != null) {
            this.removeCodeAttribute(lvt);
        }
        if (lnt != null) {
            this.removeCodeAttribute(lnt);
        }
        if (code != null) {
            this.removeAttribute(code);
        }
        if (et != null) {
            this.removeAttribute(et);
        }
        return m;
    }

    public void removeNOPs() {
        if (this.il != null) {
            InstructionHandle ih = this.il.getStart();
            while (ih != null) {
                InstructionHandle next = ih.next;
                if (next != null && ih.getInstruction() instanceof NOP) {
                    try {
                        this.il.delete(ih);
                    }
                    catch (TargetLostException e) {
                        InstructionHandle[] targets = e.getTargets();
                        for (int i = 0; i < targets.length; ++i) {
                            InstructionTargeter[] targeters = targets[i].getTargeters();
                            for (int j = 0; j < targeters.length; ++j) {
                                targeters[j].updateTarget(targets[i], next);
                            }
                        }
                    }
                }
                ih = next;
            }
        }
    }

    public void setMaxLocals(int m) {
        this.max_locals = m;
    }

    public int getMaxLocals() {
        return this.max_locals;
    }

    public void setMaxStack(int m) {
        this.max_stack = m;
    }

    public int getMaxStack() {
        return this.max_stack;
    }

    public String getClassName() {
        return this.class_name;
    }

    public void setClassName(String class_name) {
        this.class_name = class_name;
    }

    public void setReturnType(Type return_type) {
        this.setType(return_type);
    }

    public Type getReturnType() {
        return this.getType();
    }

    public void setArgumentTypes(Type[] arg_types) {
        this.arg_types = arg_types;
    }

    public Type[] getArgumentTypes() {
        return (Type[])this.arg_types.clone();
    }

    public void setArgumentType(int i, Type type2) {
        this.arg_types[i] = type2;
    }

    public Type getArgumentType(int i) {
        return this.arg_types[i];
    }

    public void setArgumentNames(String[] arg_names) {
        this.arg_names = arg_names;
    }

    public String[] getArgumentNames() {
        return (String[])this.arg_names.clone();
    }

    public void setArgumentName(int i, String name2) {
        this.arg_names[i] = name2;
    }

    public String getArgumentName(int i) {
        return this.arg_names[i];
    }

    public InstructionList getInstructionList() {
        return this.il;
    }

    public void setInstructionList(InstructionList il) {
        this.il = il;
    }

    @Override
    public String getSignature() {
        return Type.getMethodSignature(this.type, this.arg_types);
    }

    public void setMaxStack() {
        this.max_stack = this.il != null ? MethodGen.getMaxStack(this.cp, this.il, this.getExceptionHandlers()) : 0;
    }

    public void setMaxLocals() {
        if (this.il != null) {
            int max2;
            int n2 = max2 = this.isStatic() ? 0 : 1;
            if (this.arg_types != null) {
                for (int i = 0; i < this.arg_types.length; ++i) {
                    max2 += this.arg_types[i].getSize();
                }
            }
            for (InstructionHandle ih = this.il.getStart(); ih != null; ih = ih.getNext()) {
                int index2;
                Instruction ins = ih.getInstruction();
                if (!(ins instanceof LocalVariableInstruction) && !(ins instanceof RET) && !(ins instanceof IINC) || (index2 = ((IndexedInstruction)((Object)ins)).getIndex() + ((TypedInstruction)((Object)ins)).getType(this.cp).getSize()) <= max2) continue;
                max2 = index2;
            }
            this.max_locals = max2;
        } else {
            this.max_locals = 0;
        }
    }

    public void stripLocalVarTable(boolean flag) {
        this.strip_localVarTable = flag;
    }

    public void stripLineTable(boolean flag) {
        this.strip_lineTable = flag;
    }

    public static int getMaxStack(ConstantPoolGen cp, InstructionList il, CodeExceptionGen[] et) {
        BranchStack branchTargets = new BranchStack();
        HashSet<InstructionHandle> visited = new HashSet<InstructionHandle>();
        for (int i = 0; i < et.length; ++i) {
            InstructionHandle handler_pc = et[i].getHandlerPC();
            if (handler_pc == null) continue;
            branchTargets.push(handler_pc, 1);
        }
        int stackDepth = 0;
        int maxStackDepth = 0;
        InstructionHandle ih = il.getStart();
        while (ih != null) {
            BranchTarget bt;
            if (!visited.add(ih)) {
                ih = null;
            } else {
                Instruction instruction2 = ih.getInstruction();
                short opcode = instruction2.getOpcode();
                int delta = instruction2.produceStack(cp) - instruction2.consumeStack(cp);
                if ((stackDepth += delta) > maxStackDepth) {
                    maxStackDepth = stackDepth;
                }
                if (instruction2 instanceof BranchInstruction) {
                    BranchInstruction branch = (BranchInstruction)instruction2;
                    if (instruction2 instanceof Select) {
                        Select select2 = (Select)branch;
                        InstructionHandle[] targets = select2.getTargets();
                        for (int i = 0; i < targets.length; ++i) {
                            if (visited.contains(targets[i])) continue;
                            branchTargets.push(targets[i], stackDepth);
                        }
                        ih = null;
                    } else if (!(branch instanceof IfInstruction)) {
                        if (opcode == 168 || opcode == 201) {
                            branchTargets.push(ih.getNext(), stackDepth - 1);
                        }
                        ih = null;
                    }
                    branchTargets.push(branch.getTarget(), stackDepth);
                } else if (opcode == 191 || opcode == 169 || opcode >= 172 && opcode <= 177) {
                    ih = null;
                }
                if (ih != null) {
                    ih = ih.getNext();
                }
            }
            if (ih != null || (bt = branchTargets.pop()) == null) continue;
            ih = bt.target;
            stackDepth = bt.stackDepth;
        }
        return maxStackDepth;
    }

    public void addObserver(MethodObserver o) {
        if (this.observers == null) {
            this.observers = new ArrayList();
        }
        this.observers.add(o);
    }

    public void removeObserver(MethodObserver o) {
        if (this.observers != null) {
            this.observers.remove(o);
        }
    }

    public void update() {
        if (this.observers != null) {
            Iterator e = this.observers.iterator();
            while (e.hasNext()) {
                ((MethodObserver)e.next()).notify(this);
            }
        }
    }

    public final String toString() {
        String access = Utility.accessToString(this.access_flags);
        String signature = Type.getMethodSignature(this.type, this.arg_types);
        signature = Utility.methodSignatureToString(signature, this.name, access, true, this.getLocalVariableTable(this.cp));
        StringBuffer buf = new StringBuffer(signature);
        if (this.throws_vec.size() > 0) {
            Iterator e = this.throws_vec.iterator();
            while (e.hasNext()) {
                buf.append("\n\t\tthrows " + e.next());
            }
        }
        return buf.toString();
    }

    public MethodGen copy(String class_name, ConstantPoolGen cp) {
        Method m = ((MethodGen)this.clone()).getMethod();
        MethodGen mg = new MethodGen(m, class_name, this.cp);
        if (this.cp != cp) {
            mg.setConstantPool(cp);
            mg.getInstructionList().replaceConstantPool(this.cp, cp);
        }
        return mg;
    }

    static final class BranchStack {
        Stack branchTargets = new Stack();
        Hashtable visitedTargets = new Hashtable();

        BranchStack() {
        }

        public void push(InstructionHandle target, int stackDepth) {
            if (this.visited(target)) {
                return;
            }
            this.branchTargets.push(this.visit(target, stackDepth));
        }

        public BranchTarget pop() {
            if (!this.branchTargets.empty()) {
                BranchTarget bt = (BranchTarget)this.branchTargets.pop();
                return bt;
            }
            return null;
        }

        private final BranchTarget visit(InstructionHandle target, int stackDepth) {
            BranchTarget bt = new BranchTarget(target, stackDepth);
            this.visitedTargets.put(target, bt);
            return bt;
        }

        private final boolean visited(InstructionHandle target) {
            return this.visitedTargets.get(target) != null;
        }
    }

    static final class BranchTarget {
        InstructionHandle target;
        int stackDepth;

        BranchTarget(InstructionHandle target, int stackDepth) {
            this.target = target;
            this.stackDepth = stackDepth;
        }
    }
}

