/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.generic;

import com.ibm.xltxe.rnm1.xtq.bcel.Constants;
import com.ibm.xltxe.rnm1.xtq.bcel.ExceptionConstants;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.AllocationInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ArrayType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.BasicType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ExceptionThrower;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Instruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.StackProducer;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Type;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Visitor;
import com.ibm.xltxe.rnm1.xtq.bcel.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public class NEWARRAY
extends Instruction
implements AllocationInstruction,
ExceptionThrower,
StackProducer {
    private byte type;

    NEWARRAY() {
    }

    public NEWARRAY(byte type2) {
        super((short)188, (short)2);
        this.type = type2;
    }

    public NEWARRAY(BasicType type2) {
        this(type2.getType());
    }

    @Override
    public void dump(DataOutputStream out) throws IOException {
        out.writeByte(this.opcode);
        out.writeByte(this.type);
    }

    public final byte getTypecode() {
        return this.type;
    }

    public final Type getType() {
        return new ArrayType(BasicType.getType(this.type), 1);
    }

    @Override
    public String toString(boolean verbose) {
        return super.toString(verbose) + " " + Constants.TYPE_NAMES[this.type];
    }

    @Override
    protected void initFromFile(ByteSequence bytes2, boolean wide) throws IOException {
        this.type = bytes2.readByte();
        this.length = (short)2;
    }

    @Override
    public Class[] getExceptions() {
        return new Class[]{ExceptionConstants.NEGATIVE_ARRAY_SIZE_EXCEPTION};
    }

    @Override
    public void accept(Visitor v) {
        v.visitAllocationInstruction(this);
        v.visitExceptionThrower(this);
        v.visitStackProducer(this);
        v.visitNEWARRAY(this);
    }
}

