/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.generic;

import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionHandle;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Select;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Visitor;
import com.ibm.xltxe.rnm1.xtq.bcel.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public class TABLESWITCH
extends Select {
    TABLESWITCH() {
    }

    public TABLESWITCH(int[] match, InstructionHandle[] targets, InstructionHandle target) {
        super((short)170, match, targets, target);
        this.length = (short)(13 + this.match_length * 4);
        this.fixed_length = this.length;
    }

    @Override
    public void dump(DataOutputStream out) throws IOException {
        super.dump(out);
        int low = this.match_length > 0 ? this.match[0] : 0;
        out.writeInt(low);
        int high = this.match_length > 0 ? this.match[this.match_length - 1] : 0;
        out.writeInt(high);
        for (int i = 0; i < this.match_length; ++i) {
            this.indices[i] = this.getTargetOffset(this.targets[i]);
            out.writeInt(this.indices[i]);
        }
    }

    @Override
    protected void initFromFile(ByteSequence bytes2, boolean wide) throws IOException {
        int i;
        super.initFromFile(bytes2, wide);
        int low = bytes2.readInt();
        int high = bytes2.readInt();
        this.match_length = high - low + 1;
        this.fixed_length = (short)(13 + this.match_length * 4);
        this.length = (short)(this.fixed_length + this.padding);
        this.match = new int[this.match_length];
        this.indices = new int[this.match_length];
        this.targets = new InstructionHandle[this.match_length];
        for (i = low; i <= high; ++i) {
            this.match[i - low] = i;
        }
        for (i = 0; i < this.match_length; ++i) {
            this.indices[i] = bytes2.readInt();
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitVariableLengthInstruction(this);
        v.visitStackProducer(this);
        v.visitBranchInstruction(this);
        v.visitSelect(this);
        v.visitTABLESWITCH(this);
    }
}

