/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.util;

import com.ibm.xltxe.rnm1.xtq.bcel.Constants;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Utility;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.AllocationInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ArrayInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.BranchHandle;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.BranchInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.CHECKCAST;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.CPInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.CodeExceptionGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ConstantPoolGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ConstantPushInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.EmptyVisitor;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.FieldInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IINC;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.INSTANCEOF;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Instruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionConstants;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionHandle;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InvokeInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LDC;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LDC2_W;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LocalVariableInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.MULTIANEWARRAY;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.MethodGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.NEWARRAY;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ObjectType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.RET;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ReturnInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Select;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Type;
import com.ibm.xltxe.rnm1.xtq.bcel.util.BCELifier;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;

class BCELFactory
extends EmptyVisitor {
    private MethodGen _mg;
    private PrintWriter _out;
    private ConstantPoolGen _cp;
    private HashMap branch_map = new HashMap();
    private ArrayList branches = new ArrayList();

    BCELFactory(MethodGen mg, PrintWriter out) {
        this._mg = mg;
        this._cp = mg.getConstantPool();
        this._out = out;
    }

    public void start() {
        if (!this._mg.isAbstract() && !this._mg.isNative()) {
            for (InstructionHandle ih = this._mg.getInstructionList().getStart(); ih != null; ih = ih.getNext()) {
                Instruction i = ih.getInstruction();
                if (i instanceof BranchInstruction) {
                    this.branch_map.put(i, ih);
                }
                if (ih.hasTargeters()) {
                    if (i instanceof BranchInstruction) {
                        this._out.println("    InstructionHandle ih_" + ih.getPosition() + ";");
                    } else {
                        this._out.print("    InstructionHandle ih_" + ih.getPosition() + " = ");
                    }
                } else {
                    this._out.print("    ");
                }
                if (this.visitInstruction(i)) continue;
                i.accept(this);
            }
            this.updateBranchTargets();
            this.updateExceptionHandlers();
        }
    }

    private boolean visitInstruction(Instruction i) {
        short opcode = i.getOpcode();
        if (InstructionConstants.INSTRUCTIONS[opcode] != null && !(i instanceof ConstantPushInstruction) && !(i instanceof ReturnInstruction)) {
            this._out.println("il.append(InstructionConstants." + i.getName().toUpperCase() + ");");
            return true;
        }
        return false;
    }

    @Override
    public void visitLocalVariableInstruction(LocalVariableInstruction i) {
        short opcode = i.getOpcode();
        Type type2 = i.getType(this._cp);
        if (opcode == 132) {
            this._out.println("il.append(new IINC(" + i.getIndex() + ", " + ((IINC)i).getIncrement() + "));");
        } else {
            String kind2 = opcode < 54 ? "Load" : "Store";
            this._out.println("il.append(_factory.create" + kind2 + "(" + BCELifier.printType(type2) + ", " + i.getIndex() + "));");
        }
    }

    @Override
    public void visitArrayInstruction(ArrayInstruction i) {
        short opcode = i.getOpcode();
        Type type2 = i.getType(this._cp);
        String kind2 = opcode < 79 ? "Load" : "Store";
        this._out.println("il.append(_factory.createArray" + kind2 + "(" + BCELifier.printType(type2) + "));");
    }

    @Override
    public void visitFieldInstruction(FieldInstruction i) {
        short opcode = i.getOpcode();
        String class_name = i.getClassName(this._cp);
        String field_name = i.getFieldName(this._cp);
        Type type2 = i.getFieldType(this._cp);
        this._out.println("il.append(_factory.createFieldAccess(\"" + class_name + "\", \"" + field_name + "\", " + BCELifier.printType(type2) + ", " + "Constants." + Constants.OPCODE_NAMES[opcode].toUpperCase() + "));");
    }

    @Override
    public void visitInvokeInstruction(InvokeInstruction i) {
        short opcode = i.getOpcode();
        String class_name = i.getClassName(this._cp);
        String method_name = i.getMethodName(this._cp);
        Type type2 = i.getReturnType(this._cp);
        Type[] arg_types = i.getArgumentTypes(this._cp);
        this._out.println("il.append(_factory.createInvoke(\"" + class_name + "\", \"" + method_name + "\", " + BCELifier.printType(type2) + ", " + BCELifier.printArgumentTypes(arg_types) + ", " + "Constants." + Constants.OPCODE_NAMES[opcode].toUpperCase() + "));");
    }

    @Override
    public void visitAllocationInstruction(AllocationInstruction i) {
        Type type2 = i instanceof CPInstruction ? ((CPInstruction)((Object)i)).getType(this._cp) : ((NEWARRAY)i).getType();
        short opcode = ((Instruction)((Object)i)).getOpcode();
        short dim = 1;
        switch (opcode) {
            case 187: {
                this._out.println("il.append(_factory.createNew(\"" + ((ObjectType)type2).getClassName() + "\"));");
                break;
            }
            case 197: {
                dim = ((MULTIANEWARRAY)i).getDimensions();
            }
            case 188: 
            case 189: {
                this._out.println("il.append(_factory.createNewArray(" + BCELifier.printType(type2) + ", (short) " + dim + "));");
                break;
            }
            default: {
                throw new RuntimeException("Oops: " + opcode);
            }
        }
    }

    private void createConstant(Object value2) {
        String embed = value2.toString();
        if (value2 instanceof String) {
            embed = '\"' + Utility.convertString(value2.toString()) + '\"';
        } else if (value2 instanceof Character) {
            embed = "(char)0x" + Integer.toHexString(((Character)value2).charValue());
        }
        this._out.println("il.append(new PUSH(_cp, " + embed + "));");
    }

    @Override
    public void visitLDC(LDC i) {
        this.createConstant(i.getValue(this._cp));
    }

    @Override
    public void visitLDC2_W(LDC2_W i) {
        this.createConstant(i.getValue(this._cp));
    }

    @Override
    public void visitConstantPushInstruction(ConstantPushInstruction i) {
        this.createConstant(i.getValue());
    }

    @Override
    public void visitINSTANCEOF(INSTANCEOF i) {
        Type type2 = i.getType(this._cp);
        this._out.println("il.append(new INSTANCEOF(_cp.addClass(" + BCELifier.printType(type2) + ")));");
    }

    @Override
    public void visitCHECKCAST(CHECKCAST i) {
        Type type2 = i.getType(this._cp);
        this._out.println("il.append(_factory.createCheckCast(" + BCELifier.printType(type2) + "));");
    }

    @Override
    public void visitReturnInstruction(ReturnInstruction i) {
        Type type2 = i.getType(this._cp);
        this._out.println("il.append(_factory.createReturn(" + BCELifier.printType(type2) + "));");
    }

    @Override
    public void visitBranchInstruction(BranchInstruction bi) {
        BranchHandle bh = (BranchHandle)this.branch_map.get(bi);
        int pos = bh.getPosition();
        String name2 = bi.getName() + "_" + pos;
        if (bi instanceof Select) {
            int i;
            Select s = (Select)bi;
            this.branches.add(bi);
            StringBuffer args = new StringBuffer("new int[] { ");
            int[] matchs = s.getMatchs();
            for (i = 0; i < matchs.length; ++i) {
                args.append(matchs[i]);
                if (i >= matchs.length - 1) continue;
                args.append(", ");
            }
            args.append(" }");
            this._out.print("    Select " + name2 + " = new " + bi.getName().toUpperCase() + "(" + args + ", new InstructionHandle[] { ");
            for (i = 0; i < matchs.length; ++i) {
                this._out.print("null");
                if (i >= matchs.length - 1) continue;
                this._out.print(", ");
            }
            this._out.println(");");
        } else {
            String target;
            int t_pos = bh.getTarget().getPosition();
            if (pos > t_pos) {
                target = "ih_" + t_pos;
            } else {
                this.branches.add(bi);
                target = "null";
            }
            this._out.println("    BranchInstruction " + name2 + " = _factory.createBranchInstruction(" + "Constants." + bi.getName().toUpperCase() + ", " + target + ");");
        }
        if (bh.hasTargeters()) {
            this._out.println("    ih_" + pos + " = il.append(" + name2 + ");");
        } else {
            this._out.println("    il.append(" + name2 + ");");
        }
    }

    @Override
    public void visitRET(RET i) {
        this._out.println("il.append(new RET(" + i.getIndex() + ")));");
    }

    private void updateBranchTargets() {
        for (BranchInstruction bi : this.branches) {
            BranchHandle bh = (BranchHandle)this.branch_map.get(bi);
            int pos = bh.getPosition();
            String name2 = bi.getName() + "_" + pos;
            int t_pos = bh.getTarget().getPosition();
            this._out.println("    " + name2 + ".setTarget(ih_" + t_pos + ");");
            if (!(bi instanceof Select)) continue;
            InstructionHandle[] ihs = ((Select)bi).getTargets();
            for (int j = 0; j < ihs.length; ++j) {
                t_pos = ihs[j].getPosition();
                this._out.println("    " + name2 + ".setTarget(" + j + ", ih_" + t_pos + ");");
            }
        }
    }

    private void updateExceptionHandlers() {
        CodeExceptionGen[] handlers = this._mg.getExceptionHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            CodeExceptionGen h = handlers[i];
            String type2 = h.getCatchType() == null ? "null" : BCELifier.printType(h.getCatchType());
            this._out.println("    method.addExceptionHandler(ih_" + h.getStartPC().getPosition() + ", " + "ih_" + h.getEndPC().getPosition() + ", " + "ih_" + h.getHandlerPC().getPosition() + ", " + type2 + ");");
        }
    }
}

