/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassPath
implements Serializable {
    public static final ClassPath SYSTEM_CLASS_PATH = new ClassPath();
    private PathEntry[] paths;
    private String class_path;

    public ClassPath(final String class_path) {
        this.class_path = class_path;
        ArrayList newvec = (ArrayList)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                ArrayList<PathEntry> vec = new ArrayList<PathEntry>();
                StringTokenizer tok = new StringTokenizer(class_path, System.getProperty("path.separator"));
                while (tok.hasMoreTokens()) {
                    String path2 = tok.nextToken();
                    if (path2.equals("")) continue;
                    File file = new File(path2);
                    try {
                        if (!file.exists()) continue;
                        if (file.isDirectory()) {
                            vec.add(new Dir(path2));
                            continue;
                        }
                        vec.add(new Zip(new ZipFile(file)));
                    }
                    catch (IOException e) {}
                }
                return vec;
            }
        });
        this.paths = new PathEntry[newvec.size()];
        newvec.toArray(this.paths);
    }

    public ClassPath() {
        this(ClassPath.getClassPath());
    }

    public String toString() {
        return this.class_path;
    }

    public int hashCode() {
        return this.class_path.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ClassPath) {
            return this.class_path.equals(((ClassPath)o).class_path);
        }
        return false;
    }

    private static final void getPathComponents(String path2, final ArrayList list) {
        if (path2 != null) {
            final StringTokenizer tok = new StringTokenizer(path2, File.pathSeparator);
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    while (tok.hasMoreTokens()) {
                        String name2 = tok.nextToken();
                        File file = new File(name2);
                        if (!file.exists()) continue;
                        list.add(name2);
                    }
                    return null;
                }
            });
        }
    }

    public static final String getClassPath() {
        String class_path = (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return System.getProperty("java.class.path");
            }
        });
        String boot_path = (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return System.getProperty("sun.boot.class.path");
            }
        });
        String ext_path = (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return System.getProperty("java.ext.dirs");
            }
        });
        ArrayList<String> list = new ArrayList<String>();
        ClassPath.getPathComponents(class_path, list);
        ClassPath.getPathComponents(boot_path, list);
        ArrayList dirs = new ArrayList();
        ClassPath.getPathComponents(ext_path, dirs);
        Iterator e = dirs.iterator();
        while (e.hasNext()) {
            final File ext_dir = new File((String)e.next());
            String[] extensions = (String[])AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return ext_dir.list(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name2) {
                            return (name2 = name2.toLowerCase()).endsWith(".zip") || name2.endsWith(".jar");
                        }
                    });
                }
            });
            if (extensions == null) continue;
            for (int i = 0; i < extensions.length; ++i) {
                list.add(ext_path + File.separatorChar + extensions[i]);
            }
        }
        StringBuffer buf = new StringBuffer();
        Iterator e2 = list.iterator();
        while (e2.hasNext()) {
            buf.append((String)e2.next());
            if (!e2.hasNext()) continue;
            buf.append(File.pathSeparatorChar);
        }
        return buf.toString().intern();
    }

    public InputStream getInputStream(String name2) throws IOException {
        return this.getInputStream(name2, ".class");
    }

    public InputStream getInputStream(String name2, String suffix2) throws IOException {
        InputStream is2 = null;
        try {
            is2 = this.getClass().getClassLoader().getResourceAsStream(name2 + suffix2);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (is2 != null) {
            return is2;
        }
        return this.getClassFile(name2, suffix2).getInputStream();
    }

    public ClassFile getClassFile(String name2, String suffix2) throws IOException {
        for (int i = 0; i < this.paths.length; ++i) {
            ClassFile cf = this.paths[i].getClassFile(name2, suffix2);
            if (cf == null) continue;
            return cf;
        }
        throw new IOException("Couldn't find: " + name2 + suffix2);
    }

    public ClassFile getClassFile(String name2) throws IOException {
        return this.getClassFile(name2, ".class");
    }

    public byte[] getBytes(String name2, String suffix2) throws IOException {
        InputStream is2 = this.getInputStream(name2, suffix2);
        if (is2 == null) {
            throw new IOException("Couldn't find: " + name2 + suffix2);
        }
        DataInputStream dis = new DataInputStream(is2);
        byte[] bytes2 = new byte[is2.available()];
        dis.readFully(bytes2);
        dis.close();
        is2.close();
        return bytes2;
    }

    public byte[] getBytes(String name2) throws IOException {
        return this.getBytes(name2, ".class");
    }

    public String getPath(String name2) throws IOException {
        int index2 = name2.lastIndexOf(46);
        String suffix2 = "";
        if (index2 > 0) {
            suffix2 = name2.substring(index2);
            name2 = name2.substring(0, index2);
        }
        return this.getPath(name2, suffix2);
    }

    public String getPath(String name2, String suffix2) throws IOException {
        return this.getClassFile(name2, suffix2).getPath();
    }

    private static class Zip
    extends PathEntry {
        private ZipFile zip;

        Zip(ZipFile z) {
            this.zip = z;
        }

        @Override
        ClassFile getClassFile(String name2, String suffix2) throws IOException {
            final ZipEntry entry = this.zip.getEntry(name2.replace('.', '/') + suffix2);
            return entry != null ? new ClassFile(){

                @Override
                public InputStream getInputStream() throws IOException {
                    return Zip.this.zip.getInputStream(entry);
                }

                @Override
                public String getPath() {
                    return entry.toString();
                }

                @Override
                public long getTime() {
                    return entry.getTime();
                }

                @Override
                public long getSize() {
                    return entry.getSize();
                }

                @Override
                public String getBase() {
                    return Zip.this.zip.getName();
                }
            } : null;
        }
    }

    private static class Dir
    extends PathEntry {
        private String dir;

        Dir(String d) {
            this.dir = d;
        }

        @Override
        ClassFile getClassFile(String name2, String suffix2) throws IOException {
            final File file = new File(this.dir + File.separatorChar + name2.replace('.', File.separatorChar) + suffix2);
            return file.exists() ? new ClassFile(){

                @Override
                public InputStream getInputStream() throws IOException {
                    return new FileInputStream(file);
                }

                @Override
                public String getPath() {
                    try {
                        return file.getCanonicalPath();
                    }
                    catch (IOException e) {
                        return null;
                    }
                }

                @Override
                public long getTime() {
                    return file.lastModified();
                }

                @Override
                public long getSize() {
                    return file.length();
                }

                @Override
                public String getBase() {
                    return Dir.this.dir;
                }
            } : null;
        }

        public String toString() {
            return this.dir;
        }
    }

    public static interface ClassFile {
        public InputStream getInputStream() throws IOException;

        public String getPath();

        public String getBase();

        public long getTime();

        public long getSize();
    }

    private static abstract class PathEntry
    implements Serializable {
        private PathEntry() {
        }

        abstract ClassFile getClassFile(String var1, String var2) throws IOException;
    }
}

