/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.util;

import com.ibm.xltxe.rnm1.xtq.bcel.Constants;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Attribute;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Code;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.CodeException;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantFieldref;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantInterfaceMethodref;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantMethodref;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantNameAndType;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantPool;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.LocalVariable;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.LocalVariableTable;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Method;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Utility;
import com.ibm.xltxe.rnm1.xtq.bcel.util.ByteSequence;
import com.ibm.xltxe.rnm1.xtq.bcel.util.Class2HTML;
import com.ibm.xltxe.rnm1.xtq.bcel.util.ConstantHTML;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.BitSet;

final class CodeHTML
implements Constants {
    private String class_name;
    private Method[] methods;
    private PrintWriter file;
    private BitSet goto_set;
    private ConstantPool constant_pool;
    private ConstantHTML constant_html;
    private static boolean wide = false;

    CodeHTML(String dir, String class_name, Method[] methods, ConstantPool constant_pool, ConstantHTML constant_html) throws IOException {
        this.class_name = class_name;
        this.methods = methods;
        this.constant_pool = constant_pool;
        this.constant_html = constant_html;
        this.file = new PrintWriter(new FileOutputStream(dir + class_name + "_code.html"));
        this.file.println("<HTML><BODY BGCOLOR=\"#C0C0C0\">");
        for (int i = 0; i < methods.length; ++i) {
            this.writeMethod(methods[i], i);
        }
        this.file.println("</BODY></HTML>");
        this.file.close();
    }

    private final String codeToHTML(ByteSequence bytes2, int method_number) throws IOException {
        int i;
        short opcode = (short)bytes2.readUnsignedByte();
        int default_offset = 0;
        int no_pad_bytes = 0;
        StringBuffer buf = new StringBuffer("<TT>" + OPCODE_NAMES[opcode] + "</TT></TD><TD>");
        if (opcode == 170 || opcode == 171) {
            int remainder = bytes2.getIndex() % 4;
            no_pad_bytes = remainder == 0 ? 0 : 4 - remainder;
            for (i = 0; i < no_pad_bytes; ++i) {
                bytes2.readByte();
            }
            default_offset = bytes2.readInt();
        }
        switch (opcode) {
            case 170: {
                int i2;
                int low = bytes2.readInt();
                int high = bytes2.readInt();
                int offset = bytes2.getIndex() - 12 - no_pad_bytes - 1;
                default_offset += offset;
                buf.append("<TABLE BORDER=1><TR>");
                int[] jump_table = new int[high - low + 1];
                for (i2 = 0; i2 < jump_table.length; ++i2) {
                    jump_table[i2] = offset + bytes2.readInt();
                    buf.append("<TH>" + (low + i2) + "</TH>");
                }
                buf.append("<TH>default</TH></TR>\n<TR>");
                for (i2 = 0; i2 < jump_table.length; ++i2) {
                    buf.append("<TD><A HREF=\"#code" + method_number + "@" + jump_table[i2] + "\">" + jump_table[i2] + "</A></TD>");
                }
                buf.append("<TD><A HREF=\"#code" + method_number + "@" + default_offset + "\">" + default_offset + "</A></TD></TR>\n</TABLE>\n");
                break;
            }
            case 171: {
                int npairs = bytes2.readInt();
                int offset = bytes2.getIndex() - 8 - no_pad_bytes - 1;
                int[] jump_table = new int[npairs];
                default_offset += offset;
                buf.append("<TABLE BORDER=1><TR>");
                for (i = 0; i < npairs; ++i) {
                    int match = bytes2.readInt();
                    jump_table[i] = offset + bytes2.readInt();
                    buf.append("<TH>" + match + "</TH>");
                }
                buf.append("<TH>default</TH></TR>\n<TR>");
                for (i = 0; i < npairs; ++i) {
                    buf.append("<TD><A HREF=\"#code" + method_number + "@" + jump_table[i] + "\">" + jump_table[i] + "</A></TD>");
                }
                buf.append("<TD><A HREF=\"#code" + method_number + "@" + default_offset + "\">" + default_offset + "</A></TD></TR>\n</TABLE>\n");
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                int index2 = bytes2.getIndex() + bytes2.readShort() - 1;
                buf.append("<A HREF=\"#code" + method_number + "@" + index2 + "\">" + index2 + "</A>");
                break;
            }
            case 200: 
            case 201: {
                int windex = bytes2.getIndex() + bytes2.readInt() - 1;
                buf.append("<A HREF=\"#code" + method_number + "@" + windex + "\">" + windex + "</A>");
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                int vindex;
                if (wide) {
                    vindex = bytes2.readShort();
                    wide = false;
                } else {
                    vindex = bytes2.readUnsignedByte();
                }
                buf.append("%" + vindex);
                break;
            }
            case 196: {
                wide = true;
                buf.append("(wide)");
                break;
            }
            case 188: {
                buf.append("<FONT COLOR=\"#00FF00\">" + TYPE_NAMES[bytes2.readByte()] + "</FONT>");
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                int index2 = bytes2.readShort();
                ConstantFieldref c1 = (ConstantFieldref)this.constant_pool.getConstant(index2, (byte)9);
                int class_index = c1.getClassIndex();
                String name2 = this.constant_pool.getConstantString(class_index, (byte)7);
                name2 = Utility.compactClassName(name2, false);
                index2 = c1.getNameAndTypeIndex();
                String field_name = this.constant_pool.constantToString(index2, (byte)12);
                if (name2.equals(this.class_name)) {
                    buf.append("<A HREF=\"" + this.class_name + "_methods.html#field" + field_name + "\" TARGET=Methods>" + field_name + "</A>\n");
                    break;
                }
                buf.append(this.constant_html.referenceConstant(class_index) + "." + field_name);
                break;
            }
            case 187: 
            case 192: 
            case 193: {
                short index2 = bytes2.readShort();
                buf.append(this.constant_html.referenceConstant(index2));
                break;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                int index3;
                String str;
                int class_index;
                short m_index = bytes2.readShort();
                if (opcode == 185) {
                    int nargs = bytes2.readUnsignedByte();
                    int reserved = bytes2.readUnsignedByte();
                    ConstantInterfaceMethodref c = (ConstantInterfaceMethodref)this.constant_pool.getConstant(m_index, (byte)11);
                    class_index = c.getClassIndex();
                    str = this.constant_pool.constantToString(c);
                    index3 = c.getNameAndTypeIndex();
                } else {
                    ConstantMethodref c = (ConstantMethodref)this.constant_pool.getConstant(m_index, (byte)10);
                    class_index = c.getClassIndex();
                    str = this.constant_pool.constantToString(c);
                    index3 = c.getNameAndTypeIndex();
                }
                String name2 = Class2HTML.referenceClass(class_index);
                str = Class2HTML.toHTML(this.constant_pool.constantToString(this.constant_pool.getConstant(index3, (byte)12)));
                ConstantNameAndType c2 = (ConstantNameAndType)this.constant_pool.getConstant(index3, (byte)12);
                String signature = this.constant_pool.constantToString(c2.getSignatureIndex(), (byte)1);
                String[] args = Utility.methodSignatureArgumentTypes(signature, false);
                String type2 = Utility.methodSignatureReturnType(signature, false);
                buf.append(name2 + ".<A HREF=\"" + this.class_name + "_cp.html#cp" + m_index + "\" TARGET=ConstantPool>" + str + "</A>" + "(");
                for (int i3 = 0; i3 < args.length; ++i3) {
                    buf.append(Class2HTML.referenceType(args[i3]));
                    if (i3 >= args.length - 1) continue;
                    buf.append(", ");
                }
                buf.append("):" + Class2HTML.referenceType(type2));
                break;
            }
            case 19: 
            case 20: {
                short index3 = bytes2.readShort();
                buf.append("<A HREF=\"" + this.class_name + "_cp.html#cp" + index3 + "\" TARGET=\"ConstantPool\">" + Class2HTML.toHTML(this.constant_pool.constantToString(index3, this.constant_pool.getConstant(index3).getTag())) + "</a>");
                break;
            }
            case 18: {
                int index3 = bytes2.readUnsignedByte();
                buf.append("<A HREF=\"" + this.class_name + "_cp.html#cp" + index3 + "\" TARGET=\"ConstantPool\">" + Class2HTML.toHTML(this.constant_pool.constantToString(index3, this.constant_pool.getConstant(index3).getTag())) + "</a>");
                break;
            }
            case 189: {
                short index3 = bytes2.readShort();
                buf.append(this.constant_html.referenceConstant(index3));
                break;
            }
            case 197: {
                short index3 = bytes2.readShort();
                byte dimensions = bytes2.readByte();
                buf.append(this.constant_html.referenceConstant(index3) + ":" + dimensions + "-dimensional");
                break;
            }
            case 132: {
                short constant;
                int vindex;
                if (wide) {
                    vindex = bytes2.readShort();
                    constant = bytes2.readShort();
                    wide = false;
                } else {
                    vindex = bytes2.readUnsignedByte();
                    constant = bytes2.readByte();
                }
                buf.append("%" + vindex + " " + constant);
                break;
            }
            default: {
                if (NO_OF_OPERANDS[opcode] <= 0) break;
                for (int i4 = 0; i4 < TYPE_OF_OPERANDS[opcode].length; ++i4) {
                    switch (TYPE_OF_OPERANDS[opcode][i4]) {
                        case 8: {
                            buf.append(bytes2.readUnsignedByte());
                            break;
                        }
                        case 9: {
                            buf.append(bytes2.readShort());
                            break;
                        }
                        case 10: {
                            buf.append(bytes2.readInt());
                            break;
                        }
                        default: {
                            System.err.println("Unreachable default case reached!");
                            System.exit(-1);
                        }
                    }
                    buf.append("&nbsp;");
                }
            }
        }
        buf.append("</TD>");
        return buf.toString();
    }

    private final void findGotos(ByteSequence bytes2, Method method, Code code) throws IOException {
        int j;
        this.goto_set = new BitSet(bytes2.available());
        if (code != null) {
            CodeException[] ce = code.getExceptionTable();
            int len = ce.length;
            for (int i = 0; i < len; ++i) {
                this.goto_set.set(ce[i].getStartPC());
                this.goto_set.set(ce[i].getEndPC());
                this.goto_set.set(ce[i].getHandlerPC());
            }
            Attribute[] attributes2 = code.getAttributes();
            for (int i = 0; i < attributes2.length; ++i) {
                if (attributes2[i].getTag() != 5) continue;
                LocalVariable[] vars = ((LocalVariableTable)attributes2[i]).getLocalVariableTable();
                for (j = 0; j < vars.length; ++j) {
                    int start = vars[j].getStartPC();
                    int end = start + vars[j].getLength();
                    this.goto_set.set(start);
                    this.goto_set.set(end);
                }
                break;
            }
        }
        int i = 0;
        while (bytes2.available() > 0) {
            int opcode = bytes2.readUnsignedByte();
            switch (opcode) {
                case 170: 
                case 171: {
                    int index2;
                    int remainder = bytes2.getIndex() % 4;
                    int no_pad_bytes = remainder == 0 ? 0 : 4 - remainder;
                    for (j = 0; j < no_pad_bytes; ++j) {
                        bytes2.readByte();
                    }
                    int default_offset = bytes2.readInt();
                    if (opcode == 170) {
                        int low = bytes2.readInt();
                        int high = bytes2.readInt();
                        int offset = bytes2.getIndex() - 12 - no_pad_bytes - 1;
                        this.goto_set.set(default_offset += offset);
                        for (int j2 = 0; j2 < high - low + 1; ++j2) {
                            index2 = offset + bytes2.readInt();
                            this.goto_set.set(index2);
                        }
                    } else {
                        int npairs = bytes2.readInt();
                        int offset = bytes2.getIndex() - 8 - no_pad_bytes - 1;
                        this.goto_set.set(default_offset += offset);
                        for (int j3 = 0; j3 < npairs; ++j3) {
                            int match = bytes2.readInt();
                            index2 = offset + bytes2.readInt();
                            this.goto_set.set(index2);
                        }
                    }
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 198: 
                case 199: {
                    int index2 = bytes2.getIndex() + bytes2.readShort() - 1;
                    this.goto_set.set(index2);
                    break;
                }
                case 200: 
                case 201: {
                    int index2 = bytes2.getIndex() + bytes2.readInt() - 1;
                    this.goto_set.set(index2);
                    break;
                }
                default: {
                    bytes2.unreadByte();
                    this.codeToHTML(bytes2, 0);
                }
            }
            ++i;
        }
    }

    private void writeMethod(Method method, int method_number) throws IOException {
        String signature = method.getSignature();
        String[] args = Utility.methodSignatureArgumentTypes(signature, false);
        String type2 = Utility.methodSignatureReturnType(signature, false);
        String name2 = method.getName();
        String html_name = Class2HTML.toHTML(name2);
        String access = Utility.accessToString(method.getAccessFlags());
        access = Utility.replace(access, " ", "&nbsp;");
        Attribute[] attributes2 = method.getAttributes();
        this.file.print("<P><B><FONT COLOR=\"#FF0000\">" + access + "</FONT>&nbsp;" + "<A NAME=method" + method_number + ">" + Class2HTML.referenceType(type2) + "</A>&nbsp<A HREF=\"" + this.class_name + "_methods.html#method" + method_number + "\" TARGET=Methods>" + html_name + "</A>(");
        for (int i = 0; i < args.length; ++i) {
            this.file.print(Class2HTML.referenceType(args[i]));
            if (i >= args.length - 1) continue;
            this.file.print(",&nbsp;");
        }
        this.file.println(")</B></P>");
        Code c = null;
        byte[] code = null;
        if (attributes2.length > 0) {
            this.file.print("<H4>Attributes</H4><UL>\n");
            for (int i = 0; i < attributes2.length; ++i) {
                byte tag = attributes2[i].getTag();
                if (tag != -1) {
                    this.file.print("<LI><A HREF=\"" + this.class_name + "_attributes.html#method" + method_number + "@" + i + "\" TARGET=Attributes>" + ATTRIBUTE_NAMES[tag] + "</A></LI>\n");
                } else {
                    this.file.print("<LI>" + attributes2[i] + "</LI>");
                }
                if (tag != 2) continue;
                c = (Code)attributes2[i];
                Attribute[] attributes22 = c.getAttributes();
                code = c.getCode();
                this.file.print("<UL>");
                for (int j = 0; j < attributes22.length; ++j) {
                    tag = attributes22[j].getTag();
                    this.file.print("<LI><A HREF=\"" + this.class_name + "_attributes.html#" + "method" + method_number + "@" + i + "@" + j + "\" TARGET=Attributes>" + ATTRIBUTE_NAMES[tag] + "</A></LI>\n");
                }
                this.file.print("</UL>");
            }
            this.file.println("</UL>");
        }
        if (code != null) {
            ByteSequence stream2 = new ByteSequence(code);
            stream2.mark(stream2.available());
            this.findGotos(stream2, method, c);
            stream2.reset();
            this.file.println("<TABLE BORDER=0><TR><TH ALIGN=LEFT>Byte<BR>offset</TH><TH ALIGN=LEFT>Instruction</TH><TH ALIGN=LEFT>Argument</TH>");
            int i = 0;
            while (stream2.available() > 0) {
                int offset = stream2.getIndex();
                String str = this.codeToHTML(stream2, method_number);
                String anchor = "";
                if (this.goto_set.get(offset)) {
                    anchor = "<A NAME=code" + method_number + "@" + offset + "></A>";
                }
                String anchor2 = stream2.getIndex() == code.length ? "<A NAME=code" + method_number + "@" + code.length + ">" + offset + "</A>" : "" + offset;
                this.file.println("<TR VALIGN=TOP><TD>" + anchor2 + "</TD><TD>" + anchor + str + "</TR>");
                ++i;
            }
            this.file.println("<TR><TD> </A></TD></TR>");
            this.file.println("</TABLE>");
        }
    }
}

