/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.verifier.statics;

import com.ibm.xltxe.rnm1.xtq.bcel.generic.Type;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.exc.AssertionViolatedException;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.exc.LocalVariableInfoInconsistentException;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.statics.DOUBLE_Upper;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.statics.LONG_Upper;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.statics.LocalVariableInfo;

public class LocalVariablesInfo {
    private LocalVariableInfo[] localVariableInfos;

    LocalVariablesInfo(int max_locals) {
        this.localVariableInfos = new LocalVariableInfo[max_locals];
        for (int i = 0; i < max_locals; ++i) {
            this.localVariableInfos[i] = new LocalVariableInfo();
        }
    }

    public LocalVariableInfo getLocalVariableInfo(int slot) {
        if (slot < 0 || slot >= this.localVariableInfos.length) {
            throw new AssertionViolatedException("Slot number for local variable information out of range.");
        }
        return this.localVariableInfos[slot];
    }

    public void add(int slot, String name2, int startpc, int length2, Type t) throws LocalVariableInfoInconsistentException {
        if (slot < 0 || slot >= this.localVariableInfos.length) {
            throw new AssertionViolatedException("Slot number for local variable information out of range.");
        }
        this.localVariableInfos[slot].add(name2, startpc, length2, t);
        if (t == Type.LONG) {
            this.localVariableInfos[slot + 1].add(name2, startpc, length2, LONG_Upper.theInstance());
        }
        if (t == Type.DOUBLE) {
            this.localVariableInfos[slot + 1].add(name2, startpc, length2, DOUBLE_Upper.theInstance());
        }
    }
}

