/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.verifier.statics;

import com.ibm.xltxe.rnm1.xtq.bcel.Repository;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.AccessFlags;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Attribute;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Code;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.CodeException;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Constant;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantClass;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantDouble;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantFieldref;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantFloat;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantInteger;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantInterfaceMethodref;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantLong;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantMethodref;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantNameAndType;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantString;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.ConstantUtf8;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Field;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.FieldOrMethod;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.JavaClass;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.LineNumber;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.LineNumberTable;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.LocalVariable;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.LocalVariableTable;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.Method;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ALOAD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ANEWARRAY;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ASTORE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ATHROW;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ArrayType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.BREAKPOINT;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.CHECKCAST;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ConstantPoolGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.DLOAD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.DSTORE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.EmptyVisitor;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.FLOAD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.FSTORE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.FieldInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.GETSTATIC;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.GotoInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IINC;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ILOAD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IMPDEP1;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.IMPDEP2;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.INSTANCEOF;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.INVOKEINTERFACE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.INVOKESPECIAL;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.INVOKESTATIC;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.INVOKEVIRTUAL;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ISTORE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Instruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionHandle;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionList;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InvokeInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.JsrInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LDC;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LDC2_W;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LLOAD;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LOOKUPSWITCH;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LSTORE;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.LoadClass;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.MULTIANEWARRAY;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.NEW;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.NEWARRAY;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ObjectType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.PUTSTATIC;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.RET;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ReturnInstruction;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.TABLESWITCH;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Type;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.PassVerifier;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.VerificationResult;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.Verifier;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.VerifierFactory;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.exc.AssertionViolatedException;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.exc.ClassConstraintException;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.exc.InvalidMethodException;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.exc.StaticCodeConstraintException;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.exc.StaticCodeInstructionConstraintException;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.exc.StaticCodeInstructionOperandConstraintException;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.statics.IntList;

public final class Pass3aVerifier
extends PassVerifier {
    private Verifier myOwner;
    private int method_no;
    InstructionList instructionList;
    Code code;

    public Pass3aVerifier(Verifier owner, int method_no) {
        this.myOwner = owner;
        this.method_no = method_no;
    }

    @Override
    public VerificationResult do_verify() {
        if (this.myOwner.doPass2().equals(VerificationResult.VR_OK)) {
            JavaClass jc = Repository.lookupClass(this.myOwner.getClassName());
            Method[] methods = jc.getMethods();
            if (this.method_no >= methods.length) {
                throw new InvalidMethodException("METHOD DOES NOT EXIST!");
            }
            Method method = methods[this.method_no];
            this.code = method.getCode();
            if (method.isAbstract() || method.isNative()) {
                return VerificationResult.VR_OK;
            }
            try {
                this.instructionList = new InstructionList(method.getCode().getCode());
            }
            catch (RuntimeException re) {
                return new VerificationResult(2, "Bad bytecode in the code array of the Code attribute of method '" + method + "'.");
            }
            this.instructionList.setPositions(true);
            VerificationResult vr = VerificationResult.VR_OK;
            try {
                this.delayedPass2Checks();
            }
            catch (ClassConstraintException cce) {
                vr = new VerificationResult(2, cce.getMessage());
                return vr;
            }
            try {
                this.pass3StaticInstructionChecks();
                this.pass3StaticInstructionOperandsChecks();
            }
            catch (StaticCodeConstraintException scce) {
                vr = new VerificationResult(2, scce.getMessage());
            }
            return vr;
        }
        return VerificationResult.VR_NOTYET;
    }

    private void delayedPass2Checks() {
        int i;
        int[] instructionPositions = this.instructionList.getInstructionPositions();
        int codeLength = this.code.getCode().length;
        LineNumberTable lnt = this.code.getLineNumberTable();
        if (lnt != null) {
            LineNumber[] lineNumbers = lnt.getLineNumberTable();
            IntList offsets = new IntList();
            block0: for (i = 0; i < lineNumbers.length; ++i) {
                for (int j = 0; j < instructionPositions.length; ++j) {
                    int offset = lineNumbers[i].getStartPC();
                    if (instructionPositions[j] != offset) continue;
                    if (offsets.contains(offset)) {
                        this.addMessage("LineNumberTable attribute '" + this.code.getLineNumberTable() + "' refers to the same code offset ('" + offset + "') more than once which is violating the semantics [but is sometimes produced by IBM's 'jikes' compiler].");
                        continue block0;
                    }
                    offsets.add(offset);
                    continue block0;
                }
                throw new ClassConstraintException("Code attribute '" + this.code + "' has a LineNumberTable attribute '" + this.code.getLineNumberTable() + "' referring to a code offset ('" + lineNumbers[i].getStartPC() + "') that does not exist.");
            }
        }
        Attribute[] atts = this.code.getAttributes();
        for (int a = 0; a < atts.length; ++a) {
            LocalVariableTable lvt;
            if (!(atts[a] instanceof LocalVariableTable) || (lvt = (LocalVariableTable)atts[a]) == null) continue;
            LocalVariable[] localVariables = lvt.getLocalVariableTable();
            for (int i2 = 0; i2 < localVariables.length; ++i2) {
                int startpc = localVariables[i2].getStartPC();
                int length2 = localVariables[i2].getLength();
                if (!Pass3aVerifier.contains(instructionPositions, startpc)) {
                    throw new ClassConstraintException("Code attribute '" + this.code + "' has a LocalVariableTable attribute '" + this.code.getLocalVariableTable() + "' referring to a code offset ('" + startpc + "') that does not exist.");
                }
                if (Pass3aVerifier.contains(instructionPositions, startpc + length2) || startpc + length2 == codeLength) continue;
                throw new ClassConstraintException("Code attribute '" + this.code + "' has a LocalVariableTable attribute '" + this.code.getLocalVariableTable() + "' referring to a code offset start_pc+length ('" + (startpc + length2) + "') that does not exist.");
            }
        }
        CodeException[] exceptionTable = this.code.getExceptionTable();
        for (i = 0; i < exceptionTable.length; ++i) {
            int startpc = exceptionTable[i].getStartPC();
            int endpc = exceptionTable[i].getEndPC();
            int handlerpc = exceptionTable[i].getHandlerPC();
            if (startpc >= endpc) {
                throw new ClassConstraintException("Code attribute '" + this.code + "' has an exception_table entry '" + exceptionTable[i] + "' that has its start_pc ('" + startpc + "') not smaller than its end_pc ('" + endpc + "').");
            }
            if (!Pass3aVerifier.contains(instructionPositions, startpc)) {
                throw new ClassConstraintException("Code attribute '" + this.code + "' has an exception_table entry '" + exceptionTable[i] + "' that has a non-existant bytecode offset as its start_pc ('" + startpc + "').");
            }
            if (!Pass3aVerifier.contains(instructionPositions, endpc) && endpc != codeLength) {
                throw new ClassConstraintException("Code attribute '" + this.code + "' has an exception_table entry '" + exceptionTable[i] + "' that has a non-existant bytecode offset as its end_pc ('" + startpc + "') [that is also not equal to code_length ('" + codeLength + "')].");
            }
            if (Pass3aVerifier.contains(instructionPositions, handlerpc)) continue;
            throw new ClassConstraintException("Code attribute '" + this.code + "' has an exception_table entry '" + exceptionTable[i] + "' that has a non-existant bytecode offset as its handler_pc ('" + handlerpc + "').");
        }
    }

    private void pass3StaticInstructionChecks() {
        if (this.code.getCode().length >= 65536) {
            throw new StaticCodeInstructionConstraintException("Code array in code attribute '" + this.code + "' too big: must be smaller than 65536 bytes.");
        }
        for (InstructionHandle ih = this.instructionList.getStart(); ih != null; ih = ih.getNext()) {
            Instruction i = ih.getInstruction();
            if (i instanceof IMPDEP1) {
                throw new StaticCodeInstructionConstraintException("IMPDEP1 must not be in the code, it is an illegal instruction for _internal_ JVM use!");
            }
            if (i instanceof IMPDEP2) {
                throw new StaticCodeInstructionConstraintException("IMPDEP2 must not be in the code, it is an illegal instruction for _internal_ JVM use!");
            }
            if (!(i instanceof BREAKPOINT)) continue;
            throw new StaticCodeInstructionConstraintException("BREAKPOINT must not be in the code, it is an illegal instruction for _internal_ JVM use!");
        }
        Instruction last2 = this.instructionList.getEnd().getInstruction();
        if (!(last2 instanceof ReturnInstruction || last2 instanceof RET || last2 instanceof GotoInstruction || last2 instanceof ATHROW)) {
            throw new StaticCodeInstructionConstraintException("Execution must not fall off the bottom of the code array. This constraint is enforced statically as some existing verifiers do - so it may be a false alarm if the last instruction is not reachable.");
        }
    }

    private void pass3StaticInstructionOperandsChecks() {
        ConstantPoolGen cpg = new ConstantPoolGen(Repository.lookupClass(this.myOwner.getClassName()).getConstantPool());
        InstOperandConstraintVisitor v = new InstOperandConstraintVisitor(cpg);
        for (InstructionHandle ih = this.instructionList.getStart(); ih != null; ih = ih.getNext()) {
            Instruction i = ih.getInstruction();
            if (i instanceof JsrInstruction) {
                InstructionHandle target = ((JsrInstruction)i).getTarget();
                if (target == this.instructionList.getStart()) {
                    throw new StaticCodeInstructionOperandConstraintException("Due to JustIce's clear definition of subroutines, no JSR or JSR_W may have a top-level instruction (such as the very first instruction, which is targeted by instruction '" + ih + "' as its target.");
                }
                if (!(target.getInstruction() instanceof ASTORE)) {
                    throw new StaticCodeInstructionOperandConstraintException("Due to JustIce's clear definition of subroutines, no JSR or JSR_W may target anything else than an ASTORE instruction. Instruction '" + ih + "' targets '" + target + "'.");
                }
            }
            ih.accept(v);
        }
    }

    private static boolean contains(int[] ints, int i) {
        for (int j = 0; j < ints.length; ++j) {
            if (ints[j] != i) continue;
            return true;
        }
        return false;
    }

    public int getMethodNo() {
        return this.method_no;
    }

    private class InstOperandConstraintVisitor
    extends EmptyVisitor {
        private ConstantPoolGen cpg;

        InstOperandConstraintVisitor(ConstantPoolGen cpg) {
            this.cpg = cpg;
        }

        private int max_locals() {
            return Repository.lookupClass(Pass3aVerifier.this.myOwner.getClassName()).getMethods()[Pass3aVerifier.this.method_no].getCode().getMaxLocals();
        }

        private void constraintViolated(Instruction i, String message) {
            throw new StaticCodeInstructionOperandConstraintException("Instruction " + i + " constraint violated: " + message);
        }

        private void indexValid(Instruction i, int idx) {
            if (idx < 0 || idx >= this.cpg.getSize()) {
                this.constraintViolated(i, "Illegal constant pool index '" + idx + "'.");
            }
        }

        @Override
        public void visitLoadClass(LoadClass o) {
            Verifier v;
            VerificationResult vr;
            ObjectType t = o.getLoadClassType(this.cpg);
            if (t != null && (vr = (v = VerifierFactory.getVerifier(t.getClassName())).doPass1()).getStatus() != 1) {
                this.constraintViolated((Instruction)((Object)o), "Class '" + o.getLoadClassType(this.cpg).getClassName() + "' is referenced, but cannot be loaded: '" + vr + "'.");
            }
        }

        @Override
        public void visitLDC(LDC o) {
            this.indexValid(o, o.getIndex());
            Constant c = this.cpg.getConstant(o.getIndex());
            if (!(c instanceof ConstantInteger || c instanceof ConstantFloat || c instanceof ConstantString)) {
                this.constraintViolated(o, "Operand of LDC or LDC_W must be one of CONSTANT_Integer, CONSTANT_Float or CONSTANT_String, but is '" + c + "'.");
            }
        }

        @Override
        public void visitLDC2_W(LDC2_W o) {
            this.indexValid(o, o.getIndex());
            Constant c = this.cpg.getConstant(o.getIndex());
            if (!(c instanceof ConstantLong) && !(c instanceof ConstantDouble)) {
                this.constraintViolated(o, "Operand of LDC2_W must be CONSTANT_Long or CONSTANT_Double, but is '" + c + "'.");
            }
            try {
                this.indexValid(o, o.getIndex() + 1);
            }
            catch (StaticCodeInstructionOperandConstraintException e) {
                throw new AssertionViolatedException("OOPS: Does not BCEL handle that? LDC2_W operand has a problem.");
            }
        }

        @Override
        public void visitFieldInstruction(FieldInstruction o) {
            this.indexValid(o, o.getIndex());
            Constant c = this.cpg.getConstant(o.getIndex());
            if (!(c instanceof ConstantFieldref)) {
                this.constraintViolated(o, "Indexing a constant that's not a CONSTANT_Fieldref but a '" + c + "'.");
            }
            String field_name = o.getFieldName(this.cpg);
            JavaClass jc = Repository.lookupClass(o.getClassType(this.cpg).getClassName());
            Field[] fields = jc.getFields();
            FieldOrMethod f2 = null;
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].getName().equals(field_name)) continue;
                f2 = fields[i];
                break;
            }
            if (f2 == null) {
                this.constraintViolated(o, "Referenced field '" + field_name + "' does not exist in class '" + jc.getClassName() + "'.");
            } else {
                Type o_type;
                Type f_type = Type.getType(f2.getSignature());
                if (!f_type.equals(o_type = o.getType(this.cpg))) {
                    this.constraintViolated(o, "Referenced field '" + field_name + "' has type '" + f_type + "' instead of '" + o_type + "' as expected.");
                }
            }
        }

        @Override
        public void visitInvokeInstruction(InvokeInstruction o) {
            Verifier v;
            VerificationResult vr;
            ConstantNameAndType cnat;
            Constant c;
            this.indexValid(o, o.getIndex());
            if (o instanceof INVOKEVIRTUAL || o instanceof INVOKESPECIAL || o instanceof INVOKESTATIC) {
                c = this.cpg.getConstant(o.getIndex());
                if (!(c instanceof ConstantMethodref)) {
                    this.constraintViolated(o, "Indexing a constant that's not a CONSTANT_Methodref but a '" + c + "'.");
                } else {
                    cnat = (ConstantNameAndType)this.cpg.getConstant(((ConstantMethodref)c).getNameAndTypeIndex());
                    ConstantUtf8 cutf8 = (ConstantUtf8)this.cpg.getConstant(cnat.getNameIndex());
                    if (cutf8.getBytes().equals("<init>") && !(o instanceof INVOKESPECIAL)) {
                        this.constraintViolated(o, "Only INVOKESPECIAL is allowed to invoke instance initialization methods.");
                    }
                    if (!cutf8.getBytes().equals("<init>") && cutf8.getBytes().startsWith("<")) {
                        this.constraintViolated(o, "No method with a name beginning with '<' other than the instance initialization methods may be called by the method invocation instructions.");
                    }
                }
            } else {
                String name2;
                c = this.cpg.getConstant(o.getIndex());
                if (!(c instanceof ConstantInterfaceMethodref)) {
                    this.constraintViolated(o, "Indexing a constant that's not a CONSTANT_InterfaceMethodref but a '" + c + "'.");
                }
                if ((name2 = ((ConstantUtf8)this.cpg.getConstant((cnat = (ConstantNameAndType)this.cpg.getConstant(((ConstantInterfaceMethodref)c).getNameAndTypeIndex())).getNameIndex())).getBytes()).equals("<init>")) {
                    this.constraintViolated(o, "Method to invoke must not be '<init>'.");
                }
                if (name2.equals("<clinit>")) {
                    this.constraintViolated(o, "Method to invoke must not be '<clinit>'.");
                }
            }
            Type t = o.getReturnType(this.cpg);
            if (t instanceof ArrayType) {
                t = ((ArrayType)t).getBasicType();
            }
            if (t instanceof ObjectType && (vr = (v = VerifierFactory.getVerifier(((ObjectType)t).getClassName())).doPass2()).getStatus() != 1) {
                this.constraintViolated(o, "Return type class/interface could not be verified successfully: '" + vr.getMessage() + "'.");
            }
            Type[] ts = o.getArgumentTypes(this.cpg);
            for (int i = 0; i < ts.length; ++i) {
                Verifier v2;
                VerificationResult vr2;
                t = ts[i];
                if (t instanceof ArrayType) {
                    t = ((ArrayType)t).getBasicType();
                }
                if (!(t instanceof ObjectType) || (vr2 = (v2 = VerifierFactory.getVerifier(((ObjectType)t).getClassName())).doPass2()).getStatus() == 1) continue;
                this.constraintViolated(o, "Argument type class/interface could not be verified successfully: '" + vr2.getMessage() + "'.");
            }
        }

        @Override
        public void visitINSTANCEOF(INSTANCEOF o) {
            this.indexValid(o, o.getIndex());
            Constant c = this.cpg.getConstant(o.getIndex());
            if (!(c instanceof ConstantClass)) {
                this.constraintViolated(o, "Expecting a CONSTANT_Class operand, but found a '" + c + "'.");
            }
        }

        @Override
        public void visitCHECKCAST(CHECKCAST o) {
            this.indexValid(o, o.getIndex());
            Constant c = this.cpg.getConstant(o.getIndex());
            if (!(c instanceof ConstantClass)) {
                this.constraintViolated(o, "Expecting a CONSTANT_Class operand, but found a '" + c + "'.");
            }
        }

        @Override
        public void visitNEW(NEW o) {
            this.indexValid(o, o.getIndex());
            Constant c = this.cpg.getConstant(o.getIndex());
            if (!(c instanceof ConstantClass)) {
                this.constraintViolated(o, "Expecting a CONSTANT_Class operand, but found a '" + c + "'.");
            } else {
                ConstantUtf8 cutf8 = (ConstantUtf8)this.cpg.getConstant(((ConstantClass)c).getNameIndex());
                Type t = Type.getType("L" + cutf8.getBytes() + ";");
                if (t instanceof ArrayType) {
                    this.constraintViolated(o, "NEW must not be used to create an array.");
                }
            }
        }

        @Override
        public void visitMULTIANEWARRAY(MULTIANEWARRAY o) {
            Type t;
            short dimensions2create;
            this.indexValid(o, o.getIndex());
            Constant c = this.cpg.getConstant(o.getIndex());
            if (!(c instanceof ConstantClass)) {
                this.constraintViolated(o, "Expecting a CONSTANT_Class operand, but found a '" + c + "'.");
            }
            if ((dimensions2create = o.getDimensions()) < 1) {
                this.constraintViolated(o, "Number of dimensions to create must be greater than zero.");
            }
            if ((t = o.getType(this.cpg)) instanceof ArrayType) {
                int dimensions = ((ArrayType)t).getDimensions();
                if (dimensions < dimensions2create) {
                    this.constraintViolated(o, "Not allowed to create array with more dimensions ('+dimensions2create+') than the one referenced by the CONSTANT_Class '" + t + "'.");
                }
            } else {
                this.constraintViolated(o, "Expecting a CONSTANT_Class referencing an array type. [Constraint not found in The Java Virtual Machine Specification, Second Edition, 4.8.1]");
            }
        }

        @Override
        public void visitANEWARRAY(ANEWARRAY o) {
            int dimensions;
            Type t;
            this.indexValid(o, o.getIndex());
            Constant c = this.cpg.getConstant(o.getIndex());
            if (!(c instanceof ConstantClass)) {
                this.constraintViolated(o, "Expecting a CONSTANT_Class operand, but found a '" + c + "'.");
            }
            if ((t = o.getType(this.cpg)) instanceof ArrayType && (dimensions = ((ArrayType)t).getDimensions()) >= 255) {
                this.constraintViolated(o, "Not allowed to create an array with more than 255 dimensions.");
            }
        }

        @Override
        public void visitNEWARRAY(NEWARRAY o) {
            byte t = o.getTypecode();
            if (t != 4 && t != 5 && t != 6 && t != 7 && t != 8 && t != 9 && t != 10 && t != 11) {
                this.constraintViolated(o, "Illegal type code '+t+' for 'atype' operand.");
            }
        }

        @Override
        public void visitILOAD(ILOAD o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        @Override
        public void visitFLOAD(FLOAD o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        @Override
        public void visitALOAD(ALOAD o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        @Override
        public void visitISTORE(ISTORE o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        @Override
        public void visitFSTORE(FSTORE o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        @Override
        public void visitASTORE(ASTORE o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        @Override
        public void visitIINC(IINC o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        @Override
        public void visitRET(RET o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        @Override
        public void visitLLOAD(LLOAD o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative. [Constraint by JustIce as an analogon to the single-slot xLOAD/xSTORE instructions; may not happen anyway.]");
            } else {
                int maxminus2 = this.max_locals() - 2;
                if (idx > maxminus2) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-2 '" + maxminus2 + "'.");
                }
            }
        }

        @Override
        public void visitDLOAD(DLOAD o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative. [Constraint by JustIce as an analogon to the single-slot xLOAD/xSTORE instructions; may not happen anyway.]");
            } else {
                int maxminus2 = this.max_locals() - 2;
                if (idx > maxminus2) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-2 '" + maxminus2 + "'.");
                }
            }
        }

        @Override
        public void visitLSTORE(LSTORE o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative. [Constraint by JustIce as an analogon to the single-slot xLOAD/xSTORE instructions; may not happen anyway.]");
            } else {
                int maxminus2 = this.max_locals() - 2;
                if (idx > maxminus2) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-2 '" + maxminus2 + "'.");
                }
            }
        }

        @Override
        public void visitDSTORE(DSTORE o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative. [Constraint by JustIce as an analogon to the single-slot xLOAD/xSTORE instructions; may not happen anyway.]");
            } else {
                int maxminus2 = this.max_locals() - 2;
                if (idx > maxminus2) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-2 '" + maxminus2 + "'.");
                }
            }
        }

        @Override
        public void visitLOOKUPSWITCH(LOOKUPSWITCH o) {
            int[] matchs = o.getMatchs();
            int max2 = Integer.MIN_VALUE;
            for (int i = 0; i < matchs.length; ++i) {
                if (matchs[i] == max2 && i != 0) {
                    this.constraintViolated(o, "Match '" + matchs[i] + "' occurs more than once.");
                }
                if (matchs[i] < max2) {
                    this.constraintViolated(o, "Lookup table must be sorted but isn't.");
                    continue;
                }
                max2 = matchs[i];
            }
        }

        @Override
        public void visitTABLESWITCH(TABLESWITCH o) {
        }

        @Override
        public void visitPUTSTATIC(PUTSTATIC o) {
            String field_name = o.getFieldName(this.cpg);
            JavaClass jc = Repository.lookupClass(o.getClassType(this.cpg).getClassName());
            Field[] fields = jc.getFields();
            AccessFlags f2 = null;
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].getName().equals(field_name)) continue;
                f2 = fields[i];
                break;
            }
            if (f2 == null) {
                throw new AssertionViolatedException("Field not found?!?");
            }
            if (f2.isFinal() && !Pass3aVerifier.this.myOwner.getClassName().equals(o.getClassType(this.cpg).getClassName())) {
                this.constraintViolated(o, "Referenced field '" + f2 + "' is final and must therefore be declared in the current class '" + Pass3aVerifier.this.myOwner.getClassName() + "' which is not the case: it is declared in '" + o.getClassType(this.cpg).getClassName() + "'.");
            }
            if (!f2.isStatic()) {
                this.constraintViolated(o, "Referenced field '" + f2 + "' is not static which it should be.");
            }
            String meth_name = Repository.lookupClass(Pass3aVerifier.this.myOwner.getClassName()).getMethods()[Pass3aVerifier.this.method_no].getName();
            if (!jc.isClass() && !meth_name.equals("<clinit>")) {
                this.constraintViolated(o, "Interface field '" + f2 + "' must be set in a '" + "<clinit>" + "' method.");
            }
        }

        @Override
        public void visitGETSTATIC(GETSTATIC o) {
            String field_name = o.getFieldName(this.cpg);
            JavaClass jc = Repository.lookupClass(o.getClassType(this.cpg).getClassName());
            Field[] fields = jc.getFields();
            AccessFlags f2 = null;
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].getName().equals(field_name)) continue;
                f2 = fields[i];
                break;
            }
            if (f2 == null) {
                throw new AssertionViolatedException("Field not found?!?");
            }
            if (!f2.isStatic()) {
                this.constraintViolated(o, "Referenced field '" + f2 + "' is not static which it should be.");
            }
        }

        @Override
        public void visitINVOKEINTERFACE(INVOKEINTERFACE o) {
            String classname = o.getClassName(this.cpg);
            JavaClass jc = Repository.lookupClass(classname);
            Method[] ms = jc.getMethods();
            Method m = null;
            for (int i = 0; i < ms.length; ++i) {
                if (!ms[i].getName().equals(o.getMethodName(this.cpg)) || !Type.getReturnType(ms[i].getSignature()).equals(o.getReturnType(this.cpg)) || !this.objarrayequals(Type.getArgumentTypes(ms[i].getSignature()), o.getArgumentTypes(this.cpg))) continue;
                m = ms[i];
                break;
            }
            if (m == null) {
                this.constraintViolated(o, "Referenced method '" + o.getMethodName(this.cpg) + "' with expected signature not found in class '" + jc.getClassName() + "'. The native verfier does allow the method to be declared in some superinterface, which the Java Virtual Machine Specification, Second Edition does not.");
            }
            if (jc.isClass()) {
                this.constraintViolated(o, "Referenced class '" + jc.getClassName() + "' is a class, but not an interface as expected.");
            }
        }

        @Override
        public void visitINVOKESPECIAL(INVOKESPECIAL o) {
            JavaClass current2;
            String classname = o.getClassName(this.cpg);
            JavaClass jc = Repository.lookupClass(classname);
            Method[] ms = jc.getMethods();
            Method m = null;
            for (int i = 0; i < ms.length; ++i) {
                if (!ms[i].getName().equals(o.getMethodName(this.cpg)) || !Type.getReturnType(ms[i].getSignature()).equals(o.getReturnType(this.cpg)) || !this.objarrayequals(Type.getArgumentTypes(ms[i].getSignature()), o.getArgumentTypes(this.cpg))) continue;
                m = ms[i];
                break;
            }
            if (m == null) {
                this.constraintViolated(o, "Referenced method '" + o.getMethodName(this.cpg) + "' with expected signature not found in class '" + jc.getClassName() + "'. The native verfier does allow the method to be declared in some superclass or implemented interface, which the Java Virtual Machine Specification, Second Edition does not.");
            }
            if ((current2 = Repository.lookupClass(Pass3aVerifier.this.myOwner.getClassName())).isSuper() && Repository.instanceOf(current2, jc) && !current2.equals(jc) && !o.getMethodName(this.cpg).equals("<init>")) {
                int supidx = -1;
                Method meth = null;
                while (supidx != 0) {
                    supidx = current2.getSuperclassNameIndex();
                    current2 = Repository.lookupClass(current2.getSuperclassName());
                    Method[] meths = current2.getMethods();
                    for (int i = 0; i < meths.length; ++i) {
                        if (!meths[i].getName().equals(o.getMethodName(this.cpg)) || !Type.getReturnType(meths[i].getSignature()).equals(o.getReturnType(this.cpg)) || !this.objarrayequals(Type.getArgumentTypes(meths[i].getSignature()), o.getArgumentTypes(this.cpg))) continue;
                        meth = meths[i];
                        break;
                    }
                    if (meth == null) continue;
                    break;
                }
                if (meth == null) {
                    this.constraintViolated(o, "ACC_SUPER special lookup procedure not successful: method '" + o.getMethodName(this.cpg) + "' with proper signature not declared in superclass hierarchy.");
                }
            }
        }

        @Override
        public void visitINVOKESTATIC(INVOKESTATIC o) {
            String classname = o.getClassName(this.cpg);
            JavaClass jc = Repository.lookupClass(classname);
            Method[] ms = jc.getMethods();
            AccessFlags m = null;
            for (int i = 0; i < ms.length; ++i) {
                if (!ms[i].getName().equals(o.getMethodName(this.cpg)) || !Type.getReturnType(ms[i].getSignature()).equals(o.getReturnType(this.cpg)) || !this.objarrayequals(Type.getArgumentTypes(ms[i].getSignature()), o.getArgumentTypes(this.cpg))) continue;
                m = ms[i];
                break;
            }
            if (m == null) {
                this.constraintViolated(o, "Referenced method '" + o.getMethodName(this.cpg) + "' with expected signature not found in class '" + jc.getClassName() + "'. The native verifier possibly allows the method to be declared in some superclass or implemented interface, which the Java Virtual Machine Specification, Second Edition does not.");
            }
            if (!m.isStatic()) {
                this.constraintViolated(o, "Referenced method '" + o.getMethodName(this.cpg) + "' has ACC_STATIC unset.");
            }
        }

        @Override
        public void visitINVOKEVIRTUAL(INVOKEVIRTUAL o) {
            String classname = o.getClassName(this.cpg);
            JavaClass jc = Repository.lookupClass(classname);
            Method[] ms = jc.getMethods();
            Method m = null;
            for (int i = 0; i < ms.length; ++i) {
                if (!ms[i].getName().equals(o.getMethodName(this.cpg)) || !Type.getReturnType(ms[i].getSignature()).equals(o.getReturnType(this.cpg)) || !this.objarrayequals(Type.getArgumentTypes(ms[i].getSignature()), o.getArgumentTypes(this.cpg))) continue;
                m = ms[i];
                break;
            }
            if (m == null) {
                this.constraintViolated(o, "Referenced method '" + o.getMethodName(this.cpg) + "' with expected signature not found in class '" + jc.getClassName() + "'. The native verfier does allow the method to be declared in some superclass or implemented interface, which the Java Virtual Machine Specification, Second Edition does not.");
            }
            if (!jc.isClass()) {
                this.constraintViolated(o, "Referenced class '" + jc.getClassName() + "' is an interface, but not a class as expected.");
            }
        }

        private boolean objarrayequals(Object[] o, Object[] p) {
            if (o.length != p.length) {
                return false;
            }
            for (int i = 0; i < o.length; ++i) {
                if (o[i].equals(p[i])) continue;
                return false;
            }
            return true;
        }
    }
}

