/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.verifier.structurals;

import com.ibm.xltxe.rnm1.xtq.bcel.generic.CodeExceptionGen;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionHandle;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.MethodGen;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.structurals.ExceptionHandler;
import java.util.HashSet;
import java.util.Hashtable;

public class ExceptionHandlers {
    private Hashtable exceptionhandlers = new Hashtable();

    public ExceptionHandlers(MethodGen mg) {
        CodeExceptionGen[] cegs = mg.getExceptionHandlers();
        for (int i = 0; i < cegs.length; ++i) {
            ExceptionHandler eh = new ExceptionHandler(cegs[i].getCatchType(), cegs[i].getHandlerPC());
            for (InstructionHandle ih = cegs[i].getStartPC(); ih != cegs[i].getEndPC().getNext(); ih = ih.getNext()) {
                HashSet<ExceptionHandler> hs = (HashSet<ExceptionHandler>)this.exceptionhandlers.get(ih);
                if (hs == null) {
                    hs = new HashSet<ExceptionHandler>();
                    this.exceptionhandlers.put(ih, hs);
                }
                hs.add(eh);
            }
        }
    }

    public ExceptionHandler[] getExceptionHandlers(InstructionHandle ih) {
        HashSet hs = (HashSet)this.exceptionhandlers.get(ih);
        if (hs == null) {
            return new ExceptionHandler[0];
        }
        ExceptionHandler[] ret = new ExceptionHandler[hs.size()];
        return hs.toArray(ret);
    }
}

