/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.bcel.verifier.structurals;

import com.ibm.xltxe.rnm1.xtq.bcel.generic.ObjectType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.ReferenceType;
import com.ibm.xltxe.rnm1.xtq.bcel.generic.Type;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.exc.AssertionViolatedException;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.exc.StructuralCodeConstraintException;
import com.ibm.xltxe.rnm1.xtq.bcel.verifier.structurals.UninitializedObjectType;
import java.util.ArrayList;

public class OperandStack {
    private ArrayList stack = new ArrayList();
    private int maxStack;

    public OperandStack(int maxStack) {
        this.maxStack = maxStack;
    }

    public OperandStack(int maxStack, ObjectType obj) {
        this.maxStack = maxStack;
        this.push(obj);
    }

    protected Object clone() {
        OperandStack newstack = new OperandStack(this.maxStack);
        newstack.stack = (ArrayList)this.stack.clone();
        return newstack;
    }

    public void clear() {
        this.stack = new ArrayList();
    }

    public boolean equals(Object o) {
        if (!(o instanceof OperandStack)) {
            return false;
        }
        OperandStack s = (OperandStack)o;
        return this.stack.equals(s.stack);
    }

    public OperandStack getClone() {
        return (OperandStack)this.clone();
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public int maxStack() {
        return this.maxStack;
    }

    public Type peek() {
        return this.peek(0);
    }

    public Type peek(int i) {
        return (Type)this.stack.get(this.size() - i - 1);
    }

    public Type pop() {
        Type e = (Type)this.stack.remove(this.size() - 1);
        return e;
    }

    public Type pop(int i) {
        for (int j = 0; j < i; ++j) {
            this.pop();
        }
        return null;
    }

    public void push(Type type2) {
        if (type2 == null) {
            throw new AssertionViolatedException("Cannot push NULL onto OperandStack.");
        }
        if (type2 == Type.BOOLEAN || type2 == Type.CHAR || type2 == Type.BYTE || type2 == Type.SHORT) {
            throw new AssertionViolatedException("The OperandStack does not know about '" + type2 + "'; use Type.INT instead.");
        }
        if (this.slotsUsed() >= this.maxStack) {
            throw new AssertionViolatedException("OperandStack too small, should have thrown proper Exception elsewhere. Stack: " + this);
        }
        this.stack.add(type2);
    }

    int size() {
        return this.stack.size();
    }

    public int slotsUsed() {
        int slots = 0;
        for (int i = 0; i < this.stack.size(); ++i) {
            slots += this.peek(i).getSize();
        }
        return slots;
    }

    public String toString() {
        String s = "Slots used: " + this.slotsUsed() + " MaxStack: " + this.maxStack + ".\n";
        for (int i = 0; i < this.size(); ++i) {
            s = s + this.peek(i) + " (Size: " + this.peek(i).getSize() + ")\n";
        }
        return s;
    }

    public void merge(OperandStack s) {
        if (this.slotsUsed() != s.slotsUsed() || this.size() != s.size()) {
            throw new StructuralCodeConstraintException("Cannot merge stacks of different size:\nOperandStack A:\n" + this + "\nOperandStack B:\n" + s);
        }
        for (int i = 0; i < this.size(); ++i) {
            if (!(this.stack.get(i) instanceof UninitializedObjectType) && s.stack.get(i) instanceof UninitializedObjectType) {
                throw new StructuralCodeConstraintException("Backwards branch with an uninitialized object on the stack detected.");
            }
            if (!this.stack.get(i).equals(s.stack.get(i)) && this.stack.get(i) instanceof UninitializedObjectType && !(s.stack.get(i) instanceof UninitializedObjectType)) {
                throw new StructuralCodeConstraintException("Backwards branch with an uninitialized object on the stack detected.");
            }
            if (this.stack.get(i) instanceof UninitializedObjectType && !(s.stack.get(i) instanceof UninitializedObjectType)) {
                this.stack.set(i, ((UninitializedObjectType)this.stack.get(i)).getInitialized());
            }
            if (this.stack.get(i).equals(s.stack.get(i))) continue;
            if (this.stack.get(i) instanceof ReferenceType && s.stack.get(i) instanceof ReferenceType) {
                this.stack.set(i, ((ReferenceType)this.stack.get(i)).getFirstCommonSuperclass((ReferenceType)s.stack.get(i)));
                continue;
            }
            throw new StructuralCodeConstraintException("Cannot merge stacks of different types:\nStack A:\n" + this + "\nStack B:\n" + s);
        }
    }

    public void initializeObject(UninitializedObjectType u) {
        for (int i = 0; i < this.stack.size(); ++i) {
            if (this.stack.get(i) != u) continue;
            this.stack.set(i, u.getInitialized());
        }
    }
}

