/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.common.utils;

import com.ibm.xltxe.rnm1.xtq.common.utils.ErrorHandler;
import com.ibm.xltxe.rnm1.xtq.common.utils.SourceLocation;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMLocator;

public abstract class AbstractErrorHandler
implements ErrorHandler {
    @Override
    public boolean handleError(DOMError error2) {
        int level = this.severityToLevel(error2.getSeverity());
        String message = error2.getMessage();
        Object obj = error2.getRelatedException();
        Throwable cause = obj instanceof Throwable ? (Throwable)obj : null;
        SourceLocation location = this.convertDOMLocation(error2.getLocation());
        this.report(level, message, location, cause, false);
        return true;
    }

    private int severityToLevel(short severity) {
        switch (severity) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 3;
    }

    private SourceLocation convertDOMLocation(DOMLocator locator) {
        if (locator == null) {
            return null;
        }
        return new SourceLocation(locator.getUri(), null, locator.getLineNumber(), locator.getColumnNumber(), -1, -1);
    }
}

