/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.common.utils;

import java.io.IOException;
import java.io.Reader;
import java.nio.BufferUnderflowException;
import java.nio.CharBuffer;

public class CharBufferReader
extends Reader {
    private CharBuffer m_chars;

    public CharBufferReader(CharBuffer chars) {
        this.m_chars = chars;
    }

    @Override
    public void close() throws IOException {
        this.m_chars = null;
    }

    @Override
    public int read() throws IOException {
        try {
            return this.m_chars.get();
        }
        catch (BufferUnderflowException e) {
            throw new IOException();
        }
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int left = this.m_chars.remaining();
        if (len <= left) {
            this.m_chars.get(cbuf, off, len);
            return len;
        }
        if (left > 0) {
            this.m_chars.get(cbuf, off, left);
            return left;
        }
        return -1;
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public boolean ready() throws IOException {
        return this.m_chars.hasRemaining();
    }

    @Override
    public long skip(long n2) throws IOException {
        int position2 = this.m_chars.position();
        int left = this.m_chars.remaining();
        if ((long)left < n2) {
            n2 = left;
        }
        this.m_chars.position((int)((long)position2 + n2));
        return n2;
    }
}

