/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.common.utils;

import java.util.HashMap;
import java.util.Map;

public class CompileTimeFlagSet {
    private final String fSetName;
    private final HashMap<Integer, Flag> fSetValues = new HashMap();
    private int fNextFlagValue = 1;
    private Flag fFlagForLookUp = new Flag(0);

    protected Flag getFlagByValue(int value2) {
        Integer valueObj = value2;
        Flag flag = this.fSetValues.get(valueObj);
        if (flag == null) {
            flag = new Flag(value2);
            this.fSetValues.put(valueObj, flag);
        }
        return flag;
    }

    public CompileTimeFlagSet(String setName) {
        this.fSetName = setName;
    }

    public Flag nullFlag() {
        return this.getFlagByValue(0);
    }

    public Flag nextBaseFlagValue() {
        if (this.fNextFlagValue == 0) {
            throw new UnsupportedOperationException("Too many base flag values in " + this.fSetName);
        }
        Flag nextFlag = this.getFlagByValue(this.fNextFlagValue);
        this.fNextFlagValue <<= 1;
        return nextFlag;
    }

    public String toString() {
        StringBuilder stringValue = new StringBuilder(CompileTimeFlagSet.class.getName()).append(" {name == ").append(this.fSetName);
        for (Map.Entry<Integer, Flag> valueEntry : this.fSetValues.entrySet()) {
            stringValue.append(valueEntry.getValue().toString());
        }
        return stringValue.append("}").toString();
    }

    public final class Flag {
        private final int fFlagValue;

        private Flag(int flagValue) {
            this.fFlagValue = flagValue;
        }

        public Flag intersect(Flag that) {
            return CompileTimeFlagSet.this.getFlagByValue(this.fFlagValue & that.fFlagValue);
        }

        public Flag union(Flag that) {
            return CompileTimeFlagSet.this.getFlagByValue(this.fFlagValue | that.fFlagValue);
        }

        public boolean contains(Flag that) {
            return (this.fFlagValue & that.fFlagValue) == that.fFlagValue;
        }

        public boolean isEmpty() {
            return this.fFlagValue == 0;
        }

        public boolean equals(Object that) {
            return this == that;
        }

        public int hashCode() {
            return this.fFlagValue;
        }

        public String toString() {
            return Integer.toHexString(this.fFlagValue);
        }
    }
}

