/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.common.utils;

import com.ibm.xltxe.rnm1.xtq.common.utils.Encodings;

public final class EncodingInfo {
    private final char m_highCharInContiguousGroup;
    final String name;
    final String javaName;
    final boolean isStateless;
    InEncoding m_encoding;
    private static final byte[] s_noBytes = new byte[0];

    public boolean isCharInEncoding(char ch) {
        if (this.m_encoding == null) {
            this.m_encoding = new EncodingImpl(this);
        }
        return this.m_encoding.isCharInEncoding(ch);
    }

    public boolean isCodePointInEncoding(int codePoint) {
        if (this.m_encoding == null) {
            this.m_encoding = new EncodingImpl(this);
        }
        return this.m_encoding.isCodePointInEncoding(codePoint);
    }

    public byte[] getEncodedBytesForChar(char ch) {
        if (this.m_encoding == null) {
            this.m_encoding = new EncodingImpl(this);
        }
        return this.m_encoding.getEncodedBytesForChar(ch);
    }

    public boolean isSurrogatePairInEncoding(char high, char low) {
        if (this.m_encoding == null) {
            this.m_encoding = new EncodingImpl(this);
        }
        return this.m_encoding.isSurrogatePairInEncoding(high, low);
    }

    public byte[] getEncodedBytesForCodepoint(int codepoint2, char high, char low) {
        if (this.m_encoding == null) {
            this.m_encoding = new EncodingImpl(this);
        }
        return this.m_encoding.getEncodedBytesForCodepoint(codepoint2, high, low);
    }

    public EncodingInfo(String name2, String javaName, char highChar, boolean isStateless) {
        this.name = name2;
        this.javaName = javaName;
        this.m_highCharInContiguousGroup = highChar;
        this.isStateless = isStateless;
    }

    private static byte[] inEncoding(int ch, String encoding) {
        byte[] bytes2;
        try {
            char[] cArray = new char[]{(char)ch};
            String s = new String(cArray);
            byte[] bArray = s.getBytes(encoding);
            boolean isInEncoding = EncodingInfo.inEncoding(ch, bArray);
            bytes2 = (byte[])(isInEncoding ? bArray : null);
        }
        catch (Exception e) {
            boolean isInEncoding = false;
            if (encoding == null) {
                isInEncoding = true;
                bytes2 = s_noBytes;
            }
            bytes2 = null;
        }
        return bytes2;
    }

    private static byte[] getEncBytes(char high, char low, String encoding) {
        try {
            char[] cArray = new char[]{high, low};
            String s = new String(cArray);
            byte[] bArray = s.getBytes(encoding);
            boolean isInEncoding = EncodingInfo.inEncoding((int)high, bArray);
            if (isInEncoding) {
                return bArray;
            }
            return null;
        }
        catch (Exception e) {
            boolean isInEncoding = false;
            return null;
        }
    }

    private static boolean inEncoding(int ch, byte[] data2) {
        boolean isInEncoding = data2 == null || data2.length == 0 ? false : (data2[0] == 0 ? false : data2[0] != 63 || ch == 63);
        return isInEncoding;
    }

    public final char getHighChar() {
        return this.m_highCharInContiguousGroup;
    }

    public final boolean isStatelessEncoding() {
        return this.isStateless;
    }

    static final class EncodingImpl
    implements InEncoding {
        private final EncodingInfo m_encoding;
        private final int m_first;
        private final int m_explFirst;
        private final int m_explLast;
        private final int m_last;
        private EncodingImpl m_before;
        private EncodingImpl m_after;
        private static final int RANGE = 128;
        private final boolean[] m_alreadyKnown = new boolean[128];
        private final byte[][] m_char2Bytes = new byte[128][];

        @Override
        public boolean isCharInEncoding(char ch1) {
            byte[] b = this.getEncodedBytesForChar(ch1);
            return b != null;
        }

        @Override
        public boolean isSurrogatePairInEncoding(char high, char low) {
            int codepoint2 = Encodings.toCodePoint(high, low);
            byte[] b = this.getEncodedBytesForCodepoint(codepoint2, high, low);
            return b != null;
        }

        public final byte[] getEncodedBytes127(int idx) {
            return this.m_char2Bytes[idx];
        }

        @Override
        public byte[] getEncodedBytesForChar(char ch1) {
            byte[] ret;
            char codePoint = ch1;
            if (codePoint < this.m_explFirst) {
                if (this.m_before == null) {
                    this.m_before = new EncodingImpl(this.m_encoding, this.m_first, this.m_explFirst - 1, codePoint);
                }
                ret = this.m_before.getEncodedBytesForChar(ch1);
            } else if (this.m_explLast < codePoint) {
                if (this.m_after == null) {
                    this.m_after = new EncodingImpl(this.m_encoding, this.m_explLast + 1, this.m_last, codePoint);
                }
                ret = this.m_after.getEncodedBytesForChar(ch1);
            } else {
                int idx = codePoint - this.m_explFirst;
                if (this.m_alreadyKnown[idx]) {
                    ret = this.m_char2Bytes[idx];
                } else {
                    ret = EncodingInfo.inEncoding(ch1, this.m_encoding.javaName);
                    this.m_alreadyKnown[idx] = true;
                    this.m_char2Bytes[idx] = ret;
                }
            }
            return ret;
        }

        @Override
        public byte[] getEncodedBytesForCodepoint(int codePoint, char high, char low) {
            byte[] ret;
            if (codePoint < this.m_explFirst) {
                if (this.m_before == null) {
                    this.m_before = new EncodingImpl(this.m_encoding, this.m_first, this.m_explFirst - 1, codePoint);
                }
                ret = this.m_before.getEncodedBytesForCodepoint(codePoint, high, low);
            } else if (this.m_explLast < codePoint) {
                if (this.m_after == null) {
                    this.m_after = new EncodingImpl(this.m_encoding, this.m_explLast + 1, this.m_last, codePoint);
                }
                ret = this.m_after.getEncodedBytesForCodepoint(codePoint, high, low);
            } else {
                int idx = codePoint - this.m_explFirst;
                if (this.m_alreadyKnown[idx]) {
                    ret = this.m_char2Bytes[idx];
                } else {
                    ret = EncodingInfo.getEncBytes(high, low, this.m_encoding.javaName);
                    this.m_alreadyKnown[idx] = true;
                    this.m_char2Bytes[idx] = ret;
                }
            }
            return ret;
        }

        EncodingImpl(EncodingInfo ei) {
            this(ei, 0, Integer.MAX_VALUE, 0);
        }

        private EncodingImpl(EncodingInfo encoding, int first, int last2, int codePoint) {
            this.m_first = first;
            this.m_last = last2;
            this.m_explFirst = codePoint;
            this.m_explLast = codePoint + 127;
            this.m_encoding = encoding;
            String javaName = encoding.javaName;
            if (javaName != null && 0 <= this.m_explFirst && this.m_explFirst <= 127 && encoding.isStatelessEncoding()) {
                int idx;
                char unicode2;
                if ("UTF8".equals(javaName) || "UTF-16".equals(javaName) || "ASCII".equals(javaName) || "US-ASCII".equals(javaName) || "Unicode".equals(javaName) || "UNICODE".equals(javaName) || javaName.startsWith("ISO8859")) {
                    for (unicode2 = '\u0000'; unicode2 < '\u007f'; ++unicode2) {
                        idx = unicode2 - this.m_explFirst;
                        if (0 > idx || idx >= 128) continue;
                        this.m_alreadyKnown[idx] = true;
                        this.m_char2Bytes[idx] = new byte[]{(byte)unicode2};
                    }
                } else {
                    for (unicode2 = '\u0000'; unicode2 < '\u007f'; unicode2 = (char)((char)(unicode2 + 1))) {
                        idx = unicode2 - this.m_explFirst;
                        if (0 > idx || idx >= 128) continue;
                        this.m_char2Bytes[idx] = this.getEncodedBytesForChar(unicode2);
                    }
                }
            }
            if (javaName == null) {
                for (int idx = 0; idx < this.m_alreadyKnown.length; ++idx) {
                    this.m_alreadyKnown[idx] = true;
                    this.m_char2Bytes[idx] = s_noBytes;
                }
            }
        }

        @Override
        public boolean isCodePointInEncoding(int codePoint) {
            block4: {
                try {
                    if (Encodings.codePointHasSurrogatePair(codePoint)) {
                        int low = Encodings.getLowSurrogate(codePoint);
                        int high = Encodings.getHighSurrogate(codePoint);
                        if (low != -1 && high != -1) {
                            return this.isSurrogatePairInEncoding((char)high, (char)low);
                        }
                        break block4;
                    }
                    char ch = (char)codePoint;
                    return this.isCharInEncoding(ch);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    private static interface InEncoding {
        public boolean isCharInEncoding(char var1);

        public boolean isSurrogatePairInEncoding(char var1, char var2);

        public boolean isCodePointInEncoding(int var1);

        public byte[] getEncodedBytesForChar(char var1);

        public byte[] getEncodedBytesForCodepoint(int var1, char var2, char var3);
    }
}

