/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.common.utils;

import com.ibm.xltxe.rnm1.xtq.common.utils.EncodingInfo;
import com.ibm.xltxe.rnm1.xtq.common.utils.ObjectFactory;
import com.ibm.xltxe.rnm1.xtq.common.utils.SecuritySupport;
import com.ibm.xltxe.rnm1.xtq.common.utils.WrappedRuntimeException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public final class Encodings {
    private static final String PKG_NAME;
    private static final String PKG_PATH;
    private static final String ENCODINGS_FILE;
    static final String DEFAULT_MIME_ENCODING = "UTF-8";
    private static final Hashtable _encodingTableKeyJava;
    private static final Hashtable _encodingTableKeyMime;
    private static final EncodingInfo[] _encodings;

    static Writer getWriter(OutputStream output, String encoding) throws UnsupportedEncodingException {
        for (int i = 0; i < _encodings.length; ++i) {
            if (!Encodings._encodings[i].name.equalsIgnoreCase(encoding)) continue;
            try {
                String javaName = Encodings._encodings[i].javaName;
                OutputStreamWriter osw = new OutputStreamWriter(output, javaName);
                return osw;
            }
            catch (IllegalArgumentException iae) {
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        try {
            return new OutputStreamWriter(output, encoding);
        }
        catch (IllegalArgumentException iae) {
            throw new UnsupportedEncodingException(encoding);
        }
    }

    static EncodingInfo getEncodingInfo(String encoding) {
        String normalizedEncoding = Encodings.toUpperCaseFast(encoding);
        EncodingInfo ei = (EncodingInfo)_encodingTableKeyJava.get(normalizedEncoding);
        if (ei == null) {
            ei = (EncodingInfo)_encodingTableKeyMime.get(normalizedEncoding);
        }
        if (ei == null) {
            ei = new EncodingInfo(null, null, '\u0000', true);
        }
        return ei;
    }

    public static boolean isRecognizedEncoding(String encoding) {
        String normalizedEncoding = encoding.toUpperCase();
        EncodingInfo ei = (EncodingInfo)_encodingTableKeyJava.get(normalizedEncoding);
        if (ei == null) {
            ei = (EncodingInfo)_encodingTableKeyMime.get(normalizedEncoding);
        }
        return ei != null;
    }

    private static String toUpperCaseFast(String s) {
        boolean different = false;
        int mx = s.length();
        char[] chars = new char[mx];
        for (int i = 0; i < mx; ++i) {
            char ch = s.charAt(i);
            if ('a' <= ch && ch <= 'z') {
                ch = (char)(ch + -32);
                different = true;
            }
            chars[i] = ch;
        }
        String upper2 = different ? String.valueOf(chars) : s;
        return upper2;
    }

    static String getMimeEncoding(String encoding) {
        block5: {
            if (null == encoding) {
                try {
                    encoding = System.getProperty("file.encoding", "UTF8");
                    if (null != encoding) {
                        String jencoding = encoding.equalsIgnoreCase("Cp1252") || encoding.equalsIgnoreCase("ISO8859_1") || encoding.equalsIgnoreCase("8859_1") || encoding.equalsIgnoreCase("UTF8") ? DEFAULT_MIME_ENCODING : Encodings.convertJava2MimeEncoding(encoding);
                        encoding = null != jencoding ? jencoding : DEFAULT_MIME_ENCODING;
                        break block5;
                    }
                    encoding = DEFAULT_MIME_ENCODING;
                }
                catch (SecurityException se) {
                    encoding = DEFAULT_MIME_ENCODING;
                }
            } else {
                encoding = Encodings.convertJava2MimeEncoding(encoding);
            }
        }
        return encoding;
    }

    private static String convertJava2MimeEncoding(String encoding) {
        EncodingInfo enc = (EncodingInfo)_encodingTableKeyJava.get(Encodings.toUpperCaseFast(encoding));
        if (null != enc) {
            return enc.name;
        }
        return encoding;
    }

    public static String convertMime2JavaEncoding(String encoding) {
        for (int i = 0; i < _encodings.length; ++i) {
            if (!Encodings._encodings[i].name.equalsIgnoreCase(encoding)) continue;
            return Encodings._encodings[i].javaName;
        }
        return encoding;
    }

    private static EncodingInfo[] loadEncodingInfo() {
        try {
            InputStream is2 = SecuritySupport.getResourceAsStream(ObjectFactory.findClassLoader(), ENCODINGS_FILE);
            Properties props = new Properties();
            if (is2 != null) {
                props.load(is2);
                is2.close();
            }
            int totalEntries = props.size();
            ArrayList<EncodingInfo> encodingInfo_list = new ArrayList<EncodingInfo>();
            Enumeration<Object> keys2 = props.keys();
            for (int i = 0; i < totalEntries; ++i) {
                char highChar;
                String mimeName;
                String javaName = (String)keys2.nextElement();
                String val = props.getProperty(javaName);
                String token1 = null;
                String token2 = null;
                String token3 = null;
                StringTokenizer st1 = new StringTokenizer(val, " \t");
                int token = 1;
                while (st1.hasMoreTokens()) {
                    String s = st1.nextToken();
                    if (token == 1) {
                        token1 = s;
                    } else if (token == 2) {
                        token2 = s;
                    } else if (token == 3) {
                        token3 = s;
                    }
                    ++token;
                }
                if (token1 == null) {
                    mimeName = javaName;
                    highChar = '\u0000';
                    continue;
                }
                try {
                    String highVal = token2;
                    highChar = token2 == null ? (char)'\u0000' : (char)Integer.decode(highVal).intValue();
                }
                catch (NumberFormatException e) {
                    highChar = '\u0000';
                }
                boolean isStateless = "STATELESS".equals(token3);
                String mimeNames = token1;
                StringTokenizer st = new StringTokenizer(mimeNames, ",");
                boolean first = true;
                while (st.hasMoreTokens()) {
                    mimeName = st.nextToken();
                    EncodingInfo ei = new EncodingInfo(mimeName, javaName, highChar, isStateless);
                    encodingInfo_list.add(ei);
                    _encodingTableKeyMime.put(mimeName.toUpperCase(), ei);
                    if (first) {
                        _encodingTableKeyJava.put(javaName.toUpperCase(), ei);
                    }
                    first = false;
                }
            }
            EncodingInfo[] ret_ei = new EncodingInfo[encodingInfo_list.size()];
            encodingInfo_list.toArray(ret_ei);
            return ret_ei;
        }
        catch (MalformedURLException mue) {
            throw new WrappedRuntimeException(mue);
        }
        catch (IOException ioe) {
            throw new WrappedRuntimeException(ioe);
        }
    }

    static boolean isHighUTF16Surrogate(char ch) {
        return '\ud800' <= ch && ch <= '\udbff';
    }

    static boolean isLowUTF16Surrogate(char ch) {
        return '\udc00' <= ch && ch <= '\udfff';
    }

    static int toCodePoint(char highSurrogate, char lowSurrogate) {
        int codePoint = (highSurrogate - 55296 << 10) + (lowSurrogate - 56320) + 65536;
        return codePoint;
    }

    static final boolean codePointHasSurrogatePair(int codePoint) {
        return codePoint > 65535;
    }

    static int getHighSurrogate(int codePoint) {
        int high = codePoint - 65536;
        if (high < 0) {
            return -1;
        }
        high >>>= 10;
        if ((high += 55296) > 56319) {
            return -1;
        }
        return high;
    }

    static int getLowSurrogate(int codePoint) {
        int low = codePoint & 0x3FF;
        if ((low += 56320) > 57343) {
            return -1;
        }
        return low;
    }

    static int toCodePoint(char ch) {
        char codePoint = ch;
        return codePoint;
    }

    public static char getHighChar(String encoding) {
        String normalizedEncoding = Encodings.toUpperCaseFast(encoding);
        EncodingInfo ei = (EncodingInfo)_encodingTableKeyJava.get(normalizedEncoding);
        if (ei == null) {
            ei = (EncodingInfo)_encodingTableKeyMime.get(normalizedEncoding);
        }
        char highCodePoint = ei != null ? ei.getHighChar() : (char)'\u0000';
        return highCodePoint;
    }

    static {
        String fullyQualifiedName = Encodings.class.getName();
        int lastDot = fullyQualifiedName.lastIndexOf(46);
        PKG_NAME = lastDot < 0 ? "" : fullyQualifiedName.substring(0, lastDot);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < PKG_NAME.length(); ++i) {
            char ch = PKG_NAME.charAt(i);
            if (ch == '.') {
                sb.append('/');
                continue;
            }
            sb.append(ch);
        }
        PKG_PATH = sb.toString();
        ENCODINGS_FILE = PKG_PATH + "/Encodings.properties";
        _encodingTableKeyJava = new Hashtable();
        _encodingTableKeyMime = new Hashtable();
        _encodings = Encodings.loadEncodingInfo();
    }
}

