/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.common.utils;

import com.ibm.xltxe.rnm1.xtq.common.utils.XMLCharacterRecognizer;
import java.io.IOException;
import java.io.Writer;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class FastStringBuffer {
    public static final int SUPPRESS_LEADING_WS = 1;
    public static final int SUPPRESS_TRAILING_WS = 2;
    public static final int SUPPRESS_BOTH = 3;
    private static final int CARRY_WS = 4;
    protected int m_chunkBits = 15;
    protected int m_chunkSize;
    protected int m_chunkMask;
    protected char[][] m_array;
    int m_lastChunk = 0;
    int m_firstFree = 0;
    private static final int[] MULTI_BYTE_LENGTH = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 3, 3, 4, 0};
    private static final char[] SINGLE_SPACE = new char[]{' '};

    public FastStringBuffer(int initChunkBits, int maxChunkBits, int rebundleBits) {
        maxChunkBits = initChunkBits;
        this.m_array = new char[16][];
        if (initChunkBits > maxChunkBits) {
            initChunkBits = maxChunkBits;
        }
        this.m_chunkBits = initChunkBits;
        this.m_chunkSize = 1 << initChunkBits;
        this.m_chunkMask = this.m_chunkSize - 1;
        this.m_array[0] = new char[this.m_chunkSize];
    }

    public FastStringBuffer(int initChunkBits, int maxChunkBits) {
        this(initChunkBits, maxChunkBits, 2);
    }

    public FastStringBuffer(int initChunkBits) {
        this(initChunkBits, 15, 2);
    }

    public FastStringBuffer() {
        this(10, 15, 2);
    }

    public final int size() {
        return (this.m_lastChunk << this.m_chunkBits) + this.m_firstFree;
    }

    public final int length() {
        return (this.m_lastChunk << this.m_chunkBits) + this.m_firstFree;
    }

    public final void reset() {
        this.m_lastChunk = 0;
        this.m_firstFree = 0;
        this.m_array = new char[16][0];
        this.m_array[0] = new char[this.m_chunkSize];
    }

    public final void setLength(int l) {
        this.m_lastChunk = l >>> this.m_chunkBits;
        this.m_firstFree = l & this.m_chunkMask;
        if (this.m_firstFree == 0 && this.m_lastChunk > 0) {
            --this.m_lastChunk;
            this.m_firstFree = this.m_chunkSize;
        }
    }

    private final void setLength(int l, FastStringBuffer rootFSB) {
        this.m_lastChunk = l >>> this.m_chunkBits;
        rootFSB.m_chunkBits = this.m_chunkBits;
        rootFSB.m_chunkSize = this.m_chunkSize;
        rootFSB.m_chunkMask = this.m_chunkMask;
        rootFSB.m_array = this.m_array;
        rootFSB.m_lastChunk = this.m_lastChunk;
        rootFSB.m_firstFree = l & this.m_chunkMask;
    }

    public final String toString() {
        int length2 = (this.m_lastChunk << this.m_chunkBits) + this.m_firstFree;
        return this.getString(new StringBuffer(length2), 0, 0, length2).toString();
    }

    public final void append(char value2) {
        char[] chunk;
        if (this.m_firstFree < this.m_chunkSize) {
            chunk = this.m_array[this.m_lastChunk];
        } else {
            int i = this.m_array.length;
            if (this.m_lastChunk + 1 == i) {
                char[][] newarray = new char[i + 16][];
                System.arraycopy(this.m_array, 0, newarray, 0, i);
                this.m_array = newarray;
            }
            if ((chunk = this.m_array[++this.m_lastChunk]) == null) {
                this.m_array[this.m_lastChunk] = new char[this.m_chunkSize];
                chunk = this.m_array[this.m_lastChunk];
            }
            this.m_firstFree = 0;
        }
        chunk[this.m_firstFree++] = value2;
    }

    public final void append(String value2) {
        if (value2 == null) {
            return;
        }
        int strlen = value2.length();
        if (0 == strlen) {
            return;
        }
        int copyfrom = 0;
        char[] chunk = this.m_array[this.m_lastChunk];
        int available2 = this.m_chunkSize - this.m_firstFree;
        while (strlen > 0) {
            if (available2 > strlen) {
                available2 = strlen;
            }
            value2.getChars(copyfrom, copyfrom + available2, this.m_array[this.m_lastChunk], this.m_firstFree);
            copyfrom += available2;
            if ((strlen -= available2) <= 0) continue;
            int i = this.m_array.length;
            if (this.m_lastChunk + 1 == i) {
                char[][] newarray = new char[i + 16][];
                System.arraycopy(this.m_array, 0, newarray, 0, i);
                this.m_array = newarray;
            }
            if ((chunk = this.m_array[++this.m_lastChunk]) == null) {
                this.m_array[this.m_lastChunk] = new char[this.m_chunkSize];
                chunk = this.m_array[this.m_lastChunk];
            }
            available2 = this.m_chunkSize;
            this.m_firstFree = 0;
        }
        this.m_firstFree += available2;
    }

    public final void append(StringBuffer value2) {
        if (value2 == null) {
            return;
        }
        int strlen = value2.length();
        if (0 == strlen) {
            return;
        }
        int copyfrom = 0;
        char[] chunk = this.m_array[this.m_lastChunk];
        int available2 = this.m_chunkSize - this.m_firstFree;
        while (strlen > 0) {
            if (available2 > strlen) {
                available2 = strlen;
            }
            value2.getChars(copyfrom, copyfrom + available2, this.m_array[this.m_lastChunk], this.m_firstFree);
            copyfrom += available2;
            if ((strlen -= available2) <= 0) continue;
            int i = this.m_array.length;
            if (this.m_lastChunk + 1 == i) {
                char[][] newarray = new char[i + 16][];
                System.arraycopy(this.m_array, 0, newarray, 0, i);
                this.m_array = newarray;
            }
            if ((chunk = this.m_array[++this.m_lastChunk]) == null) {
                this.m_array[this.m_lastChunk] = new char[this.m_chunkSize];
                chunk = this.m_array[this.m_lastChunk];
            }
            available2 = this.m_chunkSize;
            this.m_firstFree = 0;
        }
        this.m_firstFree += available2;
    }

    public final void append(char[] chars, int start, int length2) {
        if (0 == length2) {
            return;
        }
        int strlen = length2;
        int copyfrom = start;
        char[] chunk = this.m_array[this.m_lastChunk];
        int available2 = this.m_chunkSize - this.m_firstFree;
        while (true) {
            if (available2 > strlen) {
                available2 = strlen;
            }
            System.arraycopy(chars, copyfrom, this.m_array[this.m_lastChunk], this.m_firstFree, available2);
            copyfrom += available2;
            if ((strlen -= available2) <= 0) break;
            int i = this.m_array.length;
            if (this.m_lastChunk + 1 == i) {
                char[][] newarray = new char[i + 16][];
                System.arraycopy(this.m_array, 0, newarray, 0, i);
                this.m_array = newarray;
            }
            if ((chunk = this.m_array[++this.m_lastChunk]) == null) {
                this.m_array[this.m_lastChunk] = new char[this.m_chunkSize];
                chunk = this.m_array[this.m_lastChunk];
            }
            available2 = this.m_chunkSize;
            this.m_firstFree = 0;
        }
        this.m_firstFree += available2;
    }

    public final void append(FastStringBuffer value2) {
        if (value2 == null) {
            return;
        }
        int strlen = value2.length();
        if (0 == strlen) {
            return;
        }
        int copyfrom = 0;
        char[] chunk = this.m_array[this.m_lastChunk];
        int available2 = this.m_chunkSize - this.m_firstFree;
        while (strlen > 0) {
            if (available2 > strlen) {
                available2 = strlen;
            }
            int sourcechunk = copyfrom + value2.m_chunkSize - 1 >>> value2.m_chunkBits;
            int sourcecolumn = copyfrom & value2.m_chunkMask;
            int runlength = value2.m_chunkSize - sourcecolumn;
            if (runlength > available2) {
                runlength = available2;
            }
            System.arraycopy(value2.m_array[sourcechunk], sourcecolumn, this.m_array[this.m_lastChunk], this.m_firstFree, runlength);
            if (runlength != available2) {
                System.arraycopy(value2.m_array[sourcechunk + 1], 0, this.m_array[this.m_lastChunk], this.m_firstFree + runlength, available2 - runlength);
            }
            copyfrom += available2;
            if ((strlen -= available2) <= 0) continue;
            int i = this.m_array.length;
            if (this.m_lastChunk + 1 == i) {
                char[][] newarray = new char[i + 16][];
                System.arraycopy(this.m_array, 0, newarray, 0, i);
                this.m_array = newarray;
            }
            if ((chunk = this.m_array[++this.m_lastChunk]) == null) {
                this.m_array[this.m_lastChunk] = new char[this.m_chunkSize];
                chunk = this.m_array[this.m_lastChunk];
            }
            available2 = this.m_chunkSize;
            this.m_firstFree = 0;
        }
        this.m_firstFree += available2;
    }

    public final boolean append(byte[] inputBuffer, int startOffset, int endOffset) {
        int maxChars = endOffset - startOffset - 1;
        int currChunkOffset = this.m_firstFree;
        int currInputOffset = startOffset;
        char[] chunk = this.m_array[this.m_lastChunk];
        int available2 = this.m_chunkSize - this.m_firstFree;
        if (available2 == 0) {
            this.makeNewChunk();
            chunk = this.m_array[this.m_lastChunk];
            available2 = this.m_chunkSize;
            currChunkOffset = 0;
        }
        while (maxChars > 0) {
            if (available2 > maxChars) {
                available2 = maxChars;
            }
            maxChars -= available2;
            while (available2 > 0) {
                byte b0 = inputBuffer[currInputOffset];
                ++currInputOffset;
                chunk[currChunkOffset] = (char)(b0 & 0xFF);
                ++currChunkOffset;
                --available2;
            }
            if (maxChars <= 0) continue;
            this.makeNewChunk();
            chunk = this.m_array[this.m_lastChunk];
            available2 = this.m_chunkSize;
            currChunkOffset = 0;
        }
        this.m_firstFree = currChunkOffset;
        return true;
    }

    public final boolean appendNormalized(byte[] inputBuffer, int startOffset, int endOffset) {
        int maxChars = endOffset - startOffset - 1;
        int currChunkOffset = this.m_firstFree;
        int currInputOffset = startOffset;
        char[] chunk = this.m_array[this.m_lastChunk];
        int available2 = this.m_chunkSize - this.m_firstFree;
        if (available2 == 0) {
            this.makeNewChunk();
            chunk = this.m_array[this.m_lastChunk];
            available2 = this.m_chunkSize;
            currChunkOffset = 0;
        }
        while (currInputOffset < endOffset) {
            int b0 = inputBuffer[currInputOffset];
            ++currInputOffset;
            if (b0 >= 0) {
                if (b0 == 13) {
                    chunk[currChunkOffset] = 10;
                    if (currInputOffset < endOffset && inputBuffer[currInputOffset] == 10) {
                        ++currInputOffset;
                    }
                } else {
                    chunk[currChunkOffset] = (char)b0;
                }
            } else {
                int mblen = MULTI_BYTE_LENGTH[(b0 &= 0xFF) >> 3];
                if (mblen == 0 || currInputOffset - 1 + mblen > endOffset) {
                    return false;
                }
                int b1 = inputBuffer[currInputOffset] & 0xFF;
                ++currInputOffset;
                if ((0xC0 & b1) != 128) {
                    return false;
                }
                if (mblen == 2) {
                    chunk[currChunkOffset] = (char)((b0 & 0x1F) << 6 | b1 & 0x3F);
                } else {
                    int b2 = inputBuffer[currInputOffset] & 0xFF;
                    ++currInputOffset;
                    if ((0xC0 & b2) != 128) {
                        return false;
                    }
                    if (mblen == 3) {
                        int ch = (b0 & 0xF) << 12 | (b1 & 0x3F) << 6 | b2 & 0x3F;
                        if ((ch & 0xF800) == 55296) {
                            return false;
                        }
                        chunk[currChunkOffset] = (char)ch;
                    } else {
                        int b3 = inputBuffer[currInputOffset] & 0xFF;
                        ++currInputOffset;
                        if ((0xC0 & b3) != 128) {
                            return false;
                        }
                        int wwww = ((b0 & 7) << 8 | (b1 & 0x30) << 2) - 64;
                        if ((wwww & 0xFFFFFC00) != 0) {
                            return false;
                        }
                        int ch0 = 0xD800 | wwww | (b1 & 0xF) << 2 | (b2 & 0x30) >> 4;
                        int ch1 = 0xDC00 | (b2 & 0xF) << 6 | b3 & 0x3F;
                        chunk[currChunkOffset] = (char)ch0;
                        ++currChunkOffset;
                        if (--available2 == 0) {
                            this.makeNewChunk();
                            chunk = this.m_array[this.m_lastChunk];
                            available2 = this.m_chunkSize;
                            currChunkOffset = 0;
                        }
                        chunk[currChunkOffset] = (char)ch1;
                    }
                }
            }
            ++currChunkOffset;
            if (--available2 != 0) continue;
            this.makeNewChunk();
            chunk = this.m_array[this.m_lastChunk];
            available2 = this.m_chunkSize;
            currChunkOffset = 0;
        }
        this.m_firstFree = currChunkOffset;
        return true;
    }

    private void makeNewChunk() {
        char[] chunk;
        int i = this.m_array.length;
        if (this.m_lastChunk + 1 == i) {
            char[][] newarray = new char[i + 16][];
            System.arraycopy(this.m_array, 0, newarray, 0, i);
            this.m_array = newarray;
        }
        if ((chunk = this.m_array[++this.m_lastChunk]) == null) {
            this.m_array[this.m_lastChunk] = new char[this.m_chunkSize];
        }
        this.m_firstFree = 0;
    }

    public boolean isWhitespace(int start, int length2) {
        int sourcechunk = start >>> this.m_chunkBits;
        int sourcecolumn = start & this.m_chunkMask;
        int available2 = this.m_chunkSize - sourcecolumn;
        while (length2 > 0) {
            int runlength = length2 <= available2 ? length2 : available2;
            boolean chunkOK = XMLCharacterRecognizer.isWhiteSpace(this.m_array[sourcechunk], sourcecolumn, runlength);
            if (!chunkOK) {
                return false;
            }
            length2 -= runlength;
            ++sourcechunk;
            sourcecolumn = 0;
            available2 = this.m_chunkSize;
        }
        return true;
    }

    public String getString(int start, int length2) {
        int startColumn = start & this.m_chunkMask;
        int startChunk = start >>> this.m_chunkBits;
        if (startColumn + length2 < this.m_chunkMask) {
            return this.getOneChunkString(startChunk, startColumn, length2);
        }
        return this.getString(new StringBuffer(length2), startChunk, startColumn, length2).toString();
    }

    protected String getOneChunkString(int startChunk, int startColumn, int length2) {
        return new String(this.m_array[startChunk], startColumn, length2);
    }

    StringBuffer getString(StringBuffer sb, int start, int length2) {
        return this.getString(sb, start >>> this.m_chunkBits, start & this.m_chunkMask, length2);
    }

    public int writeTo(Writer writer, int start, int length2) throws IOException {
        return this.writeTo(writer, start >>> this.m_chunkBits, start & this.m_chunkMask, length2);
    }

    public int writeTo(Writer writer, int startChunk, int startColumn, int length2) throws IOException {
        int stop = (startChunk << this.m_chunkBits) + startColumn + length2;
        int stopChunk = stop >>> this.m_chunkBits;
        int stopColumn = stop & this.m_chunkMask;
        for (int i = startChunk; i < stopChunk; ++i) {
            writer.write(this.m_array[i], startColumn, this.m_chunkSize - startColumn);
            startColumn = 0;
        }
        if (stopColumn > startColumn) {
            writer.write(this.m_array[stopChunk], startColumn, stopColumn - startColumn);
        }
        return length2;
    }

    StringBuffer getString(StringBuffer sb, int startChunk, int startColumn, int length2) {
        int stop = (startChunk << this.m_chunkBits) + startColumn + length2;
        int stopChunk = stop >>> this.m_chunkBits;
        int stopColumn = stop & this.m_chunkMask;
        for (int i = startChunk; i < stopChunk; ++i) {
            sb.append(this.m_array[i], startColumn, this.m_chunkSize - startColumn);
            startColumn = 0;
        }
        if (stopColumn > startColumn) {
            sb.append(this.m_array[stopChunk], startColumn, stopColumn - startColumn);
        }
        return sb;
    }

    char[] copyChars(char[] buffer, int bufoffset, int startChunk, int startColumn, int length2) {
        int stop = (startChunk << this.m_chunkBits) + startColumn + length2;
        int stopChunk = stop >>> this.m_chunkBits;
        int stopColumn = stop & this.m_chunkMask;
        for (int i = startChunk; i < stopChunk; ++i) {
            int unit = this.m_chunkSize - startColumn;
            System.arraycopy(this.m_array[i], startColumn, buffer, bufoffset, unit);
            bufoffset += unit;
            startColumn = 0;
        }
        int unit = stopColumn - startColumn;
        if (stopColumn > startColumn) {
            System.arraycopy(this.m_array[stopChunk], startColumn, buffer, bufoffset, unit);
        }
        return buffer;
    }

    public char charAt(int pos) {
        int startChunk = pos >>> this.m_chunkBits;
        return this.m_array[startChunk][pos & this.m_chunkMask];
    }

    public void sendSAXcharacters(ContentHandler ch, int start, int length2) throws SAXException {
        int startChunk = start >>> this.m_chunkBits;
        int startColumn = start & this.m_chunkMask;
        if (startColumn + length2 < this.m_chunkMask) {
            ch.characters(this.m_array[startChunk], startColumn, length2);
            return;
        }
        int stop = start + length2;
        int stopChunk = stop >>> this.m_chunkBits;
        int stopColumn = stop & this.m_chunkMask;
        for (int i = startChunk; i < stopChunk; ++i) {
            ch.characters(this.m_array[i], startColumn, this.m_chunkSize - startColumn);
            startColumn = 0;
        }
        if (stopColumn > startColumn) {
            ch.characters(this.m_array[stopChunk], startColumn, stopColumn - startColumn);
        }
    }

    public int sendNormalizedSAXcharacters(ContentHandler ch, int start, int length2) throws SAXException {
        int stateForNextChunk = 1;
        int stop = start + length2;
        int startChunk = start >>> this.m_chunkBits;
        int startColumn = start & this.m_chunkMask;
        int stopChunk = stop >>> this.m_chunkBits;
        int stopColumn = stop & this.m_chunkMask;
        for (int i = startChunk; i < stopChunk; ++i) {
            stateForNextChunk = FastStringBuffer.sendNormalizedSAXcharacters(this.m_array[i], startColumn, this.m_chunkSize - startColumn, ch, stateForNextChunk);
            startColumn = 0;
        }
        if (stopColumn > startColumn) {
            stateForNextChunk = FastStringBuffer.sendNormalizedSAXcharacters(this.m_array[stopChunk], startColumn, stopColumn - startColumn, ch, stateForNextChunk | 2);
        }
        return stateForNextChunk;
    }

    static int sendNormalizedSAXcharacters(char[] ch, int start, int length2, ContentHandler handler, int edgeTreatmentFlags) throws SAXException {
        int currPos;
        boolean processingLeadingWhitespace = (edgeTreatmentFlags & 1) != 0;
        boolean seenWhitespace = (edgeTreatmentFlags & 4) != 0;
        boolean suppressTrailingWhitespace = (edgeTreatmentFlags & 2) != 0;
        int limit = start + length2;
        if (processingLeadingWhitespace) {
            for (currPos = start; currPos < limit && XMLCharacterRecognizer.isWhiteSpace(ch[currPos]); ++currPos) {
            }
            if (currPos == limit) {
                return edgeTreatmentFlags;
            }
        }
        while (currPos < limit) {
            int startNonWhitespace = currPos;
            while (currPos < limit && !XMLCharacterRecognizer.isWhiteSpace(ch[currPos])) {
                ++currPos;
            }
            if (startNonWhitespace != currPos) {
                if (seenWhitespace) {
                    handler.characters(SINGLE_SPACE, 0, 1);
                    seenWhitespace = false;
                }
                handler.characters(ch, startNonWhitespace, currPos - startNonWhitespace);
            }
            int startWhitespace = currPos;
            while (currPos < limit && XMLCharacterRecognizer.isWhiteSpace(ch[currPos])) {
                ++currPos;
            }
            if (startWhitespace == currPos) continue;
            seenWhitespace = true;
        }
        return (seenWhitespace ? 4 : 0) | edgeTreatmentFlags & 2;
    }

    public static void sendNormalizedSAXcharacters(char[] ch, int start, int length2, ContentHandler handler) throws SAXException {
        FastStringBuffer.sendNormalizedSAXcharacters(ch, start, length2, handler, 3);
    }

    public void sendSAXComment(LexicalHandler ch, int start, int length2) throws SAXException {
        String comment2 = this.getString(start, length2);
        ch.comment(comment2.toCharArray(), 0, length2);
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        this.copyChars(dst, dstBegin, srcBegin >>> this.m_chunkBits, srcBegin & this.m_chunkMask, srcEnd);
    }
}

