/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.xml.sax.InputSource;

public class InputSource2CharBuffer {
    private String m_encoding;
    private CharBuffer m_chars;
    private static final int UNKNOWN = 0;
    private static final int UTF8N = 1;
    private static final int UTF16BE = 2;
    private static final int UTF16LE = 3;
    private static final int UTF32BE = 4;
    private static final int UTF32LE = 5;
    private static final int LATIN = 6;
    private static final int EBCDIC = 7;
    private static final int UCS2BE = 8;
    private static final int UCS2LE = 9;
    private static final int UCS4BE = 10;
    private static final int UCS4LE = 11;
    private final InputSource2CharBuffer fSource = this;
    private int fBytesPerChar;
    private boolean fIsBigEndian;
    private static final int CODEPOINT_ILLEGAL = 0;
    private static final int CODEPOINT_WHITESPACE = 1;
    private static final int CODEPOINT_EQUALSIGN = 2;
    private static final int CODEPOINT_SINGLEQUOTE = 3;
    private static final int CODEPOINT_DOUBLEQUOTE = 4;
    private static final int CODEPOINT_LETTER = 5;
    private static final int CODEPOINT_DIGIT = 6;
    private static final int CODEPOINT_HYPHEN = 7;
    private static final int CODEPOINT_UNDERSCORE = 8;
    private static final int CODEPOINT_PERIOD = 9;
    private static final int CODEPOINT_LESSTHAN = 10;
    private static final int CODEPOINT_GREATERTHAN = 11;
    private static final int CODEPOINT_QUESTIONMARK = 12;
    private static final int LITERAL_STARTPIXML = 0;
    private static final int LITERAL_VERSION = 1;
    private static final int LITERAL_VERSION1X = 2;
    private static final int LITERAL_ENCODING = 3;
    private static final int LITERAL_STANDALONE = 4;
    private static final int LITERAL_YES = 5;
    private static final int LITERAL_NO = 6;
    private static final int LITERAL_ENDPI = 7;
    private static final int STATE_START = 0;
    private static final int STATE_VERSION = 1;
    private static final int STATE_ENCODING = 2;
    private static final int STATE_STANDALONE = 3;
    private static final int STATE_FINISHED = 4;
    private static final byte BAD = 0;
    private static final byte WSP = 1;
    private static final byte PER = 9;
    private static final byte LSS = 10;
    private static final byte HYP = 7;
    private static final byte USC = 8;
    private static final byte GTR = 11;
    private static final byte QST = 12;
    private static final byte SQT = 3;
    private static final byte EQL = 2;
    private static final byte DQT = 4;
    private static final byte LTR = 5;
    private static final byte DIG = 6;
    private static final int DEFAULT_BUFFER_LENGTH = 4096;
    private InputStream stream;
    private byte[] readBuffer;
    private int readOffset;
    private int readLength;
    private boolean isXML10;
    private int readMark;
    private int readLimit;
    private char[] encodingBuffer;
    private int encodingLength;
    private String specifiedEncoding;
    private static final byte[] fgCodePointMapEBCDIC = new byte[]{0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 11, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 2, 4, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 0, 0, 0, 0, 0, 0};
    private static final char BAD_ = '\u0000';
    private static final char[] fgEncodingNameMapEBCDIC = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '.', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '-', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '_', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
    private static final int[] STARTPIXML_EBCDIC = new int[]{76, 111, 167, 148, 147};
    private static final int[] VERSION_EBCDIC = new int[]{165, 133, 153, 162, 137, 150, 149};
    private static final int[] VERSION1_EBCDIC = new int[]{241, 75};
    private static final int[] ENCODING_EBCDIC = new int[]{133, 149, 131, 150, 132, 137, 149, 135};
    private static final int[] STANDALONE_EBCDIC = new int[]{162, 163, 129, 149, 132, 129, 147, 150, 149, 133};
    private static final int[] YES_EBCDIC = new int[]{168, 133, 162};
    private static final int[] NO_EBCDIC = new int[]{149, 150};
    private static final int[] ENDPI_EBCDIC = new int[]{111, 110};
    private static final byte[] encNameCharMapLatin = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 2, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0};
    private static final int[] STARTPIXML_Latin = new int[]{60, 63, 120, 109, 108};
    private static final int[] VERSION_Latin = new int[]{118, 101, 114, 115, 105, 111, 110};
    private static final int[] VERSION1_Latin = new int[]{49, 46};
    private static final int[] ENCODING_Latin = new int[]{101, 110, 99, 111, 100, 105, 110, 103};
    private static final int[] STANDALONE_Latin = new int[]{115, 116, 97, 110, 100, 97, 108, 111, 110, 101};
    private static final int[] YES_Latin = new int[]{121, 101, 115};
    private static final int[] NO_Latin = new int[]{110, 111};

    public InputSource2CharBuffer(InputSource input) throws IOException, FileNotFoundException, URISyntaxException {
        Reader reader = input.getCharacterStream();
        if (reader != null) {
            char[] chars = new char[4096];
            int offset = 0;
            int available2 = 4096;
            int numberRead = reader.read(chars, offset, available2);
            while (numberRead != -1) {
                offset += numberRead;
                if (0 == (available2 -= numberRead)) {
                    available2 = chars.length;
                    char[] newArray = new char[chars.length << 1];
                    System.arraycopy(chars, 0, newArray, 0, newArray.length);
                    chars = newArray;
                }
                numberRead = reader.read(chars, offset, available2);
            }
            this.m_chars = CharBuffer.wrap(chars, 0, offset);
            this.m_encoding = this.getXMLEncodingFromCharacterStream();
        } else {
            InputStream m_inputStream = input.getByteStream();
            if (m_inputStream == null) {
                String systemId = input.getSystemId();
                File file = new File(systemId);
                if (file.exists()) {
                    m_inputStream = new FileInputStream(file);
                } else {
                    URI uri2 = new URI(systemId);
                    m_inputStream = uri2.toURL().openStream();
                }
            }
            this.mark();
            this.m_encoding = this.getXMLEncoding(m_inputStream);
            this.readRestOfFile();
            this.doReset();
            if (this.stream != null) {
                this.stream.close();
                this.stream = null;
            }
            Charset cs = Charset.forName(this.m_encoding);
            CharsetDecoder decoder = cs.newDecoder();
            ByteBuffer bb = ByteBuffer.wrap(this.readBuffer, this.readOffset, this.readLimit - this.readOffset);
            this.m_chars = decoder.decode(bb);
        }
    }

    public CharBuffer getCharBuffer() {
        return this.m_chars;
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    private String getXMLEncodingFromCharacterStream() {
        int end;
        String enc = "UTF-8";
        int bufferLength = this.m_chars.length();
        if (InputSource2CharBuffer.startsWith(this.m_chars, "<?xml") && 0 < (end = InputSource2CharBuffer.indexOf(this.m_chars, "?>", 5, bufferLength))) {
            int closingQuote;
            int encodingStart = InputSource2CharBuffer.indexOf(this.m_chars, "encoding=", 5, end);
            char delim = '\u0000';
            if (0 < encodingStart && ((delim = this.m_chars.charAt(encodingStart + 9)) == '\"' || delim == '\'') && 0 < (closingQuote = InputSource2CharBuffer.indexOf(this.m_chars, new String(new char[]{delim}), encodingStart + 10, end))) {
                enc = ((Object)this.m_chars.subSequence(encodingStart + 10, closingQuote)).toString();
            }
        }
        return enc;
    }

    private static boolean startsWith(CharBuffer buffer, String lookup) {
        int i;
        int bufferLength = buffer.length();
        int lookupLength = lookup.length();
        for (i = 0; i < lookupLength && i < bufferLength; ++i) {
            if (lookup.charAt(i) == buffer.charAt(i)) continue;
            return false;
        }
        return i == lookupLength;
    }

    private static int indexOf(CharBuffer buffer, String lookup, int start, int end) {
        int lookupLength = lookup.length();
        int i = start;
        int toMatch = 0;
        boolean matching = false;
        while (i < end && toMatch < lookupLength) {
            if (lookup.charAt(toMatch) == buffer.charAt(i)) {
                matching = true;
                ++toMatch;
            } else if (matching) {
                matching = false;
                toMatch = 0;
                continue;
            }
            ++i;
        }
        return toMatch == lookupLength ? i - lookupLength : -1;
    }

    private void setByteStream(InputStream is2) {
        this.stream = is2;
        this.isXML10 = true;
        this.readLength = 4096;
        this.readBuffer = new byte[this.readLength];
        this.encodingBuffer = new char[64];
        this.readLimit = 0;
        this.readOffset = 0;
        this.readMark = 0;
        this.encodingLength = 0;
        this.specifiedEncoding = null;
    }

    private void addEncodingChar(char ch) {
        if (this.encodingLength == this.encodingBuffer.length) {
            int newLen = this.encodingLength << 1;
            char[] newArray = new char[newLen];
            System.arraycopy(this.encodingBuffer, 0, newArray, 0, this.encodingBuffer.length);
            this.encodingBuffer = newArray;
        }
        this.encodingBuffer[this.encodingLength++] = ch;
    }

    private boolean saveEncodingChars() {
        return this.encodingLength > 0;
    }

    private String getSpecifiedEncoding() {
        if (this.specifiedEncoding == null && this.encodingLength > 0) {
            this.specifiedEncoding = new String(this.encodingBuffer, 0, this.encodingLength);
        }
        return this.specifiedEncoding;
    }

    private void resetOffsets() {
        this.readLimit -= this.readOffset;
        System.arraycopy(this.readBuffer, this.readOffset, this.readBuffer, 0, this.readLimit);
        this.readOffset = 0;
    }

    private void mark() {
        this.readMark = this.readOffset;
    }

    private void doReset() {
        this.readOffset = this.readMark;
    }

    private void rewind() {
        this.readOffset = 0;
        this.readMark = 0;
    }

    private void unreadByte() {
        --this.readOffset;
    }

    private boolean readMoreBytes(int current2) throws IOException {
        int readcount;
        int capacity = this.readLength - 1;
        if (current2 == capacity) {
            this.readLength <<= 1;
            byte[] newArray = new byte[this.readLength];
            System.arraycopy(this.readBuffer, 0, newArray, 0, this.readBuffer.length);
            this.readBuffer = newArray;
            capacity = this.readLength - 1;
        }
        if ((readcount = this.stream.read(this.readBuffer, current2, capacity - current2)) == -1) {
            this.stream.close();
            this.stream = null;
            return false;
        }
        this.readLimit += readcount;
        return true;
    }

    private int readByte() throws IOException {
        if (this.readOffset < this.readLimit) {
            return this.readBuffer[this.readOffset++] & 0xFF;
        }
        return this.readMoreBytes(this.readOffset) ? this.readBuffer[this.readOffset++] & 0xFF : -1;
    }

    private void readRestOfFile() throws IOException {
        while (this.readMoreBytes(this.readLimit)) {
        }
    }

    public boolean getIsXML10() {
        return this.isXML10;
    }

    public String getXMLEncoding(InputStream is2) throws IOException {
        this.setByteStream(is2);
        this.isXML10 = true;
        int encodingType = this.detectEncoding();
        switch (encodingType) {
            default: {
                return "UTF-8";
            }
            case 2: {
                return "UTF-16BE";
            }
            case 3: {
                return "UTF-16LE";
            }
            case 4: {
                return "UTF-32BE";
            }
            case 5: {
                return "UTF-32LE";
            }
            case 6: {
                if (this.getLatinEncoding(true)) {
                    return this.getSpecifiedEncoding();
                }
                return "UTF-8";
            }
            case 7: {
                if (this.getEBCDICEncoding(true)) {
                    return this.getSpecifiedEncoding();
                }
                return null;
            }
            case 8: {
                if (this.getUCSEncoding(true, 2, true)) {
                    return this.getSpecifiedEncoding();
                }
                return null;
            }
            case 9: {
                if (this.getUCSEncoding(true, 2, false)) {
                    return this.getSpecifiedEncoding();
                }
                return null;
            }
            case 10: {
                if (this.getUCSEncoding(true, 4, true)) {
                    return this.getSpecifiedEncoding();
                }
                return null;
            }
            case 11: 
        }
        if (this.getUCSEncoding(true, 4, false)) {
            return this.getSpecifiedEncoding();
        }
        return null;
    }

    private int detectEncoding() throws IOException {
        int b = this.fSource.readByte();
        switch (b) {
            case 60: {
                b = this.fSource.readByte();
                if (b == 63) {
                    b = this.fSource.readByte();
                    if (b != 120 || (b = this.fSource.readByte()) != 109) break;
                    this.fSource.rewind();
                    return 6;
                }
                if (b != 0) break;
                b = this.fSource.readByte();
                if (b == 63) {
                    b = this.fSource.readByte();
                    if (b != 0) break;
                    this.fSource.rewind();
                    return 9;
                }
                if (b != 0 || (b = this.fSource.readByte()) != 0) break;
                this.fSource.rewind();
                return 11;
            }
            case 239: {
                b = this.fSource.readByte();
                if (b != 187 || (b = this.fSource.readByte()) != 191) break;
                this.fSource.resetOffsets();
                return 1;
            }
            case 0: {
                b = this.fSource.readByte();
                if (b == 60) {
                    b = this.fSource.readByte();
                    if (b != 0 || (b = this.fSource.readByte()) != 63) break;
                    this.fSource.rewind();
                    return 8;
                }
                if (b != 0) break;
                b = this.fSource.readByte();
                if (b == 0) {
                    b = this.fSource.readByte();
                    if (b != 60) break;
                    this.fSource.rewind();
                    return 10;
                }
                if (b != 254 || (b = this.fSource.readByte()) != 255) break;
                this.fSource.resetOffsets();
                return 4;
            }
            case 254: {
                b = this.fSource.readByte();
                if (b != 255) break;
                this.fSource.resetOffsets();
                return 2;
            }
            case 255: {
                b = this.fSource.readByte();
                if (b != 254) break;
                this.fSource.resetOffsets();
                b = this.fSource.readByte();
                if (b == 0 && (b = this.fSource.readByte()) == 0) {
                    this.fSource.resetOffsets();
                    return 5;
                }
                this.fSource.rewind();
                return 3;
            }
            case 76: {
                b = this.fSource.readByte();
                if (b != 111 || (b = this.fSource.readByte()) != 167 || (b = this.fSource.readByte()) != 148) break;
                this.fSource.rewind();
                return 7;
            }
        }
        this.fSource.rewind();
        return 0;
    }

    private boolean getEBCDICEncoding(boolean isDocumentEntity) throws IOException {
        return this.readEBCDICEncodingDecl(isDocumentEntity);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean readEBCDICEncodingDecl(boolean isDocumentEntity) throws IOException {
        int state = 0;
        if (!this.skipEBCDICLiteral(0)) {
            return false;
        }
        this.skipEBCDICSpaces();
        do {
            if (!isDocumentEntity) {
                if (state == 0 && this.skipEBCDICLiteral(1)) {
                    state = 1;
                } else {
                    if (!this.skipEBCDICLiteral(3)) return false;
                    state = 2;
                }
            } else if (state == 0) {
                if (!this.skipEBCDICLiteral(1)) return false;
                state = 1;
            } else if (state != 1 || !this.skipEBCDICLiteral(3)) {
                if (!this.skipEBCDICLiteral(4)) break;
                state = 3;
            } else {
                state = 2;
            }
            this.skipEBCDICSpaces();
            if (!this.skipEBCDICCodePoint(2)) {
                return false;
            }
            this.skipEBCDICSpaces();
            boolean single2 = this.skipEBCDICCodePoint(3);
            if (!single2 && !this.skipEBCDICCodePoint(4)) {
                return false;
            }
            int qchar = single2 ? 3 : 4;
            switch (state) {
                case 1: {
                    if (!this.skipEBCDICLiteral(2) || !this.skipEBCDICCodePoint(qchar)) {
                        return false;
                    }
                    if (this.skipEBCDICSpaces()) break;
                    if (!isDocumentEntity) {
                        return false;
                    }
                    state = 4;
                    break;
                }
                case 2: {
                    if (!this.scanEBCDICEncodingName(qchar)) {
                        return false;
                    }
                    if (!this.skipEBCDICSpaces()) {
                        state = 4;
                        break;
                    }
                    if (isDocumentEntity) break;
                    state = 4;
                    break;
                }
                case 3: {
                    if (!this.skipEBCDICLiteral(5) && !this.skipEBCDICLiteral(6) || !this.skipEBCDICCodePoint(qchar)) {
                        return false;
                    }
                    this.skipEBCDICSpaces();
                    state = 4;
                }
            }
        } while (state != 4);
        if (this.skipEBCDICLiteral(7)) return this.fSource.saveEncodingChars();
        return false;
    }

    protected boolean skipEBCDICCodePoint(int codePoint) throws IOException {
        int b = this.fSource.readByte();
        if (b == -1) {
            return false;
        }
        byte cp = fgCodePointMapEBCDIC[b];
        if (cp != codePoint) {
            this.fSource.unreadByte();
            return false;
        }
        return true;
    }

    protected boolean skipEBCDICLiteral(int literal) throws IOException {
        int b;
        int litLength;
        int[] litData2;
        this.fSource.mark();
        switch (literal) {
            case 0: {
                int b2;
                int[] litData2 = STARTPIXML_EBCDIC;
                for (int i = 0; i < 5; ++i) {
                    b2 = this.fSource.readByte();
                    if (b2 == litData2[i]) continue;
                    this.fSource.doReset();
                    return false;
                }
                b2 = this.fSource.readByte();
                if (b2 == -1) {
                    this.fSource.doReset();
                    return false;
                }
                byte cp = fgCodePointMapEBCDIC[b2];
                if (cp != 1) {
                    this.fSource.doReset();
                    return false;
                }
                return true;
            }
            case 1: {
                litData2 = VERSION_EBCDIC;
                litLength = 7;
                break;
            }
            case 2: {
                litData2 = VERSION1_EBCDIC;
                litLength = 2;
                break;
            }
            case 3: {
                litData2 = ENCODING_EBCDIC;
                litLength = 8;
                break;
            }
            case 4: {
                litData2 = STANDALONE_EBCDIC;
                litLength = 10;
                break;
            }
            case 5: {
                litData2 = YES_EBCDIC;
                litLength = 3;
                break;
            }
            case 6: {
                litData2 = NO_EBCDIC;
                litLength = 2;
                break;
            }
            case 7: {
                litData2 = ENDPI_EBCDIC;
                litLength = 2;
                break;
            }
            default: {
                return false;
            }
        }
        for (int i = 0; i < litLength; ++i) {
            b = this.fSource.readByte();
            if (b == litData2[i]) continue;
            this.fSource.doReset();
            return false;
        }
        if (literal == 2) {
            b = this.fSource.readByte();
            if (b < 240 || b > 241) {
                this.fSource.doReset();
                return false;
            }
            if (b == 241) {
                this.fSource.isXML10 = false;
            }
        }
        return true;
    }

    protected boolean skipEBCDICSpaces() throws IOException {
        boolean result2 = false;
        while (this.skipEBCDICCodePoint(1)) {
            result2 = true;
        }
        return result2;
    }

    protected boolean scanEBCDICEncodingName(int qchar) throws IOException {
        block7: {
            this.fSource.mark();
            int b = this.fSource.readByte();
            if (b == -1) {
                this.fSource.doReset();
                return false;
            }
            byte cp = fgCodePointMapEBCDIC[b];
            if (cp != 5) {
                this.fSource.doReset();
                return false;
            }
            this.fSource.addEncodingChar(fgEncodingNameMapEBCDIC[b]);
            block3: while (true) {
                if ((b = this.fSource.readByte()) == -1) {
                    this.fSource.doReset();
                    return false;
                }
                cp = fgCodePointMapEBCDIC[b];
                if (cp == qchar) break block7;
                switch (cp) {
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        this.fSource.addEncodingChar(fgEncodingNameMapEBCDIC[b]);
                        continue block3;
                    }
                }
                break;
            }
            this.fSource.doReset();
            return false;
        }
        return true;
    }

    private boolean getLatinEncoding(boolean isDocumentEntity) throws IOException {
        return this.readLatinEncodingDecl(isDocumentEntity);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean readLatinEncodingDecl(boolean isDocumentEntity) throws IOException {
        int state = 0;
        int b = this.fSource.readByte();
        if (!this.skipLatinLiteral(b, 0)) {
            return false;
        }
        b = this.skipLatinSpaces();
        do {
            boolean dquote;
            if (!isDocumentEntity) {
                if (state == 0 && b == 118) {
                    if (!this.skipLatinLiteral(b, 1)) return false;
                    state = 1;
                } else {
                    if (!this.skipLatinLiteral(b, 3)) return false;
                    state = 2;
                }
            } else if (state == 0) {
                if (!this.skipLatinLiteral(b, 1)) return false;
                state = 1;
            } else if (state == 1 && b == 101) {
                if (!this.skipLatinLiteral(b, 3)) return false;
                state = 2;
            } else {
                if (b != 115) break;
                if (!this.skipLatinLiteral(b, 4)) return false;
                state = 3;
            }
            b = this.skipLatinSpaces();
            if (b != 61) {
                return false;
            }
            b = this.skipLatinSpaces();
            boolean bl = dquote = b == 34;
            if (!dquote && b != 39) {
                return false;
            }
            int qchar = b;
            b = this.fSource.readByte();
            switch (state) {
                case 1: {
                    if (!this.skipLatinLiteral(b, 2) || this.fSource.readByte() != qchar) {
                        return false;
                    }
                    b = this.fSource.readByte();
                    if (b == 32 || b == 10 || b == 9 || b == 13) {
                        b = this.skipLatinSpaces();
                        break;
                    }
                    if (!isDocumentEntity) {
                        return false;
                    }
                    state = 4;
                    break;
                }
                case 2: {
                    if (!this.scanLatinEncodingName(b, qchar)) {
                        return false;
                    }
                    b = this.fSource.readByte();
                    if (b == 32 || b == 10 || b == 9 || b == 13) {
                        b = this.skipLatinSpaces();
                        if (isDocumentEntity) break;
                        state = 4;
                        break;
                    }
                    state = 4;
                    break;
                }
                case 3: {
                    if (b == 121 ? !this.skipLatinLiteral(b, 5) || this.fSource.readByte() != qchar : !this.skipLatinLiteral(b, 6) || this.fSource.readByte() != qchar) {
                        return false;
                    }
                    b = this.skipLatinSpaces();
                    state = 4;
                }
            }
        } while (state != 4);
        if (b == 63 && this.fSource.readByte() == 62) return this.fSource.saveEncodingChars();
        return false;
    }

    private boolean skipLatinLiteral(int firstByte, int literal) throws IOException {
        int b;
        int litLength;
        int[] litData;
        switch (literal) {
            case 0: {
                litData = STARTPIXML_Latin;
                litLength = 5;
                break;
            }
            case 1: {
                litData = VERSION_Latin;
                litLength = 7;
                break;
            }
            case 2: {
                litData = VERSION1_Latin;
                litLength = 2;
                break;
            }
            case 3: {
                litData = ENCODING_Latin;
                litLength = 8;
                break;
            }
            case 4: {
                litData = STANDALONE_Latin;
                litLength = 10;
                break;
            }
            case 5: {
                litData = YES_Latin;
                litLength = 3;
                break;
            }
            case 6: {
                litData = NO_Latin;
                litLength = 2;
                break;
            }
            default: {
                return false;
            }
        }
        if (firstByte != litData[0]) {
            return false;
        }
        for (int i = 1; i < litLength; ++i) {
            b = this.fSource.readByte();
            if (b == litData[i]) continue;
            return false;
        }
        if (literal == 0) {
            b = this.fSource.readByte();
            if (b != 32 && b != 10 && b != 9 && b != 13) {
                return false;
            }
        } else if (literal == 2) {
            b = this.fSource.readByte();
            if (b < 48 || b > 49) {
                return false;
            }
            if (b == 49) {
                this.fSource.isXML10 = false;
            }
        }
        return true;
    }

    private int skipLatinSpaces() throws IOException {
        int b;
        while ((b = this.fSource.readByte()) == 32 || b == 10 || b == 9 || b == 13) {
        }
        return b;
    }

    private boolean scanLatinEncodingName(int firstByte, int qchar) throws IOException {
        block3: {
            int b = firstByte;
            if (b == -1) {
                return false;
            }
            if (b >= 128 || encNameCharMapLatin[b] != 1) {
                return false;
            }
            do {
                this.fSource.addEncodingChar((char)b);
                b = this.fSource.readByte();
                if (b == qchar) break block3;
                if (b != -1) continue;
                return false;
            } while (b < 128 && encNameCharMapLatin[b] != 0);
            return false;
        }
        return true;
    }

    private boolean getUCSEncoding(boolean isDocumentEntity, int bytesPerChar, boolean isBigEndian) throws IOException {
        this.fBytesPerChar = bytesPerChar;
        this.fIsBigEndian = isBigEndian;
        return this.readUCSEncodingDecl(isDocumentEntity);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean readUCSEncodingDecl(boolean isDocumentEntity) throws IOException {
        int state = 0;
        int b = this.readUCSChar();
        if (!this.skipUCSLiteral(b, 0)) {
            return false;
        }
        b = this.skipUCSSpaces();
        do {
            boolean dquote;
            if (!isDocumentEntity) {
                if (state == 0 && b == 118) {
                    if (!this.skipUCSLiteral(b, 1)) return false;
                    state = 1;
                } else {
                    if (!this.skipUCSLiteral(b, 3)) return false;
                    state = 2;
                }
            } else if (state == 0) {
                if (!this.skipUCSLiteral(b, 1)) return false;
                state = 1;
            } else if (state == 1 && b == 101) {
                if (!this.skipUCSLiteral(b, 3)) return false;
                state = 2;
            } else {
                if (b != 115) break;
                if (!this.skipUCSLiteral(b, 4)) return false;
                state = 3;
            }
            b = this.skipUCSSpaces();
            if (b != 61) {
                return false;
            }
            b = this.skipUCSSpaces();
            boolean bl = dquote = b == 34;
            if (!dquote && b != 39) {
                return false;
            }
            int qchar = b;
            b = this.readUCSChar();
            switch (state) {
                case 1: {
                    if (!this.skipUCSLiteral(b, 2) || this.readUCSChar() != qchar) {
                        return false;
                    }
                    b = this.readUCSChar();
                    if (b == 32 || b == 10 || b == 9 || b == 13) {
                        b = this.skipUCSSpaces();
                        break;
                    }
                    if (!isDocumentEntity) {
                        return false;
                    }
                    state = 4;
                    break;
                }
                case 2: {
                    if (!this.scanUCSEncodingName(b, qchar)) {
                        return false;
                    }
                    b = this.readUCSChar();
                    if (b == 32 || b == 10 || b == 9 || b == 13) {
                        b = this.skipUCSSpaces();
                        if (isDocumentEntity) break;
                        state = 4;
                        break;
                    }
                    state = 4;
                    break;
                }
                case 3: {
                    if (b == 121 ? !this.skipUCSLiteral(b, 5) || this.readUCSChar() != qchar : !this.skipUCSLiteral(b, 6) || this.readUCSChar() != qchar) {
                        return false;
                    }
                    b = this.skipUCSSpaces();
                    state = 4;
                }
            }
        } while (state != 4);
        if (b == 63 && this.readUCSChar() == 62) return this.fSource.saveEncodingChars();
        return false;
    }

    private int readUCSChar() throws IOException {
        int b0 = this.fSource.readByte();
        if (b0 == -1) {
            return -1;
        }
        int b1 = this.fSource.readByte();
        if (b1 == -1) {
            return -1;
        }
        if (this.fBytesPerChar == 2) {
            if (this.fIsBigEndian) {
                return (b0 << 8) + b1;
            }
            return (b1 << 8) + b0;
        }
        int b2 = this.fSource.readByte();
        if (b2 == -1) {
            return -1;
        }
        int b3 = this.fSource.readByte();
        if (b3 == -1) {
            return -1;
        }
        if (this.fIsBigEndian) {
            return (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
        }
        return (b3 << 24) + (b2 << 16) + (b1 << 8) + b0;
    }

    private boolean skipUCSLiteral(int firstByte, int literal) throws IOException {
        int b;
        int litLength;
        int[] litData;
        switch (literal) {
            case 0: {
                litData = STARTPIXML_Latin;
                litLength = 5;
                break;
            }
            case 1: {
                litData = VERSION_Latin;
                litLength = 7;
                break;
            }
            case 2: {
                litData = VERSION1_Latin;
                litLength = 2;
                break;
            }
            case 3: {
                litData = ENCODING_Latin;
                litLength = 8;
                break;
            }
            case 4: {
                litData = STANDALONE_Latin;
                litLength = 10;
                break;
            }
            case 5: {
                litData = YES_Latin;
                litLength = 3;
                break;
            }
            case 6: {
                litData = NO_Latin;
                litLength = 2;
                break;
            }
            default: {
                return false;
            }
        }
        if (firstByte != litData[0]) {
            return false;
        }
        for (int i = 1; i < litLength; ++i) {
            b = this.readUCSChar();
            if (b == litData[i]) continue;
            return false;
        }
        if (literal == 0) {
            b = this.readUCSChar();
            if (b != 32 && b != 10 && b != 9 && b != 13) {
                return false;
            }
        } else if (literal == 2) {
            b = this.readUCSChar();
            if (b < 48 || b > 49) {
                return false;
            }
            if (b == 49) {
                this.fSource.isXML10 = false;
            }
        }
        return true;
    }

    private int skipUCSSpaces() throws IOException {
        int b;
        while ((b = this.readUCSChar()) == 32 || b == 10 || b == 9 || b == 13) {
        }
        return b;
    }

    private boolean scanUCSEncodingName(int firstChar, int qchar) throws IOException {
        block3: {
            int b = firstChar;
            if (b == -1) {
                return false;
            }
            if (b >= 128 || encNameCharMapLatin[b] != 1) {
                return false;
            }
            do {
                this.fSource.addEncodingChar((char)b);
                b = this.readUCSChar();
                if (b == qchar) break block3;
                if (b != -1) continue;
                return false;
            } while (b < 128 && encNameCharMapLatin[b] != 0);
            return false;
        }
        return true;
    }
}

