/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.common.utils;

import java.util.Random;

public final class PerSessionHash {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2012. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String ENABLE_SECURE_HASH = "com.ibm.xml.xci.enableSecureHash";
    private static final boolean useSecureHash;
    protected static int[] _substitute8;
    protected static int[] _substitute;

    protected static void shuffle(Random r, int[] s) {
        int l = s.length;
        for (int i = l - 1; i >= 0; --i) {
            int j = r.nextInt(l);
            int t = s[i];
            s[i] = s[j];
            s[j] = t;
        }
    }

    public static int hash(String s) {
        if (!useSecureHash) {
            return s.hashCode();
        }
        int h = 0;
        for (int i = s.length() - 1; i >= 0; --i) {
            char c = s.charAt(i);
            h = (h << 5) + h + _substitute8[c >> 8];
            h = (h << 5) + h + _substitute[c & 0xFF];
        }
        return h;
    }

    static {
        int i;
        boolean setting = false;
        try {
            String propValue = System.getProperty(ENABLE_SECURE_HASH);
            setting = "true".equalsIgnoreCase(propValue);
        }
        catch (Exception e) {
            // empty catch block
        }
        useSecureHash = setting;
        Random r = new Random();
        _substitute = new int[256];
        for (i = 255; i >= 0; --i) {
            PerSessionHash._substitute[i] = i;
        }
        PerSessionHash.shuffle(r, _substitute);
        _substitute8 = new int[256];
        for (i = 255; i >= 0; --i) {
            PerSessionHash._substitute8[i] = i;
        }
        PerSessionHash.shuffle(r, _substitute8);
    }
}

