/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.common.utils;

import com.ibm.xltxe.rnm1.xtq.common.utils.StAX2SAX;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.EntityDeclaration;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class STAXEvent2SAX
extends StAX2SAX {
    private XMLEventReader m_eventReader = null;
    private ArrayList m_attributes = new ArrayList();

    public STAXEvent2SAX(XMLEventReader reader) {
        this.m_eventReader = reader;
    }

    @Override
    public void parse(InputSource unused) throws IOException, SAXException {
        if (this.m_eventReader != null) {
            this.parse(this.m_eventReader);
        }
    }

    private void parse(XMLEventReader reader) throws IOException, SAXException {
        block19: {
            try {
                if (!reader.hasNext()) break block19;
                XMLEvent event = reader.nextEvent();
                switch (event.getEventType()) {
                    case 7: {
                        this.setLocation(event.getLocation());
                        this.setXMLVersion(((StartDocument)event).getVersion());
                        this.getContentHandler().setDocumentLocator(this);
                        this.getContentHandler().startDocument();
                        while (reader.hasNext()) {
                            this.parse(reader);
                        }
                        this.getContentHandler().endDocument();
                        break;
                    }
                    case 4: 
                    case 6: {
                        String text2 = event.asCharacters().getData();
                        this.getContentHandler().characters(text2.toCharArray(), 0, text2.length());
                        break;
                    }
                    case 12: {
                        char[] cdata = event.asCharacters().getData().toCharArray();
                        if (this.getLexicalHandler() != null) {
                            this.getLexicalHandler().startCDATA();
                            this.getContentHandler().characters(cdata, 0, cdata.length);
                            this.getLexicalHandler().endCDATA();
                            break;
                        }
                        this.getContentHandler().characters(cdata, 0, cdata.length);
                        break;
                    }
                    case 1: {
                        String prefix2;
                        StartElement eleEvent = (StartElement)event;
                        ArrayList<String> pushedPrefixes = new ArrayList<String>();
                        AttributesImpl attrs = new AttributesImpl();
                        Iterator<Attribute> itr = eleEvent.getNamespaces();
                        while (itr.hasNext()) {
                            Namespace nms = itr.next();
                            String uriAttr = nms.getNamespaceURI();
                            prefix2 = nms.getPrefix();
                            if (!this.startPrefixMapping(prefix2, uriAttr)) continue;
                            pushedPrefixes.add(prefix2);
                        }
                        itr = eleEvent.getAttributes();
                        while (itr.hasNext()) {
                            this.m_attributes.add(itr.next());
                        }
                        QName qname2 = eleEvent.getName();
                        String uri2 = qname2.getNamespaceURI();
                        String localName2 = qname2.getLocalPart();
                        prefix2 = qname2.getPrefix();
                        if (uri2 != null && !uri2.equals("") && this.startPrefixMapping(prefix2, uri2)) {
                            pushedPrefixes.add(prefix2);
                        }
                        String qnameString = prefix2.equals("") ? localName2 : prefix2 + ":" + localName2;
                        this.getContentHandler().startElement(uri2, localName2, qnameString, this);
                        this.m_attributes.clear();
                        while (reader.hasNext() && reader.peek().getEventType() != 2) {
                            this.parse(reader);
                        }
                        reader.nextEvent();
                        this.getContentHandler().endElement(uri2, localName2, qnameString);
                        int nPushedPrefixes = pushedPrefixes.size();
                        for (int i = 0; i < nPushedPrefixes; ++i) {
                            this.endPrefixMapping((String)pushedPrefixes.get(i));
                        }
                        break;
                    }
                    case 5: {
                        if (this.getLexicalHandler() == null) break;
                        String value2 = ((Comment)event).getText();
                        this.getLexicalHandler().comment(value2.toCharArray(), 0, value2.length());
                        break;
                    }
                    case 3: {
                        ProcessingInstruction piEvent = (ProcessingInstruction)event;
                        this.getContentHandler().processingInstruction(piEvent.getTarget(), piEvent.getData());
                        break;
                    }
                    case 11: {
                        if (this.getDTDHandler() == null) break;
                        List l = (List)reader.getProperty("javax.xml.stream.entities");
                        for (XMLEvent evt : l) {
                            if (evt.getEventType() != 15) continue;
                            EntityDeclaration entity2 = (EntityDeclaration)evt;
                            this.getDTDHandler().unparsedEntityDecl(entity2.getName(), entity2.getPublicId(), entity2.getSystemId(), entity2.getNotationName());
                        }
                        break;
                    }
                }
            }
            catch (XMLStreamException e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public int getIndex(String qName) {
        if (qName == null) {
            return -1;
        }
        Iterator itr = this.m_attributes.iterator();
        Attribute att = null;
        int index2 = 0;
        while (itr.hasNext()) {
            String aName;
            att = (Attribute)itr.next();
            QName aQName = att.getName();
            String aLocalName = aQName.getLocalPart();
            String aPrefix = aQName.getPrefix();
            String string2 = aName = aPrefix == null || aPrefix.equals("") ? aLocalName : aPrefix + ":" + aLocalName;
            if (aName != null && aName.equals(qName)) {
                return index2;
            }
            ++index2;
        }
        return -1;
    }

    @Override
    public int getIndex(String uri2, String localName2) {
        Iterator itr = this.m_attributes.iterator();
        Attribute att = null;
        int index2 = 0;
        while (itr.hasNext()) {
            att = (Attribute)itr.next();
            QName aQName = att.getName();
            String aLocalName = aQName.getLocalPart();
            String aURI = aQName.getNamespaceURI();
            if (uri2 == null && aURI == null && localName2 != null && localName2.equals(aLocalName)) {
                return index2;
            }
            if (aURI != null && aURI.equals(uri2) && aLocalName != null && aLocalName.equals(localName2)) {
                return index2;
            }
            ++index2;
        }
        return -1;
    }

    @Override
    public int getLength() {
        return this.m_attributes.size();
    }

    @Override
    public String getLocalName(int index2) {
        if (index2 < 0 || index2 >= this.getLength()) {
            return null;
        }
        Attribute att = (Attribute)this.m_attributes.get(index2);
        return att.getName().getLocalPart();
    }

    @Override
    public String getQName(int index2) {
        if (index2 < 0 || index2 >= this.getLength()) {
            return null;
        }
        QName qname2 = ((Attribute)this.m_attributes.get(index2)).getName();
        String prefix2 = qname2.getPrefix();
        String localName2 = qname2.getLocalPart();
        return prefix2 == null || prefix2.equals("") ? localName2 : prefix2 + ":" + localName2;
    }

    @Override
    public String getType(int index2) {
        if (index2 < 0 || index2 >= this.getLength()) {
            return null;
        }
        return ((Attribute)this.m_attributes.get(index2)).getDTDType();
    }

    @Override
    public String getType(String qName) {
        int index2 = this.getIndex(qName);
        return index2 > 0 ? this.getType(index2) : null;
    }

    @Override
    public String getType(String uri2, String localName2) {
        int index2 = this.getIndex(uri2, localName2);
        return index2 > 0 ? this.getType(index2) : null;
    }

    @Override
    public String getURI(int index2) {
        if (index2 < 0 || index2 >= this.getLength()) {
            return null;
        }
        Attribute att = (Attribute)this.m_attributes.get(index2);
        return att.getName().getNamespaceURI();
    }

    @Override
    public String getValue(int index2) {
        if (index2 < 0 || index2 >= this.getLength()) {
            return null;
        }
        Attribute att = (Attribute)this.m_attributes.get(index2);
        return att.getValue();
    }

    @Override
    public String getValue(String qName) {
        int index2 = this.getIndex(qName);
        return index2 > 0 ? this.getValue(index2) : null;
    }

    @Override
    public String getValue(String uri2, String localName2) {
        int index2 = this.getIndex(uri2, localName2);
        return index2 > 0 ? this.getValue(index2) : null;
    }
}

