/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.common.utils;

import com.ibm.xltxe.rnm1.xtq.common.utils.StAX2SAX;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.EntityDeclaration;
import javax.xml.stream.events.XMLEvent;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class STAXStream2SAX
extends StAX2SAX {
    private XMLStreamReader m_streamReader = null;

    public STAXStream2SAX(XMLStreamReader reader) {
        this.m_streamReader = reader;
    }

    @Override
    public void parse(InputSource unused) throws IOException, SAXException {
        try {
            if (this.m_streamReader != null && this.m_streamReader.hasNext()) {
                this.parse(this.m_streamReader, this.m_streamReader.getEventType());
            }
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    private void parse(XMLStreamReader reader, int type2) throws IOException, SAXException {
        try {
            switch (type2) {
                case 7: {
                    this.setLocation(reader.getLocation());
                    this.setXMLVersion(reader.getVersion());
                    this.getContentHandler().setDocumentLocator(this);
                    this.getContentHandler().startDocument();
                    while (reader.hasNext()) {
                        this.parse(reader, reader.next());
                    }
                    this.getContentHandler().endDocument();
                    break;
                }
                case 4: 
                case 6: {
                    String text2 = reader.getText();
                    this.getContentHandler().characters(text2.toCharArray(), 0, text2.length());
                    break;
                }
                case 12: {
                    int len = reader.getTextLength();
                    char[] cdata = new char[len];
                    reader.getTextCharacters(reader.getTextStart(), cdata, 0, len);
                    if (this.getLexicalHandler() != null) {
                        this.getLexicalHandler().startCDATA();
                        this.getContentHandler().characters(cdata, 0, cdata.length);
                        this.getLexicalHandler().endCDATA();
                        break;
                    }
                    this.getContentHandler().characters(cdata, 0, cdata.length);
                    break;
                }
                case 1: {
                    int nextType;
                    String prefix2;
                    ArrayList<String> pushedPrefixes = new ArrayList<String>();
                    AttributesImpl attrs = new AttributesImpl();
                    int length2 = reader.getNamespaceCount();
                    for (int i = 0; i < length2; ++i) {
                        String uriAttr = reader.getNamespaceURI(i);
                        prefix2 = reader.getNamespacePrefix(i);
                        if (!this.startPrefixMapping(prefix2, uriAttr)) continue;
                        pushedPrefixes.add(prefix2);
                    }
                    String uri2 = reader.getNamespaceURI();
                    String localName2 = reader.getLocalName();
                    prefix2 = reader.getPrefix();
                    if (uri2 != null) {
                        if (!uri2.equals("") && this.startPrefixMapping(prefix2, uri2)) {
                            pushedPrefixes.add(prefix2);
                        }
                    } else {
                        uri2 = "";
                    }
                    String qname2 = prefix2 == null || prefix2.equals("") ? localName2 : prefix2 + ":" + localName2;
                    this.getContentHandler().startElement(uri2, localName2, qname2, this);
                    while (reader.hasNext() && (nextType = reader.next()) != 2) {
                        this.parse(reader, nextType);
                    }
                    this.getContentHandler().endElement(uri2, localName2, qname2);
                    int nPushedPrefixes = pushedPrefixes.size();
                    for (int i = 0; i < nPushedPrefixes; ++i) {
                        this.endPrefixMapping((String)pushedPrefixes.get(i));
                    }
                    break;
                }
                case 5: {
                    if (this.getLexicalHandler() == null) break;
                    int len = reader.getTextLength();
                    char[] value2 = new char[len];
                    reader.getTextCharacters(reader.getTextStart(), value2, 0, len);
                    this.getLexicalHandler().comment(value2, 0, len);
                    break;
                }
                case 3: {
                    this.getContentHandler().processingInstruction(reader.getPITarget(), reader.getPIData());
                    break;
                }
                case 11: {
                    if (this.getDTDHandler() == null) break;
                    List l = (List)reader.getProperty("javax.xml.stream.entities");
                    for (XMLEvent evt : l) {
                        if (evt.getEventType() != 15) continue;
                        EntityDeclaration entity2 = (EntityDeclaration)evt;
                        this.getDTDHandler().unparsedEntityDecl(entity2.getName(), entity2.getPublicId(), entity2.getSystemId(), entity2.getNotationName());
                    }
                    break;
                }
            }
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public int getIndex(String qName) {
        for (int i = 0; i < this.getLength(); ++i) {
            String aQName;
            String aLocalName = this.m_streamReader.getAttributeLocalName(i);
            String aPrefix = this.m_streamReader.getAttributePrefix(i);
            String string2 = aQName = aPrefix == null || aPrefix.equals("") ? aLocalName : aPrefix + ":" + aLocalName;
            if (aQName == null || !aQName.equals(qName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getIndex(String uri2, String localName2) {
        for (int i = 0; i < this.getLength(); ++i) {
            String aLocalName = this.m_streamReader.getAttributeLocalName(i);
            String aURI = this.m_streamReader.getAttributeNamespace(i);
            if (uri2 == null && aURI == null && localName2 != null && localName2.equals(aLocalName)) {
                return i;
            }
            if (aURI == null || !aURI.equals(uri2) || aLocalName == null || !aLocalName.equals(localName2)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getLength() {
        return this.m_streamReader.getAttributeCount();
    }

    @Override
    public String getLocalName(int index2) {
        return this.m_streamReader.getAttributeLocalName(index2);
    }

    @Override
    public String getQName(int index2) {
        String prefix2 = this.m_streamReader.getAttributePrefix(index2);
        String localName2 = this.m_streamReader.getAttributeLocalName(index2);
        return prefix2 == null || prefix2.equals("") ? localName2 : prefix2 + ":" + localName2;
    }

    @Override
    public String getType(int index2) {
        return this.m_streamReader.getAttributeType(index2);
    }

    @Override
    public String getType(String qName) {
        int index2 = this.getIndex(qName);
        return index2 > 0 ? this.getType(index2) : null;
    }

    @Override
    public String getType(String uri2, String localName2) {
        int index2 = this.getIndex(uri2, localName2);
        return index2 > 0 ? this.getType(index2) : null;
    }

    @Override
    public String getURI(int index2) {
        return this.m_streamReader.getAttributeNamespace(index2);
    }

    @Override
    public String getValue(int index2) {
        return this.m_streamReader.getAttributeValue(index2);
    }

    @Override
    public String getValue(String qName) {
        int index2 = this.getIndex(qName);
        return index2 > 0 ? this.getValue(index2) : null;
    }

    @Override
    public String getValue(String uri2, String localName2) {
        return this.m_streamReader.getAttributeValue(uri2, localName2);
    }
}

