/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.common.utils;

import com.ibm.xltxe.rnm1.xtq.common.utils.ArrayListToReplaceVector;
import com.ibm.xltxe.rnm1.xtq.common.utils.IntVector;

public class SparseVector {
    ArrayListToReplaceVector m_values;
    IntVector m_keys;
    static final int HASHPRIME = 101;
    int[] m_hashStart = new int[101];
    IntVector m_hashChain;
    static final int NULL = -1;

    public SparseVector() {
        this.m_values = new ArrayListToReplaceVector();
        this.m_keys = new IntVector();
        this.m_hashChain = new IntVector(512);
        this.removeAllElements();
    }

    public void removeAllElements() {
        this.m_values.clear();
        this.m_keys.removeAllElements();
        for (int i = 0; i < 101; ++i) {
            this.m_hashStart[i] = -1;
        }
        this.m_hashChain.removeAllElements();
    }

    public Object elementAt(int index2) {
        int hashlast;
        int hashslot = index2 % 101;
        if (hashslot < 0) {
            hashslot = -hashslot;
        }
        int hashcandidate = hashlast = this.m_hashStart[hashslot];
        while (hashcandidate != -1) {
            if (this.m_keys.elementAt(hashcandidate) == index2) {
                Object ret = this.m_values.get(hashcandidate);
                return ret;
            }
            hashlast = hashcandidate;
            hashcandidate = this.m_hashChain.elementAt(hashcandidate);
        }
        return null;
    }

    public Object setElementAt(Object value2, int index2) {
        int hashlast;
        int hashslot = index2 % 101;
        if (hashslot < 0) {
            hashslot = -hashslot;
        }
        int hashcandidate = hashlast = this.m_hashStart[hashslot];
        while (hashcandidate != -1) {
            if (this.m_keys.elementAt(hashcandidate) == index2) {
                Object ret = this.m_values.get(hashcandidate);
                this.m_values.set(hashcandidate, value2);
                return ret;
            }
            hashlast = hashcandidate;
            hashcandidate = this.m_hashChain.elementAt(hashcandidate);
        }
        if (value2 != null) {
            int newIndex = this.m_values.size();
            this.m_values.add(value2);
            this.m_keys.addElement(index2);
            this.m_hashChain.addElement(-1);
            if (hashlast == -1) {
                this.m_hashStart[hashslot] = newIndex;
            } else {
                this.m_hashChain.setElementAt(newIndex, hashlast);
            }
        }
        return null;
    }
}

