/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.common.utils;

import com.ibm.xltxe.rnm1.xtq.common.utils.URI;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;

public final class SystemIDResolver {
    public static String getAbsoluteURIFromRelative(String localPath) {
        String urlString;
        if (localPath == null) {
            localPath = "";
        }
        String absolutePath = localPath;
        if (!SystemIDResolver.isAbsolutePath(localPath)) {
            try {
                absolutePath = SystemIDResolver.getAbsolutePathFromRelativePath(localPath);
            }
            catch (SecurityException se) {
                return "file:" + localPath;
            }
        }
        if (null != absolutePath) {
            urlString = absolutePath.startsWith(File.separator) ? "file://" + absolutePath : "file:///" + absolutePath;
            if (localPath.endsWith(File.separator) && !absolutePath.endsWith(File.separator)) {
                urlString = urlString + File.separator;
            }
        } else {
            urlString = "file:" + localPath;
        }
        return SystemIDResolver.replaceChars(urlString);
    }

    private static String getAbsolutePathFromRelativePath(String relativePath) {
        String userDirURI = (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return System.getProperty("user.dir");
            }
        });
        char separator = File.separatorChar;
        userDirURI = userDirURI.replace(separator, '/');
        relativePath = relativePath.replace(separator, '/');
        userDirURI = userDirURI.endsWith("/") ? userDirURI : userDirURI + '/';
        String absoluteURI = userDirURI + relativePath;
        return absoluteURI;
    }

    public static boolean isAbsoluteURI(String systemId) {
        int colonIndex = systemId.indexOf(58);
        if (colonIndex > 1) {
            return SystemIDResolver.checkScheme(systemId, colonIndex);
        }
        if (SystemIDResolver.isWindowsAbsolutePath(systemId)) {
            return false;
        }
        return SystemIDResolver.checkScheme(systemId, colonIndex);
    }

    private static boolean checkScheme(String systemId, int colonIndex) {
        int fragmentIndex = systemId.indexOf(35);
        int queryIndex = systemId.indexOf(63);
        int slashIndex = systemId.indexOf(47);
        int index2 = systemId.length() - 1;
        if (fragmentIndex > 0) {
            index2 = fragmentIndex;
        }
        if (queryIndex > 0 && queryIndex < index2) {
            index2 = queryIndex;
        }
        if (slashIndex > 0 && slashIndex < index2) {
            index2 = slashIndex;
        }
        return colonIndex > 0 && colonIndex < index2;
    }

    public static boolean isAbsolutePath(String systemId) {
        if (systemId == null) {
            return false;
        }
        File file = new File(systemId);
        return file.isAbsolute();
    }

    private static boolean isWindowsAbsolutePath(String systemId) {
        if (!SystemIDResolver.isAbsolutePath(systemId)) {
            return false;
        }
        return systemId.length() > 2 && systemId.charAt(1) == ':' && Character.isLetter(systemId.charAt(0)) && (systemId.charAt(2) == '\\' || systemId.charAt(2) == '/');
    }

    private static String replaceChars(String str) {
        StringBuffer buf = new StringBuffer(str);
        int length2 = buf.length();
        for (int i = 0; i < length2; ++i) {
            char currentChar = buf.charAt(i);
            if (currentChar == ' ') {
                buf.setCharAt(i, '%');
                buf.insert(i + 1, "20");
                length2 += 2;
                i += 2;
                continue;
            }
            if (currentChar != '\\') continue;
            buf.setCharAt(i, '/');
        }
        return buf.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getAbsoluteURI(String systemId) {
        int secondColonIndex;
        String absoluteURI = systemId;
        if (!SystemIDResolver.isAbsoluteURI(systemId)) return SystemIDResolver.getAbsoluteURIFromRelative(systemId);
        if (!systemId.startsWith("file:")) return systemId;
        String str = systemId.substring(5);
        if (str == null || !str.startsWith("/")) return SystemIDResolver.getAbsoluteURIFromRelative(systemId.substring(5));
        if (!str.startsWith("///") && str.startsWith("//") || (secondColonIndex = systemId.indexOf(58, 5)) <= 0) return SystemIDResolver.replaceChars(absoluteURI);
        String localPath = systemId.substring(secondColonIndex - 1);
        try {
            if (SystemIDResolver.isAbsolutePath(localPath)) return SystemIDResolver.replaceChars(absoluteURI);
            absoluteURI = systemId.substring(0, secondColonIndex - 1) + SystemIDResolver.getAbsolutePathFromRelativePath(localPath);
            return SystemIDResolver.replaceChars(absoluteURI);
        }
        catch (SecurityException se) {
            return systemId;
        }
    }

    public static String getAbsoluteURI(String urlString, String base2) throws URI.MalformedURIException {
        if (base2 == null) {
            return SystemIDResolver.getAbsoluteURI(urlString);
        }
        String absoluteBase = SystemIDResolver.getAbsoluteURI(base2);
        URI uri2 = null;
        URI baseURI = new URI(absoluteBase);
        uri2 = new URI(baseURI, urlString);
        return SystemIDResolver.replaceChars(uri2.toString());
    }
}

