/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.common.utils;

import com.ibm.xltxe.rnm1.xtq.common.utils.XML11Char;
import com.ibm.xltxe.rnm1.xtq.common.utils.res.XMLMessages;
import java.io.IOException;

public class URI {
    private static final String RESERVED_CHARACTERS = ";/?:@&=+$,";
    private static final String MARK_CHARACTERS = "-_.!~*'() ";
    private static final String SCHEME_CHARACTERS = "+-.";
    private static final String USERINFO_CHARACTERS = ";:&=+$,";
    private static final String REG_NAME_CHARACTERS = ";:&=+$,@";
    private String m_scheme = null;
    private String m_userinfo = null;
    private String m_reg_name = null;
    private String m_host = null;
    private int m_port = -1;
    private String m_path = null;
    private String m_queryString = null;
    private String m_fragment = null;
    private static boolean DEBUG = false;

    public URI() {
    }

    public URI(URI p_other) {
        this.initialize(p_other);
    }

    public URI(String p_uriSpec) throws MalformedURIException {
        this((URI)null, p_uriSpec);
    }

    public URI(URI p_base, String p_uriSpec) throws MalformedURIException {
        this.initialize(p_base, p_uriSpec);
    }

    public URI(String p_scheme, String p_schemeSpecificPart) throws MalformedURIException {
        if (p_scheme == null || p_scheme.trim().length() == 0) {
            throw new MalformedURIException(XMLMessages.createXMLMessage("ER_SCHEME_REQUIRED", null));
        }
        if (p_schemeSpecificPart == null || p_schemeSpecificPart.trim().length() == 0) {
            throw new MalformedURIException(XMLMessages.createXMLMessage("ERR_URI_SCHEME_SPEC", null));
        }
        this.setScheme(p_scheme);
        this.setPath(p_schemeSpecificPart);
    }

    public URI(String p_scheme, String p_host, String p_path, String p_queryString, String p_fragment) throws MalformedURIException {
        this(p_scheme, null, p_host, -1, p_path, p_queryString, p_fragment);
    }

    public URI(String p_scheme, String p_userinfo, String p_host, int p_port, String p_path, String p_queryString, String p_fragment) throws MalformedURIException {
        if (p_scheme == null || p_scheme.trim().length() == 0) {
            throw new MalformedURIException(XMLMessages.createXMLMessage("ER_SCHEME_REQUIRED", null));
        }
        if (p_host == null) {
            if (p_userinfo != null) {
                throw new MalformedURIException(XMLMessages.createXMLMessage("ER_NO_USERINFO_IF_NO_HOST", null));
            }
            if (p_port != -1) {
                throw new MalformedURIException(XMLMessages.createXMLMessage("ER_NO_PORT_IF_NO_HOST", null));
            }
        }
        if (p_path != null) {
            if (p_path.indexOf(63) != -1 && p_queryString != null) {
                throw new MalformedURIException(XMLMessages.createXMLMessage("ER_NO_QUERY_STRING_IN_PATH", null));
            }
            if (p_path.indexOf(35) != -1 && p_fragment != null) {
                throw new MalformedURIException(XMLMessages.createXMLMessage("ER_NO_FRAGMENT_STRING_IN_PATH", null));
            }
        }
        this.setScheme(p_scheme);
        this.setHost(p_host);
        this.setPort(p_port);
        this.setUserinfo(p_userinfo);
        this.setPath(p_path);
        this.setQueryString(p_queryString);
        this.setFragment(p_fragment);
    }

    private void initialize(URI p_other) {
        this.m_scheme = p_other.getScheme();
        this.m_userinfo = p_other.getUserinfo();
        this.m_host = p_other.getHost();
        this.m_port = p_other.getPort();
        this.m_reg_name = p_other.getRegistryName();
        this.m_path = p_other.getPath();
        this.m_queryString = p_other.getQueryString();
        this.m_fragment = p_other.getFragment();
    }

    private void initialize(URI p_base, String p_uriSpec) throws MalformedURIException {
        if (p_base == null && (p_uriSpec == null || p_uriSpec.trim().length() == 0)) {
            throw new MalformedURIException(XMLMessages.createXMLMessage("ER_CANNOT_INIT_URI_EMPTY_PARMS", null));
        }
        if (p_uriSpec == null || p_uriSpec.trim().length() == 0) {
            this.initialize(p_base);
            this.setFragment(null);
            return;
        }
        String uriSpec = p_uriSpec.trim();
        int uriSpecLen = uriSpec.length();
        int index2 = 0;
        int colonIndex = uriSpec.indexOf(58);
        if (colonIndex < 0) {
            if (p_base == null) {
                throw new MalformedURIException(XMLMessages.createXMLMessage("ER_NO_SCHEME_IN_URI", new Object[]{uriSpec}));
            }
        } else {
            this.initializeScheme(uriSpec);
            uriSpec = uriSpec.substring(colonIndex + 1);
            if (!(this.m_scheme == null || p_base == null || !uriSpec.startsWith("/") && this.m_scheme.equals(p_base.m_scheme) && p_base.getSchemeSpecificPart().startsWith("/"))) {
                p_base = null;
            }
            uriSpecLen = uriSpec.length();
        }
        if (index2 + 1 < uriSpecLen && uriSpec.substring(index2).startsWith("//")) {
            int startPos = index2 += 2;
            char testChar = '\u0000';
            while (index2 < uriSpecLen && (testChar = uriSpec.charAt(index2)) != '/' && testChar != '?' && testChar != '#') {
                ++index2;
            }
            if (index2 > startPos) {
                this.initializeAuthority(uriSpec.substring(startPos, index2));
            } else {
                this.m_host = "";
            }
        }
        this.initializePath(uriSpec.substring(index2));
        if (p_base != null) {
            int lastSlash;
            if (this.m_path.length() == 0 && this.m_scheme == null && this.m_host == null) {
                this.m_scheme = p_base.getScheme();
                this.m_userinfo = p_base.getUserinfo();
                this.m_host = p_base.getHost();
                this.m_port = p_base.getPort();
                this.m_reg_name = p_base.getRegistryName();
                this.m_path = p_base.getPath();
                if (this.m_queryString == null) {
                    this.m_queryString = p_base.getQueryString();
                }
                return;
            }
            if (this.m_scheme == null) {
                this.m_scheme = p_base.getScheme();
            }
            if (this.m_host != null || this.m_reg_name != null) {
                return;
            }
            this.m_userinfo = p_base.getUserinfo();
            this.m_host = p_base.getHost();
            this.m_port = p_base.getPort();
            this.m_reg_name = p_base.getRegistryName();
            if (this.m_path.length() > 0 && this.m_path.startsWith("/")) {
                return;
            }
            String path2 = new String();
            String basePath = p_base.getPath();
            if (basePath != null && (lastSlash = basePath.lastIndexOf(47)) != -1) {
                path2 = basePath.substring(0, lastSlash + 1);
            }
            path2 = path2.concat(this.m_path);
            if (p_base.isGenericURI() && path2.length() > 0 && path2.charAt(0) != '/') {
                path2 = "/".concat(path2);
            }
            index2 = -1;
            while ((index2 = path2.indexOf("/./")) != -1) {
                path2 = path2.substring(0, index2 + 1).concat(path2.substring(index2 + 3));
            }
            if (path2.endsWith("/.")) {
                path2 = path2.substring(0, path2.length() - 1);
            }
            index2 = -1;
            int segIndex = -1;
            String tempString = null;
            while ((index2 = path2.indexOf("/../")) >= 0) {
                tempString = path2.substring(0, path2.indexOf("/../"));
                segIndex = tempString.lastIndexOf(47);
                if (segIndex < 0) {
                    segIndex = 0;
                }
                path2 = path2.substring(0, segIndex).concat(path2.substring(index2 + 3));
            }
            if (path2.endsWith("/..") && (segIndex = (tempString = path2.substring(0, path2.length() - 3)).lastIndexOf(47)) != -1) {
                path2 = path2.substring(0, segIndex + 1);
            }
            this.m_path = path2;
        }
    }

    private void initializeScheme(String p_uriSpec) throws MalformedURIException {
        int index2;
        int uriSpecLen = p_uriSpec.length();
        String scheme = null;
        char testChar = '\u0000';
        for (index2 = 0; index2 < uriSpecLen && (testChar = p_uriSpec.charAt(index2)) != ':' && testChar != '/' && testChar != '?' && testChar != '#'; ++index2) {
        }
        scheme = p_uriSpec.substring(0, index2);
        if (scheme.length() == 0) {
            throw new MalformedURIException(XMLMessages.createXMLMessage("ER_NO_SCHEME_IN_URI", new Object[]{p_uriSpec}));
        }
        this.setScheme(scheme);
    }

    private void initializeAuthority(String p_uriSpec) throws MalformedURIException {
        int index2;
        int start = 0;
        int end = p_uriSpec.length();
        char testChar = '\u0000';
        String userinfo = null;
        if (p_uriSpec.indexOf(64, start) != -1) {
            for (index2 = 0; index2 < end && (testChar = p_uriSpec.charAt(index2)) != '@'; ++index2) {
            }
            userinfo = p_uriSpec.substring(start, index2);
            ++index2;
        }
        String host = null;
        start = index2;
        while (index2 < end && (testChar = p_uriSpec.charAt(index2)) != ':') {
            ++index2;
        }
        host = p_uriSpec.substring(start, index2);
        int port = -1;
        if (host.length() > 0 && testChar == ':') {
            start = ++index2;
            while (index2 < end) {
                ++index2;
            }
            String portStr = p_uriSpec.substring(start, index2);
            if (portStr.length() > 0) {
                for (int i = 0; i < portStr.length(); ++i) {
                    if (URI.isDigit(portStr.charAt(i))) continue;
                    throw new MalformedURIException(XMLMessages.createXMLMessage("ER_INVALID_PORT", new Object[]{portStr}));
                }
                try {
                    port = Integer.parseInt(portStr);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
        }
        if (!URI.isWellFormedAddress(host) || !URI.isValidPortNumber(port) || userinfo != null && URI.isValidUserinfo(userinfo) >= 0) {
            this.setRegistryName(p_uriSpec);
        } else {
            this.setHost(host);
            this.setPort(port);
            this.setUserinfo(userinfo);
        }
    }

    private void initializePath0(String p_uriSpec) throws MalformedURIException {
        int index2;
        if (p_uriSpec == null) {
            throw new MalformedURIException(XMLMessages.createXMLMessage("ERR_NULL_URI_SPEC", null));
        }
        int start = 0;
        int end = p_uriSpec.length();
        int testChar = 0;
        boolean isSurrogate = false;
        char highSurrogate = '\u0000';
        for (index2 = 0; index2 < end; ++index2) {
            testChar = p_uriSpec.charAt(index2);
            if (isSurrogate) {
                if (XML11Char.isLowSurrogate(testChar)) {
                    testChar = XML11Char.supplemental(highSurrogate, (char)testChar);
                    isSurrogate = false;
                } else {
                    throw new MalformedURIException(XMLMessages.createXMLMessage("ER_PATH_INVALID_CHAR", new Object[]{p_uriSpec, String.valueOf((char)testChar)}));
                }
            }
            if (XML11Char.isHighSurrogate(testChar)) {
                isSurrogate = true;
                highSurrogate = (char)testChar;
            }
            if (testChar == 63 || testChar == 35) break;
            if (testChar == 37) {
                if (index2 + 2 < end && URI.isHex(p_uriSpec.charAt(index2 + 1)) && URI.isHex(p_uriSpec.charAt(index2 + 2))) continue;
                throw new MalformedURIException(XMLMessages.createXMLMessage("ER_PATH_CONTAINS_INVALID_ESCAPE_SEQUENCE", new Object[]{p_uriSpec}));
            }
            if (URI.isReservedCharacter(testChar) || URI.isUnreservedCharacter(testChar) || URI.isIRICharacter(testChar) || 92 == testChar || isSurrogate) continue;
            throw new MalformedURIException(XMLMessages.createXMLMessage("ER_PATH_INVALID_CHAR", new Object[]{p_uriSpec, String.valueOf((char)testChar)}));
        }
        this.m_path = p_uriSpec.substring(start, index2);
        if (testChar == 63) {
            start = ++index2;
            while (index2 < end && (testChar = (int)p_uriSpec.charAt(index2)) != 35) {
                if (testChar == 37) {
                    if (index2 + 2 >= end || !URI.isHex(p_uriSpec.charAt(index2 + 1)) || !URI.isHex(p_uriSpec.charAt(index2 + 2))) {
                        throw new MalformedURIException(XMLMessages.createXMLMessage("ERR_QUERY_CONTAINS_INVALID_ESCAPE_CHAR", new Object[]{p_uriSpec.substring(start)}));
                    }
                } else if (!(URI.isReservedCharacter(testChar) || URI.isUnreservedCharacter(testChar) || URI.isIRICharacter(testChar))) {
                    throw new MalformedURIException(XMLMessages.createXMLMessage("ERR_QUERY_CONTAINS_INVALID_CHAR", new Object[]{p_uriSpec.substring(start), String.valueOf(testChar)}));
                }
                ++index2;
            }
            this.m_queryString = p_uriSpec.substring(start, index2);
        }
        if (testChar == 35) {
            start = ++index2;
            while (index2 < end) {
                testChar = p_uriSpec.charAt(index2);
                if (testChar == 37) {
                    if (index2 + 2 >= end || !URI.isHex(p_uriSpec.charAt(index2 + 1)) || !URI.isHex(p_uriSpec.charAt(index2 + 2))) {
                        throw new MalformedURIException(XMLMessages.createXMLMessage("ERR_FRAGMENT_CONTAINS_INVALID_ESCAPE_CHAR", new Object[]{p_uriSpec.substring(start)}));
                    }
                } else if (!(URI.isReservedCharacter(testChar) || URI.isUnreservedCharacter(testChar) || URI.isIRICharacter(testChar))) {
                    throw new MalformedURIException(XMLMessages.createXMLMessage("ERR_FRAGMENT_CONTAINS_INVALID_CHAR", new Object[]{p_uriSpec.substring(start), String.valueOf(testChar)}));
                }
                ++index2;
            }
            this.m_fragment = p_uriSpec.substring(start, index2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initializePath(String p_uriSpec) throws MalformedURIException {
        int index2;
        if (p_uriSpec == null) {
            throw new MalformedURIException(XMLMessages.createXMLMessage("ERR_NULL_URI_SPEC", null));
        }
        int start = 0;
        int testChar = 0;
        char highSurrogate = '\u0000';
        int end = p_uriSpec.length();
        for (index2 = 0; index2 < end; ++index2) {
            testChar = p_uriSpec.charAt(index2);
            if (XML11Char.isHighSurrogate(testChar)) {
                highSurrogate = (char)testChar;
                if (++index2 >= end || !XML11Char.isLowSurrogate(testChar = p_uriSpec.charAt(index2))) throw new MalformedURIException(XMLMessages.createXMLMessage("ER_PATH_INVALID_CHAR", new Object[]{p_uriSpec, String.valueOf((char)testChar)}));
                testChar = XML11Char.supplemental(highSurrogate, (char)testChar);
            } else {
                if (XML11Char.isLowSurrogate(testChar)) {
                    throw new MalformedURIException(XMLMessages.createXMLMessage("ER_PATH_INVALID_CHAR", new Object[]{p_uriSpec, String.valueOf((char)testChar)}));
                }
                if (testChar == 63 || testChar == 35) break;
            }
            if (testChar == 37) {
                if (index2 + 2 >= end || !URI.isHex(p_uriSpec.charAt(index2 + 1)) || !URI.isHex(p_uriSpec.charAt(index2 + 2))) {
                    throw new MalformedURIException(XMLMessages.createXMLMessage("ER_PATH_CONTAINS_INVALID_ESCAPE_SEQUENCE", new Object[]{p_uriSpec}));
                }
                index2 += 2;
                continue;
            }
            if (92 == testChar || URI.isReservedCharacter(testChar) || URI.isUnreservedCharacter(testChar) || URI.isIRICharacter(testChar)) continue;
            throw new MalformedURIException(XMLMessages.createXMLMessage("ER_PATH_INVALID_CHAR", new Object[]{p_uriSpec, String.valueOf((char)testChar)}));
        }
        this.m_path = p_uriSpec.substring(start, index2);
        if (testChar == 63) {
            start = ++index2;
            while (index2 < end && (testChar = p_uriSpec.charAt(index2)) != 35) {
                if (testChar == 37) {
                    if (index2 + 2 >= end || !URI.isHex(p_uriSpec.charAt(index2 + 1)) || !URI.isHex(p_uriSpec.charAt(index2 + 2))) {
                        throw new MalformedURIException(XMLMessages.createXMLMessage("ERR_QUERY_CONTAINS_INVALID_ESCAPE_CHAR", new Object[]{p_uriSpec.substring(start)}));
                    }
                } else if (!(URI.isReservedCharacter(testChar) || URI.isUnreservedCharacter(testChar) || URI.isIRICharacter(testChar))) {
                    throw new MalformedURIException(XMLMessages.createXMLMessage("ERR_QUERY_CONTAINS_INVALID_CHAR", new Object[]{p_uriSpec.substring(start), String.valueOf(testChar)}));
                }
                ++index2;
            }
            this.m_queryString = p_uriSpec.substring(start, index2);
        }
        if (testChar != 35) return;
        start = ++index2;
        while (index2 < end) {
            testChar = p_uriSpec.charAt(index2);
            if (testChar == 37) {
                if (index2 + 2 >= end || !URI.isHex(p_uriSpec.charAt(index2 + 1)) || !URI.isHex(p_uriSpec.charAt(index2 + 2))) {
                    throw new MalformedURIException(XMLMessages.createXMLMessage("ERR_FRAGMENT_CONTAINS_INVALID_ESCAPE_CHAR", new Object[]{p_uriSpec.substring(start)}));
                }
            } else if (!(URI.isReservedCharacter(testChar) || URI.isUnreservedCharacter(testChar) || URI.isIRICharacter(testChar))) {
                throw new MalformedURIException(XMLMessages.createXMLMessage("ERR_FRAGMENT_CONTAINS_INVALID_CHAR", new Object[]{p_uriSpec.substring(start), String.valueOf(testChar)}));
            }
            ++index2;
        }
        this.m_fragment = p_uriSpec.substring(start, index2);
    }

    public String getScheme() {
        return this.m_scheme;
    }

    public String getSchemeSpecificPart() {
        StringBuffer schemespec = new StringBuffer();
        if (this.m_userinfo != null || this.m_host != null || this.m_port != -1 || this.m_reg_name != null) {
            schemespec.append("//");
        }
        if (this.m_reg_name != null) {
            schemespec.append(this.m_reg_name);
        }
        if (this.m_userinfo != null) {
            schemespec.append(this.m_userinfo);
            schemespec.append('@');
        }
        if (this.m_host != null) {
            schemespec.append(this.m_host);
        }
        if (this.m_port != -1) {
            schemespec.append(':');
            schemespec.append(this.m_port);
        }
        if (this.m_path != null) {
            schemespec.append(this.m_path);
        }
        if (this.m_queryString != null) {
            schemespec.append('?');
            schemespec.append(this.m_queryString);
        }
        if (this.m_fragment != null) {
            schemespec.append('#');
            schemespec.append(this.m_fragment);
        }
        return schemespec.toString();
    }

    public String getUserinfo() {
        return this.m_userinfo;
    }

    public String getRegistryName() {
        return this.m_reg_name;
    }

    public String getHost() {
        return this.m_host;
    }

    public int getPort() {
        return this.m_port;
    }

    public String getPath(boolean p_includeQueryString, boolean p_includeFragment) {
        StringBuffer pathString = new StringBuffer(this.m_path);
        if (p_includeQueryString && this.m_queryString != null) {
            pathString.append('?');
            pathString.append(this.m_queryString);
        }
        if (p_includeFragment && this.m_fragment != null) {
            pathString.append('#');
            pathString.append(this.m_fragment);
        }
        return pathString.toString();
    }

    public String getPath() {
        return this.m_path;
    }

    public String getQueryString() {
        return this.m_queryString;
    }

    public String getFragment() {
        return this.m_fragment;
    }

    public void setScheme(String p_scheme) throws MalformedURIException {
        if (p_scheme == null || p_scheme.trim().length() == 0) {
            throw new MalformedURIException(XMLMessages.createXMLMessage("ER_SCHEME_REQUIRED", null));
        }
        if (!URI.isConformantSchemeName(p_scheme)) {
            throw new MalformedURIException(XMLMessages.createXMLMessage("ER_SCHEME_NOT_CONFORMANT", new Object[]{p_scheme}));
        }
        this.m_scheme = p_scheme;
    }

    public void setUserinfo(String p_userinfo) throws MalformedURIException {
        if (p_userinfo == null) {
            this.m_userinfo = null;
        } else {
            if (this.m_host == null) {
                throw new MalformedURIException(XMLMessages.createXMLMessage("ER_NO_USERINFO_IF_NO_HOST", null));
            }
            int checkResult = URI.isValidUserinfo(p_userinfo);
            if (checkResult == 0) {
                throw new MalformedURIException(XMLMessages.createXMLMessage("ERR_USERINFO_CONTAINS_INVALID_ESCAPE_CHAR", new Object[]{p_userinfo}));
            }
            if (checkResult > 0) {
                throw new MalformedURIException(XMLMessages.createXMLMessage("ERR_USERINFO_CONTAINS_INVALID_CHAR", new Object[]{p_userinfo, String.valueOf((char)checkResult)}));
            }
            this.m_userinfo = p_userinfo;
        }
    }

    public void setHost(String p_host) throws MalformedURIException {
        if (p_host == null || p_host.trim().length() == 0) {
            this.m_host = p_host;
            this.m_userinfo = null;
            this.m_port = -1;
            this.m_reg_name = null;
        } else if (!URI.isWellFormedAddress(p_host)) {
            throw new MalformedURIException(XMLMessages.createXMLMessage("ER_HOST_ADDRESS_NOT_WELLFORMED", new Object[]{p_host}));
        }
        this.m_host = p_host;
        this.m_reg_name = null;
    }

    public void setPort(int p_port) throws MalformedURIException {
        if (URI.isValidPortNumber(p_port)) {
            if (this.m_host == null) {
                throw new MalformedURIException(XMLMessages.createXMLMessage("ER_PORT_WHEN_HOST_NULL", null));
            }
        } else {
            throw new MalformedURIException(XMLMessages.createXMLMessage("ER_INVALID_PORT", new Object[]{p_port}));
        }
        this.m_port = p_port;
        this.m_port = p_port;
    }

    public void setRegistryName(String p_reg_name) throws MalformedURIException {
        if (p_reg_name == null) {
            this.m_reg_name = null;
        } else {
            int checkResult = URI.isValidRegistryName(p_reg_name);
            if (checkResult >= 0) {
                throw new MalformedURIException(XMLMessages.createXMLMessage("ER_REGISTRY_NAME_NOT_VALID", new Object[]{p_reg_name}));
            }
            this.m_reg_name = p_reg_name;
            this.m_host = null;
            this.m_userinfo = null;
            this.m_port = -1;
        }
    }

    public void setPath(String p_path) throws MalformedURIException {
        if (p_path == null) {
            this.m_path = null;
            this.m_queryString = null;
            this.m_fragment = null;
        } else {
            this.initializePath(p_path);
        }
    }

    public void appendPath(String p_addToPath) throws MalformedURIException {
        if (p_addToPath == null || p_addToPath.trim().length() == 0) {
            return;
        }
        if (!URI.isURIString(p_addToPath)) {
            throw new MalformedURIException(XMLMessages.createXMLMessage("ER_PATH_INVALID", new Object[]{p_addToPath}));
        }
        this.m_path = this.m_path == null || this.m_path.trim().length() == 0 ? (p_addToPath.startsWith("/") ? p_addToPath : "/" + p_addToPath) : (this.m_path.endsWith("/") ? (p_addToPath.startsWith("/") ? this.m_path.concat(p_addToPath.substring(1)) : this.m_path.concat(p_addToPath)) : (p_addToPath.startsWith("/") ? this.m_path.concat(p_addToPath) : this.m_path.concat("/" + p_addToPath)));
    }

    public void setQueryString(String p_queryString) throws MalformedURIException {
        if (p_queryString == null) {
            this.m_queryString = null;
        } else {
            if (!this.isGenericURI()) {
                throw new MalformedURIException(XMLMessages.createXMLMessage("ERR_NON_GENERIC_URI", null));
            }
            if (this.getPath() == null) {
                throw new MalformedURIException(XMLMessages.createXMLMessage("ERR_NULL_PATH_FOR_QUERY", null));
            }
            if (!URI.isURIString(p_queryString)) {
                throw new MalformedURIException(XMLMessages.createXMLMessage("ERR_QUERY_INVALID", new Object[]{p_queryString}));
            }
            this.m_queryString = p_queryString;
        }
    }

    public void setFragment(String p_fragment) throws MalformedURIException {
        if (p_fragment == null) {
            this.m_fragment = null;
        } else {
            if (!this.isGenericURI()) {
                throw new MalformedURIException(XMLMessages.createXMLMessage("ER_FRAG_FOR_GENERIC_URI", null));
            }
            if (this.getPath() == null) {
                throw new MalformedURIException(XMLMessages.createXMLMessage("ER_FRAG_WHEN_PATH_NULL", null));
            }
            if (!URI.isURIString(p_fragment)) {
                throw new MalformedURIException(XMLMessages.createXMLMessage("ER_FRAG_INVALID_CHAR", new Object[]{p_fragment}));
            }
            this.m_fragment = p_fragment;
        }
    }

    public boolean equals(Object p_test) {
        if (p_test instanceof URI) {
            URI testURI = (URI)p_test;
            if ((this.m_scheme == null && testURI.m_scheme == null || this.m_scheme != null && testURI.m_scheme != null && this.m_scheme.toLowerCase().equals(testURI.m_scheme.toLowerCase())) && (this.m_userinfo == null && testURI.m_userinfo == null || this.m_userinfo != null && testURI.m_userinfo != null && this.m_userinfo.equals(testURI.m_userinfo)) && (this.m_host == null && testURI.m_host == null || this.m_host != null && testURI.m_host != null && this.m_host.equals(testURI.m_host)) && (this.m_reg_name == null && testURI.m_reg_name == null || this.m_reg_name != null && testURI.m_reg_name != null && this.m_reg_name.equals(testURI.m_reg_name)) && this.m_port == testURI.m_port && (this.m_path == null && testURI.m_path == null || this.m_path != null && testURI.m_path != null && this.m_path.equals(testURI.m_path)) && (this.m_queryString == null && testURI.m_queryString == null || this.m_queryString != null && testURI.m_queryString != null && this.m_queryString.equals(testURI.m_queryString)) && (this.m_fragment == null && testURI.m_fragment == null || this.m_fragment != null && testURI.m_fragment != null && this.m_fragment.equals(testURI.m_fragment))) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer uriSpecString = new StringBuffer();
        if (this.m_scheme != null) {
            uriSpecString.append(this.m_scheme);
            uriSpecString.append(':');
        }
        uriSpecString.append(this.getSchemeSpecificPart());
        return uriSpecString.toString();
    }

    public boolean isGenericURI() {
        return this.m_host != null || this.m_reg_name != null;
    }

    public static boolean isConformantSchemeName(String p_scheme) {
        if (p_scheme == null || p_scheme.trim().length() == 0) {
            return false;
        }
        if (URI.isDigit(p_scheme.charAt(0)) || !URI.isAlpha(p_scheme.charAt(0))) {
            return false;
        }
        for (int i = 1; i < p_scheme.length(); ++i) {
            char testChar = p_scheme.charAt(i);
            if (URI.isAlphanum(testChar) || SCHEME_CHARACTERS.indexOf(testChar) != -1) continue;
            return false;
        }
        return true;
    }

    public static boolean isWellFormedAddress(String p_address) {
        if (p_address == null) {
            return false;
        }
        String address = p_address.trim();
        int addrLength = address.length();
        if (addrLength == 0 || addrLength > 255) {
            return false;
        }
        if (address.startsWith(".") || address.startsWith("-")) {
            return false;
        }
        int index2 = address.lastIndexOf(46);
        if (address.endsWith(".")) {
            index2 = address.substring(0, index2).lastIndexOf(46);
        }
        if (index2 + 1 < addrLength && URI.isDigit(p_address.charAt(index2 + 1))) {
            int numDots = 0;
            for (int i = 0; i < addrLength; ++i) {
                char testChar = address.charAt(i);
                if (testChar == '.') {
                    if (!URI.isDigit(address.charAt(i - 1)) || i + 1 < addrLength && !URI.isDigit(address.charAt(i + 1))) {
                        return false;
                    }
                    ++numDots;
                    continue;
                }
                if (URI.isDigit(testChar)) continue;
                return false;
            }
            if (numDots != 3) {
                return false;
            }
        } else {
            for (int i = 0; i < addrLength; ++i) {
                char testChar = address.charAt(i);
                if (testChar == '.') {
                    if (!URI.isAlphanum(address.charAt(i - 1))) {
                        return false;
                    }
                    if (i + 1 >= addrLength || URI.isAlphanum(address.charAt(i + 1))) continue;
                    return false;
                }
                if (URI.isAlphanum(testChar) || testChar == '-') continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isValidPortNumber(int p_port) {
        return p_port >= 0 && p_port <= 65535 || p_port == -1;
    }

    public static int isValidUserinfo(String p_userinfo) {
        return URI.isValidUserinfoOrRegistryName(p_userinfo, false);
    }

    public static int isValidRegistryName(String p_reg_name) {
        return URI.isValidUserinfoOrRegistryName(p_reg_name, true);
    }

    private static int isValidUserinfoOrRegistryName(String p_string, boolean is_reg_name) {
        int end = p_string.length();
        char testChar = '\u0000';
        for (int index2 = 0; index2 < end; ++index2) {
            testChar = p_string.charAt(index2);
            if (testChar == '%') {
                if (index2 + 2 < end && URI.isHex(p_string.charAt(index2 + 1)) && URI.isHex(p_string.charAt(index2 + 2))) continue;
                return 0;
            }
            if (URI.isUnreservedCharacter(testChar) || (is_reg_name || USERINFO_CHARACTERS.indexOf(testChar) != -1) && (!is_reg_name || REG_NAME_CHARACTERS.indexOf(testChar) != -1)) continue;
            return testChar;
        }
        return -1;
    }

    private static boolean isDigit(int p_char) {
        return p_char >= 48 && p_char <= 57;
    }

    private static boolean isHex(char p_char) {
        return URI.isDigit(p_char) || p_char >= 'a' && p_char <= 'f' || p_char >= 'A' && p_char <= 'F';
    }

    private static boolean isAlpha(int p_char) {
        return XML11Char.isXML11NCName(p_char);
    }

    private static boolean isAlphanum(int p_char) {
        return URI.isAlpha(p_char) || URI.isDigit(p_char);
    }

    private static boolean isReservedCharacter(int p_char) {
        return RESERVED_CHARACTERS.indexOf(p_char) != -1;
    }

    private static boolean isUnreservedCharacter(int p_char) {
        return URI.isAlphanum(p_char) || MARK_CHARACTERS.indexOf(p_char) != -1;
    }

    private static boolean isIRICharacter(int p_char) {
        return p_char >= 160 && p_char <= 55295 || p_char >= 63744 && p_char <= 64975 || p_char >= 65008 && p_char <= 65519 || p_char >= 57344 && p_char <= 63743 || p_char >= 983040 && p_char <= 1048573 || p_char >= 0x100000 && p_char <= 1114109;
    }

    private static boolean isURIString(String p_uric) {
        if (p_uric == null) {
            return false;
        }
        int end = p_uric.length();
        char testChar = '\u0000';
        for (int i = 0; i < end; ++i) {
            testChar = p_uric.charAt(i);
            if (testChar == '%') {
                if (i + 2 >= end || !URI.isHex(p_uric.charAt(i + 1)) || !URI.isHex(p_uric.charAt(i + 2))) {
                    return false;
                }
                i += 2;
                continue;
            }
            if (URI.isReservedCharacter(testChar) || URI.isUnreservedCharacter(testChar) || URI.isIRICharacter(testChar)) continue;
            return false;
        }
        return true;
    }

    public static class MalformedURIException
    extends IOException {
        private static final long serialVersionUID = -3880275380896996457L;

        public MalformedURIException() {
        }

        public MalformedURIException(String p_msg) {
            super(p_msg);
        }
    }
}

