/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.common.utils;

import com.ibm.icu.text.Normalizer;
import com.ibm.xltxe.rnm1.xtq.common.utils.UnicodeNormalizer;

public final class UnicodeNormalizerFactory {
    static final Class m_icu = UnicodeNormalizerFactory.init();

    private static Class init() {
        Class<?> c;
        try {
            c = Class.forName("com.ibm.icu.text.Normalizer");
        }
        catch (ClassNotFoundException e) {
            c = null;
        }
        return c;
    }

    private static boolean icuIsOnTheClassPath() {
        return m_icu != null;
    }

    public static final UnicodeNormalizer getUnicodeNormalizer() {
        UnicodeNormalizer un = UnicodeNormalizerFactory.icuIsOnTheClassPath() ? new UnicodeNormalizerICUImpl() : new UnicodeNormalizerDefaultImpl();
        return un;
    }

    private static class UnicodeNormalizerDefaultImpl
    implements UnicodeNormalizer {
        private UnicodeNormalizerDefaultImpl() {
        }

        @Override
        public boolean alreadyNormalized(int char32, int mode) {
            return true;
        }

        @Override
        public boolean alreadyNormalized(char[] src, int start, int limit, int mode) {
            return true;
        }

        @Override
        public boolean alreadyNormalized(String str, int mode) {
            return true;
        }

        @Override
        public String normalizeUnicode(int char32, int mode) {
            return null;
        }

        @Override
        public int normalizeUnicode(char[] src, int srcStart, int srcLimit, char[] dest, int destStart, int destLimit, int mode) {
            return 0;
        }

        @Override
        public String normalizeUnicode(String src, int mode) {
            return null;
        }
    }

    private static class UnicodeNormalizerICUImpl
    implements UnicodeNormalizer {
        final Normalizer.Mode getMode(int mode) {
            switch (mode) {
                case 2: {
                    return Normalizer.NFC;
                }
                case 3: {
                    return Normalizer.NFD;
                }
                case 4: {
                    return Normalizer.NFKC;
                }
                case 5: {
                    return Normalizer.NFKD;
                }
                case 1: {
                    return Normalizer.NONE;
                }
                case 6: {
                    return Normalizer.NFC;
                }
            }
            return Normalizer.NONE;
        }

        @Override
        public final boolean alreadyNormalized(int char32, int mode) {
            return Normalizer.isNormalized((int)char32, (Normalizer.Mode)this.getMode(mode), (int)0);
        }

        @Override
        public final boolean alreadyNormalized(char[] src, int start, int limit, int mode) {
            Normalizer.QuickCheckResult ans = Normalizer.quickCheck((char[])src, (int)start, (int)limit, (Normalizer.Mode)this.getMode(mode), (int)0);
            boolean normalized = ans == Normalizer.YES;
            return normalized;
        }

        @Override
        public final boolean alreadyNormalized(String str, int mode) {
            Normalizer.QuickCheckResult ans = Normalizer.quickCheck((String)str, (Normalizer.Mode)this.getMode(mode), (int)0);
            boolean normalized = ans == Normalizer.YES;
            return normalized;
        }

        @Override
        public final String normalizeUnicode(int char32, int mode) {
            return Normalizer.normalize((int)char32, (Normalizer.Mode)this.getMode(mode), (int)0);
        }

        @Override
        public final int normalizeUnicode(char[] src, int srcStart, int srcLimit, char[] dest, int destStart, int destLimit, int mode) {
            return Normalizer.normalize((char[])src, (int)srcStart, (int)srcLimit, (char[])dest, (int)destStart, (int)destLimit, (Normalizer.Mode)this.getMode(mode), (int)0);
        }

        @Override
        public final String normalizeUnicode(String src, int mode) {
            return Normalizer.normalize((String)src, (Normalizer.Mode)this.getMode(mode));
        }
    }
}

