/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.common.utils;

import com.ibm.xltxe.rnm1.xtq.common.utils.XML11Char;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.namespace.QName;

public final class Util {
    private static char filesep;
    public static final String EMPTYSTRING = "";
    private static final char ESCAPE_DELIM_CHAR = '$';

    public static String baseName(String name2) {
        int index2 = name2.lastIndexOf(92);
        if (index2 < 0) {
            index2 = name2.lastIndexOf(47);
        }
        if (index2 >= 0) {
            return name2.substring(index2 + 1);
        }
        int lastColonIndex = name2.lastIndexOf(58);
        if (lastColonIndex > 0) {
            return name2.substring(lastColonIndex + 1);
        }
        return name2;
    }

    public static String pathName(String name2) {
        int index2 = name2.lastIndexOf(47);
        if (index2 < 0) {
            index2 = name2.lastIndexOf(92);
        }
        return name2.substring(0, index2 + 1);
    }

    public static String toJavaInternalName(String name2) {
        int nameLength = name2.length();
        if (nameLength > 0) {
            StringBuilder result2 = new StringBuilder();
            char ch = name2.charAt(0);
            for (int i = 0; i < nameLength; ++i) {
                ch = name2.charAt(i);
                if (ch < '\u0100' && ch != '$' && (i == 0 && Character.isJavaIdentifierStart(ch) || i > 0 && Character.isJavaIdentifierPart(ch))) {
                    result2.append(ch);
                    continue;
                }
                result2.append('$');
                result2.append(Integer.toHexString(ch));
                result2.append('$');
            }
            return result2.toString();
        }
        return name2;
    }

    public static String internalName(String cname) {
        return cname.replace('.', filesep);
    }

    public static void println(String s) {
        System.out.println(s);
    }

    public static void println(char ch) {
        System.out.println(ch);
    }

    public static void TRACE1() {
        System.out.println("TRACE1");
    }

    public static void TRACE2() {
        System.out.println("TRACE2");
    }

    public static void TRACE3() {
        System.out.println("TRACE3");
    }

    public static String replace(String base2, char ch, String str) {
        return base2.indexOf(ch) < 0 ? base2 : Util.replace(base2, String.valueOf(ch), new String[]{str});
    }

    public static String replace(String base2, String delim, String[] str) {
        int len = base2.length();
        StringBuffer result2 = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            char ch = base2.charAt(i);
            int k = delim.indexOf(ch);
            if (k >= 0) {
                result2.append(str[k]);
                continue;
            }
            result2.append(ch);
        }
        return result2.toString();
    }

    public static String escape(String input) {
        return Util.replace(input, ".-/:", new String[]{"$dot$", "$dash$", "$slash$", "$colon$"});
    }

    public static String getLocalName(String qname2) {
        int index2 = qname2.lastIndexOf(":");
        return index2 > 0 ? qname2.substring(index2 + 1) : qname2;
    }

    public static String getPrefix(String qname2) {
        int index2 = qname2.lastIndexOf(":");
        return index2 > 0 ? qname2.substring(0, index2) : EMPTYSTRING;
    }

    public static boolean isLiteral(String str) {
        int length2 = str.length();
        for (int i = 0; i < length2 - 1; ++i) {
            if (str.charAt(i) != '{' || str.charAt(i + 1) == '{') continue;
            return false;
        }
        return true;
    }

    public static boolean isValidQNames(String str) {
        return Util.isValidQNames(str, new String[0]);
    }

    public static boolean isValidQNames(String str, String[] exceptions) {
        if (str != null && !str.equals(EMPTYSTRING)) {
            StringTokenizer tokens = Util.whitespaceTokenize(str);
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if (XML11Char.isXML11ValidQName(token)) continue;
                if (exceptions.length > 0) {
                    boolean found = false;
                    for (int i = 0; i < exceptions.length; ++i) {
                        if (!exceptions[i].equals(token)) continue;
                        found = true;
                    }
                    if (found) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    public static boolean isValidNCNames(String str) {
        return Util.isValidNCNames(str, new String[0]);
    }

    public static boolean isValidNCNames(String str, String[] exceptions) {
        if (str != null && !str.equals(EMPTYSTRING)) {
            StringTokenizer tokens = Util.whitespaceTokenize(str);
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if (XML11Char.isXML11ValidNCName(token)) continue;
                if (exceptions.length > 0) {
                    boolean found = false;
                    for (int i = 0; i < exceptions.length; ++i) {
                        if (!exceptions[i].equals(token)) continue;
                        found = true;
                    }
                    if (found) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    public static String trimWhitespace(String input) {
        char tmp;
        int i;
        if (input == null || input.equals(EMPTYSTRING)) {
            return input;
        }
        char[] chars = input.toCharArray();
        int len = chars.length;
        int start = 0;
        int end = len - 1;
        boolean isWhitespace = false;
        for (i = 0; i < len; ++i) {
            tmp = chars[i];
            if (tmp != '\t' && tmp != '\n' && tmp != '\r' && tmp != ' ') {
                start = i;
                break;
            }
            if (i != end) continue;
            isWhitespace = true;
        }
        if (isWhitespace) {
            return EMPTYSTRING;
        }
        for (i = end; i > 0; --i) {
            tmp = chars[i];
            if (tmp == '\t' || tmp == '\n' || tmp == '\r' || tmp == ' ') continue;
            end = i;
            break;
        }
        return input.substring(start, end + 1);
    }

    public static StringTokenizer whitespaceTokenize(String input) {
        return new StringTokenizer(input, " \t\n\r");
    }

    public static String getStringRep(QName qname2) {
        String prefix2 = qname2.getPrefix();
        String localname2 = qname2.getLocalPart();
        if (prefix2 != null && !prefix2.equals(EMPTYSTRING)) {
            String uri2 = qname2.getNamespaceURI();
            return prefix2 + ':' + localname2;
        }
        return localname2;
    }

    public static boolean containsInstance(Iterator iter, Object obj) throws NullPointerException {
        while (iter.hasNext()) {
            if (iter.next() != obj) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAllInstances(Vector vec, Vector objs) throws NullPointerException {
        for (int i = 0; i < objs.size(); ++i) {
            if (Util.containsInstance(vec.iterator(), objs.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    static {
        String temp = System.getProperty("file.separator", "/");
        filesep = temp.charAt(0);
    }
}

