/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.debug;

import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.exec.SourceLocation;
import com.ibm.xml.xci.exec.trace.ContextEvent;
import com.ibm.xml.xci.exec.trace.ContextGroupsEvent;
import com.ibm.xml.xci.exec.trace.ContextSequenceEvent;
import com.ibm.xml.xci.exec.trace.FunctionEvent;
import com.ibm.xml.xci.exec.trace.GenerateOutputEvent;
import com.ibm.xml.xci.exec.trace.InstructionEvent;
import com.ibm.xml.xci.exec.trace.JavaExtensionEvent;
import com.ibm.xml.xci.exec.trace.ModuleDecl;
import com.ibm.xml.xci.exec.trace.ModuleEvent;
import com.ibm.xml.xci.exec.trace.QueryEvent;
import com.ibm.xml.xci.exec.trace.TargetOutputEvent;
import com.ibm.xml.xci.exec.trace.TemplateEvent;
import com.ibm.xml.xci.exec.trace.TraceEvent;
import com.ibm.xml.xci.exec.trace.TraceListener;
import com.ibm.xml.xci.exec.trace.TransformationEvent;
import com.ibm.xml.xci.exec.trace.VariableEvent;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class DisplayTraceListener
implements TraceListener {
    private static final String START_TRANSFORMATION_PATTERN = "START transformation\n\tstylesheet = {0}";
    private static final String END_TRANSFORMATION_PATTERN = "END transformation\n\tstylesheet = {0}";
    private static final String START_QUERY_PATTERN = "START query\n\tquery = {0}";
    private static final String END_QUERY_PATTERN = "END query\n\tquery = {0}";
    private static final String MODULE_DECL_PATTERN = "module decl\n\tid = {0}\n\tmodule type = {1}\n\tnamespace = {2}\n\tURI = {3}\n\timports = {4}\n\t";
    private static final String MODULE_ENTRY_PATTERN = "ENTER module\n\tid = {0}\n\t";
    private static final String MODULE_EXIT_PATTERN = "EXIT module\n\tid = {0}\n\t";
    private static final String TEMPLATE_ENTRY_PATTERN = "ENTER template\n\ttemplate attributes:\n{0}\tstart location = source: ''{1}'', line: {2}, column: {3}\n\tend location = line: {4}, column: {5}\n\tstart offset = {6} end offset = {7}";
    private static final String TEMPLATE_EXIT_PATTERN = "EXIT template\n\ttemplate attributes:\n{0}\tstart location = source: ''{1}'', line: {2}, column: {3}\n\tend location = line: {4}, column: {5}\n\tstart offset = {6} end offset = {7}";
    private static final String FUNCTION_ENTRY_PATTERN = "ENTER function\n\tname = {0}\n\tstart location = source: ''{1}'', line: {2}, column: {3}\n\tend location = line: {4}, column: {5}\n\tstart offset = {6} end offset = {7}";
    private static final String FUNCTION_EXIT_PATTERN = "EXIT function\n\tname = {0}\n\tstart location = source: ''{1}'', line: {2}, column: {3}\n\tend location = line: {4}, column: {5}\n\tstart offset = {6} end offset = {7}";
    private static final String INSTRUCTION_START_PATTERN = "START instruction\n\tname = {0}\n\tstart location = source: ''{1}'', line: {2}, column: {3}\n\tend location = line: {4}, column: {5}\n\tstart offset = {6} end offset = {7}";
    private static final String INSTRUCTION_END_PATTERN = "END instruction\n\tname = {0}\n\tstart location = source: ''{1}'', line: {2}, column: {3}\n\tend location = line: {4}, column: {5}\n\tstart offset = {6} end offset = {7}";
    private static final String VARIABLE_START_PATTERN = "START variable\n\tname = {0}\n\tparameter = {1}\n\tglobal = {2}\n\ttype = {3}\n\tvalue = {4}";
    private static final String VARIABLE_END_PATTERN = "END variable\n\tname = {0}\n\tparameter = {1}\n\tglobal = {2}\n\ttype = {3}\n\tvalue = {4}";
    private static final String TARGET_OUTPUT_START_PATTERN = "START output\n\tURI = ''{0}''\n\tsystem identifier = ''{1}''\n\tmethod = ''{2}''\n\tappend = {3}";
    private static final String TARGET_OUTPUT_END_PATTERN = "END output\n\tURI = ''{0}''\n\tsystem identifier = ''{1}''\n\tmethod = ''{2}''\n\tappend = {3}";
    private static final String GENERATE_OUTPUT_PATTERN = "generate output\n\tcharacters = ''{0}''";
    private static final String JAVA_EXTENSION_START_PATTERN = "START Java extension\n\tclass = {0}\n\tmethod = {1}";
    private static final String JAVA_EXTENSION_END_PATTERN = "END Java extension\n\tclass = {0}\n\tmethod = {1}";
    private static final String CONTEXT_START_PATTERN = "START context\n\tcontext components:\n\t{0}";
    private static final String CONTEXT_END_PATTERN = "END context\n\tcontext components:\n\t{0}";

    @Override
    public void trace(TraceEvent event) {
        switch (event.getEventType()) {
            case 0: {
                TransformationEvent transformEvent = (TransformationEvent)event;
                String message = MessageFormat.format(START_TRANSFORMATION_PATTERN, transformEvent.getStylesheetURI());
                this.display(message);
                break;
            }
            case 1: {
                TransformationEvent transformEvent = (TransformationEvent)event;
                String message = MessageFormat.format(END_TRANSFORMATION_PATTERN, transformEvent.getStylesheetURI());
                this.display(message);
                break;
            }
            case 21: {
                QueryEvent queryEvent = (QueryEvent)event;
                String message = MessageFormat.format(START_QUERY_PATTERN, queryEvent.getQueryURI());
                this.display(message);
                Map<Integer, ModuleDecl> moduleDecls = queryEvent.getModuleDecls();
                for (Map.Entry<Integer, ModuleDecl> entry : moduleDecls.entrySet()) {
                    ModuleDecl moduleDecl = entry.getValue();
                    String moduleType = moduleDecl.isMainModule() ? "main" : "library";
                    StringBuilder builder = new StringBuilder();
                    builder.append('(');
                    Iterator<Integer> imports = moduleDecl.getImports().iterator();
                    boolean start = true;
                    while (imports.hasNext()) {
                        if (start) {
                            start = false;
                        } else {
                            builder.append(", ");
                        }
                        builder.append(imports.next());
                    }
                    builder.append(')');
                    message = MessageFormat.format(MODULE_DECL_PATTERN, entry.getKey(), moduleType, moduleDecl.getNamespace(), moduleDecl.getURI(), builder.toString());
                    this.display(message);
                }
                break;
            }
            case 22: {
                QueryEvent queryEvent = (QueryEvent)event;
                String message = MessageFormat.format(END_QUERY_PATTERN, queryEvent.getQueryURI());
                this.display(message);
                break;
            }
            case 23: {
                ModuleEvent moduleEvent = (ModuleEvent)event;
                String message = MessageFormat.format(MODULE_ENTRY_PATTERN, moduleEvent.getModuleId());
                this.display(message);
                break;
            }
            case 24: {
                ModuleEvent moduleEvent = (ModuleEvent)event;
                String message = MessageFormat.format(MODULE_EXIT_PATTERN, moduleEvent.getModuleId());
                this.display(message);
                break;
            }
            case 2: {
                TemplateEvent templateEvent = (TemplateEvent)event;
                Object[] messageParams = new Object[8];
                messageParams[0] = this.getTemplateAttributesString(templateEvent);
                this.addSourceLocationMessageParams(templateEvent.getTemplateSourceLocation(), 1, messageParams);
                String message = MessageFormat.format(TEMPLATE_ENTRY_PATTERN, messageParams);
                this.display(message);
                break;
            }
            case 3: {
                TemplateEvent templateEvent = (TemplateEvent)event;
                Object[] messageParams = new Object[8];
                messageParams[0] = this.getTemplateAttributesString(templateEvent);
                this.addSourceLocationMessageParams(templateEvent.getTemplateSourceLocation(), 1, messageParams);
                String message = MessageFormat.format(TEMPLATE_EXIT_PATTERN, messageParams);
                this.display(message);
                break;
            }
            case 4: {
                FunctionEvent funcEvent = (FunctionEvent)event;
                Object[] messageParams = new Object[8];
                messageParams[0] = funcEvent.getFunctionName();
                this.addSourceLocationMessageParams(funcEvent.getFunctionSourceLocation(), 1, messageParams);
                String message = MessageFormat.format(FUNCTION_ENTRY_PATTERN, messageParams);
                this.display(message);
                break;
            }
            case 5: {
                FunctionEvent funcEvent = (FunctionEvent)event;
                Object[] messageParams = new Object[8];
                messageParams[0] = funcEvent.getFunctionName();
                this.addSourceLocationMessageParams(funcEvent.getFunctionSourceLocation(), 1, messageParams);
                String message = MessageFormat.format(FUNCTION_EXIT_PATTERN, messageParams);
                this.display(message);
                break;
            }
            case 6: {
                InstructionEvent instructionEvent = (InstructionEvent)event;
                Object[] messageParams = new Object[8];
                messageParams[0] = instructionEvent.getInstructionName();
                this.addSourceLocationMessageParams(instructionEvent.getInstructionSourceLocation(), 1, messageParams);
                String message = MessageFormat.format(INSTRUCTION_START_PATTERN, messageParams);
                this.display(message);
                break;
            }
            case 7: {
                InstructionEvent instructionEvent = (InstructionEvent)event;
                Object[] messageParams = new Object[8];
                messageParams[0] = instructionEvent.getInstructionName();
                this.addSourceLocationMessageParams(instructionEvent.getInstructionSourceLocation(), 1, messageParams);
                String message = MessageFormat.format(INSTRUCTION_END_PATTERN, messageParams);
                this.display(message);
                break;
            }
            case 8: {
                this.display(this.getVariableEventString((VariableEvent)event, true));
                break;
            }
            case 9: {
                this.display(this.getVariableEventString((VariableEvent)event, false));
                break;
            }
            case 10: {
                TargetOutputEvent outputStartEvent = (TargetOutputEvent)event;
                this.display(MessageFormat.format(TARGET_OUTPUT_START_PATTERN, outputStartEvent.getURI(), outputStartEvent.getSystemId(), outputStartEvent.getMethod(), outputStartEvent.getAppend()));
                break;
            }
            case 11: {
                TargetOutputEvent outputEndEvent = (TargetOutputEvent)event;
                this.display(MessageFormat.format(TARGET_OUTPUT_END_PATTERN, outputEndEvent.getURI(), outputEndEvent.getSystemId(), outputEndEvent.getMethod(), outputEndEvent.getAppend()));
                break;
            }
            case 12: {
                GenerateOutputEvent outputEvent = (GenerateOutputEvent)event;
                this.display(MessageFormat.format(GENERATE_OUTPUT_PATTERN, outputEvent.getCharacters()));
                break;
            }
            case 13: {
                JavaExtensionEvent extStartEvent = (JavaExtensionEvent)event;
                if (extStartEvent.getJavaMethod() != null) {
                    this.display(MessageFormat.format(JAVA_EXTENSION_START_PATTERN, extStartEvent.getJavaMethod().getDeclaringClass().getName(), extStartEvent.getJavaMethod().getName()));
                    break;
                }
                this.display(MessageFormat.format(JAVA_EXTENSION_START_PATTERN, extStartEvent.getJavaConstructor().getDeclaringClass().getName(), extStartEvent.getJavaConstructor().getName()));
                break;
            }
            case 14: {
                JavaExtensionEvent extEndEvent = (JavaExtensionEvent)event;
                if (extEndEvent.getJavaMethod() != null) {
                    this.display(MessageFormat.format(JAVA_EXTENSION_END_PATTERN, extEndEvent.getJavaMethod().getDeclaringClass().getName(), extEndEvent.getJavaMethod().getName()));
                    break;
                }
                this.display(MessageFormat.format(JAVA_EXTENSION_START_PATTERN, extEndEvent.getJavaConstructor().getDeclaringClass().getName(), extEndEvent.getJavaConstructor().getName()));
                break;
            }
            case 15: {
                this.display(this.getContextEventString((ContextEvent)event, true));
                break;
            }
            case 16: {
                this.display(this.getContextEventString((ContextEvent)event, false));
                break;
            }
            case 17: {
                this.display(this.getContextSequenceEventString((ContextSequenceEvent)event, true));
                break;
            }
            case 18: {
                this.display(this.getContextSequenceEventString((ContextSequenceEvent)event, false));
                break;
            }
            case 19: {
                this.display(this.getContextGroupsEventString((ContextGroupsEvent)event, true));
                break;
            }
            case 20: {
                this.display(this.getContextGroupsEventString((ContextGroupsEvent)event, false));
            }
        }
    }

    private String getVariableEventString(VariableEvent event, boolean start) {
        String name2 = event.getVariableName();
        Cursor cursor2 = event.getVariableValue();
        String type2 = null;
        String value2 = null;
        if (cursor2 != null) {
            type2 = cursor2.itemIsAtomic() ? cursor2.itemTypeName().toString() : String.valueOf(cursor2.itemKind());
            value2 = this.sequenceToString(cursor2);
        }
        String pattern2 = start ? VARIABLE_START_PATTERN : VARIABLE_END_PATTERN;
        String message = MessageFormat.format(pattern2, name2, event.isParam(), event.isGlobal(), type2, value2);
        return message;
    }

    private String getContextEventString(ContextEvent event, boolean start) {
        StringBuilder buf = new StringBuilder();
        int position2 = event.getPosition();
        if (position2 > 0 && event.getItem() != null) {
            Cursor item2 = event.getItem();
            if (!item2.itemIsAtomic()) {
                buf.append("Name: " + item2.itemName());
                buf.append(", ");
            }
            String value2 = String.valueOf(item2.itemStringValue());
            value2 = this.escapeWhitespace(value2);
            buf.append("Value: \"" + value2 + "\"");
            buf.append(", Position: " + position2);
            buf.append(", Last: " + event.getSize());
            buf.append(", ");
        }
        buf.append("Mode: " + event.getMode());
        buf.append(", Group: " + this.sequenceToString(event.getGroup()));
        buf.append(", Grouping Key: " + this.sequenceToString(event.getGroupingKey()));
        buf.append(", Captured Substrings: " + event.getCapturedSubstrings());
        buf.append(", Temporary Output State: " + event.getTemporaryOutputState());
        String pattern2 = start ? CONTEXT_START_PATTERN : CONTEXT_END_PATTERN;
        String message = MessageFormat.format(pattern2, buf.toString());
        return message;
    }

    private String getContextSequenceEventString(ContextSequenceEvent event, boolean start) {
        StringBuilder buf = new StringBuilder();
        if (start) {
            buf.append("START sequence: ");
            Cursor sequence2 = event.getSequence();
            buf.append(this.sequenceToString(sequence2));
        } else {
            buf.append("END sequence");
        }
        return buf.toString();
    }

    private String getContextGroupsEventString(ContextGroupsEvent event, boolean start) {
        StringBuilder buf = new StringBuilder();
        if (start) {
            buf.append("START groups:\n");
            List<Cursor> groups2 = event.getGroups();
            List<Cursor> groupingKeys = event.getGroupingKeys();
            for (int i = 0; i < groups2.size(); ++i) {
                buf.append("\t" + this.sequenceToString(groupingKeys.get(i)) + ": ");
                buf.append(this.sequenceToString(groups2.get(i)));
                buf.append("\n");
            }
        } else {
            buf.append("END groups\n");
        }
        return buf.toString();
    }

    private String sequenceToString(Cursor cursor2) {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        if (cursor2 != null) {
            cursor2 = cursor2.fork(false);
            boolean first = true;
            do {
                if (first) {
                    first = false;
                } else {
                    buf.append(", ");
                }
                String value2 = String.valueOf(cursor2.itemStringValue());
                value2 = this.escapeWhitespace(value2);
                buf.append("\"" + value2 + "\"");
            } while (cursor2.toNext());
        }
        buf.append(")");
        return buf.toString();
    }

    private String escapeWhitespace(String string2) {
        string2 = string2.replace("\t", "\\t");
        string2 = string2.replace("\n", "\\n");
        return string2;
    }

    private String getTemplateAttributesString(TemplateEvent event) {
        StringBuilder attributes2 = new StringBuilder();
        if (event.getTemplateName() != null) {
            attributes2.append("\t\tname = " + event.getTemplateName() + "\n");
        }
        if (event.getTemplateMatch() != null) {
            attributes2.append("\t\tmatch = " + event.getTemplateMatch() + "\n");
        }
        if (event.getTemplateMode() != null) {
            attributes2.append("\t\tmode = " + event.getTemplateMode() + "\n");
        }
        if (event.getTemplatePriority() != null) {
            attributes2.append("\t\tpriority = " + event.getTemplatePriority() + "\n");
        }
        if (event.getTemplateAs() != null) {
            attributes2.append("\t\tas = " + event.getTemplateAs() + "\n");
        }
        return attributes2.toString();
    }

    private void addSourceLocationMessageParams(SourceLocation location, int startIndex, Object[] messageParams) {
        messageParams[startIndex++] = location.getSystemId();
        messageParams[startIndex++] = location.getStartLine();
        messageParams[startIndex++] = location.getStartColumn();
        messageParams[startIndex++] = location.getEndLine();
        messageParams[startIndex++] = location.getEndColumn();
        messageParams[startIndex++] = location.getStartOffset();
        messageParams[startIndex] = location.getEndOffset();
    }

    abstract void display(String var1);
}

