/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.drivers;

import com.ibm.xltxe.rnm1.xtq.drivers.ObjectFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

public class EnvironmentCheck {
    public static final String ERROR = "ERROR.";
    public static final String WARNING = "WARNING.";
    public static final String ERROR_FOUND = "At least one error was found!";
    public static final String VERSION = "version.";
    public static final String FOUNDCLASSES = "foundclasses.";
    public static final String CLASS_PRESENT = "present-unknown-version";
    public static final String CLASS_NOTPRESENT = "not-present";
    public String[] jarNames = new String[]{"xml.jar"};
    public Hashtable versionTable = new Hashtable();
    public Hashtable relatedJarsTable = new Hashtable();
    protected PrintWriter outWriter = new PrintWriter(System.out, true);

    public EnvironmentCheck() {
        this.versionTable.put("xlxpCompiler", "com.ibm.xml.xlxp.compiler.Version");
        this.versionTable.put("xlxpScanner", "com.ibm.xml.xlxp.internal.s1.scan.Version");
        this.versionTable.put("xlxpVM", "com.ibm.xml.xlxp.internal.s1.runtime.Version");
        this.versionTable.put("xmlapis", "org.apache.xmlcommons.Version");
        this.versionTable.put("xlxpXCIAdapter", "com.ibm.xml.xci.adapters.xlxp2.Version");
        this.versionTable.put("resolver", "org.apache.xml.resolver.Version");
        this.versionTable.put("xerces", "com.ibm.xml.xml4j.internal.s1.impl.Version");
        this.versionTable.put("serializer", "com.ibm.xltxe.rnm1.xml.serializer.Version");
        this.versionTable.put("XLTXE2", "com.ibm.xltxe.rnm1.xtq.Version");
        this.versionTable.put("XLTXE1", "org.apache.xalan.Version");
        this.versionTable.put("xci", "com.ibm.xml.xci.Version");
        this.versionTable.put("fcg", "com.ibm.xltxe.rnm1.fcg.Version");
        this.relatedJarsTable.put("bcel", "com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionList");
        this.relatedJarsTable.put("icu", "com.ibm.icu.text.Normalizer");
    }

    public static void main(String[] args) {
        PrintWriter sendOutputTo = new PrintWriter(System.out, true);
        for (int i = 0; i < args.length; ++i) {
            if (!"-out".equalsIgnoreCase(args[i])) continue;
            if (++i < args.length) {
                try {
                    sendOutputTo = new PrintWriter(new FileWriter(args[i], true));
                }
                catch (Exception e) {
                    System.err.println("# WARNING: -out " + args[i] + " threw " + e.toString());
                }
                continue;
            }
            System.err.println("# WARNING: -out argument should have a filename, output sent to console");
        }
        EnvironmentCheck app = new EnvironmentCheck();
        app.checkEnvironment(sendOutputTo);
    }

    public boolean checkEnvironment(PrintWriter pw) {
        Hashtable hash;
        boolean environmentHasErrors;
        if (null != pw) {
            this.outWriter = pw;
        }
        if (environmentHasErrors = this.writeEnvironmentReport(hash = this.getEnvironmentHash())) {
            this.logMsg("# WARNING: Potential problems found in your environment!");
            this.logMsg("#    Check any 'ERROR' items above against the Xalan FAQs");
            this.logMsg("#    to correct potential problems with your classes/jars");
            this.logMsg("#    http://xml.apache.org/xalan-j/faq.html");
            if (null != this.outWriter) {
                this.outWriter.flush();
            }
            return false;
        }
        this.logMsg("# Your environment seems to be OK.");
        if (null != this.outWriter) {
            this.outWriter.flush();
        }
        return true;
    }

    public Hashtable getEnvironmentHash() {
        Hashtable hash = new Hashtable();
        this.checkAntVersion(hash);
        this.checkDOMVersion(hash);
        this.checkSAXVersion(hash);
        this.checkSystemProperties(hash);
        this.checkVersionUtilities(hash, this.versionTable);
        this.checkOtherRelatedJars(hash);
        return hash;
    }

    protected boolean writeEnvironmentReport(Hashtable h) {
        if (null == h) {
            this.logMsg("# ERROR: writeEnvironmentReport called with null Hashtable");
            return false;
        }
        boolean errors = false;
        StringBuffer version_sb = new StringBuffer();
        StringBuffer ant_sb = new StringBuffer();
        StringBuffer dom_sb = new StringBuffer();
        StringBuffer sax_sb = new StringBuffer();
        StringBuffer xlxp_sb = new StringBuffer();
        StringBuffer xerces_sb = new StringBuffer();
        StringBuffer xmlapis_sb = new StringBuffer();
        StringBuffer xltxe_sb = new StringBuffer();
        StringBuffer relatedJars_sb = new StringBuffer();
        StringBuffer otherversions_sb = new StringBuffer();
        this.logMsg("#---- BEGIN writeEnvironmentReport(Revision: 1.44): Useful stuff found: ----");
        Enumeration keys2 = h.keys();
        while (keys2.hasMoreElements()) {
            Object key2 = keys2.nextElement();
            String keyStr = (String)key2;
            try {
                if (keyStr.startsWith(FOUNDCLASSES)) {
                    Vector v = (Vector)h.get(keyStr);
                    errors |= this.logFoundJars(v, keyStr);
                    continue;
                }
                if (keyStr.startsWith(ERROR)) {
                    errors = true;
                }
                if (keyStr.startsWith("version.DOM")) {
                    dom_sb.append(keyStr + "=" + h.get(keyStr) + "\n");
                    continue;
                }
                if (keyStr.startsWith("version.ant")) {
                    ant_sb.append(keyStr + "=" + h.get(keyStr) + "\n");
                    continue;
                }
                if (keyStr.startsWith("version.SAX")) {
                    sax_sb.append(keyStr + "=" + h.get(keyStr) + "\n");
                    continue;
                }
                if (keyStr.startsWith("version.xlxp")) {
                    xlxp_sb.append(keyStr + "=" + h.get(keyStr) + "\n");
                    continue;
                }
                if (keyStr.startsWith("version.xerces")) {
                    xerces_sb.append(keyStr + "=" + h.get(keyStr) + "\n");
                    continue;
                }
                if (keyStr.startsWith("version.xmlapis")) {
                    xmlapis_sb.append(keyStr + "=" + h.get(keyStr) + "\n");
                    continue;
                }
                if (keyStr.startsWith("version.XLTXE")) {
                    xltxe_sb.append(keyStr + "=" + h.get(keyStr) + "\n");
                    continue;
                }
                if (keyStr.startsWith("version")) {
                    otherversions_sb.append(keyStr + "=" + h.get(keyStr) + "\n");
                    continue;
                }
                if (keyStr.startsWith("other")) {
                    relatedJars_sb.append(keyStr + "=" + h.get(keyStr) + "\n");
                    continue;
                }
                this.logMsg(keyStr + "=" + h.get(keyStr));
            }
            catch (Exception e) {
                this.logMsg("Reading-" + key2 + "= threw: " + e.toString());
            }
        }
        version_sb.append(ant_sb.toString());
        version_sb.append(dom_sb.toString());
        version_sb.append(sax_sb.toString());
        version_sb.append(xlxp_sb.toString());
        version_sb.append(xerces_sb.toString());
        version_sb.append(xmlapis_sb.toString());
        version_sb.append(xltxe_sb.toString());
        version_sb.append(otherversions_sb.toString());
        this.logMsg("#----- Start reporting Version utilities -----");
        this.logMsg(version_sb.toString());
        this.logMsg("#----- End reporting Version utilities -----");
        this.logMsg("#----- Start reporting Other related Jars -----");
        this.logMsg(relatedJars_sb.toString());
        this.logMsg("#----- END reporting Other related Jars -----");
        this.logMsg("#----- END writeEnvironmentReport: Useful properties found: -----");
        return errors;
    }

    protected boolean logFoundJars(Vector v, String desc) {
        if (null == v || v.size() < 1) {
            return false;
        }
        boolean errors = false;
        this.logMsg("#---- BEGIN Listing XML-related jars in: " + desc + " ----");
        for (int i = 0; i < v.size(); ++i) {
            Hashtable subhash = (Hashtable)v.elementAt(i);
            Enumeration keys2 = subhash.keys();
            while (keys2.hasMoreElements()) {
                Object key2 = keys2.nextElement();
                String keyStr = (String)key2;
                try {
                    if (keyStr.startsWith(ERROR)) {
                        errors = true;
                    }
                    this.logMsg(keyStr + "=" + subhash.get(keyStr));
                }
                catch (Exception e) {
                    errors = true;
                    this.logMsg("Reading-" + key2 + "= threw: " + e.toString());
                }
            }
        }
        this.logMsg("#----- END Listing XML-related jars in: " + desc + " -----");
        return errors;
    }

    public void appendEnvironmentReport(Node container, Document factory, Hashtable h) {
        if (null == container || null == factory) {
            return;
        }
        try {
            Element envCheckNode = factory.createElement("EnvironmentCheck");
            envCheckNode.setAttribute("version", "Revision: 1.44");
            container.appendChild(envCheckNode);
            if (null == h) {
                Element statusNode = factory.createElement("status");
                statusNode.setAttribute("result", "ERROR");
                statusNode.appendChild(factory.createTextNode("appendEnvironmentReport called with null Hashtable!"));
                envCheckNode.appendChild(statusNode);
                return;
            }
            boolean errors = false;
            Element hashNode = factory.createElement("environment");
            envCheckNode.appendChild(hashNode);
            Enumeration keys2 = h.keys();
            while (keys2.hasMoreElements()) {
                Object key2 = keys2.nextElement();
                String keyStr = (String)key2;
                try {
                    if (keyStr.startsWith(FOUNDCLASSES)) {
                        Vector v = (Vector)h.get(keyStr);
                        errors |= this.appendFoundJars(hashNode, factory, v, keyStr);
                        continue;
                    }
                    if (keyStr.startsWith(ERROR)) {
                        errors = true;
                    }
                    Element node2 = factory.createElement("item");
                    node2.setAttribute("key", keyStr);
                    node2.appendChild(factory.createTextNode((String)h.get(keyStr)));
                    hashNode.appendChild(node2);
                }
                catch (Exception e) {
                    errors = true;
                    Element node3 = factory.createElement("item");
                    node3.setAttribute("key", keyStr);
                    node3.appendChild(factory.createTextNode("ERROR. Reading " + key2 + " threw: " + e.toString()));
                    hashNode.appendChild(node3);
                }
            }
            Element statusNode = factory.createElement("status");
            statusNode.setAttribute("result", errors ? "ERROR" : "OK");
            envCheckNode.appendChild(statusNode);
        }
        catch (Exception e2) {
            System.err.println("appendEnvironmentReport threw: " + e2.toString());
            e2.printStackTrace();
        }
    }

    protected boolean appendFoundJars(Node container, Document factory, Vector v, String desc) {
        if (null == v || v.size() < 1) {
            return false;
        }
        boolean errors = false;
        for (int i = 0; i < v.size(); ++i) {
            Hashtable subhash = (Hashtable)v.elementAt(i);
            Enumeration keys2 = subhash.keys();
            while (keys2.hasMoreElements()) {
                Element node2;
                Object key2 = keys2.nextElement();
                try {
                    String keyStr = (String)key2;
                    if (keyStr.startsWith(ERROR)) {
                        errors = true;
                    }
                    node2 = factory.createElement("foundJar");
                    node2.setAttribute("name", keyStr.substring(0, keyStr.indexOf("-")));
                    node2.setAttribute("desc", keyStr.substring(keyStr.indexOf("-") + 1));
                    node2.appendChild(factory.createTextNode((String)subhash.get(keyStr)));
                    container.appendChild(node2);
                }
                catch (Exception e) {
                    errors = true;
                    node2 = factory.createElement("foundJar");
                    node2.appendChild(factory.createTextNode("ERROR. Reading " + key2 + " threw: " + e.toString()));
                    container.appendChild(node2);
                }
            }
        }
        return errors;
    }

    protected void checkSystemProperties(Hashtable h) {
        if (null == h) {
            h = new Hashtable<String, Object>();
        }
        try {
            String javaVersion = System.getProperty("java.version");
            h.put("java.version", javaVersion);
        }
        catch (SecurityException se) {
            h.put("java.version", "WARNING: SecurityException thrown accessing system version properties");
        }
        try {
            String othercp;
            String cp = System.getProperty("java.class.path");
            h.put("java.class.path", cp);
            Vector classpathJars = this.checkPathForJars(cp, this.jarNames);
            if (null != classpathJars) {
                h.put("foundclasses.java.class.path", classpathJars);
            }
            if (null != (othercp = System.getProperty("sun.boot.class.path"))) {
                h.put("sun.boot.class.path", othercp);
                classpathJars = this.checkPathForJars(othercp, this.jarNames);
                if (null != classpathJars) {
                    h.put("foundclasses.sun.boot.class.path", classpathJars);
                }
            }
            if (null != (othercp = System.getProperty("java.ext.dirs"))) {
                h.put("java.ext.dirs", othercp);
                classpathJars = this.checkPathForJars(othercp, this.jarNames);
                if (null != classpathJars) {
                    h.put("foundclasses.java.ext.dirs", classpathJars);
                }
            }
            if (null != (othercp = System.getProperty("java.endorsed.dirs"))) {
                h.put("java.endorsed.dirs", othercp);
                classpathJars = this.checkPathForJars(othercp, this.jarNames);
                if (null != classpathJars) {
                    h.put("foundclasses.java.endorsed.dirs", classpathJars);
                }
            }
        }
        catch (SecurityException se2) {
            h.put("java.class.path", "WARNING: SecurityException thrown accessing system classpath properties");
        }
    }

    protected Vector checkPathForJars(String cp, String[] jars) {
        if (null == cp || null == jars || 0 == cp.length() || 0 == jars.length) {
            return null;
        }
        Vector v = new Vector();
        StringTokenizer st = new StringTokenizer(cp, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String filename = st.nextToken();
            for (int i = 0; i < jars.length; ++i) {
                Hashtable<String, String> h;
                if (filename.indexOf(jars[i]) <= -1) continue;
                File f2 = new File(filename);
                if (f2.exists()) {
                    try {
                        h = new Hashtable(2);
                        h.put(jars[i] + "-path", f2.getAbsolutePath());
                    }
                    catch (Exception e) {}
                    continue;
                }
                h = new Hashtable<String, String>(2);
                h.put(jars[i] + "-path", "WARNING. Classpath entry: " + filename + " does not exist");
                h.put(jars[i] + "-apparent.version", CLASS_NOTPRESENT);
                v.addElement(h);
            }
        }
        return v;
    }

    protected void checkVersionUtilities(Hashtable h, Hashtable versionTable) {
        if (null == h) {
            h = new Hashtable<String, String>();
        }
        int size = versionTable.size();
        Enumeration versionKeys = versionTable.keys();
        while (versionKeys.hasMoreElements()) {
            String versionKey = (String)versionKeys.nextElement();
            String VERSION_CLASS = (String)versionTable.get(versionKey);
            String classLocation = "";
            try {
                CodeSource cs;
                Class clazz = ObjectFactory.findProviderClass(VERSION_CLASS, ObjectFactory.findClassLoader(), true);
                Class[] noArgs = new Class[]{};
                Method method = clazz.getMethod("getVersion", noArgs);
                String version = (String)method.invoke(null, new Object[0]);
                ProtectionDomain pd = clazz.getProtectionDomain();
                if (pd != null && (cs = pd.getCodeSource()) != null) {
                    classLocation = cs.getLocation().getPath();
                }
                if (classLocation.length() > 0) {
                    h.put(VERSION + versionKey, version + " is loaded from " + classLocation);
                    continue;
                }
                h.put(VERSION + versionKey, version);
            }
            catch (Exception e) {
                h.put(VERSION + versionKey, CLASS_NOTPRESENT);
            }
        }
    }

    protected void checkOtherRelatedJars(Hashtable h) {
        if (null == h) {
            h = new Hashtable<String, String>();
        }
        int size = this.relatedJarsTable.size();
        Enumeration relatedJarsKeys = this.relatedJarsTable.keys();
        while (relatedJarsKeys.hasMoreElements()) {
            String relatedJarKey = (String)relatedJarsKeys.nextElement();
            String RELATEDJAR_CLASS = (String)this.relatedJarsTable.get(relatedJarKey);
            try {
                Class clazz = ObjectFactory.findProviderClass(RELATEDJAR_CLASS, ObjectFactory.findClassLoader(), true);
                String classLocation = clazz.getProtectionDomain().getCodeSource().getLocation().getPath();
                h.put("other." + relatedJarKey, relatedJarKey + " is loaded from " + classLocation);
            }
            catch (Exception e) {
                h.put("other." + relatedJarKey, CLASS_NOTPRESENT);
            }
        }
    }

    protected void checkAntVersion(Hashtable h) {
        if (null == h) {
            h = new Hashtable<String, String>();
        }
        try {
            String ANT_VERSION_CLASS = "org.apache.tools.ant.Main";
            String ANT_VERSION_METHOD = "getAntVersion";
            Class[] noArgs = new Class[]{};
            Class clazz = ObjectFactory.findProviderClass("org.apache.tools.ant.Main", ObjectFactory.findClassLoader(), true);
            Method method = clazz.getMethod("getAntVersion", noArgs);
            Object returnValue = method.invoke(null, new Object[0]);
            h.put("version.ant", (String)returnValue);
        }
        catch (Exception e) {
            h.put("version.ant", CLASS_NOTPRESENT);
        }
    }

    protected void checkDOMVersion(Hashtable h) {
        if (null == h) {
            h = new Hashtable<String, String>();
        }
        String DOM_LEVEL2_CLASS = "org.w3c.dom.Document";
        String DOM_LEVEL2_METHOD = "createElementNS";
        String DOM_LEVEL2WD_CLASS = "org.w3c.dom.Node";
        String DOM_LEVEL2WD_METHOD = "supported";
        String DOM_LEVEL2FD_CLASS = "org.w3c.dom.Node";
        String DOM_LEVEL2FD_METHOD = "isSupported";
        Class[] twoStringArgs = new Class[]{String.class, String.class};
        try {
            Class clazz = ObjectFactory.findProviderClass("org.w3c.dom.Document", ObjectFactory.findClassLoader(), true);
            clazz.getMethod("createElementNS", twoStringArgs);
            h.put("version.DOM", "2.0");
        }
        catch (Exception e) {
            h.put("ERROR.version.DOM", "ERROR attempting to load DOM level 2 class: " + e.toString());
            h.put(ERROR, ERROR_FOUND);
        }
    }

    protected void checkSAXVersion(Hashtable h) {
        if (null == h) {
            h = new Hashtable<String, String>();
        }
        String SAX_VERSION1_CLASS = "org.xml.sax.Parser";
        String SAX_VERSION1_METHOD = "parse";
        String SAX_VERSION2_CLASS = "org.xml.sax.XMLReader";
        String SAX_VERSION2_METHOD = "parse";
        String SAX_VERSION2BETA_CLASSNF = "org.xml.sax.helpers.AttributesImpl";
        String SAX_VERSION2BETA_METHODNF = "setAttributes";
        Class[] oneStringArg = new Class[]{String.class};
        Class[] attributesArg = new Class[]{Attributes.class};
        try {
            Class clazz = ObjectFactory.findProviderClass("org.xml.sax.helpers.AttributesImpl", ObjectFactory.findClassLoader(), true);
            clazz.getMethod("setAttributes", attributesArg);
            h.put("version.SAX", "2.0");
        }
        catch (Exception e) {
            h.put("ERROR.version.SAX", "ERROR attempting to load SAX version 2 class: " + e.toString());
            h.put(ERROR, ERROR_FOUND);
            try {
                Class clazz = ObjectFactory.findProviderClass("org.xml.sax.XMLReader", ObjectFactory.findClassLoader(), true);
                clazz.getMethod("parse", oneStringArg);
                h.put("version.SAX-backlevel", "2.0beta2-or-earlier");
            }
            catch (Exception e2) {
                h.put("ERROR.version.SAX", "ERROR attempting to load SAX version 2 class: " + e.toString());
                h.put(ERROR, ERROR_FOUND);
                try {
                    Class clazz = ObjectFactory.findProviderClass("org.xml.sax.Parser", ObjectFactory.findClassLoader(), true);
                    Method method = clazz.getMethod("parse", oneStringArg);
                    h.put("version.SAX-backlevel", "1.0");
                }
                catch (Exception e3) {
                    h.put("ERROR.version.SAX-backlevel", "ERROR attempting to load SAX version 1 class: " + e3.toString());
                }
            }
        }
    }

    protected void logMsg(String s) {
        this.outWriter.println(s);
    }
}

