/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.drivers;

import com.ibm.xltxe.rnm1.xtq.ProcessorAttributes;
import com.ibm.xltxe.rnm1.xtq.drivers.ObjectFactory;
import com.ibm.xltxe.rnm1.xtq.drivers.SecuritySupport;
import com.ibm.xml.ras.LoggerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipFile;
import javax.xml.transform.Source;

public class StarletLoader {
    private static final Logger s_logger = LoggerUtil.getLogger(StarletLoader.class);
    private static final String s_className = StarletLoader.class.getName();

    public static ClassLoader getStarletClassLoader(String starletClassName, Source source, ProcessorAttributes pa) {
        String jarFileName = pa.getStringAttribute("http://www.ibm.com/xmlns/prod/xltxe-j/jar-name");
        ClassLoader autoPathletClassLoader = jarFileName != null ? StarletLoader.getJarClassLoader(source, starletClassName, pa) : StarletLoader.getDirectoryClassLoader(source, starletClassName, pa);
        return autoPathletClassLoader;
    }

    private static ClassLoader getDirectoryClassLoader(Source source, String fullClassName, ProcessorAttributes pa) {
        int fileLength;
        if (fullClassName == null) {
            return null;
        }
        String xslFileName = source != null ? StarletLoader.getStylesheetFileName(source) : null;
        File xslFile = null;
        if (xslFileName != null) {
            xslFile = new File(xslFileName);
        }
        String transletPath = fullClassName.replace('.', '/');
        String destinationDirectory = pa.getStringAttribute("http://www.ibm.com/xmlns/prod/xltxe-j/destination-directory");
        transletPath = destinationDirectory != null ? destinationDirectory + "/" + transletPath + ".class" : (xslFile != null && xslFile.getParent() != null ? xslFile.getParent() + "/" + transletPath + ".class" : transletPath + ".class");
        File transletFile = new File(transletPath);
        if (!transletFile.exists()) {
            return null;
        }
        if (xslFile != null && xslFile.exists()) {
            long xslTimestamp = xslFile.lastModified();
            long transletTimestamp = transletFile.lastModified();
            if (transletTimestamp < xslTimestamp) {
                return null;
            }
        }
        if ((fileLength = (int)transletFile.length()) == 0) {
            return null;
        }
        String transletParentDir = transletFile.getParent();
        String transletDir = "";
        if (transletParentDir != null) {
            transletDir = transletParentDir;
        } else {
            try {
                transletDir = (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return System.getProperty("user.dir");
                    }
                });
            }
            catch (SecurityException e) {
                // empty catch block
            }
        }
        TransletURLClassLoader dirClassLoader = null;
        try {
            URL dirURL = new File(transletDir).toURL();
            dirClassLoader = new TransletURLClassLoader(new URL[]{dirURL}, SecuritySupport.getContextClassLoader());
        }
        catch (MalformedURLException mue) {
            // empty catch block
        }
        return dirClassLoader;
    }

    private static ClassLoader getJarClassLoader(Source source, String fullClassName, ProcessorAttributes pa) {
        String xslFileName = StarletLoader.getStylesheetFileName(source);
        File xslFile = null;
        if (xslFileName != null) {
            xslFile = new File(xslFileName);
        }
        String jarPath = null;
        String destinationDirectory = pa.getStringAttribute("http://www.ibm.com/xmlns/prod/xltxe-j/destination-directory");
        String jarFileName = pa.getStringAttribute("http://www.ibm.com/xmlns/prod/xltxe-j/jar-name");
        jarPath = destinationDirectory != null ? destinationDirectory + "/" + jarFileName : (xslFile != null && xslFile.getParent() != null ? xslFile.getParent() + "/" + jarFileName : jarFileName);
        File file = new File(jarPath);
        if (!file.exists()) {
            return null;
        }
        if (xslFile != null && xslFile.exists()) {
            long xslTimestamp = xslFile.lastModified();
            long transletTimestamp = file.lastModified();
            if (transletTimestamp < xslTimestamp) {
                return null;
            }
        }
        try {
            new ZipFile(file);
        }
        catch (IOException e) {
            return null;
        }
        TransletURLClassLoader jarClassLoader = null;
        try {
            jarClassLoader = new TransletURLClassLoader(new URL[]{file.toURL()}, SecuritySupport.getContextClassLoader());
        }
        catch (MalformedURLException mue) {
            // empty catch block
        }
        return jarClassLoader;
    }

    private static String getStylesheetFileName(Source source) {
        String systemId = source.getSystemId();
        if (systemId != null) {
            File file = new File(systemId);
            if (file.exists()) {
                return systemId;
            }
            URL url = null;
            try {
                url = new URL(systemId);
            }
            catch (MalformedURLException e) {
                return null;
            }
            if ("file".equals(url.getProtocol())) {
                return url.getFile();
            }
            return null;
        }
        return null;
    }

    public static ClassLoader getJarClassLoader(String fullClassName, String jarPath) {
        File file = new File(jarPath);
        if (!file.exists()) {
            return null;
        }
        try {
            new ZipFile(file);
        }
        catch (IOException e) {
            return null;
        }
        TransletURLClassLoader jarClassLoader = null;
        try {
            jarClassLoader = new TransletURLClassLoader(new URL[]{file.toURL()}, SecuritySupport.getContextClassLoader());
        }
        catch (MalformedURLException mue) {
            // empty catch block
        }
        return jarClassLoader;
    }

    public static Class loadStarlet(String name2, ClassLoader cl) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            if (cl != null) {
                try {
                    clazz = ObjectFactory.findProviderClass(name2, cl, true);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            if (clazz == null) {
                clazz = ObjectFactory.findProviderClass(name2, ObjectFactory.findClassLoader(), true);
            }
        }
        catch (ClassNotFoundException cnf) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "loadStarlet", "Failed to load class " + name2 + " trying the working directory class loader.", cnf);
            }
            cl = new ClassLoader(){

                protected Class findClass(String arg0) throws ClassNotFoundException {
                    try {
                        File file = new File(arg0 + ".class");
                        FileInputStream fis = new FileInputStream(file);
                        byte[] data2 = new byte[(int)file.length()];
                        fis.read(data2);
                        fis.close();
                        return super.defineClass(arg0, data2, 0, data2.length);
                    }
                    catch (Exception e) {
                        return super.findClass(arg0);
                    }
                }
            };
            try {
                clazz = cl.loadClass(name2);
            }
            catch (ClassNotFoundException e) {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                    s_logger.logp(Level.FINE, s_className, "loadStarlet", "Failed to load class " + name2 + " using working directory class loader.", e);
                }
                throw e;
            }
            catch (NoClassDefFoundError e) {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                    s_logger.logp(Level.FINE, s_className, "loadStarlet", "Failed to load class " + name2 + " using working directory class loader.", e);
                }
                throw e;
            }
        }
        return clazz;
    }

    public static ByteCodeArraysClassLoader getByteCodeArraysClassLoader(final byte[][] bytecodes, final String[] names) {
        return (ByteCodeArraysClassLoader)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return new ByteCodeArraysClassLoader(bytecodes, names, SecuritySupport.getContextClassLoader());
            }
        });
    }

    public static class OldTransletError
    extends NoClassDefFoundError {
        public OldTransletError(String name2) {
            super(name2);
        }
    }

    static class ByteCodeArraysClassLoader
    extends ClassLoader {
        private byte[][] _bytecodes;
        private String[] _cNames;

        protected ByteCodeArraysClassLoader(byte[][] bytecodes, String[] classNames, ClassLoader parent2) {
            super(parent2);
            this._cNames = classNames;
            this._bytecodes = bytecodes;
        }

        protected Class findClass(String name2) throws ClassNotFoundException {
            Class clazz = this.lookUpClassInByteArrays(name2);
            if (clazz == null) {
                throw new ClassNotFoundException(name2);
            }
            return clazz;
        }

        private Class lookUpClassInByteArrays(String name2) {
            Class clazz = null;
            int classCount = this._bytecodes.length;
            byte[] b = null;
            for (int i = 0; i < classCount; ++i) {
                String className = this._cNames[i];
                if (!name2.equals(className)) continue;
                b = this._bytecodes[i];
                this._bytecodes[i] = null;
                this._cNames[i] = null;
                break;
            }
            if (b != null) {
                final String myname = name2;
                final byte[] bb = b;
                clazz = (Class)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return ByteCodeArraysClassLoader.this.defineClass(myname, bb, 0, bb.length, this.getClass().getProtectionDomain());
                    }
                });
            }
            return clazz;
        }

        protected Class loadClass(final String name2, boolean resolve2) throws ClassNotFoundException {
            Class clazz = this.findLoadedClass(name2);
            if (clazz == null && (clazz = this.lookUpClassInByteArrays(name2)) == null) {
                try {
                    clazz = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws ClassNotFoundException {
                            ClassLoader parentLoader = ByteCodeArraysClassLoader.this.getParent();
                            if (parentLoader != null) {
                                return parentLoader.loadClass(name2);
                            }
                            return Class.forName(name2);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw (ClassNotFoundException)e.getException();
                }
            }
            if (clazz == null) {
                throw new ClassNotFoundException(name2);
            }
            if (resolve2) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
    }

    private static class TransletURLClassLoader
    extends URLClassLoader {
        TransletURLClassLoader(URL[] urls, ClassLoader parent2) {
            super(urls, parent2);
        }

        protected Class loadClass(String name2, boolean resolve2) throws ClassNotFoundException {
            Class<?> clazz = this.findLoadedClass(name2);
            if (clazz == null) {
                try {
                    clazz = this.findClass(name2);
                }
                catch (ClassNotFoundException cnfe) {
                    // empty catch block
                }
                if (clazz == null) {
                    ClassLoader parentLoader = this.getParent();
                    if (parentLoader != null) {
                        try {
                            clazz = parentLoader.loadClass(name2);
                        }
                        catch (ClassNotFoundException e) {
                            if ("org.apache.xalan.xsltc.runtime.AbstractTranslet".equals(name2)) {
                                throw new OldTransletError(name2);
                            }
                            throw e;
                        }
                    } else {
                        clazz = Class.forName(name2);
                    }
                }
            }
            if (clazz == null) {
                if ("org.apache.xalan.xsltc.runtime.AbstractTranslet".equals(name2)) {
                    throw new OldTransletError(name2);
                }
                throw new ClassNotFoundException(name2);
            }
            if (resolve2) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
    }
}

