/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.drivers;

import com.ibm.xltxe.rnm1.fcg.impl.HiddenOptions;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.XTQProgram;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.JavaClass;
import com.ibm.xltxe.rnm1.xtq.common.utils.ErrorHandler;
import com.ibm.xltxe.rnm1.xtq.common.utils.SystemIDResolver;
import com.ibm.xltxe.rnm1.xtq.drivers.XStarLinker;
import com.ibm.xltxe.rnm1.xtq.drivers.XTQModuleManager;
import com.ibm.xltxe.rnm1.xtq.runtime.AbstractStarlet;
import com.ibm.xltxe.rnm1.xtq.xpath.drivers.XPathPreparer;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.DriverConstants;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompilerSettings;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTLinkerSettings;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XylemRuntimePreCompiler;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.LineNumberHelper;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.parser.FormHandler;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.parser.TypeHandler;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleImportDirective;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ModuleSignatureStore;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.TopLevelModuleImportDirective;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationSettings;
import com.ibm.xltxe.rnm1.xylem.codegen.bcel.ClassCollector;
import com.ibm.xltxe.rnm1.xylem.codegen.bcel.Resource;
import com.ibm.xltxe.rnm1.xylem.parser.ClassLoaderSourceResolver;
import com.ibm.xltxe.rnm1.xylem.parser.Parser;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.SessionContext;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XStarCompiler {
    public static final int FILE_OUTPUT = 1;
    public static final int BYTEARRAY_OUTPUT = 2;
    public static final int JAR_OUTPUT = 4;
    public static final int JAVA_SOURCE = 8;
    public static final int DEBUG_MSG = 16;
    public static final int BYTEARRAY_AND_FILE_OUTPUT = 3;
    public static final int BYTEARRAY_AND_JAR_OUTPUT = 6;
    public static final int BYTEARRAY_AND_JAR_DEBUG_OUTPUT = 22;
    public static final int JAVA_SOURCE_AND_FILE_OUTPUT = 9;
    private static final Logger s_logger = LoggerUtil.getLogger(XStarCompiler.class);
    private static final String s_className = XStarCompiler.class.getName();
    protected Module m_runtimeLibrary = null;
    private static Object s_cachedRuntimeLock = new Object();
    private static int s_cachedReductionHelperCount;
    private static SoftReference<Module> s_cachedCompilerRuntime;
    private static SoftReference<ModuleSignature> s_cachedRuntimeSignature;
    protected boolean m_debug = false;
    protected String m_jarFileName = null;
    protected String m_className = null;
    protected File m_destDir = null;
    protected String m_packageName = null;
    protected XSLTCompilerSettings m_compiSettings = null;
    protected XSLTLinkerSettings m_linkerSettings = null;
    protected Vector<JavaClass> m_classes = new Vector();
    protected Vector<Resource> m_resources = new Vector();
    protected byte[][] m_bytecodes;
    protected String[] m_cnames;
    protected int m_outputType = 2;
    protected boolean m_generateBCEL = false;
    protected ModuleSignature m_moduleSignature = null;
    private Module m_starletModule = null;
    private XTQModuleManager m_moduleManager = null;
    private Map<XTQProgram, Module> m_modules = new IdentityHashMap<XTQProgram, Module>();
    public static final String MIXEDMODE_OPTION = "mixedmode";
    public static final boolean MIXEDMODE;
    private boolean m_mixedMode;
    private String m_filLibraryName;
    private Class<? extends AbstractStarlet> m_filLibrary;
    private LineNumberHelper m_lineNumberHelper = new LineNumberHelper();

    public XStarCompiler(String version) {
        this.m_compiSettings = new XSLTCompilerSettings();
        this.m_compiSettings.setVersion(version);
        this.m_linkerSettings = new XSLTLinkerSettings(this.m_compiSettings);
        this.m_linkerSettings.setLineNumberHelper(this.m_lineNumberHelper);
    }

    public void setStreamResultOnly(boolean flag) {
        this.m_compiSettings.setStreamResultOnly(flag);
        CodeGenerationSettings cgs = this.m_linkerSettings.getCodeGenerationSettings();
        cgs.setOrderSafeSplit(!flag);
    }

    public boolean isStreamResultOnly() {
        return this.m_compiSettings.isStreamResultOnly();
    }

    public void reset() {
        this.m_classes.removeAllElements();
        this.m_resources.removeAllElements();
        this.m_bytecodes = null;
    }

    public byte[][] getBytecodes() {
        if (this.m_bytecodes == null) {
            int count2 = this.m_classes.size();
            byte[][] result2 = new byte[count2][];
            String[] names = new String[count2];
            for (int i = 0; i < count2; ++i) {
                JavaClass clazz = this.m_classes.get(i);
                result2[i] = clazz.getBytes();
                names[i] = clazz.getClassName();
            }
            this.m_bytecodes = result2;
            this.m_cnames = names;
            this.m_classes.removeAllElements();
        }
        return this.m_bytecodes;
    }

    public String[] getNames() {
        return this.m_cnames;
    }

    public void setClassName(String className) {
        this.m_className = this.m_packageName == null ? className : this.m_packageName + '.' + className;
    }

    public String getClassName() {
        return this.m_className;
    }

    private String classFileName(String className) {
        return className.replace('.', File.separatorChar) + ".class";
    }

    public void setOutputType(int type2) {
        this.m_outputType = type2;
    }

    private File getOutputFile(String className) {
        if (this.m_destDir != null) {
            return new File(this.m_destDir, this.classFileName(className));
        }
        return new File(this.classFileName(className));
    }

    public boolean setDestDirectory(String dstDirName) {
        File dir;
        if (dstDirName != null && ((dir = new File(dstDirName)).exists() || dir.mkdirs())) {
            this.m_destDir = dir;
            this.m_linkerSettings.setOutputDir(this.m_destDir);
            return true;
        }
        this.m_destDir = null;
        return false;
    }

    public void setPackageName(String packageName) {
        this.m_packageName = packageName;
        if (this.m_className != null) {
            this.setClassName(this.m_className);
        }
    }

    public void setJarFileName(String jarFileName) {
        String JAR_EXT = ".jar";
        this.m_jarFileName = jarFileName.endsWith(".jar") ? jarFileName : jarFileName + ".jar";
    }

    public String getJarFileName() {
        return this.m_jarFileName;
    }

    public void setDebug(boolean debug) {
        this.m_debug = debug;
    }

    public boolean debug() {
        return this.m_debug;
    }

    public boolean getGenerateBCEL() {
        return this.m_generateBCEL;
    }

    public void setGenerateBCEL(boolean m_generatebcel) {
        CodeGenerationSettings cgs = this.m_linkerSettings.getCodeGenerationSettings();
        this.m_generateBCEL = m_generatebcel;
        if (m_generatebcel) {
            cgs.setTargetLanguage(4);
        } else {
            cgs.setTargetLanguage(3);
        }
    }

    public int getSplitLimit() {
        return this.m_compiSettings.getPrereductionSplitLimit();
    }

    public void setSplitLimit(int splitLimit) {
        this.m_compiSettings.setPrereductionSplitLimit(splitLimit);
        CodeGenerationSettings cgs = this.m_linkerSettings.getCodeGenerationSettings();
        cgs.setBCELAutoSplitFunctions(splitLimit == 0);
    }

    public void setEmitAutoSplitWarning(boolean value2) {
        CodeGenerationSettings cgs = this.m_linkerSettings.getCodeGenerationSettings();
        cgs.setEmitAutoSplitWarning(value2);
    }

    public ClassCollector getByteCodeClassCollecter() {
        ChainedClassCollector cc = null;
        if ((this.m_outputType & 2) != 0) {
            cc = new CachingClassCollector(cc);
        }
        if ((this.m_outputType & 1) != 0) {
            cc = new WritingClassCollector(cc);
        }
        return cc;
    }

    public void outputToJar(boolean debug_msg) throws IOException {
        Attributes attr2;
        Manifest manifest = new Manifest();
        Attributes atrs = manifest.getMainAttributes();
        atrs.put(Attributes.Name.MANIFEST_VERSION, "1.2");
        Map<String, Attributes> map2 = manifest.getEntries();
        Enumeration<JavaClass> classes = this.m_classes.elements();
        String now = new Date().toString();
        Attributes.Name dateAttr = new Attributes.Name("Date");
        while (classes.hasMoreElements()) {
            JavaClass clazz = classes.nextElement();
            String className = clazz.getClassName().replace('.', '/');
            attr2 = new Attributes();
            attr2.put(dateAttr, now);
            map2.put(className + ".class", attr2);
        }
        Enumeration<Resource> resources = this.m_resources.elements();
        while (resources.hasMoreElements()) {
            Resource res = resources.nextElement();
            attr2 = new Attributes();
            attr2.put(dateAttr, now);
            map2.put(res.getName(), attr2);
        }
        boolean isAbsolute = SystemIDResolver.isAbsolutePath(this.m_jarFileName);
        File jarFile = null;
        jarFile = isAbsolute ? new File(this.m_jarFileName) : new File(this.m_destDir, this.m_jarFileName);
        JarOutputStream jos = new JarOutputStream((OutputStream)new FileOutputStream(jarFile), manifest);
        classes = this.m_classes.elements();
        while (classes.hasMoreElements()) {
            JavaClass clazz = classes.nextElement();
            String className = clazz.getClassName().replace('.', '/');
            jos.putNextEntry(new JarEntry(className + ".class"));
            ByteArrayOutputStream out = new ByteArrayOutputStream(2048);
            clazz.dump(out);
            out.writeTo(jos);
        }
        resources = this.m_resources.elements();
        while (resources.hasMoreElements()) {
            Resource res = resources.nextElement();
            jos.putNextEntry(new JarEntry(res.getName()));
            ByteArrayOutputStream out = new ByteArrayOutputStream(2048);
            res.dump(out);
            out.writeTo(jos);
        }
        jos.close();
        if (debug_msg) {
            s_logger.logrb(Level.INFO, s_className, "outputToJar", "com.ibm.xltxe.rnm1.xylem.res.XylemMessages", "DUMPED_INFO_LOCATION", new Object[]{jarFile.getCanonicalPath()});
        }
    }

    private ModuleSignature readModuleSignature() throws Exception {
        InputStream signature = XylemRuntimePreCompiler.getPrecompiledRuntimeSignature();
        if (signature == null) {
            return null;
        }
        List<URL> searchPath = Collections.emptyList();
        ModuleSignatureStore mss = new ModuleSignatureStore(searchPath);
        ObjectInputStream ois = new ObjectInputStream(signature);
        ModuleSignature ms = new ModuleSignature();
        ms.read(ois, mss);
        signature.close();
        if (LoggerUtil.isFineLoggable(s_logger)) {
            s_logger.logp(Level.FINE, s_className, "readModuleSignature", "Successfully read serialized FIL runtime library module signature");
        }
        return ms;
    }

    private static Module readModule() throws Exception {
        InputStream moduleStream = XylemRuntimePreCompiler.getPrecompiledRuntime();
        InputStream signatureStream = XylemRuntimePreCompiler.getPrecompiledRuntimeSignature();
        if (moduleStream == null || signatureStream == null) {
            return null;
        }
        List<URL> searchPath = Collections.emptyList();
        ModuleSignatureStore mss = new ModuleSignatureStore(searchPath);
        ObjectInputStream ois = new ObjectInputStream(signatureStream);
        ModuleSignature ms = new ModuleSignature();
        ms.read(ois, mss);
        signatureStream.close();
        mss.registerModuleSignature("xslt2", ms);
        ois = new ObjectInputStream(moduleStream);
        Module m = Module.readModule(ois, mss);
        moduleStream.close();
        m.typeCheckReduced();
        if (LoggerUtil.isFineLoggable(s_logger)) {
            s_logger.logp(Level.FINE, s_className, "readModule", "Successfully read serialized FIL runtime library module");
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleSignature loadRuntimeSignature() throws Exception {
        Object object2 = s_cachedRuntimeLock;
        synchronized (object2) {
            ModuleSignature rtsig;
            ModuleSignature moduleSignature = rtsig = s_cachedRuntimeSignature == null ? null : s_cachedRuntimeSignature.get();
            if (rtsig == null) {
                rtsig = this.newRuntimeLibrarySignatureInstance();
                s_cachedRuntimeSignature = new SoftReference<ModuleSignature>(rtsig);
            } else if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "loadRuntimeSignature", "Using cached FIL runtime library module signature");
            }
            return rtsig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Module loadRuntimeLibrary() throws Exception {
        Object object2 = s_cachedRuntimeLock;
        synchronized (object2) {
            Module rtlib;
            Module module = rtlib = s_cachedCompilerRuntime == null ? null : s_cachedCompilerRuntime.get();
            if (rtlib == null) {
                rtlib = this.newRuntimeLibraryInstance();
                s_cachedReductionHelperCount = ReductionHelper.getIntermediateIdentifierCount();
                s_cachedCompilerRuntime = new SoftReference<Module>(rtlib);
            } else if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "loadRuntimeLibrary", "Using cached FIL runtime library module");
            }
            ReductionHelper.resetIntermediateIdentifierCounter(s_cachedReductionHelperCount);
            if (this.isInterpreted()) {
                return rtlib;
            }
            return rtlib.cloneModule();
        }
    }

    private Module newRuntimeLibraryInstance() throws Exception {
        Module runtime = XStarCompiler.readModule();
        if (runtime == null) {
            return XStarCompiler.parseRuntimeLibrary();
        }
        return runtime;
    }

    private ModuleSignature newRuntimeLibrarySignatureInstance() throws Exception {
        ModuleSignature signature = this.readModuleSignature();
        if (signature == null) {
            signature = XStarCompiler.parseRuntimeLibrarySignature();
        }
        return signature;
    }

    public void linkAndCodeGen(Program program, Module runtime, Module starlet, SessionContext session) throws Exception {
        this.m_linkerSettings.getCodeGenerationSettings().setBCELClassCollector(this.getByteCodeClassCollecter());
        if (XPathPreparer.JAVASOURCEDESTDIRSPECIFIED) {
            File dir = new File(XPathPreparer.OPTION_JAVASOURCEDESTDIRS);
            this.m_linkerSettings.setOutputDir(dir);
        }
        this.getLinker().compileProgram(program, starlet, runtime, 1, Collections.EMPTY_LIST, this.m_className, this.m_linkerSettings, session);
        if ((this.m_outputType & 4) != 0) {
            this.outputToJar((this.m_outputType & 0x10) != 0);
        }
    }

    public XStarLinker getLinker() {
        return XStarLinker.s_linker;
    }

    public static Module parseRuntimeLibrary() throws Exception {
        ClassLoaderSourceResolver clsr = new ClassLoaderSourceResolver();
        Parser parser = new Parser(clsr, clsr.resolve(null, "com/ibm/xltxe/rnm1/xtq/xslt/runtime/v2/MainLib2.xylem"));
        new TypeHandler().registerTypes(parser);
        new FormHandler().registerForms(parser);
        Module m = parser.parseModuleFragment();
        m.setName("xslt2");
        m.exportAllSymbols();
        m.typeCheck();
        m.exportAllSymbols();
        m.reduce();
        if (LoggerUtil.isFineLoggable(s_logger)) {
            s_logger.logp(Level.FINE, s_className, "parseRuntimeLibrary", "Successfully parsed FIL runtime library");
        }
        return m;
    }

    private static ModuleSignature parseRuntimeLibrarySignature() throws Exception {
        return XStarCompiler.parseRuntimeLibrary().m_signature;
    }

    public Module getRuntimeLibrary() {
        return this.m_runtimeLibrary;
    }

    public void setRuntimeLibrary(Module rtl) {
        this.m_runtimeLibrary = rtl;
    }

    public void cleanRuntimeLibrary() {
        this.setRuntimeLibrary(null);
    }

    public ModuleSignature getModuleSignature() {
        return this.m_moduleSignature;
    }

    public void setModuleSignature(ModuleSignature signature) {
        this.m_moduleSignature = signature;
    }

    public int getPrereductionSplitLimit() {
        return this.m_compiSettings.getPrereductionSplitLimit();
    }

    public boolean isSerializationTraceEnabled() {
        return this.m_compiSettings.isSerializationTraceEnabled();
    }

    public void setTraceImportsAndIncludes(boolean b) {
        this.m_compiSettings.setTraceImportsAndIncludes(b);
    }

    public void setDoPostASTProcessing(boolean b) {
        this.m_compiSettings.setDoPostASTProcessing(b);
    }

    public boolean getDoPostASTProcessing() {
        return this.m_compiSettings.isDoPostASTProcessing();
    }

    public boolean isInterpreted() {
        return this.m_compiSettings.isInterpreted();
    }

    public boolean useMixedMode() {
        return this.m_mixedMode;
    }

    public Class<? extends AbstractStarlet> getFILLibrary() {
        return this.m_filLibrary;
    }

    public String getFILLibraryName() {
        return this.m_filLibraryName;
    }

    public void setInterpreted(boolean b) {
        this.m_compiSettings.setInterpreted(b);
        if (b && MIXEDMODE) {
            CodeGenerationSettings cgs = this.m_linkerSettings.getCodeGenerationSettings();
            this.m_mixedMode = true;
            this.m_filLibraryName = cgs.getArbitraryPrecision() ? DriverConstants.RUNTIME_ARBITRARY_PRECISION_QUALIFIED_CLASS_NAME : (cgs.getOverflowDetection() ? DriverConstants.RUNTIME_OVERFLOW_DETECTION_QUALIFIED_CLASS_NAME : DriverConstants.RUNTIME_QUALIFIED_CLASS_NAME);
            try {
                this.m_filLibrary = Class.forName(this.m_filLibraryName).asSubclass(AbstractStarlet.class);
                if (LoggerUtil.isFineLoggable(s_logger)) {
                    s_logger.logp(Level.FINE, s_className, "setInterpreted", "Using mixed-mode interpreter: " + this.m_filLibraryName);
                }
            }
            catch (Exception e) {
                s_logger.logrb(Level.WARNING, s_className, "setInterpreted", "com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMessages", "ERR_PRECOMPILED_RUNTIME_NOT_FOUND");
                this.m_mixedMode = false;
            }
        }
    }

    public XSLTCompilerSettings getCompilerSettings() {
        return this.m_compiSettings;
    }

    public static Module loadRuntimeLibrary(boolean interpreted) throws Exception {
        XStarCompiler compiler = new XStarCompiler("2.0");
        compiler.setInterpreted(interpreted);
        return compiler.loadRuntimeLibrary();
    }

    public Module getStarletModule() {
        return this.m_starletModule;
    }

    public void setStarletModule(Module stlModule) {
        this.m_starletModule = stlModule;
    }

    public void cleanStarletModule() {
        this.setStarletModule(null);
    }

    public XTQModuleManager getModuleManager() {
        return this.m_moduleManager;
    }

    public void setModuleManager(XTQModuleManager moduleManager) {
        this.m_moduleManager = moduleManager;
    }

    protected void addModule(XTQProgram astModule, Module xylemModule) {
        this.m_modules.put(astModule, xylemModule);
    }

    public Collection<Module> getModules() {
        return this.m_modules.values();
    }

    public TopLevelModuleImportDirective getModuleImport(XTQProgram astModule) {
        Module module = this.m_modules.get(astModule);
        return new TopLevelModuleImportDirective(module.getName(), module.m_signature, module.getName());
    }

    public Collection<ModuleImportDirective> getModuleImports(Collection<XTQProgram> astModules) {
        ArrayList<ModuleImportDirective> moduleImports = new ArrayList<ModuleImportDirective>();
        Iterator<XTQProgram> iterator = astModules.iterator();
        while (iterator.hasNext()) {
            TopLevelModuleImportDirective moduleImport = this.getModuleImport(iterator.next());
            if (moduleImport == null) continue;
            moduleImports.add(moduleImport);
        }
        return moduleImports;
    }

    protected void setupModuleImports() {
        for (XTQProgram program : this.m_modules.keySet()) {
            Collection<XTQProgram> importedPrograms = this.getCompilerSettings().getExecutionTracing() && !program.isLibraryModule() ? this.getModuleManager().getAllModules() : program.getStaticContext().getModules();
            Module module = this.m_modules.get(program);
            module.addModuleImports(this.getModuleImports(importedPrograms));
        }
    }

    public Map<XTQProgram, Module> getModuleMap() {
        return this.m_modules;
    }

    public XSLTLinkerSettings getLinkerSettings() {
        return this.m_linkerSettings;
    }

    public ErrorHandler getErrorHandler() {
        return this.m_linkerSettings.getErrorHandler();
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.m_linkerSettings.setErrorHandler(handler);
    }

    protected void dumpModule(Module module) {
        try {
            File f2 = new File(XPathPreparer.OPTION_JAVASOURCEDESTDIRS, module.getName() + ".xylem");
            PrintWriter pw = new PrintWriter(new FileWriter(f2));
            module.dump(pw);
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public LineNumberHelper getLineNumberHelper() {
        return this.m_lineNumberHelper;
    }

    static {
        s_cachedCompilerRuntime = null;
        s_cachedRuntimeSignature = null;
        MIXEDMODE = !HiddenOptions.optionValueIs(MIXEDMODE_OPTION, "off");
    }

    private class WritingClassCollector
    extends ChainedClassCollector {
        public WritingClassCollector(ClassCollector next) {
            super(next);
        }

        @Override
        public void handleGeneratedClass(JavaClass jc) {
            try {
                jc.dump(XStarCompiler.this.getOutputFile(jc.getClassName()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void handleGeneratedResource(Resource resource) {
            try {
                resource.dump(new FileOutputStream(new File(XStarCompiler.this.m_destDir, resource.getName())));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class CachingClassCollector
    extends ChainedClassCollector {
        public CachingClassCollector(ClassCollector next) {
            super(next);
        }

        @Override
        public void handleGeneratedClass(JavaClass jc) {
            XStarCompiler.this.m_classes.add(jc);
        }

        @Override
        public void handleGeneratedResource(Resource resource) {
            XStarCompiler.this.m_resources.add(resource);
        }
    }

    private abstract class ChainedClassCollector
    extends ClassCollector {
        private ClassCollector m_nextCollector;

        public ChainedClassCollector(ClassCollector next) {
            this.m_nextCollector = next;
        }

        public abstract void handleGeneratedClass(JavaClass var1);

        public abstract void handleGeneratedResource(Resource var1);

        @Override
        public final void acceptGeneratedClass(JavaClass jc) {
            this.handleGeneratedClass(jc);
            if (this.m_nextCollector != null) {
                this.m_nextCollector.acceptGeneratedClass(jc);
            }
        }

        @Override
        public final void acceptGeneratedResource(Resource resource) {
            this.handleGeneratedResource(resource);
            if (this.m_nextCollector != null) {
                this.m_nextCollector.acceptGeneratedResource(resource);
            }
        }
    }
}

