/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.drivers;

import com.ibm.xltxe.rnm1.xtq.ast.Parser;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.ImportSchemaOrModule;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.SimpleNode;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.XTQProgram;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.ParseException;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.TokenMgrError;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.XPath;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.factories.ExpressionFactoryImpl;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.SourceCache;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XQueryContextWrapper;
import com.ibm.xltxe.rnm1.xtq.common.utils.SystemIDResolver;
import com.ibm.xltxe.rnm1.xtq.common.utils.WrappedRuntimeException;
import com.ibm.xltxe.rnm1.xtq.exec.AbstractSPIPreparer;
import com.ibm.xltxe.rnm1.xtq.exec.XTQStaticContext;
import com.ibm.xltxe.rnm1.xtq.runtime.HandledRuntimeException;
import com.ibm.xltxe.rnm1.xtq.scontext.XStaticContext;
import com.ibm.xltxe.rnm1.xtq.utils.LineInfo;
import com.ibm.xltxe.rnm1.xtq.utils.Reporter;
import com.ibm.xltxe.rnm1.xtq.xquery.drivers.XQueryParseUtils;
import com.ibm.xltxe.rnm1.xtq.xslt.res.ErrorMsg;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.v2.SchemaInfo;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.ASTDecorator2;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xapi.XModuleResolver;
import com.ibm.xml.xci.exec.BasicStaticContext;
import com.ibm.xml.xci.exec.StaticContext;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSModel;
import com.ibm.xml.xml4j.api.s1.xs.XSNamespaceItemList;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class XTQModuleManager {
    private static final Logger s_logger = LoggerUtil.getLogger(XTQModuleManager.class);
    private static final String s_className = XTQModuleManager.class.getName();
    private static final String GENERATED_MODULE_URI = "http://www.ibm.com/xmlns/prod/xltxe-j/modules/uri";
    private final StaticContext m_baseContext;
    private final StaticContext m_baseContextForModules;
    private HashMap<String, XTQProgram> m_modules = new HashMap();
    private int m_idCounter = 1;
    private int m_uriCounter = 1;
    private List<SchemaSet> m_schemaSetList;
    private SourceCache m_sourceCache;
    private Map<Set<String>, SchemaInfo> m_systemIdSet2schemaInfoMap;
    private Map<XTQStaticContext, Set<SchemaInfo>> m_context2schemaInfoSetMap;
    private Map<SchemaInfo, List<Source>> m_schemaInfo2sourceListMap;
    private Map<Set<SchemaInfo>, TypeRegistry> m_schemaInfoSet2typeRegistryMap;

    public XTQModuleManager(StaticContext baseContext) {
        this.m_baseContext = baseContext;
        BasicStaticContext contextCopy = new BasicStaticContext(baseContext.getTypeRegistry());
        baseContext.copyInto(contextCopy);
        contextCopy.removeAllFunctions();
        contextCopy.removeAllVariables();
        this.m_baseContextForModules = contextCopy;
    }

    public boolean hasModules() {
        return this.m_modules.size() > 0;
    }

    public Collection<XTQProgram> getAllModules() {
        return this.m_modules.values();
    }

    public void parseModules(XTQProgram program, Reporter reporter) {
        LinkedList<XTQProgram> moduleQueue = new LinkedList<XTQProgram>();
        IdentityHashMap<XTQProgram, XTQProgram> processed = new IdentityHashMap<XTQProgram, XTQProgram>();
        moduleQueue.add(program);
        while (!moduleQueue.isEmpty()) {
            program = (XTQProgram)moduleQueue.removeFirst();
            processed.put(program, program);
            XStaticContext context2 = program.getStaticContext();
            for (ImportSchemaOrModule imp : context2.getModuleImports().values()) {
                Collection<XTQProgram> modules = this.getModules(imp, context2.getBaseURI(), reporter);
                context2.addModules(modules, imp.getNamespace());
                for (XTQProgram module : modules) {
                    if (processed.containsKey(module)) continue;
                    moduleQueue.add(module);
                }
            }
        }
    }

    public Collection<XTQProgram> getModules(ImportSchemaOrModule imp, String baseURI, Reporter reporter) {
        String namespace2 = imp.getNamespace();
        List<String> locationHints = imp.getHints();
        ArrayList<XTQProgram> programs = new ArrayList<XTQProgram>();
        XModuleResolver moduleResolver = this.getModuleResolver();
        List<? extends Source> modules = null;
        if (moduleResolver != null) {
            modules = moduleResolver.getModule(namespace2, locationHints, baseURI);
        }
        if (modules != null && !modules.isEmpty()) {
            for (Source source : modules) {
                String systemId = source.getSystemId();
                XTQProgram program = null;
                if (systemId == null) {
                    systemId = this.generateModuleURI();
                } else {
                    program = this.m_modules.get(systemId);
                }
                if (program == null) {
                    program = this.parse(source, reporter, namespace2);
                    if (program == null) continue;
                    this.m_modules.put(systemId, program);
                    programs.add(program);
                    continue;
                }
                programs.add(program);
            }
        } else {
            for (int i = 0; i < locationHints.size(); ++i) {
                String string2;
                String uri2 = string2 = locationHints.get(i);
                try {
                    XTQProgram program;
                    if (!SystemIDResolver.isAbsoluteURI(uri2)) {
                        uri2 = SystemIDResolver.getAbsoluteURI(uri2, baseURI);
                    }
                    if ((program = this.m_modules.get(uri2)) == null) {
                        URL url = new URL(uri2);
                        StreamSource source = new StreamSource(url.openStream(), uri2);
                        program = this.parse(source, reporter, namespace2);
                        if (program == null) continue;
                        this.m_modules.put(uri2, program);
                        programs.add(program);
                        continue;
                    }
                    programs.add(program);
                    continue;
                }
                catch (IOException e) {
                    if (!LoggerUtil.isAnyTracingEnabled() || !s_logger.isLoggable(Level.FINE)) continue;
                    s_logger.logp(Level.FINE, s_className, "getModules", "Failed to load module for namespace '" + namespace2 + "' at location '" + uri2 + "'.", e);
                }
            }
        }
        if (programs.isEmpty()) {
            reporter.report(2, new ErrorMsg("ERR_NO_MODULES_FOR_NAMESPACE", (Object)namespace2, (SimpleNode)imp));
        }
        return programs;
    }

    public int getNextId() {
        return this.m_idCounter++;
    }

    public void setSourceCache(SourceCache sourceCache) {
        this.m_sourceCache = sourceCache;
    }

    public SourceCache getSourceCache() {
        return this.m_sourceCache;
    }

    public String getGeneratedSystemId() {
        return "xquery_module" + this.m_uriCounter++ + ".xq";
    }

    private XTQProgram parse(Source querySource, Reporter reporter, String uri2) {
        XTQProgram program = null;
        try {
            Parser parser;
            XTQStaticContext staticContext = this.newXTQStaticContext(false, querySource);
            try {
                querySource = XQueryParseUtils.normalizeLineBreaks(querySource, this);
            }
            catch (Exception e) {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                    s_logger.logp(Level.FINE, s_className, "parse", "Failed to load module for namespace '" + uri2 + "' at location '" + querySource.getSystemId() + "'.", e);
                }
                return null;
            }
            XQueryContextWrapper buildContext = new XQueryContextWrapper(staticContext, reporter);
            buildContext.init();
            try {
                parser = XQueryParseUtils.createParser(querySource, buildContext);
            }
            catch (IOException e) {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                    s_logger.logp(Level.FINE, s_className, "parse", "Failed to load module for namespace '" + uri2 + "' at location '" + querySource.getSystemId() + "'.", e);
                }
                return null;
            }
            if (querySource.getSystemId() != null && querySource.getSystemId().length() > 0) {
                ExpressionFactoryImpl exprFactory = ((XPath)parser.getRealParser()).getExpressionFactory();
                exprFactory.setContainerLineOffset(new LineInfo(querySource.getSystemId(), null, -1, -1, -1, -1));
            }
            Expr expr = parser.parse();
            String baseURI = staticContext.getBaseURI();
            if (baseURI != null) {
                expr.setBaseURI(SystemIDResolver.getAbsoluteURI(baseURI));
            }
            program = expr instanceof XTQProgram ? (XTQProgram)expr : expr.getXTQProgram();
            program.setParser(buildContext);
            if (!program.isLibraryModule() || !program.getModuleNamespaceURILiteral().equals(uri2)) {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                    s_logger.logp(Level.FINE, s_className, "parse", "The module in namespace '" + program.getModuleNamespaceURILiteral() + "' is invalid. " + "To use a module it must be a library module and in the correct " + "namespace.");
                }
                program = null;
            }
        }
        catch (WrappedRuntimeException wre) {
            reporter.report(2, new ErrorMsg(wre), (Throwable)wre.getException());
        }
        catch (HandledRuntimeException e) {
            throw e;
        }
        catch (ParseException e) {
            reporter.report(2, new ErrorMsg("XQUERY_PARSER_ERR", e));
        }
        catch (TokenMgrError e) {
            reporter.report(2, new ErrorMsg("XQUERY_PARSER_ERR"));
        }
        catch (Exception e) {
            reporter.report(2, new ErrorMsg(e), (Throwable)e);
        }
        catch (Error e) {
            reporter.report(2, new ErrorMsg(e), (Throwable)e);
        }
        return program;
    }

    public XTQStaticContext newXTQStaticContext(boolean mainModule, Source source) {
        StaticContext base2 = mainModule ? this.m_baseContext : this.m_baseContextForModules;
        XTQStaticContext xsc = new XTQStaticContext(base2.getTypeRegistry(), base2){

            @Override
            public List<Source> getSchemaSource(SchemaInfo schemaInfo) {
                List<Source> sources;
                if (XTQModuleManager.this.m_systemIdSet2schemaInfoMap == null) {
                    XTQModuleManager.this.m_systemIdSet2schemaInfoMap = new HashMap();
                    XTQModuleManager.this.m_context2schemaInfoSetMap = new HashMap();
                    XTQModuleManager.this.m_schemaInfo2sourceListMap = new HashMap();
                }
                if ((sources = (List<Source>)XTQModuleManager.this.m_schemaInfo2sourceListMap.get(schemaInfo)) == null) {
                    XSNamespaceItemList schemas;
                    String namespace2 = schemaInfo.getNamespace();
                    XSModel xsModel = this.m_typeRegistry.getXSModel();
                    XSNamespaceItemList xSNamespaceItemList = schemas = xsModel != null ? xsModel.getNamespaceItems() : null;
                    if (schemas != null) {
                        int size = schemas.size();
                        for (int i = 0; i < size; ++i) {
                            String schemaNS = schemas.item(i).getSchemaNamespace();
                            if (!namespace2.equals(schemaNS) && (schemaNS != null || !namespace2.equals(""))) continue;
                            sources = Collections.singletonList(this.m_typeRegistry.getSchemaSource(schemaInfo));
                            break;
                        }
                    }
                    if (sources == null) {
                        sources = super.getSchemaSource(schemaInfo);
                    }
                    XTQModuleManager.this.m_schemaInfo2sourceListMap.put(schemaInfo, sources);
                    Set<String> systemIdSet = this.convertSourceListToSystemIdSet(sources);
                    if (!XTQModuleManager.this.m_systemIdSet2schemaInfoMap.containsKey(systemIdSet)) {
                        XTQModuleManager.this.m_systemIdSet2schemaInfoMap.put(systemIdSet, schemaInfo);
                    } else {
                        schemaInfo = (SchemaInfo)XTQModuleManager.this.m_systemIdSet2schemaInfoMap.get(systemIdSet);
                    }
                    HashSet<SchemaInfo> schemaInfoSet = (HashSet<SchemaInfo>)XTQModuleManager.this.m_context2schemaInfoSetMap.get(this);
                    if (schemaInfoSet == null) {
                        schemaInfoSet = new HashSet<SchemaInfo>();
                        XTQModuleManager.this.m_context2schemaInfoSetMap.put(this, schemaInfoSet);
                    }
                    schemaInfoSet.add(schemaInfo);
                }
                return sources;
            }

            @Override
            public XSModel getInScopeSchemaModel() {
                if (this._inScopeSchemaModel == null) {
                    this.createSchemas();
                    SchemaInfo[] schemaImports = this._schemaImports.toArray(new SchemaInfo[0]);
                    HashSet<SchemaInfo> schemaInfoSet = new HashSet<SchemaInfo>(schemaImports.length);
                    if (schemaImports != null && schemaImports.length > 0) {
                        List<Source> sources;
                        if (XTQModuleManager.this.m_schemaInfoSet2typeRegistryMap == null) {
                            XTQModuleManager.this.m_schemaInfoSet2typeRegistryMap = new HashMap();
                        }
                        TypeRegistry tr = null;
                        for (SchemaInfo si : schemaImports) {
                            sources = this.getSchemaSource(si);
                            si = (SchemaInfo)XTQModuleManager.this.m_systemIdSet2schemaInfoMap.get(this.convertSourceListToSystemIdSet(sources));
                            schemaInfoSet.add(si);
                        }
                        tr = (TypeRegistry)XTQModuleManager.this.m_schemaInfoSet2typeRegistryMap.get(schemaInfoSet);
                        if (tr == null) {
                            tr = this.m_typeRegistry.cloneTypeRegistry();
                            tr.setSchemaResolver(this.m_typeRegistry.getSchemaResolver());
                            tr.setErrorHandler(this.m_typeRegistry.getErrorHandler());
                            for (SchemaInfo si : schemaImports) {
                                sources = this.getSchemaSource(si);
                                tr.load(sources);
                            }
                            XTQModuleManager.this.m_schemaInfoSet2typeRegistryMap.put(schemaInfoSet, tr);
                        }
                        this.m_typeRegistry = tr;
                        this.setSchemaResolver(this.m_typeRegistry.getSchemaResolver());
                    }
                    this._inScopeSchemaModel = this.m_typeRegistry.getXSModel();
                }
                return this._inScopeSchemaModel;
            }

            private Set<String> convertSourceListToSystemIdSet(List<Source> sources) {
                HashSet<String> systemIdSet = new HashSet<String>(){

                    @Override
                    public boolean equals(Object object2) {
                        return object2 instanceof Set && !((Set)object2).contains(null) && super.equals(object2);
                    }
                };
                for (Source s : sources) {
                    systemIdSet.add(s.getSystemId());
                }
                return systemIdSet;
            }
        };
        xsc.setBaseURI(AbstractSPIPreparer.getBaseURI(base2.getBaseURI(), source));
        return xsc;
    }

    private XModuleResolver getModuleResolver() {
        return this.m_baseContextForModules.getModuleResolver();
    }

    private String generateModuleURI() {
        return GENERATED_MODULE_URI + this.m_uriCounter++;
    }

    public List<SchemaSet> getAllSchemaSets() {
        return this.m_schemaSetList;
    }

    public void computeSchemaSets(XTQProgram mainModule) {
        if (this.m_systemIdSet2schemaInfoMap == null) {
            return;
        }
        HashMap<XTQProgram, Set<SchemaInfo>> module2schemaInfoSetMap = new HashMap<XTQProgram, Set<SchemaInfo>>();
        if (this.m_context2schemaInfoSetMap.containsKey(mainModule.getStaticContext())) {
            module2schemaInfoSetMap.put(mainModule, this.m_context2schemaInfoSetMap.get(mainModule.getStaticContext()));
        }
        for (XTQProgram module : this.getAllModules()) {
            if (!this.m_context2schemaInfoSetMap.containsKey(module.getStaticContext())) continue;
            module2schemaInfoSetMap.put(module, this.m_context2schemaInfoSetMap.get(module.getStaticContext()));
        }
        HashMap<Set<SchemaInfo>, Set<XTQProgram>> schemaInfoSet2contextSetMap = new HashMap<Set<SchemaInfo>, Set<XTQProgram>>();
        for (Map.Entry entry : module2schemaInfoSetMap.entrySet()) {
            HashSet contextSet = (HashSet)schemaInfoSet2contextSetMap.get(entry.getValue());
            if (contextSet == null) {
                contextSet = new HashSet();
                schemaInfoSet2contextSetMap.put((Set<SchemaInfo>)entry.getValue(), contextSet);
            }
            contextSet.add(entry.getKey());
        }
        this.m_systemIdSet2schemaInfoMap = null;
        this.m_context2schemaInfoSetMap = null;
        this.m_schemaInfo2sourceListMap = null;
        this.m_schemaInfoSet2typeRegistryMap = null;
        this.createSchemaSetList(schemaInfoSet2contextSetMap);
    }

    private void createSchemaSetList(Map<Set<SchemaInfo>, Set<XTQProgram>> schemaInfoSet2contextSetMap) {
        int initialSize = schemaInfoSet2contextSetMap.size();
        this.m_schemaSetList = new ArrayList<SchemaSet>(initialSize);
        for (Map.Entry<Set<SchemaInfo>, Set<XTQProgram>> entry : schemaInfoSet2contextSetMap.entrySet()) {
            int schemaSetKey = this.m_schemaSetList.size();
            Set<SchemaInfo> siSet = entry.getKey();
            this.m_schemaSetList.add(new SchemaSet(schemaSetKey, Arrays.asList(siSet.toArray(new SchemaInfo[siSet.size()]))));
            for (XTQProgram module : entry.getValue()) {
                ASTDecorator2.setModuleSchemaSetKey(module, schemaSetKey);
            }
        }
    }

    public class SchemaSet {
        private List<SchemaInfo> m_schemaInfos;
        private int m_key;

        private SchemaSet(int key2, List<SchemaInfo> schemaInfos) {
            this.m_key = key2;
            this.m_schemaInfos = schemaInfos;
        }

        public List<SchemaInfo> getSchemaInfos() {
            return this.m_schemaInfos;
        }

        public int getKey() {
            return this.m_key;
        }
    }
}

