/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.exec;

import com.ibm.xltxe.rnm1.xtq.common.utils.ErrorHandler;
import com.ibm.xltxe.rnm1.xtq.common.utils.SourceLocation;
import com.ibm.xltxe.rnm1.xtq.exec.SPIErrorHandlerImpl;
import com.ibm.xltxe.rnm1.xtq.exec.XDynamicContextImpl;
import com.ibm.xltxe.rnm1.xtq.runtime.AbstractStarlet;
import com.ibm.xltxe.rnm1.xtq.runtime.DefaultErrorHandler;
import com.ibm.xltxe.rnm1.xtq.runtime.HandledRuntimeException;
import com.ibm.xltxe.rnm1.xtq.xml.res.XMLMessages;
import com.ibm.xltxe.rnm1.xtq.xpath.runtime.ApplyTemplatesDispatchIDTable;
import com.ibm.xltxe.rnm1.xtq.xslt.res.ErrorMsg;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMsg;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.LineNumberHelper;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.utils.HiddenOptions;
import com.ibm.xltxe.rnm1.xylem.utils.OverflowException;
import com.ibm.xltxe.rnm1.xylem.utils.RuntimeTerminateException;
import com.ibm.xltxe.rnm1.xylem.utils.XSLTArgumentNodeMissingTypedValueException;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xapi.XProcessException;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.exec.BasicDynamicContext;
import com.ibm.xml.xci.exec.DynamicContext;
import com.ibm.xml.xci.exec.Executable;
import com.ibm.xml.xci.exec.trace.ModuleDecl;
import com.ibm.xml.xci.exec.trace.SourceProvider;
import com.ibm.xml.xci.type.TypeRegistry;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.Member;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;

public abstract class AbstractSPIExecutable
implements Executable {
    public static final String EXECUTION_TRACE_ENABLED_PROPERTY = "http://www.ibm.com/xmlns/prod/xltxe/execution-trace-enabled";
    public static final String EXECUTION_TRACE_SOURCE_PROVIDER = "http://www.ibm.com/xmlns/prod/xltxe/execution-trace-source-provider";
    public static final String EXECUTION_TRACE_UD_FUNCTIONS = "http://www.ibm.com/xmlns/prod/xltxe/execution-trace-ud-functions";
    public static final String EXECUTION_TRACE_UD_FUNCTION_PARAMS = "http://www.ibm.com/xmlns/prod/xltxe/execution-trace-ud-function-params";
    public static final String EXECUTION_TRACE_EXTENSION_FUNCTIONS = "http://www.ibm.com/xmlns/prod/xltxe/execution-trace-extension-functions";
    public static final String EXECUTION_TRACE_EXTENSION_FUNCTION_PARAMS = "http://www.ibm.com/xmlns/prod/xltxe/execution-trace-extension-function-params";
    public static final String EXECUTION_TRACE_MODULE_DECLS = "http://www.ibm.com/xmlns/prod/xltxe/execution-trace-module-decls";
    private static final Logger s_logger = LoggerUtil.getLogger(AbstractSPIExecutable.class);
    private static final String s_className = AbstractSPIExecutable.class.getName();
    public static final boolean DUMP_INPUT = HiddenOptions.wasSpecified("dumpinput");
    public static final boolean SOURCE_LINE_INFO = !HiddenOptions.wasSpecified("sourceLineInfo") || !"off".equals(HiddenOptions.getStringValue("sourceLineInfo"));
    protected SessionContext m_session;
    private ErrorHandler m_defaultErrorHandler;
    private HashMap<Integer, TypeRegistry> m_typeRegistries;
    private boolean m_executionTraceEnabled = false;
    private SourceProvider m_executionTraceSourceProvider;
    private Map<Integer, ModuleDecl> m_moduleDecls;
    private HashMap<String, Class<?>> m_javaExtensionFuncClassCache = null;
    private HashMap<String, Member> m_javaExtensionFuncMethodCache = null;
    private Map<String, String> m_lineTable;
    private Map<String, String> m_uriTable;
    private SoftReference<Map> m_lineTableSR = null;
    private SoftReference<Map> m_uriTableSR = null;
    private Object m_lineTableLock = new Object();

    public AbstractSPIExecutable() {
    }

    public AbstractSPIExecutable(SessionContext session) {
        this.m_session = session;
    }

    @Override
    public void execute(Cursor focus, DynamicContext context2, Cursor.Profile requestedFeatures, Cursor[] args, Result result2) {
        Cursor resultCursor = this.execute(focus, context2, requestedFeatures, args);
        if (resultCursor != null) {
            resultCursor.copyToResult(result2, null, false, true);
        }
    }

    public void loadSchema(XDynamicContextImpl dc) {
    }

    @Override
    public abstract void execute(Cursor var1, Cursor.Area var2, Cursor var3, DynamicContext var4, Cursor.Profile var5, Cursor[] var6);

    protected void initializeApplyTemplatesDispatchIDTable(AbstractStarlet starlet) {
        ApplyTemplatesDispatchIDTable tbl = new ApplyTemplatesDispatchIDTable();
        boolean assert_ok = tbl.assertTypeMappings(starlet.getNamesArray(), starlet.getUrisArray(), starlet.getTypesArray());
        if (!assert_ok) {
            throw new RuntimeException(XMLMessages.createXMLMessage("ERR_SYSTEM", "Failed pre-asserting XPath Expanded Types into Document Manager."));
        }
        starlet.setApplyTemplatesDispatchIDTable(tbl);
    }

    protected ErrorHandler getErrorHandler(DynamicContext context2) {
        ErrorHandler errorHandler = null;
        if (context2.getErrorHandler() != null) {
            int id2 = -1;
            errorHandler = new SPIErrorHandlerImpl(context2.getErrorHandler(), id2);
        } else {
            errorHandler = this.getDefaultErrorHandler();
        }
        return errorHandler;
    }

    protected void reportError(DynamicContext context2, Throwable e) {
        this.reportError(context2, e, false);
    }

    protected void reportError(DynamicContext context2, Throwable e, boolean isXSLMessage) {
        SourceLocation sourceLocation = this.getSourceLocationFromStackTrace(e);
        String msg = this.getMessageForException(e);
        if (msg == null) {
            msg = e.getMessage();
        }
        ErrorHandler handler = this.getErrorHandler(context2);
        try {
            handler.report(3, msg, sourceLocation, e, true);
        }
        catch (HandledRuntimeException ex) {
            if (ex.getRuntimeException() != null) {
                throw ex.getRuntimeException();
            }
            String code = isXSLMessage ? "ER_API_XSLT_EXECUTION_TERMINATED" : "ER_API_EXECUTION_TERMINATED";
            ErrorMsg fullMsg = new ErrorMsg(msg, sourceLocation);
            throw new XProcessException(XMLMessages.createXMLMessage(code, new Object[]{fullMsg.toString()}), e);
        }
    }

    protected void reportError(DynamicContext context2, RuntimeTerminateException rte) {
        this.reportError(context2, rte, false);
    }

    protected void reportError(DynamicContext context2, RuntimeTerminateException rte, boolean isXSLMessage) {
        String msg;
        Throwable cause = rte.getCause();
        SourceLocation sourceLocation = null;
        if (rte.getSourceLocation() != null) {
            sourceLocation = rte.getSourceLocation();
        } else if (rte.getSourceLocationIndex() != -1) {
            sourceLocation = this.getSourceLocationFromIndex(rte.getSourceLocationIndex());
        }
        if (sourceLocation == null) {
            sourceLocation = this.getSourceLocationFromStackTrace(cause == null ? rte : cause);
        }
        if (cause != null) {
            msg = this.getMessageForException(cause);
            if (msg == null) {
                msg = cause.getMessage();
            }
        } else {
            msg = rte.getMessage();
        }
        ErrorHandler handler = this.getErrorHandler(context2);
        try {
            if (handler instanceof SPIErrorHandlerImpl) {
                ((SPIErrorHandlerImpl)handler).report(3, msg, sourceLocation, cause, true, rte.getErrorObject());
            } else {
                handler.report(3, msg, sourceLocation, cause, true);
            }
        }
        catch (HandledRuntimeException ex) {
            if (ex.getRuntimeException() != null) {
                throw ex.getRuntimeException();
            }
            String code = isXSLMessage ? "ER_API_XSLT_EXECUTION_TERMINATED" : "ER_API_EXECUTION_TERMINATED";
            ErrorMsg fullMsg = new ErrorMsg(msg, sourceLocation);
            throw new XProcessException(XMLMessages.createXMLMessage(code, new Object[]{fullMsg.toString()}), cause);
        }
    }

    private SourceLocation getSourceLocationFromIndex(int index2) {
        AbstractStarlet starlet = this.getCachedStarlet();
        Map lineTable = this.getLineTable();
        Map uriTable = this.getURITable();
        String entry = (String)lineTable.get(String.valueOf(index2));
        if (entry != null) {
            return LineNumberHelper.lineTableEntryToSourceLocation(entry, uriTable);
        }
        return null;
    }

    protected SourceLocation getSourceLocationFromStackTrace(Throwable ex) {
        for (StackTraceElement element2 : ex.getStackTrace()) {
            String filename = element2.getFileName();
            if (filename == null || !filename.equals("com_ibm_xmlns_prod_xltxe_j_linetable") || element2.getLineNumber() <= 0) continue;
            return this.getSourceLocationFromIndex(element2.getLineNumber());
        }
        return null;
    }

    private String getMessageForException(Throwable ex) {
        if (ex instanceof ArithmeticException) {
            return new RuntimeMsg("ERR_DIVISION_BY_ZERO").getFormattedMessage();
        }
        if (ex instanceof OverflowException) {
            return new RuntimeMsg("ERR_OVERFLOW").getFormattedMessage();
        }
        if (ex instanceof XSLTArgumentNodeMissingTypedValueException) {
            return new RuntimeMsg("ERR_NO_TYPE_VALUE").getFormattedMessage();
        }
        return null;
    }

    protected abstract AbstractStarlet getCachedStarlet();

    @Override
    public Map<String, Object> getProperties() {
        return null;
    }

    protected void dumpInput(Cursor input) {
        String filename = "input-dump";
        if (Program.TIMESTAMPED_DUMPS) {
            filename = filename + "." + System.currentTimeMillis();
        }
        filename = filename + ".xml";
        File f2 = new File(filename);
        try {
            PrintStream ps = new PrintStream(new FileOutputStream(f2));
            ps.println("<!-- systemId: " + (input != null && input.itemDocumentInfo() != null ? input.itemDocumentInfo().getURI() : null) + " -->");
            ps.println();
            if (input != null) {
                input = input.fork(false);
                input.copyToResult(new StreamResult(ps), null, false, true);
            }
            ps.close();
            s_logger.logrb(Level.INFO, s_className, "dumpInput", "com.ibm.xltxe.rnm1.xylem.res.XylemMessages", "DUMPED_INFO_LOCATION", new Object[]{f2.getCanonicalPath()});
        }
        catch (IOException io) {
            s_logger.logrb(Level.WARNING, s_className, "dumpInput", "com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMessages", "ERR_SYSTEM_EXCEPTION", (Throwable)io);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ErrorHandler getDefaultErrorHandler() {
        if (this.m_defaultErrorHandler == null) {
            this.m_defaultErrorHandler = new DefaultErrorHandler();
        }
        return this.m_defaultErrorHandler;
    }

    public void initializeBindings(DynamicContext dynamicContext) {
        try {
            if (dynamicContext instanceof BasicDynamicContext) {
                Map<String, Object> props = this.getProperties();
                BasicDynamicContext dcImpl = (BasicDynamicContext)dynamicContext;
                Map functionMap = (Map)(props == null ? null : props.get("http://www.ibm.com/xmlns/prod/xcij/function-map"));
                Map variableMap = (Map)(props == null ? null : props.get("http://www.ibm.com/xmlns/prod/xcij/variable-map"));
                dcImpl.setupBindings(functionMap, variableMap);
            }
        }
        catch (Exception e) {
            this.reportError(dynamicContext, e);
        }
    }

    public synchronized TypeRegistry getTypeRegistry(int schemaSetKey) {
        return this.m_typeRegistries != null ? this.m_typeRegistries.get(schemaSetKey) : null;
    }

    public synchronized void setTypeRegistry(int schemaSetKey, TypeRegistry tr) {
        if (this.m_typeRegistries == null) {
            this.m_typeRegistries = new HashMap();
        }
        this.m_typeRegistries.put(schemaSetKey, tr);
    }

    public boolean getExecutionTraceEnabled() {
        return this.m_executionTraceEnabled;
    }

    public void setExecutionTraceEnabled(boolean value2) {
        this.m_executionTraceEnabled = value2;
    }

    public SourceProvider getExecutionTraceSourceProvider() {
        return this.m_executionTraceSourceProvider;
    }

    public void setExecutionTraceSourceProvider(SourceProvider sp) {
        this.m_executionTraceSourceProvider = sp;
    }

    public Map<Integer, ModuleDecl> getModuleDecls() {
        return this.m_moduleDecls;
    }

    public void setModuleDecls(Map<Integer, ModuleDecl> moduleDecls) {
        this.m_moduleDecls = moduleDecls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initCommonProperties(Map<String, Object> properties) {
        AbstractSPIExecutable abstractSPIExecutable = this;
        synchronized (abstractSPIExecutable) {
            properties.put(EXECUTION_TRACE_ENABLED_PROPERTY, this.getExecutionTraceEnabled());
            if (this.getExecutionTraceSourceProvider() != null) {
                properties.put(EXECUTION_TRACE_SOURCE_PROVIDER, this.getExecutionTraceSourceProvider());
            }
            if (this.getModuleDecls() != null) {
                properties.put(EXECUTION_TRACE_MODULE_DECLS, this.getModuleDecls());
            }
        }
    }

    public synchronized Class lookupExtensionClassInCache(String namespace2) {
        if (this.m_javaExtensionFuncClassCache == null) {
            return null;
        }
        return this.m_javaExtensionFuncClassCache.get(namespace2);
    }

    public synchronized void cacheExtensionClass(String namespace2, Class clazz) {
        if (this.m_javaExtensionFuncClassCache == null) {
            this.m_javaExtensionFuncClassCache = new HashMap();
        }
        this.m_javaExtensionFuncClassCache.put(namespace2, clazz);
    }

    public synchronized Member lookupJavaMemberInCache(String signature) {
        if (this.m_javaExtensionFuncMethodCache == null) {
            return null;
        }
        return this.m_javaExtensionFuncMethodCache.get(signature);
    }

    public synchronized void cacheJavaMember(String signature, Member member) {
        if (this.m_javaExtensionFuncMethodCache == null) {
            this.m_javaExtensionFuncMethodCache = new HashMap();
        }
        this.m_javaExtensionFuncMethodCache.put(signature, member);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getLineTable() {
        if (this.m_lineTable != null) {
            return this.m_lineTable;
        }
        Object object2 = this.m_lineTableLock;
        synchronized (object2) {
            if (this.m_lineTableSR == null || this.m_lineTableSR.get() == null) {
                Map map2 = null;
                try {
                    map2 = this.getCachedStarlet().constructLineTable();
                }
                catch (OutOfMemoryError e) {
                    if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                        s_logger.logp(Level.FINE, s_className, "getLineTable", "OutOfMemoryError trying to create line table.");
                    }
                    map2 = Collections.EMPTY_MAP;
                }
                this.m_lineTableSR = new SoftReference<Map>(map2);
            }
            return this.m_lineTableSR.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getURITable() {
        if (this.m_uriTable != null) {
            return this.m_uriTable;
        }
        Object object2 = this.m_lineTableLock;
        synchronized (object2) {
            if (this.m_uriTableSR == null || this.m_uriTableSR.get() == null) {
                Map map2 = null;
                try {
                    map2 = this.getCachedStarlet().constructURITable();
                }
                catch (OutOfMemoryError e) {
                    if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                        s_logger.logp(Level.FINE, s_className, "getURITable", "OutOfMemoryError trying to create URI table.");
                    }
                    map2 = Collections.EMPTY_MAP;
                }
                this.m_uriTableSR = new SoftReference<Map>(map2);
            }
            return this.m_uriTableSR.get();
        }
    }

    public void setLineTable(Map<String, String> lineTable) {
        this.m_lineTable = lineTable;
    }

    public void setURITable(Map<String, String> uriTable) {
        this.m_uriTable = uriTable;
    }
}

