/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.exec;

import com.ibm.xltxe.rnm1.xtq.common.utils.ErrorHandler;
import com.ibm.xltxe.rnm1.xtq.common.utils.SystemIDResolver;
import com.ibm.xltxe.rnm1.xtq.drivers.XStarCompiler;
import com.ibm.xltxe.rnm1.xtq.exec.SPIErrorHandlerImpl;
import com.ibm.xltxe.rnm1.xtq.exec.SecuritySupport;
import com.ibm.xltxe.rnm1.xtq.exec.XTQStaticContext;
import com.ibm.xltxe.rnm1.xtq.runtime.AbstractErrorHandler;
import com.ibm.xltxe.rnm1.xtq.runtime.DefaultErrorHandler;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.utils.HiddenOptions;
import com.ibm.xml.xapi.XCompilationParameters;
import com.ibm.xml.xapi.XMessageHandler;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.exec.Preparer;
import com.ibm.xml.xci.exec.StaticContext;
import com.ibm.xml.xci.exec.trace.TraceManager;
import com.ibm.xml.xci.type.TypeRegistry;
import java.util.StringTokenizer;
import javax.xml.transform.Source;

public abstract class AbstractSPIPreparer
implements Preparer {
    protected final SessionContext m_session;
    private static boolean s_listenersUpdated = false;
    public static final boolean DUMP_EXPRESSION = HiddenOptions.wasSpecified("dumpexpr");
    public static final boolean DUMP_BYTECODE = HiddenOptions.wasSpecified("dumpbytecode");

    public AbstractSPIPreparer(SessionContext session) {
        this.m_session = session;
    }

    protected XTQStaticContext getXTQStaticContext(StaticContext context2, Source source, boolean clone, ErrorHandler handler) {
        TypeRegistry registry = context2.getTypeRegistry();
        if (clone) {
            TypeRegistry cloned = registry.cloneTypeRegistry();
            cloned.setSchemaResolver(registry.getSchemaResolver());
            if (handler == null) {
                cloned.setErrorHandler(registry.getErrorHandler());
            } else {
                cloned.setErrorHandler(handler);
            }
            registry = cloned;
        }
        XTQStaticContext xsc = new XTQStaticContext(registry, context2);
        xsc.setBaseURI(AbstractSPIPreparer.getBaseURI(context2.getBaseURI(), source));
        return xsc;
    }

    protected XTQStaticContext getXTQStaticContext(StaticContext context2, Source source) {
        return this.getXTQStaticContext(context2, source, false, null);
    }

    protected ErrorHandler getErrorHandler(StaticContext context2) {
        AbstractErrorHandler errorHandler = null;
        if (context2.getErrorHandler() != null) {
            int id2 = -1;
            errorHandler = new SPIErrorHandlerImpl(context2.getErrorHandler(), id2);
        } else {
            errorHandler = new DefaultErrorHandler();
        }
        return errorHandler;
    }

    protected static void reportException(StaticContext context2, Exception e) {
        if (context2.getErrorHandler() == null) {
            e.printStackTrace();
        } else {
            context2.getErrorHandler().report(-1, XMessageHandler.MsgType.FATAL_ERROR, e, null, true);
        }
    }

    protected static void reportError(StaticContext context2, String message) {
        if (context2.getErrorHandler() == null) {
            System.err.println(message);
        } else {
            context2.getErrorHandler().report(-1, XMessageHandler.MsgType.FATAL_ERROR, message, null, true);
        }
    }

    protected String getSourceDescription(Source source) {
        String systemId = source.getSystemId();
        if (systemId != null && systemId.length() != 0) {
            return systemId;
        }
        return source.toString();
    }

    protected void enableBytecodeDump(XStarCompiler compiler) {
        compiler.setOutputType(22);
        String jarName = "bytecode-dump";
        if (Program.TIMESTAMPED_DUMPS) {
            jarName = jarName + "." + System.currentTimeMillis();
        }
        jarName = jarName + ".jar";
        compiler.setJarFileName(jarName);
    }

    @Override
    public SessionContext getSessionContext() {
        return this.m_session;
    }

    public static String getBaseURI(String baseURI, Source source) {
        String systemId;
        if (source != null && (systemId = source.getSystemId()) != null && systemId.length() > 0) {
            return systemId;
        }
        if (baseURI != null && baseURI.length() > 0) {
            return baseURI;
        }
        String userDir = SystemIDResolver.getAbsoluteURIFromRelative(null);
        if (userDir != null) {
            return userDir;
        }
        return "";
    }

    protected String getQualifiedClassName(XCompilationParameters params) {
        String classname = params.getClassName();
        String pkg = params.getPackageName();
        if (pkg != null && pkg.length() > 0) {
            classname = pkg.endsWith(".") ? pkg + classname : pkg + "." + classname;
        }
        return classname;
    }

    protected abstract String getListenersProperty();

    protected abstract int getLanguage();

    protected void updateListeners() {
        if (!s_listenersUpdated) {
            String listeners = SecuritySupport.getSystemProperty(this.getListenersProperty());
            if (listeners != null) {
                StringTokenizer tokenizer = new StringTokenizer(listeners, ",");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    TraceManager.registerListenerClass(token, this.getLanguage());
                }
            }
            s_listenersUpdated = true;
        }
    }

    protected boolean isExecutionTraceEnabled() {
        this.updateListeners();
        String trace2 = SecuritySupport.getSystemProperty("com.ibm.xml.xci.exec.trace.traceEnabled");
        return trace2 != null && trace2.equals("yes");
    }
}

