/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.exec;

import com.ibm.xltxe.rnm1.xtq.runtime.HandledRuntimeException;
import com.ibm.xltxe.rnm1.xtq.xslt.res.ErrorMsg;
import com.ibm.xml.xapi.XMessageHandler;
import com.ibm.xml.xci.exec.SourceLocation;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMLocator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DefaultErrorHandler
implements com.ibm.xml.xci.exec.ErrorHandler,
DOMErrorHandler,
ErrorHandler {
    private String m_unknown = null;

    private void report(XMessageHandler.MsgType level, String message, SourceLocation location, Throwable cause, boolean terminate2) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(message);
        if (location != null) {
            String systemId = location.getSystemId();
            if (systemId == null || systemId.length() == 0) {
                systemId = this.getUnknownString();
            }
            String line = location.getStartLine() == -1 ? this.getUnknownString() : String.valueOf(location.getStartLine());
            String column = location.getStartColumn() == -1 ? this.getUnknownString() : String.valueOf(location.getStartColumn());
            ErrorMsg locationMsg = new ErrorMsg("SOURCE_LOCATION_MSG", new Object[]{systemId, line, column});
            buffer.append(locationMsg.getFormattedMessage());
        }
        String messageAndLocation = buffer.toString();
        switch (level) {
            case INFO: {
                if (cause != null && cause.getMessage() != null) {
                    System.err.println(new ErrorMsg("INFO_PLUS_WRAPPED_MSG", (Object)messageAndLocation, (Object)cause.getMessage()));
                    break;
                }
                System.err.println(new ErrorMsg("INFO_MSG", messageAndLocation));
                break;
            }
            case WARNING: {
                if (cause != null && cause.getMessage() != null) {
                    System.err.println(new ErrorMsg("WARNING_PLUS_WRAPPED_MSG", (Object)messageAndLocation, (Object)cause.getMessage()));
                    break;
                }
                System.err.println(new ErrorMsg("WARNING_MSG", messageAndLocation));
                break;
            }
            case ERROR: {
                if (cause != null && cause.getMessage() != null) {
                    System.err.println(new ErrorMsg("ERROR_PLUS_WRAPPED_MSG", (Object)messageAndLocation, (Object)cause.getMessage()));
                    break;
                }
                System.err.println(new ErrorMsg("ERROR_MSG", messageAndLocation));
                break;
            }
            case FATAL_ERROR: {
                if (cause != null && cause.getMessage() != null) {
                    System.err.println(new ErrorMsg("FATAL_ERR_PLUS_WRAPPED_MSG", (Object)messageAndLocation, (Object)cause.getMessage()));
                    break;
                }
                System.err.println(new ErrorMsg("FATAL_ERR_MSG", messageAndLocation));
                break;
            }
            case TRACE: {
                System.err.println(new ErrorMsg("TRACE_MSG", messageAndLocation));
                break;
            }
            default: {
                if (cause != null && cause.getMessage() != null) {
                    System.err.println(new ErrorMsg("FATAL_ERR_PLUS_WRAPPED_MSG", (Object)messageAndLocation, (Object)cause.getMessage()));
                    break;
                }
                System.err.println(new ErrorMsg("FATAL_ERR_MSG", messageAndLocation));
            }
        }
        if (cause != null) {
            cause.printStackTrace(System.err);
        }
        if (terminate2) {
            String msg = message;
            throw new HandledRuntimeException(msg);
        }
    }

    @Override
    public void report(int dataProviderID, XMessageHandler.MsgType level, String message, SourceLocation location, boolean terminate2) {
        this.report(level, message, location, null, terminate2);
    }

    @Override
    public void report(int dataProviderID, XMessageHandler.MsgType level, Throwable error2, SourceLocation location, boolean terminate2) {
        this.report(level, error2.getMessage(), location, error2, terminate2);
    }

    @Override
    public boolean handleError(DOMError error2) {
        XMessageHandler.MsgType level = this.severityToLevel(error2.getSeverity());
        String message = error2.getMessage();
        Object obj = error2.getRelatedException();
        Throwable cause = obj instanceof Throwable ? (Throwable)obj : null;
        SourceLocation location = this.convertDOMLocation(error2.getLocation());
        this.report(level, message, location, cause, false);
        return true;
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        this.report(XMessageHandler.MsgType.ERROR, ex.getLocalizedMessage(), this.convertSAXLocation(ex), ex, false);
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        this.report(XMessageHandler.MsgType.FATAL_ERROR, ex.getLocalizedMessage(), this.convertSAXLocation(ex), ex, true);
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
        this.report(XMessageHandler.MsgType.WARNING, ex.getLocalizedMessage(), this.convertSAXLocation(ex), ex, false);
    }

    private XMessageHandler.MsgType severityToLevel(short severity) {
        switch (severity) {
            case 1: {
                return XMessageHandler.MsgType.WARNING;
            }
            case 2: {
                return XMessageHandler.MsgType.ERROR;
            }
        }
        return XMessageHandler.MsgType.FATAL_ERROR;
    }

    private SourceLocation convertDOMLocation(DOMLocator locator) {
        if (locator == null) {
            return null;
        }
        return new SourceLocation(locator.getUri(), null, locator.getLineNumber(), locator.getColumnNumber(), -1, -1);
    }

    private SourceLocation convertSAXLocation(SAXParseException ex) {
        return new SourceLocation(ex.getSystemId(), ex.getPublicId(), ex.getLineNumber(), ex.getColumnNumber(), -1, -1);
    }

    private String getUnknownString() {
        if (this.m_unknown == null) {
            this.m_unknown = new ErrorMsg("UNKNOWN_MSG").getFormattedMessage();
        }
        return this.m_unknown;
    }
}

