/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.exec;

import com.ibm.xml.xapi.XMessageHandler;
import com.ibm.xml.xapi.XSequenceCursor;
import com.ibm.xml.xci.exec.SourceLocation;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMLocator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class DelegatingErrorHandler
implements com.ibm.xml.xci.exec.ErrorHandler,
DOMErrorHandler,
ErrorHandler {
    private XMessageHandler m_userEH;

    public DelegatingErrorHandler(XMessageHandler userEH) {
        this.m_userEH = userEH;
    }

    @Override
    public void report(int dataProviderID, XMessageHandler.MsgType level, String message, SourceLocation location, boolean terminate2) {
        this.m_userEH.report(level, message, location, null, null);
    }

    @Override
    public void report(int dataProviderID, XMessageHandler.MsgType level, Throwable error2, SourceLocation location, boolean terminate2) {
        this.m_userEH.report(level, error2.getMessage(), location, error2, null);
    }

    public void report(int dataProviderID, XMessageHandler.MsgType level, String message, SourceLocation location, boolean terminate2, XSequenceCursor errorItems) {
        this.m_userEH.report(level, message, location, null, errorItems);
    }

    public void report(int dataProviderID, XMessageHandler.MsgType level, Throwable error2, SourceLocation location, boolean terminate2, XSequenceCursor errorItems) {
        this.m_userEH.report(level, error2.getMessage(), location, error2, errorItems);
    }

    @Override
    public boolean handleError(DOMError error2) {
        XMessageHandler.MsgType level = this.severityToLevel(error2.getSeverity());
        String message = error2.getMessage();
        Object obj = error2.getRelatedException();
        Throwable cause = obj instanceof Throwable ? (Throwable)obj : null;
        SourceLocation location = this.convertDOMLocation(error2.getLocation());
        this.m_userEH.report(level, message, location, cause, null);
        return true;
    }

    private XMessageHandler.MsgType severityToLevel(short severity) {
        switch (severity) {
            case 1: {
                return XMessageHandler.MsgType.WARNING;
            }
            case 2: {
                return XMessageHandler.MsgType.ERROR;
            }
        }
        return XMessageHandler.MsgType.FATAL_ERROR;
    }

    private SourceLocation convertDOMLocation(DOMLocator locator) {
        if (locator == null) {
            return null;
        }
        return new SourceLocation(locator.getUri(), null, locator.getLineNumber(), locator.getColumnNumber(), -1, -1);
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        this.m_userEH.report(XMessageHandler.MsgType.ERROR, ex.getLocalizedMessage(), this.convertSAXLocation(ex), ex, null);
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        this.m_userEH.report(XMessageHandler.MsgType.FATAL_ERROR, ex.getLocalizedMessage(), this.convertSAXLocation(ex), ex, null);
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
        this.m_userEH.report(XMessageHandler.MsgType.WARNING, ex.getLocalizedMessage(), this.convertSAXLocation(ex), ex, null);
    }

    private SourceLocation convertSAXLocation(SAXParseException ex) {
        return new SourceLocation(ex.getSystemId(), ex.getPublicId(), ex.getLineNumber(), ex.getColumnNumber(), -1, -1);
    }
}

