/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.exec;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xapi.XSchemaResolver;
import com.ibm.xml.xci.type.SchemaResolver;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;

public class DelegatingSchemaResolver
implements SchemaResolver {
    private static final Logger s_logger = LoggerUtil.getLogger(DelegatingSchemaResolver.class);
    private static final String s_className = DelegatingSchemaResolver.class.getName();
    XSchemaResolver m_resolver = null;

    public DelegatingSchemaResolver(XSchemaResolver resolver2) {
        this.m_resolver = resolver2;
    }

    public XSchemaResolver getSchemaResolver() {
        return this.m_resolver;
    }

    @Override
    public List<? extends Source> resolve(SchemaResolver.SchemaIdentifier schemaIdentifier) {
        List<String> locations = schemaIdentifier.getLocations();
        String baseURI = schemaIdentifier.getBaseURI();
        String namespace2 = schemaIdentifier.getNamespace();
        List<? extends Source> list = this.m_resolver.getSchema(namespace2, locations, baseURI);
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            StringBuilder sources = new StringBuilder();
            for (Source source : list) {
                sources.append(source);
                if (source != null) {
                    sources.append(" with systemId '");
                    sources.append(source.getSystemId());
                    sources.append('\'');
                }
                sources.append('\n');
            }
            s_logger.logp(Level.FINER, s_className, "resolve", "User-supplied XSchemaResolver " + this.m_resolver.toString() + " used to resolve (" + schemaIdentifier.toString() + ") returned the following Sources:\n" + sources.toString());
        }
        return list;
    }
}

