/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.exec;

import com.ibm.xltxe.rnm1.xtq.exec.DelegatingErrorHandler;
import com.ibm.xltxe.rnm1.xtq.runtime.AbstractErrorHandler;
import com.ibm.xltxe.rnm1.xtq.runtime.HandledRuntimeException;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xapi.XMessageHandler;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.exec.ErrorHandler;
import com.ibm.xml.xci.exec.SourceLocation;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SPIErrorHandlerImpl
extends AbstractErrorHandler {
    private static final Logger s_logger = LoggerUtil.getLogger(SPIErrorHandlerImpl.class);
    private static final String s_className = SPIErrorHandlerImpl.class.getName();
    private ErrorHandler m_xciEH;
    private int m_dataProviderID;

    public SPIErrorHandlerImpl(ErrorHandler xciEH, int dataProviderID) {
        this.m_xciEH = xciEH;
        this.m_dataProviderID = dataProviderID;
    }

    @Override
    public void report(int level, String message, com.ibm.xltxe.rnm1.xtq.common.utils.SourceLocation location, Throwable cause, boolean terminate2) {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "report", "Error message: " + message, cause);
        }
        SourceLocation xciSL = null;
        if (location != null) {
            xciSL = new SourceLocation(location.getSystemId(), location.getPublicId(), location.getLineNumber(), location.getColumnNumber(), location.getEndLine(), location.getEndColumn());
        }
        try {
            if (cause == null) {
                this.m_xciEH.report(this.m_dataProviderID, this.getLevel(level), message, xciSL, terminate2);
            } else {
                Throwable throwableToReport = message == null || message.equals(cause.getMessage()) ? cause : new RuntimeException(message, cause);
                this.m_xciEH.report(this.m_dataProviderID, this.getLevel(level), throwableToReport, xciSL, terminate2);
            }
        }
        catch (RuntimeException e) {
            throw new HandledRuntimeException(e);
        }
        if (terminate2) {
            String msg = message;
            if (msg == null && cause != null) {
                msg = cause.getMessage();
            }
            throw new HandledRuntimeException(msg);
        }
    }

    public void report(int level, String message, com.ibm.xltxe.rnm1.xtq.common.utils.SourceLocation location, Throwable cause, boolean terminate2, Cursor errorItems) {
        SourceLocation xciSL = null;
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "report", "Error message: " + message, cause);
        }
        xciSL = SPIErrorHandlerImpl.convertSourceLocation(location);
        try {
            if (cause == null) {
                if (this.m_xciEH instanceof DelegatingErrorHandler) {
                    ((DelegatingErrorHandler)this.m_xciEH).report(this.m_dataProviderID, this.getLevel(level), message, xciSL, terminate2, errorItems != null ? errorItems.getSequenceCursor() : null);
                } else {
                    this.m_xciEH.report(this.m_dataProviderID, this.getLevel(level), message, xciSL, terminate2);
                }
            } else {
                Throwable throwableToReport = message == null || message.equals(cause.getMessage()) ? cause : new RuntimeException(message, cause);
                if (this.m_xciEH instanceof DelegatingErrorHandler) {
                    ((DelegatingErrorHandler)this.m_xciEH).report(this.m_dataProviderID, this.getLevel(level), throwableToReport, xciSL, terminate2, errorItems != null ? errorItems.getSequenceCursor() : null);
                } else {
                    this.m_xciEH.report(this.m_dataProviderID, this.getLevel(level), throwableToReport, xciSL, terminate2);
                }
            }
        }
        catch (RuntimeException e) {
            throw new HandledRuntimeException(e);
        }
        if (terminate2) {
            String msg = message;
            if (msg == null && cause != null) {
                msg = cause.getMessage();
            }
            throw new HandledRuntimeException(msg);
        }
    }

    public static SourceLocation convertSourceLocation(com.ibm.xltxe.rnm1.xtq.common.utils.SourceLocation location) {
        if (location == null) {
            return null;
        }
        return new SourceLocation(location.getSystemId(), location.getPublicId(), location.getLineNumber(), location.getColumnNumber(), location.getEndLine(), location.getEndColumn());
    }

    private XMessageHandler.MsgType getLevel(int level) {
        switch (level) {
            case 0: {
                return XMessageHandler.MsgType.INFO;
            }
            case 1: {
                return XMessageHandler.MsgType.WARNING;
            }
            case 2: {
                return XMessageHandler.MsgType.ERROR;
            }
            case 4: {
                return XMessageHandler.MsgType.TRACE;
            }
        }
        return XMessageHandler.MsgType.FATAL_ERROR;
    }
}

