/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.exec;

import com.ibm.xltxe.rnm1.xtq.exec.DefaultErrorHandler;
import com.ibm.xltxe.rnm1.xtq.exec.DelegatingErrorHandler;
import com.ibm.xltxe.rnm1.xtq.exec.DelegatingSchemaResolver;
import com.ibm.xltxe.rnm1.xtq.exec.XCompilationParametersImpl;
import com.ibm.xltxe.rnm1.xtq.exec.XDynamicContextImpl;
import com.ibm.xltxe.rnm1.xtq.exec.XItemFactoryImpl;
import com.ibm.xltxe.rnm1.xtq.exec.XOutputParametersImpl;
import com.ibm.xltxe.rnm1.xtq.exec.XPathExecutableImpl;
import com.ibm.xltxe.rnm1.xtq.exec.XQueryExecutableImpl;
import com.ibm.xltxe.rnm1.xtq.exec.XSLTExecutableImpl;
import com.ibm.xltxe.rnm1.xtq.exec.XSequenceTypeFactoryImpl;
import com.ibm.xltxe.rnm1.xtq.exec.XStaticContextImpl;
import com.ibm.xltxe.rnm1.xtq.xml.res.XMLMessages;
import com.ibm.xml.jaxp.util.JAXPFactoryHelper;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xapi.XCompilationFactory;
import com.ibm.xml.xapi.XCompilationParameters;
import com.ibm.xml.xapi.XDynamicContext;
import com.ibm.xml.xapi.XFactory;
import com.ibm.xml.xapi.XItemFactory;
import com.ibm.xml.xapi.XItemSource;
import com.ibm.xml.xapi.XItemView;
import com.ibm.xml.xapi.XMessageHandler;
import com.ibm.xml.xapi.XOutputParameters;
import com.ibm.xml.xapi.XPathExecutable;
import com.ibm.xml.xapi.XProcessException;
import com.ibm.xml.xapi.XQueryExecutable;
import com.ibm.xml.xapi.XSLTExecutable;
import com.ibm.xml.xapi.XSchemaResolver;
import com.ibm.xml.xapi.XSequenceTypeFactory;
import com.ibm.xml.xapi.XStaticContext;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.exec.BasicStaticContext;
import com.ibm.xml.xci.exec.CompilationParameters;
import com.ibm.xml.xci.exec.Executable;
import com.ibm.xml.xci.exec.Preparer;
import com.ibm.xml.xci.exec.StaticContext;
import com.ibm.xml.xci.internal.util.xml.XCIPSVIDocument;
import com.ibm.xml.xci.type.TypeRegistry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class XFactoryImpl
extends XFactory
implements XCompilationFactory {
    private static final Logger s_logger = LoggerUtil.getLogger(XFactoryImpl.class);
    private static final String s_className = XFactoryImpl.class.getName();
    private static final DefaultErrorHandler m_defaultErrorHandler = new DefaultErrorHandler();
    private final SessionContext m_sessionContext;
    private boolean m_isValidating = false;
    private XItemFactory m_itemFactory;
    private XSequenceTypeFactory m_sequenceTypeFactory;
    private XSchemaResolver m_schemaResolver;
    private XMessageHandler m_messageHandler;
    private ErrorHandler m_saxErrorHandler;

    public XFactoryImpl() {
        this.m_sessionContext = new SessionContext();
        this.setErrorHandler(m_defaultErrorHandler);
    }

    public XFactoryImpl(SessionContext context2) {
        this.m_sessionContext = context2;
    }

    @Override
    public boolean compileXPath(String expression2, XStaticContext context2, XCompilationParameters params) {
        this.checkExpression(expression2);
        StaticContext spiContext = this.getSPIStaticContext(context2);
        spiContext.setLanguageTypeAndVersion(4);
        SessionContext sessionContext = this.getSessionContext();
        Preparer preparer = sessionContext.getPreparer(RequestInfo.XPath2);
        return preparer.compile(expression2, spiContext, (CompilationParameters)params, -1);
    }

    @Override
    public boolean compileXPath(StreamSource expression2, XStaticContext context2, XCompilationParameters params) {
        this.checkExpression(expression2);
        StaticContext spiContext = this.getSPIStaticContext(context2);
        spiContext.setLanguageTypeAndVersion(4);
        SessionContext sessionContext = this.getSessionContext();
        Preparer preparer = sessionContext.getPreparer(RequestInfo.XPath2);
        return preparer.compile(expression2, spiContext, (CompilationParameters)params, -1);
    }

    @Override
    public boolean compileXQuery(String query, XStaticContext context2, XCompilationParameters params) {
        this.checkExpression(query);
        StaticContext spiContext = this.getSPIStaticContext(context2);
        spiContext.setLanguageTypeAndVersion(1);
        SessionContext sessionContext = this.getSessionContext();
        Preparer preparer = sessionContext.getPreparer(RequestInfo.XQuery);
        return preparer.compile(query, spiContext, (CompilationParameters)params, -1);
    }

    @Override
    public boolean compileXQuery(StreamSource query, XStaticContext context2, XCompilationParameters params) {
        this.checkExpression(query);
        StaticContext spiContext = this.getSPIStaticContext(context2);
        spiContext.setLanguageTypeAndVersion(1);
        SessionContext sessionContext = this.getSessionContext();
        Preparer preparer = sessionContext.getPreparer(RequestInfo.XQuery);
        return preparer.compile(query, spiContext, (CompilationParameters)params, -1);
    }

    @Override
    public boolean compileXSLT(StreamSource stylesheet, XStaticContext context2, XCompilationParameters params) {
        this.checkExpression(stylesheet);
        StaticContext spiContext = this.getSPIStaticContext(context2);
        spiContext.setLanguageTypeAndVersion(6);
        SessionContext sessionContext = this.getSessionContext();
        Preparer preparer = sessionContext.getPreparer(RequestInfo.XSLT2);
        return preparer.compile(stylesheet, spiContext, (CompilationParameters)params, -1);
    }

    @Override
    public XPathExecutable loadXPath(XCompilationParameters params) {
        try {
            SessionContext sessionContext = this.getSessionContext();
            Preparer preparer = sessionContext.getPreparer(RequestInfo.XPath2);
            Executable executable = preparer.load((CompilationParameters)params);
            return new XPathExecutableImpl(this, executable, this.m_isValidating);
        }
        catch (Throwable e) {
            this.loadError(params, e);
            return null;
        }
    }

    @Override
    public XQueryExecutable loadXQuery(XCompilationParameters params) {
        try {
            SessionContext sessionContext = this.getSessionContext();
            Preparer preparer = sessionContext.getPreparer(RequestInfo.XQuery);
            Executable executable = preparer.load((CompilationParameters)params);
            return new XQueryExecutableImpl(this, executable, this.m_isValidating);
        }
        catch (Throwable e) {
            this.loadError(params, e);
            return null;
        }
    }

    @Override
    public XSLTExecutable loadXSLT(XCompilationParameters params) {
        try {
            SessionContext sessionContext = this.getSessionContext();
            Preparer preparer = sessionContext.getPreparer(RequestInfo.XSLT2);
            Executable executable = preparer.load((CompilationParameters)params);
            return new XSLTExecutableImpl(this, executable, this.m_isValidating);
        }
        catch (Throwable e) {
            this.loadError(params, e);
            return null;
        }
    }

    @Override
    public XDynamicContext newDynamicContext() {
        XDynamicContextImpl context2 = new XDynamicContextImpl(this.m_sessionContext, this.m_isValidating);
        context2.setMessageHandler(this.m_messageHandler);
        return context2;
    }

    @Override
    public XStaticContext newStaticContext() {
        XStaticContextImpl context2 = new XStaticContextImpl(this.getTypeRegistry());
        context2.setMessageHandler(this.m_messageHandler);
        return context2;
    }

    @Override
    public XPathExecutable prepareXPath(String expression2, XStaticContext context2) {
        this.checkExpression(expression2);
        StaticContext spiContext = this.getSPIStaticContext(context2);
        spiContext.setLanguageTypeAndVersion(4);
        SessionContext sessionContext = this.getSessionContext();
        Preparer preparer = sessionContext.getPreparer(RequestInfo.XPath2);
        Executable executable = preparer.prepare(expression2, spiContext, -1);
        this.checkExecutable(executable);
        return new XPathExecutableImpl(this, executable, this.m_isValidating);
    }

    @Override
    public XPathExecutable prepareXPath(StreamSource expression2, XStaticContext context2) {
        this.checkExpression(expression2);
        StaticContext spiContext = this.getSPIStaticContext(context2);
        spiContext.setLanguageTypeAndVersion(4);
        SessionContext sessionContext = this.getSessionContext();
        Preparer preparer = sessionContext.getPreparer(RequestInfo.XPath2);
        Executable executable = preparer.prepare(expression2, spiContext, -1);
        this.checkExecutable(executable);
        return new XPathExecutableImpl(this, executable, this.m_isValidating);
    }

    @Override
    public XQueryExecutable prepareXQuery(String query, XStaticContext context2) {
        this.checkExpression(query);
        StaticContext spiContext = this.getSPIStaticContext(context2);
        spiContext.setLanguageTypeAndVersion(1);
        SessionContext sessionContext = this.getSessionContext();
        Preparer preparer = sessionContext.getPreparer(RequestInfo.XQuery);
        Executable executable = preparer.prepare(query, spiContext, -1);
        this.checkExecutable(executable);
        return new XQueryExecutableImpl(this, executable, this.m_isValidating);
    }

    @Override
    public XQueryExecutable prepareXQuery(StreamSource query, XStaticContext context2) {
        this.checkExpression(query);
        StaticContext spiContext = this.getSPIStaticContext(context2);
        spiContext.setLanguageTypeAndVersion(1);
        SessionContext sessionContext = this.getSessionContext();
        Preparer preparer = sessionContext.getPreparer(RequestInfo.XQuery);
        Executable executable = preparer.prepare(query, spiContext, -1);
        this.checkExecutable(executable);
        return new XQueryExecutableImpl(this, executable, this.m_isValidating);
    }

    @Override
    public XSLTExecutable prepareXSLT(Source stylesheet, XStaticContext context2) {
        stylesheet = this.checkStylesheet(stylesheet);
        StaticContext spiContext = this.getSPIStaticContext(context2);
        spiContext.setLanguageTypeAndVersion(6);
        SessionContext sessionContext = this.getSessionContext();
        Preparer preparer = sessionContext.getPreparer(RequestInfo.XSLT2);
        Executable executable = preparer.prepare(stylesheet, spiContext, -1);
        this.checkExecutable(executable);
        return new XSLTExecutableImpl(this, executable, this.m_isValidating);
    }

    @Override
    public boolean compileXPath(String expression2, XCompilationParameters params) {
        return this.compileXPath(expression2, null, params);
    }

    @Override
    public boolean compileXPath(StreamSource expression2, XCompilationParameters params) {
        return this.compileXPath(expression2, null, params);
    }

    @Override
    public boolean compileXQuery(String query, XCompilationParameters params) {
        return this.compileXQuery(query, null, params);
    }

    @Override
    public boolean compileXQuery(StreamSource query, XCompilationParameters params) {
        return this.compileXQuery(query, null, params);
    }

    @Override
    public boolean compileXSLT(StreamSource stylesheet, XCompilationParameters params) {
        return this.compileXSLT(stylesheet, null, params);
    }

    @Override
    public XPathExecutable prepareXPath(String expression2) {
        return this.prepareXPath(expression2, null);
    }

    @Override
    public XPathExecutable prepareXPath(StreamSource expression2) {
        return this.prepareXPath(expression2, null);
    }

    @Override
    public XQueryExecutable prepareXQuery(String query) {
        return this.prepareXQuery(query, null);
    }

    @Override
    public XQueryExecutable prepareXQuery(StreamSource query) {
        return this.prepareXQuery(query, null);
    }

    @Override
    public XSLTExecutable prepareXSLT(Source stylesheet) {
        return this.prepareXSLT(stylesheet, null);
    }

    @Override
    public void registerSchema(Source source) {
        if (source == null) {
            throw new NullPointerException(XMLMessages.createXMLMessage("ER_API_NULL_SCHEMA_SOURCE", null));
        }
        ArrayList<Source> schemas = new ArrayList<Source>();
        schemas.add(source);
        this.getTypeRegistry().load(schemas);
    }

    @Override
    public void registerSchemas(List<? extends Source> schemas) {
        if (schemas == null) {
            throw new NullPointerException(XMLMessages.createXMLMessage("ER_API_NULL_SCHEMA_SOURCE", null));
        }
        this.getTypeRegistry().load(schemas);
    }

    @Override
    public void setValidating(int value2) {
        switch (value2) {
            case 0: {
                this.m_isValidating = false;
                break;
            }
            case 1: {
                this.m_isValidating = true;
                break;
            }
            default: {
                throw new IllegalArgumentException(XMLMessages.createXMLMessage("ER_API_INVALID_ARGUMENT", new Object[]{"setValidating", "XFactory.NO_VALIDATION, XFactory.FULL_VALIDATION"}));
            }
        }
    }

    @Override
    public int getValidating() {
        if (this.m_isValidating) {
            return 1;
        }
        return 0;
    }

    @Override
    public XSchemaResolver getSchemaResolver() {
        return this.m_schemaResolver;
    }

    @Override
    public void setSchemaResolver(XSchemaResolver resolver2) {
        this.m_schemaResolver = resolver2;
        DelegatingSchemaResolver schemaResolver = null;
        if (resolver2 != null) {
            schemaResolver = new DelegatingSchemaResolver(resolver2);
        }
        this.getTypeRegistry().setSchemaResolver(schemaResolver);
    }

    @Override
    public XItemFactory getItemFactory() {
        if (this.m_itemFactory == null) {
            this.m_itemFactory = new XItemFactoryImpl(this);
        }
        return this.m_itemFactory;
    }

    @Override
    public XSequenceTypeFactory getSequenceTypeFactory() {
        if (this.m_sequenceTypeFactory == null) {
            this.m_sequenceTypeFactory = new XSequenceTypeFactoryImpl(this);
        }
        return this.m_sequenceTypeFactory;
    }

    @Override
    public XOutputParameters newOutputParameters() {
        return new XOutputParametersImpl();
    }

    @Override
    public Document getValidatedDOM(Document document2) {
        Schema schema2 = this.getTypeRegistry().getSchema();
        Document result2 = document2 instanceof XCIPSVIDocument ? document2 : new XCIPSVIDocument();
        try {
            Validator v = schema2.newValidator();
            if (this.m_saxErrorHandler != null) {
                v.setErrorHandler(this.m_saxErrorHandler);
            }
            v.validate(new DOMSource(document2), new DOMResult(result2));
            return result2;
        }
        catch (Exception e) {
            throw new XProcessException(XMLMessages.createXMLMessage("ER_API_VALIDATE_DOM", e.getMessage()), e);
        }
    }

    @Override
    public Document getValidatedDOM(StreamSource source) {
        InputSource inputSource = null;
        InputStream stream2 = source.getInputStream();
        String systemID = source.getSystemId();
        if (null != stream2) {
            inputSource = new InputSource(stream2);
        } else {
            Reader reader = source.getReader();
            if (null != reader) {
                inputSource = new InputSource(reader);
            }
        }
        if (null != systemID) {
            if (inputSource == null) {
                inputSource = new InputSource(systemID);
            } else {
                inputSource.setSystemId(systemID);
            }
        }
        if (inputSource == null) {
            throw new IllegalArgumentException(XMLMessages.createXMLMessage("ER_API_EMPTY_STREAM_SOURCE", null));
        }
        inputSource.setSystemId(systemID);
        Schema schema2 = this.getTypeRegistry().getSchema();
        DocumentBuilderFactory factory = JAXPFactoryHelper.newDocumentBuilderFactory();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        factory.setAttribute("http://apache.org/xml/properties/dom/document-class-name", "com.ibm.xml.xci.internal.util.xml.XCIPSVIDocument");
        factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", null);
        factory.setSchema(schema2);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            if (this.m_saxErrorHandler != null) {
                builder.setErrorHandler(this.m_saxErrorHandler);
            }
            Document document2 = builder.parse(inputSource);
            return document2;
        }
        catch (Exception e) {
            throw new XProcessException(XMLMessages.createXMLMessage("ER_API_VALIDATE_DOM", e.getMessage()), e);
        }
    }

    @Override
    public XCompilationParameters newCompilationParameters(String className) {
        return new XCompilationParametersImpl(className);
    }

    public SessionContext getSessionContext() {
        return this.m_sessionContext;
    }

    private TypeRegistry getTypeRegistry() {
        return this.getSessionContext().getTypeRegistry();
    }

    private StaticContext getSPIStaticContext(XStaticContext context2) {
        StaticContext spiContext;
        if (context2 == null) {
            spiContext = new BasicStaticContext(this.getTypeRegistry());
            if (this.m_messageHandler != null) {
                spiContext.setErrorHandler(new DelegatingErrorHandler(this.m_messageHandler));
            }
        } else {
            spiContext = ((XStaticContextImpl)context2).getSPIStaticContext();
        }
        return spiContext;
    }

    private void checkExpression(Object expression2) {
        if (expression2 == null) {
            throw new NullPointerException(XMLMessages.createXMLMessage("ER_API_NULL_EXPR", null));
        }
    }

    private Source checkStylesheet(Source stylesheet) {
        this.checkExpression(stylesheet);
        if (stylesheet instanceof XItemSource) {
            XItemView item2 = ((XItemSource)stylesheet).getItem();
            if (item2 == null) {
                throw new NullPointerException(XMLMessages.createXMLMessage("ER_API_NULL_EXPR", null));
            }
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            item2.exportItem(new StreamResult(output));
            ByteArrayInputStream input = new ByteArrayInputStream(output.toByteArray());
            stylesheet = new StreamSource(input, stylesheet.getSystemId());
        }
        return stylesheet;
    }

    private void checkExecutable(Executable executable) {
        if (executable == null) {
            throw new XProcessException(XMLMessages.createXMLMessage("ER_API_CREATE_EXEC_FAILED", null), null);
        }
    }

    private String getDirectory(XCompilationParameters params) {
        String directory = params.getDirectoryName();
        if (directory == null) {
            try {
                directory = (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return System.getProperty("user.dir");
                    }
                });
            }
            catch (SecurityException e) {
                directory = "";
            }
        }
        return directory;
    }

    private void loadError(XCompilationParameters params, Throwable cause) {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "loadError", "Error loading class " + params.getClassName() + " in package " + params.getPackageName() + ".", cause);
        }
        throw new XProcessException(XMLMessages.createXMLMessage("ER_API_LOAD_FAILED", new Object[]{params.getClassName(), params.getPackageName()}), cause);
    }

    @Override
    public XCompilationFactory getCompilationFactory() {
        return this;
    }

    @Override
    public XMessageHandler getMessageHandler() {
        return this.m_messageHandler;
    }

    @Override
    public void setMessageHandler(XMessageHandler handler) {
        this.m_messageHandler = handler;
        if (handler != null) {
            DelegatingErrorHandler dHandler = new DelegatingErrorHandler(handler);
            this.m_saxErrorHandler = dHandler;
            this.setErrorHandler(dHandler);
        } else {
            this.m_saxErrorHandler = m_defaultErrorHandler;
            this.setErrorHandler(m_defaultErrorHandler);
        }
    }

    private void setErrorHandler(DOMErrorHandler handler) {
        this.getSessionContext().setErrorHandler(handler);
        this.getTypeRegistry().setErrorHandler(handler);
    }
}

