/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.runtime;

import com.ibm.xltxe.rnm1.xtq.common.utils.SourceLocation;
import com.ibm.xltxe.rnm1.xtq.runtime.AbstractErrorHandler;
import com.ibm.xltxe.rnm1.xtq.runtime.HandledRuntimeException;
import com.ibm.xltxe.rnm1.xtq.xslt.res.ErrorMsg;
import com.ibm.xml.ras.LoggerUtil;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultErrorHandler
extends AbstractErrorHandler {
    private static final Logger s_logger = LoggerUtil.getLogger(DefaultErrorHandler.class);
    private static final String s_className = DefaultErrorHandler.class.getName();
    private String m_unknown = null;

    @Override
    public void report(int level, String message, SourceLocation location, Throwable cause, boolean terminate2) {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "report", "Error message: " + message, cause);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(message);
        if (location != null) {
            String systemId = location.getSystemId();
            if (systemId == null || systemId.length() == 0) {
                systemId = this.getUnknownString();
            }
            String line = location.getLineNumber() == -1 ? this.getUnknownString() : String.valueOf(location.getLineNumber());
            String column = location.getColumnNumber() == -1 ? this.getUnknownString() : String.valueOf(location.getColumnNumber());
            ErrorMsg locationMsg = new ErrorMsg("SOURCE_LOCATION_MSG", new Object[]{systemId, line, column});
            buffer.append(locationMsg.getFormattedMessage());
        }
        String messageAndLocation = buffer.toString();
        switch (level) {
            case 0: {
                if (cause != null && cause.getMessage() != null) {
                    System.err.println(new ErrorMsg("INFO_PLUS_WRAPPED_MSG", (Object)messageAndLocation, (Object)cause.getMessage()));
                    break;
                }
                System.err.println(new ErrorMsg("INFO_MSG", messageAndLocation));
                break;
            }
            case 1: {
                if (cause != null && cause.getMessage() != null) {
                    System.err.println(new ErrorMsg("WARNING_PLUS_WRAPPED_MSG", (Object)messageAndLocation, (Object)cause.getMessage()));
                    break;
                }
                System.err.println(new ErrorMsg("WARNING_MSG", messageAndLocation));
                break;
            }
            case 2: {
                if (cause != null && cause.getMessage() != null) {
                    System.err.println(new ErrorMsg("ERROR_PLUS_WRAPPED_MSG", (Object)messageAndLocation, (Object)cause.getMessage()));
                    break;
                }
                System.err.println(new ErrorMsg("ERROR_MSG", messageAndLocation));
                break;
            }
            case 3: {
                if (cause != null && cause.getMessage() != null) {
                    System.err.println(new ErrorMsg("FATAL_ERR_PLUS_WRAPPED_MSG", (Object)messageAndLocation, (Object)cause.getMessage()));
                    break;
                }
                System.err.println(new ErrorMsg("FATAL_ERR_MSG", messageAndLocation));
                break;
            }
            case 4: {
                System.err.println(new ErrorMsg("TRACE_MSG", messageAndLocation));
                break;
            }
            default: {
                if (cause != null && cause.getMessage() != null) {
                    System.err.println(new ErrorMsg("FATAL_ERR_PLUS_WRAPPED_MSG", (Object)messageAndLocation, (Object)cause.getMessage()));
                    break;
                }
                System.err.println(new ErrorMsg("FATAL_ERR_MSG", messageAndLocation));
            }
        }
        if (cause != null) {
            cause.printStackTrace(System.err);
        }
        if (terminate2) {
            String msg = message;
            throw new HandledRuntimeException(msg);
        }
    }

    private String getUnknownString() {
        if (this.m_unknown == null) {
            this.m_unknown = new ErrorMsg("UNKNOWN_MSG").getFormattedMessage();
        }
        return this.m_unknown;
    }
}

