/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.scontext;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.CollationElement;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Import;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Include;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.XTQProgram;
import java.util.Enumeration;
import java.util.Hashtable;

public class CollationElements {
    private Hashtable m_uri2CollationElem = new Hashtable();

    boolean recognized(String collationURI) {
        Object o = this.m_uri2CollationElem.get(collationURI);
        boolean retval = o != null;
        return retval;
    }

    public boolean addCollationElement(Expr.ImportPrecedence importPrecedence, String uri2, CollationElement ce) {
        boolean updated;
        Object o = this.m_uri2CollationElem.get(uri2);
        CollationElemWithImportPrecedence elem2 = (CollationElemWithImportPrecedence)o;
        if (elem2 == null) {
            elem2 = new CollationElemWithImportPrecedence(importPrecedence, uri2, ce);
            this.m_uri2CollationElem.put(uri2, elem2);
            updated = true;
        } else {
            CollationElement prev = elem2.m_value;
            updated = elem2.update(importPrecedence, uri2, ce);
            if (updated) {
                Expr.ImportPrecedence prevPrec;
                Expr.ImportPrecedence thisPrec = ce.getImportPrecedence();
                if (thisPrec.hasSamePrecedenceAs(prevPrec = prev.getImportPrecedence())) {
                    ce.setDuplicateName(true);
                } else {
                    prev.setDuplicateName(false);
                }
            }
        }
        return updated;
    }

    public Enumeration getCollationURIs() {
        Enumeration enum_collationURIs = this.m_uri2CollationElem.keys();
        return enum_collationURIs;
    }

    public CollationElement getCollationElement(String uri2) {
        Object o = this.m_uri2CollationElem.get(uri2);
        CollationElemWithImportPrecedence cewip = (CollationElemWithImportPrecedence)o;
        if (null == cewip) {
            return null;
        }
        return cewip.m_value;
    }

    public static void parse(CollationElements that, Expr node2) {
        if (node2 instanceof Import || node2 instanceof Include || node2 instanceof XTQProgram) {
            int count2 = node2.jjtGetNumChildren();
            for (int i = 0; i < count2; ++i) {
                Expr child2 = (Expr)node2.jjtGetChild(i);
                CollationElements.parse(that, child2);
            }
        } else if (node2 instanceof CollationElement) {
            CollationElement ce = (CollationElement)node2;
            Expr.ImportPrecedence impPrec = node2.getImportPrecedence();
            String uri2 = ce.getCollationURI();
            that.addCollationElement(impPrec, uri2, ce);
        }
    }

    public void clear() {
        this.m_uri2CollationElem.clear();
    }

    public void removeCollationElement(String uri2) {
        this.m_uri2CollationElem.remove(uri2);
    }

    private class CollationElemWithImportPrecedence {
        private Expr.ImportPrecedence importPrecedence;
        private CollationElement m_value;

        private CollationElemWithImportPrecedence(Expr.ImportPrecedence imp, String k, CollationElement ce) {
            this.importPrecedence = imp;
            this.m_value = ce;
        }

        private boolean update(Expr.ImportPrecedence impPrecedence, String k, CollationElement v) {
            boolean wasUpdated;
            if (this.importPrecedence.hasSamePrecedenceAs(impPrecedence) || this.importPrecedence.hasHigherPrecedenceThan(impPrecedence)) {
                this.importPrecedence = impPrecedence;
                this.m_value = v;
                wasUpdated = true;
            } else {
                wasUpdated = false;
            }
            return wasUpdated;
        }
    }
}

