/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.scontext;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class MergedCharacterMapsManager {
    private static final int FULLYKNOWN = 1;
    private static final int NOT_PROCESSED = 2;
    public static final int CIRCULAR_REFERENCE = 3;
    private static final int NOT_FULLYKNOWN = 4;
    private Hashtable m_mapName2CharMap;
    ArrayList m_referencedMapping;
    ArrayList m_nodeThatReferences;

    public String[] getCharacterMapNames() {
        String[] mappingNames;
        if (this.m_mapName2CharMap == null) {
            mappingNames = new String[]{};
        } else {
            Enumeration mapNames = this.m_mapName2CharMap.keys();
            mappingNames = new String[this.m_mapName2CharMap.size()];
            int idx = 0;
            while (mapNames.hasMoreElements()) {
                mappingNames[idx] = (String)mapNames.nextElement();
                ++idx;
            }
        }
        return mappingNames;
    }

    private void putCharacterMap(String name2, CharacterMapRecord cm) {
        this.m_mapName2CharMap.put(name2, cm);
    }

    public CharacterMapRecord findCharMap(String mapName) {
        CharacterMapRecord cm = null;
        if (this.m_mapName2CharMap != null && mapName != null) {
            cm = (CharacterMapRecord)this.m_mapName2CharMap.get(mapName);
        }
        return cm;
    }

    public CharacterMapRecord getCharMap(String mapName, Expr.ImportPrecedence impPrecedence) {
        CharacterMapRecord cm;
        if (this.m_mapName2CharMap == null) {
            this.m_mapName2CharMap = new Hashtable();
        }
        if ((cm = this.findCharMap(mapName)) == null) {
            cm = new CharacterMapRecord(mapName, impPrecedence);
            this.putCharacterMap(mapName, cm);
        } else if (impPrecedence.hasHigherPrecedenceThan(cm.m_impPrecedence)) {
            cm = new CharacterMapRecord(mapName, impPrecedence);
            this.putCharacterMap(mapName, cm);
        }
        return cm;
    }

    public void setCharacterMapping(String mapName, int character, String toString) {
        CharacterMapRecord cm = this.findCharMap(mapName);
        if (cm == null) {
            cm = this.getCharMap(mapName, Expr.ImportPrecedence.getLowestPrecedence());
        }
        cm.setMapping(character, toString);
    }

    public void setDependancy(String primaryMapName, String dependsOnThisMapName) {
        CharacterMapRecord cm = this.findCharMap(primaryMapName);
        cm.setDependancy(dependsOnThisMapName);
    }

    public void process() {
        CharacterMapRecord cm;
        String key2;
        int idx;
        String[] name2 = this.getCharacterMapNames();
        for (idx = 0; idx < name2.length; ++idx) {
            key2 = name2[idx];
            cm = this.findCharMap(key2);
            cm.reset();
        }
        for (idx = 0; idx < name2.length; ++idx) {
            key2 = name2[idx];
            cm = this.findCharMap(key2);
            cm.process(null);
        }
    }

    public int getStatus(String mapName) {
        CharacterMapRecord cm = this.findCharMap(mapName);
        int status = cm.getStatus();
        return status;
    }

    public CharacterMapRecord[] getCircularList(String mapName) {
        CharacterMapRecord cm = this.findCharMap(mapName);
        CharacterMapRecord[] retval = cm.m_circularList;
        return retval;
    }

    public void characterMapIsReferenced(String expandedName, Object astNode) {
        if (this.m_referencedMapping == null) {
            this.m_referencedMapping = new ArrayList();
            this.m_nodeThatReferences = new ArrayList();
        }
        this.m_referencedMapping.add(expandedName);
        this.m_nodeThatReferences.add(astNode);
    }

    public String[] getReferences() {
        String[] arr = this.m_referencedMapping != null ? this.m_referencedMapping.toArray(new String[0]) : new String[]{};
        return arr;
    }

    public Object[] getReferencingNodes() {
        Object[] arr = this.m_nodeThatReferences != null ? this.m_nodeThatReferences.toArray() : new String[]{};
        return arr;
    }

    public class CharacterMapRecord {
        Object m_expr;
        private int m_status2 = 2;
        private String[] m_use_character_maps;
        private final Hashtable m_rawMappings = new Hashtable();
        private final Hashtable m_mergedIntegerToOutputCharacterRecord = new Hashtable();
        private final String m_mapName;
        private CharacterMapRecord[] m_circularList = null;
        private final Expr.ImportPrecedence m_impPrecedence;
        private boolean m_isDuplicate;
        private boolean m_isReferencedByOutputorResultDocument;
        private String m_lexicalQName;

        public void markDuplicate() {
            this.m_isDuplicate = true;
        }

        public boolean isDuplicate() {
            return this.m_isDuplicate;
        }

        public void mightBeUsedByOutputOrResultDocument() {
            this.m_isReferencedByOutputorResultDocument = true;
        }

        public boolean isReferenced() {
            return this.m_isReferencedByOutputorResultDocument;
        }

        private void setCircularList(CharacterMapRecord[] list) {
            this.m_circularList = list;
        }

        private CharacterMapRecord[] getCircularList() {
            return this.m_circularList;
        }

        public int getStatus() {
            return this.m_status2;
        }

        private void setStatus(int status) {
            this.m_status2 = status;
        }

        private CharacterMapRecord(String mapName, Expr.ImportPrecedence importPrecedence) {
            this.m_mapName = mapName;
            this.m_impPrecedence = importPrecedence;
        }

        private void setMapping(int character, String toString) {
            Integer iObj = new Integer(character);
            OutputCharacterRecord rec = new OutputCharacterRecord(character, toString);
            this.putRawCharacterMap(iObj, rec);
            this.putMergedCharacterMap(iObj, rec);
        }

        private void setDependancy(String dependsOnThisMapName) {
            if (this.m_use_character_maps == null) {
                this.m_use_character_maps = new String[1];
                this.m_use_character_maps[0] = dependsOnThisMapName;
            } else {
                int len = this.m_use_character_maps.length;
                String[] newList = new String[len + 1];
                System.arraycopy(this.m_use_character_maps, 0, newList, 0, len);
                newList[len] = dependsOnThisMapName;
                this.m_use_character_maps = newList;
            }
        }

        private void reset() {
            this.m_mergedIntegerToOutputCharacterRecord.clear();
            this.setCircularList(null);
            this.setStatus(2);
            if (this.m_use_character_maps != null) {
                boolean change = true;
                while (change) {
                    change = false;
                    for (int i = 0; i < this.m_use_character_maps.length - 1; ++i) {
                        String name1 = this.m_use_character_maps[i];
                        String name2 = this.m_use_character_maps[i + 1];
                        CharacterMapRecord cm1 = MergedCharacterMapsManager.this.findCharMap(name1);
                        CharacterMapRecord cm2 = MergedCharacterMapsManager.this.findCharMap(name2);
                        if (!cm1.getImportPrecedence().hasHigherPrecedenceThan(cm2.getImportPrecedence())) continue;
                        this.m_use_character_maps[i] = name2;
                        this.m_use_character_maps[i + 1] = name1;
                        change = true;
                    }
                }
            }
        }

        public OutputCharacterRecord[] getRawOutputCharacterRecords() {
            Enumeration keys2 = this.m_rawMappings.keys();
            int size = this.m_rawMappings.size();
            OutputCharacterRecord[] recs = new OutputCharacterRecord[size];
            for (int i = 0; i < recs.length; ++i) {
                Object key2 = keys2.nextElement();
                recs[i] = (OutputCharacterRecord)this.m_rawMappings.get(key2);
            }
            return recs;
        }

        private void putRawCharacterMap(Integer key2, OutputCharacterRecord rec) {
            this.m_rawMappings.put(key2, rec);
        }

        public Expr.ImportPrecedence getImportPrecedence() {
            return this.m_impPrecedence;
        }

        public String getLocalName() {
            int curly = this.m_mapName.indexOf(125);
            String localName2 = 0 < curly ? this.m_mapName.substring(curly + 1) : this.m_mapName;
            return localName2;
        }

        public String getURI() {
            int curly1 = this.m_mapName.indexOf(123);
            int curly2 = this.m_mapName.indexOf(125);
            String uri2 = 0 <= curly1 && curly1 < curly2 ? this.m_mapName.substring(curly1 + 1, curly2) : "";
            return uri2;
        }

        public OutputCharacterRecord[] getMergedOutputCharacterRecords() {
            Enumeration keys2 = this.m_mergedIntegerToOutputCharacterRecord.keys();
            int size = this.m_mergedIntegerToOutputCharacterRecord.size();
            OutputCharacterRecord[] recs = new OutputCharacterRecord[size];
            for (int i = 0; i < recs.length; ++i) {
                Object key2 = keys2.nextElement();
                recs[i] = (OutputCharacterRecord)this.m_mergedIntegerToOutputCharacterRecord.get(key2);
            }
            return recs;
        }

        private void putMergedCharacterMap(Integer key2, OutputCharacterRecord rec) {
            this.m_mergedIntegerToOutputCharacterRecord.put(key2, rec);
        }

        private void process(CharacterMapRecord[] listt) {
            CharacterMapRecord cm;
            String otherMapping;
            int i;
            if (this.getStatus() != 2) {
                return;
            }
            CharacterMapRecord self2 = MergedCharacterMapsManager.this.findCharMap(this.m_mapName);
            listt = this.appendToList(listt, self2);
            for (int i2 = listt.length - 2; 0 <= i2; --i2) {
                if (listt[i2] != self2) continue;
                int size = listt.length - i2;
                CharacterMapRecord[] cycle = new CharacterMapRecord[size];
                System.arraycopy(listt, i2, cycle, 0, size);
                this.setCircularList(cycle);
                this.setStatus(3);
                return;
            }
            boolean fullyknown = true;
            if (this.m_use_character_maps != null) {
                for (i = 0; i < this.m_use_character_maps.length; ++i) {
                    otherMapping = this.m_use_character_maps[i];
                    cm = MergedCharacterMapsManager.this.findCharMap(otherMapping);
                    if (cm != null) {
                        cm.process(listt);
                        int status = cm.getStatus();
                        switch (status) {
                            case 1: {
                                break;
                            }
                            case 3: {
                                fullyknown = false;
                                CharacterMapRecord[] cycle = cm.getCircularList();
                                for (int ii = 0; ii < cycle.length; ++ii) {
                                    if (cycle[ii] != self2) continue;
                                    int count2 = ii + 1;
                                    CharacterMapRecord[] myCycle = new CharacterMapRecord[1 + count2];
                                    myCycle[0] = self2;
                                    System.arraycopy(cycle, 0, myCycle, 1, count2);
                                    this.setCircularList(myCycle);
                                    this.setStatus(3);
                                    return;
                                }
                            }
                            default: {
                                fullyknown = false;
                                break;
                            }
                        }
                        continue;
                    }
                    fullyknown = false;
                }
            }
            if (!fullyknown) {
                this.setStatus(4);
                return;
            }
            if (this.m_use_character_maps != null) {
                for (i = 0; i < this.m_use_character_maps.length; ++i) {
                    otherMapping = this.m_use_character_maps[i];
                    cm = MergedCharacterMapsManager.this.findCharMap(otherMapping);
                    OutputCharacterRecord[] recs = cm.getMergedOutputCharacterRecords();
                    for (int r = 0; r < recs.length; ++r) {
                        int character = recs[r].m_inputChar;
                        Integer intObj = new Integer(character);
                        this.m_mergedIntegerToOutputCharacterRecord.put(intObj, recs[r]);
                    }
                }
            }
            OutputCharacterRecord[] recs = this.getRawOutputCharacterRecords();
            for (int i3 = 0; i3 < recs.length; ++i3) {
                int character = recs[i3].m_inputChar;
                Integer intObj = new Integer(character);
                this.m_mergedIntegerToOutputCharacterRecord.put(intObj, recs[i3]);
            }
            this.setStatus(1);
        }

        private CharacterMapRecord[] appendToList(CharacterMapRecord[] listt, CharacterMapRecord rec) {
            if (listt == null) {
                listt = new CharacterMapRecord[]{rec};
            } else {
                int mx = listt.length;
                CharacterMapRecord[] list2 = new CharacterMapRecord[mx + 1];
                System.arraycopy(listt, 0, list2, 0, mx);
                list2[mx] = rec;
                listt = list2;
            }
            return listt;
        }

        public void setExpr(Object astExpr) {
            this.m_expr = astExpr;
        }

        public Object getExpr() {
            return this.m_expr;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("<xsl:character-map name='").append(this.m_mapName);
            sb.append("' ");
            if (this.m_use_character_maps != null) {
                sb.append("use-character-maps='");
                for (int i = 0; i < this.m_use_character_maps.length; ++i) {
                    sb.append(this.m_use_character_maps[i]).append(' ');
                }
                sb.append("'");
            }
            sb.append(" />");
            if (this.m_isDuplicate) {
                sb.append("*** DUP ***");
            }
            switch (this.getStatus()) {
                case 1: {
                    sb.append(" FULLKNOWN");
                    break;
                }
                case 2: {
                    sb.append(" NOT_PROCESSED");
                    break;
                }
                case 3: {
                    sb.append(" CIRCULAR_REFERENCE");
                }
            }
            return sb.toString();
        }

        public void setLexicalQName(String lexicalQName) {
            this.m_lexicalQName = lexicalQName;
        }

        public String getLexicalQName() {
            return this.m_lexicalQName;
        }
    }

    public static class OutputCharacterRecord {
        public final int m_inputChar;
        public final String m_outputString;

        private OutputCharacterRecord() {
            this.m_inputChar = 0;
            this.m_outputString = null;
        }

        private OutputCharacterRecord(int inputChar, String outputString) {
            this.m_inputChar = inputChar;
            this.m_outputString = outputString;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("<xsl:output-character character='");
            sb.append((char)this.m_inputChar).append("' (integer " + this.m_inputChar);
            sb.append(")  string='").append(this.m_outputString).append("' />");
            return sb.toString();
        }
    }
}

