/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.utils;

import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.Token;
import org.xml.sax.Locator;

public class LineInfo {
    private final String _systemID;
    private final String _publicID;
    private final int _startLine;
    private final int _startColumn;
    private final int _endLine;
    private final int _endColumn;
    private final int _startOffset;
    private final int _endOffset;
    public static final LineInfo EMPTYLINEINFO = new LineInfo(null, null, -1, -1, -1, -1);

    public LineInfo(String systemID, String publicID, int startLine, int startColumn, int endLine, int endColumn) {
        this._systemID = systemID;
        this._publicID = publicID;
        this._startLine = startLine;
        this._startColumn = startColumn;
        this._endLine = endLine;
        this._endColumn = endColumn;
        this._startOffset = -1;
        this._endOffset = -1;
    }

    public LineInfo(String systemID, String publicID, int startLine, int startColumn, int endLine, int endColumn, int startOffset, int endOffset) {
        this._systemID = systemID;
        this._publicID = publicID;
        this._startLine = startLine;
        this._startColumn = startColumn;
        this._endLine = endLine;
        this._endColumn = endColumn;
        this._startOffset = startOffset;
        this._endOffset = endOffset;
    }

    public String getSystemID() {
        return this._systemID;
    }

    public String getPublicID() {
        return this._publicID;
    }

    public int getStartLine() {
        return this._startLine;
    }

    public int getStartColumn() {
        return this._startColumn;
    }

    public int getEndLine() {
        return this._endLine;
    }

    public int getEndColumn() {
        return this._endColumn;
    }

    public int getStartOffset() {
        return this._startOffset;
    }

    public int getEndOffset() {
        return this._endOffset;
    }

    public static LineInfo createLineInfo(Token token, LineInfo offset) {
        int startLine = offset._startLine == -1 ? token.beginLine : offset._startLine;
        int startColumn = offset._startColumn == -1 ? token.beginColumn : offset._startColumn;
        int endLine = offset._endLine == -1 ? token.endLine : offset._endLine;
        int endColumn = offset._endColumn == -1 ? token.endColumn : offset._endColumn;
        return new LineInfo(offset._systemID, offset._publicID, startLine, startColumn, endLine, endColumn);
    }

    public static LineInfo createLineInfo(Locator locator) {
        return new LineInfo(locator.getSystemId(), locator.getPublicId(), locator.getLineNumber(), locator.getColumnNumber(), -1, -1);
    }

    public String toString() {
        return this._systemID + ":" + this._publicID + ":" + String.valueOf(this._startLine) + ":" + String.valueOf(this._startColumn) + ":" + String.valueOf(this._endLine) + ":" + String.valueOf(this._endColumn) + ":" + String.valueOf(this._startOffset) + ":" + String.valueOf(this._endOffset);
    }
}

