/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.utils;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.SimpleNode;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.XPathTreeConstants;
import com.ibm.xltxe.rnm1.xtq.ast.res.ASTBaseMsg;
import com.ibm.xltxe.rnm1.xtq.ast.res.ASTMsg;
import com.ibm.xltxe.rnm1.xtq.common.utils.ErrorHandler;
import com.ibm.xltxe.rnm1.xtq.common.utils.SourceLocation;
import java.util.Vector;

public class Reporter {
    private boolean _debug = true;
    private boolean _reportImmediately = true;
    private ErrorHandler _errorHandler;
    private boolean _dieOnError = false;
    private Vector _errors = new Vector();
    private Vector _warnings = new Vector();
    private boolean _hasErrors = false;

    public void reset() {
        this._errors.removeAllElements();
        this._warnings.removeAllElements();
        this._hasErrors = false;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this._errorHandler = errorHandler;
    }

    public boolean errorsFound() {
        return this._hasErrors || this._errors.size() > 0;
    }

    public void printErrors() {
        int size = this._errors.size();
        if (size > 0) {
            System.err.println(new ASTMsg("ERR_SYSTEM", "Compiler errors."));
            for (int i = 0; i < size; ++i) {
                System.err.println("  " + this._errors.elementAt(i));
            }
            this._errors.clear();
        }
    }

    public void printWarnings() {
        int size = this._warnings.size();
        if (size > 0) {
            System.err.println(new ASTMsg("COMPILER_WARNING_KEY"));
            for (int i = 0; i < size; ++i) {
                System.err.println("  " + this._warnings.elementAt(i));
            }
            this._warnings.clear();
        }
    }

    public void _assert(String msg) {
        ASTMsg err = new ASTMsg(new RuntimeException(msg));
        this.report(0, err);
    }

    public void _assert(boolean b) {
        if (!b) {
            Throwable t = new Throwable("Programmers Assertion Failed!");
            ASTMsg err = new ASTMsg(t);
            this.report(0, err);
            throw new RuntimeException(t.getMessage());
        }
    }

    public void _assert(boolean b, Throwable t) {
        if (!b) {
            ASTMsg err = new ASTMsg(t);
            this.report(0, err);
            throw new RuntimeException(t.getMessage());
        }
    }

    public void _assert(boolean b, SimpleNode n2) {
        if (!b) {
            Throwable t = new Throwable("\nProblem with: " + n2.getClass().getName() + "! \nLine #" + n2.getLineNumber() + " type: " + XPathTreeConstants.jjtNodeName[n2.getId()]);
            ASTMsg err = new ASTMsg(t);
            this.report(0, err);
            throw new RuntimeException(t.getMessage());
        }
    }

    public void _assert(Throwable t) {
        ASTMsg err = new ASTMsg(t);
        this.report(0, err);
    }

    public void assertNotImplemented(Throwable t) {
        ASTMsg err = new ASTMsg(t);
        this.report(0, err);
    }

    public void report(int category, ASTBaseMsg error2) {
        this.report(category, error2, null);
    }

    private void reportErrorHandler(int category, String message, SourceLocation sourceLocation, Throwable cause) {
        switch (category) {
            case 0: 
            case 1: 
            case 2: {
                this._errorHandler.report(3, message, sourceLocation, cause, true);
                this._hasErrors = true;
                break;
            }
            case 3: {
                this._errorHandler.report(2, message, sourceLocation, cause, false);
                this._hasErrors = true;
                break;
            }
            case 4: {
                this._errorHandler.report(1, message, sourceLocation, cause, false);
                break;
            }
            case 5: {
                this._errorHandler.report(2, message, sourceLocation, cause, false);
            }
        }
    }

    private void reportImmediately(int category, RuntimeException e) {
        if (this.isDieOnError() && category != 4 || category == 2) {
            if (this._errors.size() > 1) {
                this.printErrors();
            }
            if (this._warnings.size() > 1) {
                this.printWarnings();
            }
            throw e;
        }
        if (this.isDebug() && category != 4) {
            if (this._errors.size() > 1) {
                this.printErrors();
            }
            if (this._warnings.size() > 1) {
                this.printWarnings();
            }
            e.printStackTrace();
        } else {
            if (this._errors.size() > 0) {
                this.printErrors();
            }
            if (this._warnings.size() > 0) {
                this.printWarnings();
            }
        }
    }

    public void report(int category, ASTBaseMsg error2, Throwable cause) {
        if (this._errorHandler != null) {
            String message = error2.getFormattedMessage();
            SourceLocation sourceLocation = error2.getSourceLocation();
            this.reportErrorHandler(category, message, sourceLocation, cause);
            return;
        }
        switch (category) {
            case 0: {
                this._errors.addElement(error2);
                break;
            }
            case 1: {
                this._errors.addElement(error2);
                break;
            }
            case 2: {
                this._errors.addElement(error2);
                break;
            }
            case 3: {
                this._errors.addElement(error2);
                break;
            }
            case 4: {
                this._warnings.addElement(error2);
            }
        }
        if (this.isReportImmediately()) {
            RuntimeException e = new RuntimeException(error2.toString());
            this.reportImmediately(category, e);
        }
    }

    public void report(int category, String message, Throwable cause) {
        if (this._errorHandler != null) {
            this.reportErrorHandler(category, message, null, cause);
            return;
        }
        if (this.isReportImmediately()) {
            if (cause instanceof RuntimeException) {
                this.reportImmediately(category, (RuntimeException)cause);
            } else {
                this.reportImmediately(category, new RuntimeException(cause));
            }
        }
    }

    public Vector getErrors() {
        return this._errors;
    }

    public Vector getWarnings() {
        return this._warnings;
    }

    public boolean isReportImmediately() {
        return this._reportImmediately;
    }

    public void setReportImmediately(boolean reportImmediately) {
        this._reportImmediately = reportImmediately;
    }

    public boolean isDebug() {
        return this._debug;
    }

    public void setDebug(boolean debug) {
        this._debug = debug;
    }

    public boolean isDieOnError() {
        return this._dieOnError;
    }

    public void setDieOnError(boolean dieOnError) {
        this._dieOnError = dieOnError;
    }
}

