/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xci.dtm;

import com.ibm.xltxe.rnm1.xtq.xci.dtm.DTM;
import com.ibm.xltxe.rnm1.xtq.xci.dtm.DTMConfigurationException;
import com.ibm.xltxe.rnm1.xtq.xci.dtm.ObjectFactory;
import com.ibm.xltxe.rnm1.xtq.xci.dtm.ref.DTMManagerDefault;
import com.ibm.xltxe.rnm1.xtq.xci.res.XMLMessages;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.dp.base.AbstractCursorFactory;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;

public abstract class DTMManager
extends AbstractCursorFactory {
    private static final Logger s_logger = LoggerUtil.getLogger(DTMManager.class);
    private static final String s_className = DTMManager.class.getName();
    private static final String defaultPropName = "com.ibm.xltxe.rnm1.xtq.xci.dtm.DTMManager";
    private static final String defaultClassName = "com.ibm.xltxe.rnm1.xtq.xci.dtm.ref.DTMManagerDefault";
    private static final String schemaAwareManagerClassName;
    private static final String defaultParserClassName;
    protected boolean m_schemaAware = false;
    static Class<?> mgrClassSchemaAware;
    static Class<?> mgrClassSchemaNotAware;
    public static boolean m_incremental;
    public static final int IDENT_DTM_NODE_BITS = 16;
    public static final int IDENT_NODE_DEFAULT = 65535;
    public static final int IDENT_DTM_DEFAULT = -65536;
    public static final int IDENT_MAX_DTMS = 65536;

    protected DTMManager(SessionContext sessionContext) {
        super(sessionContext);
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "DTMManager", "Created new DTMManager instance (class " + this.getClass().getName() + ")");
        }
    }

    public static DTMManager newInstance(boolean bl, SessionContext sessionContext) throws DTMConfigurationException {
        Class<?> clazz = DTMManager.getDTMManagerClass(bl);
        DTMManager dTMManager = DTMManager.newInstance(clazz, sessionContext);
        dTMManager.m_schemaAware = bl;
        int n2 = sessionContext.getDataProviderID(clazz.getName());
        sessionContext.setCursorFactory(n2, dTMManager);
        return dTMManager;
    }

    public static DTMManager newInstance(Class<?> clazz, SessionContext sessionContext) {
        try {
            Constructor<?> constructor = clazz.getConstructor(SessionContext.class);
            DTMManager dTMManager = (DTMManager)constructor.newInstance(sessionContext);
            return dTMManager;
        }
        catch (Exception exception) {
            String string2 = "DTMManager.newInstance() was called with class ";
            string2 = clazz == null ? string2 + "null" : string2 + clazz.getName();
            string2 = string2 + " but newInstance() failed on this class. No default implementation is found.";
            throw new DTMConfigurationException(XMLMessages.createXMLMessage("SYSTEM_ERROR", new Object[]{string2}));
        }
    }

    public static Class<?> getDTMManagerClass(boolean bl) {
        String string2;
        if (bl) {
            if (mgrClassSchemaAware != null) {
                return mgrClassSchemaAware;
            }
        } else if (mgrClassSchemaNotAware != null) {
            return mgrClassSchemaNotAware;
        }
        Class clazz = null;
        try {
            string2 = bl ? schemaAwareManagerClassName : defaultParserClassName;
            clazz = ObjectFactory.lookUpFactoryClass(defaultPropName, null, string2);
        }
        catch (ObjectFactory.ConfigurationError configurationError) {
            try {
                clazz = ObjectFactory.lookUpFactoryClass(defaultPropName, null, defaultClassName);
            }
            catch (ObjectFactory.ConfigurationError configurationError2) {
                String string3 = "DTMManager.getDTMMangerClass(" + bl + ") was called ";
                string3 = string3 + "but failed. No default implementation found.";
                throw new DTMConfigurationException(XMLMessages.createXMLMessage("SYSTEM_ERROR", new Object[]{string3}));
            }
        }
        if (clazz == null) {
            string2 = "DTMManager.getDTMMangerClass(" + bl + ") was called ";
            string2 = string2 + "but failed with null mgrClass. No default implementation found.";
            throw new DTMConfigurationException(XMLMessages.createXMLMessage("SYSTEM_ERROR", new Object[]{string2}));
        }
        if (bl) {
            mgrClassSchemaAware = clazz;
        } else {
            mgrClassSchemaNotAware = clazz;
        }
        return clazz;
    }

    public DTM getDTM(Source source, boolean bl, boolean bl2, boolean bl3) {
        return this.getDTM(source, bl, bl2, bl3, false, null);
    }

    public abstract DTM getDTM(Source var1, boolean var2, boolean var3, boolean var4, boolean var5);

    public abstract DTM getDTM(Source var1, boolean var2, boolean var3, boolean var4, boolean var5, RequestInfo var6);

    public abstract boolean release(DTM var1, boolean var2);

    public static synchronized boolean getIncremental() {
        return m_incremental;
    }

    public static synchronized void setIncremental(boolean bl) {
        m_incremental = bl;
    }

    public int getDTMIdentityMask() {
        return -65536;
    }

    public int getNodeIdentityMask() {
        return 65535;
    }

    static {
        defaultParserClassName = schemaAwareManagerClassName = DTMManagerDefault.class.getName();
        mgrClassSchemaAware = null;
        mgrClassSchemaNotAware = null;
        m_incremental = false;
    }
}

