/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xci.dtm.ref;

import com.ibm.xltxe.rnm1.xtq.common.utils.ArrayListToReplaceVector;
import com.ibm.xltxe.rnm1.xtq.common.utils.IntVector;
import com.ibm.xltxe.rnm1.xtq.common.utils.PerSessionHash;

public class DTMStringPool {
    ArrayListToReplaceVector<String> m_intToString;
    static final int HASHPRIME = 101;
    int[] m_hashStart = new int[101];
    IntVector m_hashChain;
    public static final int NULL = -1;

    public DTMStringPool(int n2) {
        this.m_intToString = new ArrayListToReplaceVector();
        this.m_hashChain = new IntVector(n2);
        this.removeAllElements();
        this.stringToIndex("");
    }

    public DTMStringPool() {
        this(512);
    }

    public void removeAllElements() {
        this.m_intToString.clear();
        for (int i = 0; i < 101; ++i) {
            this.m_hashStart[i] = -1;
        }
        this.m_hashChain.removeAllElements();
    }

    public String indexToString(int n2) throws ArrayIndexOutOfBoundsException {
        if (n2 == -1) {
            return null;
        }
        return (String)this.m_intToString.get(n2);
    }

    public int stringToIndex(String string2) {
        int n2;
        if (string2 == null) {
            return -1;
        }
        int n3 = PerSessionHash.hash(string2) % 101;
        if (n3 < 0) {
            n3 = -n3;
        }
        int n4 = n2 = this.m_hashStart[n3];
        while (n4 != -1) {
            if (((String)this.m_intToString.get(n4)).equals(string2)) {
                return n4;
            }
            n2 = n4;
            n4 = this.m_hashChain.elementAt(n4);
        }
        int n5 = this.m_intToString.size();
        this.m_intToString.add(string2);
        this.m_hashChain.addElement(-1);
        if (n2 == -1) {
            this.m_hashStart[n3] = n5;
        } else {
            this.m_hashChain.setElementAt(n5, n2);
        }
        return n5;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"Zero", "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine", "Ten", "Eleven", "Twelve", "Thirteen", "Fourteen", "Fifteen", "Sixteen", "Seventeen", "Eighteen", "Nineteen", "Twenty", "Twenty-One", "Twenty-Two", "Twenty-Three", "Twenty-Four", "Twenty-Five", "Twenty-Six", "Twenty-Seven", "Twenty-Eight", "Twenty-Nine", "Thirty", "Thirty-One", "Thirty-Two", "Thirty-Three", "Thirty-Four", "Thirty-Five", "Thirty-Six", "Thirty-Seven", "Thirty-Eight", "Thirty-Nine"};
        DTMStringPool dTMStringPool = new DTMStringPool();
        System.out.println("If no complaints are printed below, we passed initial test.");
        for (int i = 0; i <= 1; ++i) {
            int n2;
            int n3;
            for (n3 = 0; n3 < stringArray2.length; ++n3) {
                n2 = dTMStringPool.stringToIndex(stringArray2[n3]);
                if (n2 == n3) continue;
                System.out.println("\tMismatch populating pool: assigned " + n2 + " for create " + n3);
            }
            for (n3 = 0; n3 < stringArray2.length; ++n3) {
                n2 = dTMStringPool.stringToIndex(stringArray2[n3]);
                if (n2 == n3) continue;
                System.out.println("\tMismatch in stringToIndex: returned " + n2 + " for lookup " + n3);
            }
            for (n3 = 0; n3 < stringArray2.length; ++n3) {
                String string2 = dTMStringPool.indexToString(n3);
                if (stringArray2[n3].equals(string2)) continue;
                System.out.println("\tMismatch in indexToString: returned" + string2 + " for lookup " + n3);
            }
            dTMStringPool.removeAllElements();
            System.out.println("\nPass " + i + " complete\n");
        }
    }
}

