/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xci.dtm.ref.xlxp2dtm;

import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.dp.values.AbstractCData;
import com.ibm.xml.xci.dp.values.chars.CharBufferChars;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.dp.values.chars.CharsBase;
import com.ibm.xml.xci.internal.values.StringCData;
import com.ibm.xml.xci.res.XCIMessages;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLCharSequence;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import java.io.IOException;
import java.io.StringWriter;

public class XLXPCharSequenceCData
extends AbstractCData {
    XMLCharSequence m_charSequence;

    public XLXPCharSequenceCData(XMLCharSequence xMLCharSequence) {
        this.m_charSequence = xMLCharSequence;
    }

    @Override
    public CharSequence getOriginalLexicalValue() {
        return this.m_charSequence;
    }

    @Override
    public String getString(int n2) {
        if (n2 != 1) {
            throw new IndexOutOfBoundsException(XCIMessages.createXCIMessage("ER_POSITION_OUTOFRANGE1", null));
        }
        return this.m_charSequence.toString();
    }

    @Override
    public int needsEscaping(byte[] byArray) {
        return this.m_charSequence.needsEscaping(0, this.m_charSequence.length(), byArray);
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public int needsEscaping(int n2, int n3, byte[] byArray) {
        return this.m_charSequence.needsEscaping(n2, n3, byArray);
    }

    @Override
    public CData constant(boolean bl) {
        return new StringCData(this.m_charSequence.toString(), TypeRegistry.XSSTRING);
    }

    @Override
    public Cursor toCursor() {
        return this.constant(false).toCursor();
    }

    public static void writeEncodedString(Appendable appendable, Chars chars, short s) throws IOException {
        int n2 = chars.length();
        block11: for (int i = 0; i < n2; ++i) {
            char c = chars.charAt(i);
            switch (c) {
                case '<': {
                    if ((s & 1) > 0) {
                        appendable.append("&lt;");
                        continue block11;
                    }
                    appendable.append(c);
                    continue block11;
                }
                case '>': {
                    if ((s & 1) > 0) {
                        appendable.append("&gt;");
                        continue block11;
                    }
                    appendable.append(c);
                    continue block11;
                }
                case '\"': {
                    if ((s & 4) > 0) {
                        appendable.append("&quot;");
                        continue block11;
                    }
                    appendable.append(c);
                    continue block11;
                }
                case '\'': {
                    if ((s & 2) > 0) {
                        appendable.append("&apos;");
                        continue block11;
                    }
                    appendable.append(c);
                    continue block11;
                }
                case '&': {
                    appendable.append("&amp;");
                    continue block11;
                }
                case '\r': {
                    if ((s & 0x40) > 0) {
                        appendable.append("&#");
                        appendable.append(Integer.toString(c));
                        appendable.append(";");
                        continue block11;
                    }
                }
                case '\t': 
                case '\n': {
                    if ((s & 8) > 0) {
                        appendable.append("&#");
                        appendable.append(Integer.toString(c));
                        appendable.append(";");
                        continue block11;
                    }
                    appendable.append(c);
                    continue block11;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\u000b': 
                case '\f': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': 
                case '\u007f': {
                    appendable.append("&#");
                    appendable.append(Integer.toString(c));
                    appendable.append(";");
                    continue block11;
                }
                case '\u0085': 
                case '\u2028': {
                    if ((s & 0x80) > 0) {
                        appendable.append("&#x");
                        appendable.append(Integer.toHexString(c));
                        appendable.append(";");
                        continue block11;
                    }
                }
                default: {
                    appendable.append(c);
                }
            }
        }
    }

    @Override
    public boolean mayContain(short s) {
        return s != 0;
    }

    @Override
    public int writeEncodedBytesTo(int n2, byte[] byArray, int n3, String string2, short s, boolean bl) {
        return this.quote(s).toEncodedBytes(string2).writeBytesTo(n2, byArray, n3, bl);
    }

    @Override
    public Chars quote(short s) {
        if (this.mayContain(s)) {
            StringWriter stringWriter = new StringWriter();
            try {
                CharsBase.writeEncodedString((Appendable)stringWriter, CharBufferChars.make(this.lexicalValue()), s);
                stringWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return new StringCData(stringWriter.toString(), TypeRegistry.XSSTRING);
        }
        return CharBufferChars.make(this.lexicalValue());
    }

    @Override
    public XSSimpleTypeDefinition getXSTypeDefinition() {
        return TypeRegistry.XSSTRING;
    }
}

